/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.external.armnn;

import com.arm.utils.NullChecking;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class Entity {
    protected final long guid;
    protected @Nullable String name;
    protected final @NonNull List<@NonNull Entity> children;
    protected @Nullable Entity parent;
    protected int trackId;

    protected Entity(long guid, int trackId) {
        this.guid = guid;
        this.trackId = trackId;
        this.children = new ArrayList<Entity>();
    }

    public void addChild(@NonNull Entity child) {
        this.children.add(child);
    }

    public @NonNull List<@NonNull Entity> getChildren() {
        return this.children;
    }

    public long getGuid() {
        return this.guid;
    }

    public @Nullable Entity getParent() {
        return this.parent;
    }

    public @NonNull String getName() {
        return String.format("%s(%d)", NullChecking.neverNullOr((Object)this.name, (Object)"unknown"), this.guid);
    }

    public int getTrackId() {
        return this.trackId;
    }

    public void setParent(@NonNull Entity parent) {
        this.parent = parent;
    }

    public void setName(@NonNull String name) {
        this.name = name;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        return ((Entity)obj).guid == this.guid;
    }

    public int hashCode() {
        return Long.hashCode(this.guid);
    }
}

