/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.external;

import com.arm.streamline.analysis.model.DynamicCounterSeriesKey;
import com.arm.streamline.analysis.model.ICounterSeriesKey;
import com.arm.streamline.analysis.model.KernelAnnotationSeriesKey;
import com.arm.streamline.common.analysis.model.AnnotationColour;
import com.arm.streamline.common.model.counters.CounterClass;
import com.arm.streamline.common.model.counters.CounterDisplay;
import com.arm.streamline.common.model.counters.GraphRenderingType;
import com.arm.streamline.common.model.counters.SeriesComposition;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.warnings.WarningItem;
import com.arm.streamline.ftrace.TracepointFormat;
import com.arm.streamline.protocol.capture.apc.pass_two.IExternalProtocolPassTwoEventStream;
import com.arm.streamline.protocol.capture.apc.protocol.DelayProcessingException;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolEventStream;
import com.arm.streamline.protocol.capture.apc.time.ClockSource;
import com.arm.streamline.protocol.capture.apc.time.ITimestampMapper;
import com.arm.streamline.protocol.misc.TaskId;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class TimestampMappingExternalProtocolEventStream
implements IExternalProtocolEventStream {
    private final @NonNull IExternalProtocolPassTwoEventStream outputStream;
    private final @NonNull ITimestampMapper timestampMapper;

    public TimestampMappingExternalProtocolEventStream(@NonNull ITimestampMapper timestampMapper, @NonNull IExternalProtocolPassTwoEventStream outputStream) {
        this.timestampMapper = timestampMapper;
        this.outputStream = outputStream;
    }

    @Override
    public void activityStop(@NonNull ICounterSeriesKey counterKey, @NonNull ClockSource clockSource, long rawTimestamp, @NonNull ProcessingElementReference peReference, @Nullable TaskId taskId, int activity) throws IOException {
        this.outputStream.activityStop(counterKey, this.map(clockSource, rawTimestamp), peReference, taskId, activity);
    }

    @Override
    public void activitySwitch(@NonNull ICounterSeriesKey counterKey, @NonNull ClockSource clockSource, long rawTimestamp, @NonNull ProcessingElementReference peReference, @Nullable TaskId taskId, int activity, int reason) throws IOException {
        this.outputStream.activitySwitch(counterKey, this.map(clockSource, rawTimestamp), peReference, taskId, activity, reason);
    }

    @Override
    public void annotationMarker(@NonNull ClockSource clockSource, long rawTimestamp, @Nullable TaskId taskId, @NonNull AnnotationColour colour, @NonNull String text) throws IOException {
        this.outputStream.annotationMarker(this.map(clockSource, rawTimestamp), taskId, colour, text);
    }

    @Override
    public void annotationText(@NonNull ClockSource clockSource, long rawTimestamp, @NonNull TaskId taskId, int channel, @NonNull AnnotationColour colour, @NonNull String text) throws IOException {
        this.outputStream.annotationText(this.map(clockSource, rawTimestamp), taskId, channel, colour, text);
    }

    @Override
    public void annotationTextAsync(@NonNull ClockSource clockSource, long rawTimestamp, @NonNull TaskId taskId, @NonNull String title, int id, @NonNull AnnotationColour colour, @NonNull String text) throws IOException {
        this.outputStream.annotationTextAsync(this.map(clockSource, rawTimestamp), taskId, title, id, colour, text);
    }

    @Override
    public void annotationTextAsyncEnd(@NonNull ClockSource clockSource, long rawTimestamp, @NonNull TaskId taskId, @NonNull String title, int id) throws IOException {
        this.outputStream.annotationTextAsyncEnd(this.map(clockSource, rawTimestamp), taskId, title, id);
    }

    @Override
    public void annotationTextNameChannel(@NonNull ClockSource clockSource, long rawTimestamp, @NonNull TaskId taskId, int channel, int group, @NonNull String text) throws IOException {
        this.outputStream.annotationTextNameChannel(this.map(clockSource, rawTimestamp), taskId, channel, group, text);
    }

    @Override
    public void annotationTextNameGroup(@NonNull ClockSource clockSource, long rawTimestamp, @NonNull TaskId taskId, int group, @NonNull String text) throws IOException {
        this.outputStream.annotationTextNameGroup(this.map(clockSource, rawTimestamp), taskId, group, text);
    }

    @Override
    public void annotationTextPop(@NonNull ClockSource clockSource, long rawTimestamp, @NonNull TaskId taskId, @NonNull String title) throws IOException {
        this.outputStream.annotationTextPop(this.map(clockSource, rawTimestamp), taskId, title);
    }

    @Override
    public void annotationTextPush(@NonNull ClockSource clockSource, long rawTimestamp, @NonNull TaskId taskId, @NonNull String title, @NonNull AnnotationColour colour, @NonNull String text) throws IOException {
        this.outputStream.annotationTextPush(this.map(clockSource, rawTimestamp), taskId, title, colour, text);
    }

    @Override
    public void annotationVisual(@NonNull ClockSource clockSource, long rawTimestamp, @NonNull TaskId taskId, @NonNull String text, byte @NonNull [] image) throws IOException {
        this.outputStream.annotationVisual(this.map(clockSource, rawTimestamp), taskId, text, image);
    }

    @Override
    public void atraceCounter(@NonNull ClockSource clockSource, long rawTimestamp, @NonNull String name, @NonNull TaskId taskId, long value) throws IOException {
        this.outputStream.atraceCounter(this.map(clockSource, rawTimestamp), name, taskId, value);
    }

    @Override
    public void attributes(long vmUID, Map<@NonNull String, @NonNull String> attributes) throws IOException {
        this.outputStream.attributes(vmUID, attributes);
    }

    @Override
    public void camJob(int viewUID, @NonNull ClockSource clockSource, long startTime, long duration, int track, int jobUID, @NonNull String name, @NonNull AnnotationColour colour, int primaryDependency, int @NonNull [] dependencies) throws IOException {
        this.outputStream.camJob(viewUID, this.map(clockSource, startTime), duration, track, jobUID, name, colour, primaryDependency, dependencies);
    }

    @Override
    public void camJob(@NonNull TaskId taskId, int viewUID, @NonNull ClockSource clockSource, long startTime, long duration, int track, int jobUID, @NonNull String name, @NonNull AnnotationColour colour, int primaryDependency, int @NonNull [] dependencies) throws IOException {
        this.outputStream.camJob(taskId, viewUID, this.map(clockSource, startTime), duration, track, jobUID, name, colour, primaryDependency, dependencies);
    }

    @Override
    public void camJobDependencies(@NonNull TaskId taskId, int viewUID, @NonNull ClockSource clockSource, long rawTimestamp, int jobUID, int primaryDependency, int @NonNull [] dependencies) throws IOException {
        this.outputStream.camJobDependencies(taskId, viewUID, this.map(clockSource, rawTimestamp), jobUID, primaryDependency, dependencies);
    }

    @Override
    public void camJobStart(@NonNull TaskId taskId, int viewUID, @NonNull ClockSource clockSource, long rawTimestamp, int track, int jobUID, @NonNull String name, @NonNull AnnotationColour colour) throws IOException {
        this.outputStream.camJobStart(taskId, viewUID, this.map(clockSource, rawTimestamp), track, jobUID, name, colour);
    }

    @Override
    public void camJobStop(@NonNull TaskId taskId, int viewUID, @NonNull ClockSource clockSource, long rawTimestamp, int jobUID) throws IOException {
        this.outputStream.camJobStop(taskId, viewUID, this.map(clockSource, rawTimestamp), jobUID);
    }

    @Override
    public void camTrack(@NonNull ClockSource clockSource, long rawTimestamp, @NonNull TaskId taskId, int viewUID, int parentTrack, int trackUID, @NonNull String name) throws IOException {
        this.outputStream.camTrack(this.map(clockSource, rawTimestamp), taskId, viewUID, parentTrack, trackUID, name);
    }

    @Override
    public void camTrack(int viewUID, int parentTrack, int trackUID, @NonNull String name) throws IOException {
        this.outputStream.camTrack(viewUID, parentTrack, trackUID, name);
    }

    @Override
    public void camView(@NonNull ClockSource clockSource, long rawTimestamp, @NonNull TaskId taskId, int viewUID, @NonNull String name) throws IOException {
        this.outputStream.camView(this.map(clockSource, rawTimestamp), taskId, viewUID, name);
    }

    @Override
    public void camView(int viewUID, @NonNull String name) throws IOException {
        this.outputStream.camView(viewUID, name);
    }

    @Override
    public void chopExternalFrame(int offset) {
        this.outputStream.chopExternalFrame(offset);
    }

    @Override
    public void chopExternalHeaderFrame(int offset) {
        this.outputStream.chopExternalHeaderFrame(offset);
    }

    @Override
    public void counter(@NonNull ICounterSeriesKey counterKey, @NonNull ClockSource clockSource, long rawTimestamp, @NonNull ProcessingElementReference peReference, @Nullable TaskId taskId, long value) throws IOException {
        this.outputStream.counter(counterKey, this.map(clockSource, rawTimestamp), peReference, taskId, value);
    }

    @Override
    public void createDynamicCounterSeries(@NonNull DynamicCounterSeriesKey counterKey, @NonNull String title, @NonNull String name, @NonNull String units, @NonNull String description, @NonNull CounterClass counterClass, @NonNull CounterDisplay display, @NonNull SeriesComposition seriesComposition, @NonNull GraphRenderingType renderingType, boolean averageSelection, boolean percentage, @NonNull AnnotationColour colour, double multiplier, @NonNull List<@NonNull String> activities, @NonNull List<@NonNull AnnotationColour> activityColors) throws IOException {
        this.outputStream.createDynamicCounterSeries(counterKey, title, name, units, description, counterClass, display, seriesComposition, renderingType, averageSelection, percentage, colour, multiplier, activities, activityColors);
    }

    @Override
    public void createKernelAnnotationsCounterSeries(@NonNull KernelAnnotationSeriesKey counterKey, @NonNull String title, @NonNull String name, @NonNull String units, @NonNull String description, @NonNull CounterClass counterClass, @NonNull CounterDisplay display, @NonNull SeriesComposition seriesComposition, @NonNull GraphRenderingType renderingType, boolean averageSelection, boolean percentage, @NonNull AnnotationColour colour, double multiplier, @NonNull List<@NonNull String> activities, @NonNull List<@NonNull AnnotationColour> activityColors) throws IOException {
        this.outputStream.createKernelAnnotationsCounterSeries(counterKey, title, name, units, description, counterClass, display, seriesComposition, renderingType, averageSelection, percentage, colour, multiplier, activities, activityColors);
    }

    @Override
    public void idle(@NonNull ClockSource clockSource, long timestamp, @NonNull ProcessingElementReference peReference, boolean online) throws IOException {
        this.outputStream.idle(this.map(clockSource, timestamp), peReference, online);
    }

    @Override
    public void tracepointEvent(@NonNull ClockSource clockSource, long rawTimestamp, @Nullable TaskId taskId, @NonNull TracepointFormat tracepointFormat, byte @NonNull [] raw) throws IOException {
        this.outputStream.tracepointEvent(this.map(clockSource, rawTimestamp), taskId, tracepointFormat, raw);
    }

    @Override
    public void warning(@NonNull ClockSource clockSource, long rawTimestamp, @NonNull TaskId thread, @NonNull WarningItem warning) throws IOException {
        this.outputStream.warning(this.map(clockSource, rawTimestamp), thread, warning);
    }

    @Override
    public void warning(@NonNull WarningItem warning) throws IOException {
        this.outputStream.warning(warning);
    }

    private long map(@NonNull ClockSource clockSource, long rawTimestamp) throws DelayProcessingException {
        return this.timestampMapper.mapTimestamp(clockSource, rawTimestamp);
    }
}

