/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.external;

import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.analysis.model.AnnotationColour;
import com.arm.streamline.protocol.capture.apc.pass_two.warnings.WarningsFactory;
import com.arm.streamline.protocol.capture.apc.protocol.external.BufferSequenceInputStream;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolDecoder;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolEventStream;
import com.arm.streamline.protocol.capture.apc.protocol.external.MaliEventDependencyTracker;
import com.arm.streamline.protocol.capture.apc.time.ClockSource;
import com.arm.utils.NullChecking;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import org.eclipse.jdt.annotation.NonNull;
import perfetto.protos.GpuRenderStageEventOuterClass;
import perfetto.protos.InternedDataOuterClass;
import perfetto.protos.TracePacketOuterClass;

public class EStatePerfetto
implements IExternalProtocolDecoder {
    public static final String PROTOCOL = "PERFETTO";
    private static final int VIEW_ID = 20220613;
    private static final @NonNull AnnotationColour DEFAULT_COLOUR = new AnnotationColour();
    private static final int NO_DEPENDENCIES = -1;
    private static final int @NonNull [] NO_DEPENDENCIES_ARRAY = new int[0];
    private static final long DEFAULT_DURATION = 10L;
    private static final String FBO_PREFIX = "FBO";
    private static final String RP_PREFIX = "Render Pass";
    private static final String CL_DEVICE_PREFIX = "CL Device ID";
    private static final String CL_COMMAND_QUEUE_PREFIX = "CL Command Queue";
    private static final byte PROTOBUF_TRACE_PACKET_TAG = 10;
    private boolean hasAnyGpuData = false;
    private final @NonNull IExternalProtocolEventStream eventStream;
    private final @NonNull TrackHierarchyManager hierarchyManager;
    private final @NonNull BufferSequenceInputStream bufferStream;
    private final @NonNull MaliEventDependencyTracker dependencyTracker;
    private final @NonNull EventReorderBuffer reorderBuffer;

    public EStatePerfetto(@NonNull IExternalProtocolEventStream eventStream) {
        this.eventStream = eventStream;
        this.hierarchyManager = new TrackHierarchyManager(eventStream);
        this.bufferStream = new BufferSequenceInputStream();
        this.dependencyTracker = new MaliEventDependencyTracker(100000000L, 10);
        this.reorderBuffer = new EventReorderBuffer(16, this::parseRenderStageEvent);
    }

    @Override
    public void process(byte @NonNull [] data) throws IOException {
        this.bufferStream.appendBuffer(data);
        while (this.bufferStream.available() > 0) {
            this.bufferStream.mark(-1);
            int tagByte = this.bufferStream.read();
            if (tagByte == -1) {
                this.bufferStream.reset();
                break;
            }
            if (tagByte != 10) {
                CommonPlugin.warning((String)"Perfetto data stream is corrupt and will be ignored.");
                this.bufferStream.clearBuffers();
                break;
            }
            long length = EStatePerfetto.readVarint(this.bufferStream);
            if (length < 0L || (long)this.bufferStream.available() < length) {
                this.bufferStream.reset();
                break;
            }
            this.bufferStream.reset();
            this.bufferStream.read();
            TracePacketOuterClass.TracePacket packet = TracePacketOuterClass.TracePacket.parseDelimitedFrom((InputStream)this.bufferStream);
            this.parsePacket((TracePacketOuterClass.TracePacket)NullChecking.neverNull((Object)packet));
        }
    }

    private void parsePacket(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull TracePacketOuterClass.TracePacket packet) throws IOException {
        if (packet.hasInternedData()) {
            this.parseInternedData(packet.getInternedData());
            this.hasAnyGpuData = true;
        }
        if (packet.hasGpuRenderStageEvent()) {
            this.reorderBuffer.queueEvent(packet);
            this.hasAnyGpuData = true;
        }
    }

    private void parseRenderStageEvent(TracePacketOuterClass.TracePacket packet) throws IOException {
        int previousJob;
        long timestamp = packet.getTimestamp();
        GpuRenderStageEventOuterClass.GpuRenderStageEvent event = packet.getGpuRenderStageEvent();
        int gpuId = 0;
        if (event.hasGpuId()) {
            gpuId = event.getGpuId();
        }
        long duration = 10L;
        if (event.hasDuration()) {
            duration = event.getDuration();
        }
        long queueId = event.getHwQueueIid();
        long contextId = event.getContext();
        ContextApiType apiType = this.hierarchyManager.getApiTypeForContext(contextId);
        Object jobName = String.format("Submission: %d", event.getSubmissionId());
        if (event.hasRenderTargetHandle()) {
            String prefix = FBO_PREFIX;
            if (apiType == ContextApiType.OPEN_CL) {
                prefix = CL_DEVICE_PREFIX;
            }
            jobName = (String)jobName + String.format("\n%s: %d", prefix, event.getRenderTargetHandle());
        }
        if (event.hasRenderPassHandle() && event.getRenderPassHandle() != 0L) {
            jobName = (String)jobName + String.format("\n%s: 0x%08X", RP_PREFIX, event.getRenderPassHandle());
        }
        if (apiType == ContextApiType.OPEN_CL && event.hasCommandBufferHandle()) {
            jobName = (String)jobName + String.format("\n%s: %d", CL_COMMAND_QUEUE_PREFIX, event.getCommandBufferHandle());
        }
        int[] allDependencies = (previousJob = (int)this.dependencyTracker.trackEvent(timestamp, event)) != -1 ? new int[]{previousJob} : NO_DEPENDENCIES_ARRAY;
        int jobId = (int)event.getEventId();
        int trackId = this.hierarchyManager.getTrackId(gpuId, contextId, queueId);
        this.eventStream.camJob(20220613, ClockSource.MONOTONIC_RAW, timestamp, duration, trackId, jobId, (String)jobName, DEFAULT_COLOUR, previousJob, allDependencies);
    }

    private void parseInternedData(InternedDataOuterClass.InternedData data) {
        for (GpuRenderStageEventOuterClass.InternedGraphicsContext ctx : data.getGraphicsContextsList()) {
            this.hierarchyManager.defineGraphicsContext(ctx.getIid(), ctx);
        }
        for (GpuRenderStageEventOuterClass.InternedGpuRenderStageSpecification spec : data.getGpuSpecificationsList()) {
            QueueCategory queueType;
            block15: {
                block14: {
                    if (!GpuRenderStageEventOuterClass.InternedGpuRenderStageSpecification.RenderStageCategory.COMPUTE.equals((Object)spec.getCategory())) break block14;
                    queueType = QueueCategory.COMPUTE;
                    break block15;
                }
                switch (spec.getName()) {
                    case "non-fragment": 
                    case "vertex": {
                        queueType = QueueCategory.NON_FRAGMENT;
                        break;
                    }
                    case "fragment": {
                        queueType = QueueCategory.FRAGMENT;
                        break;
                    }
                    default: {
                        queueType = QueueCategory.UNKNOWN;
                    }
                }
            }
            this.hierarchyManager.defineGpuQueue(spec.getIid(), queueType);
        }
    }

    private static long readVarint(InputStream in) throws IOException {
        long value = 0L;
        int shift = 0;
        while (true) {
            if (in.available() < 1) {
                return -1L;
            }
            int b = in.read();
            if (b == -1) break;
            value |= (long)((b & 0x7F) << shift);
            if ((b & 0x80) == 0) break;
            shift += 7;
        }
        return value;
    }

    @Override
    public void close() throws IOException {
        this.reorderBuffer.flushAllEvents();
        if (!this.hasAnyGpuData) {
            this.eventStream.warning(WarningsFactory.missingMaliTimelineData());
        }
    }

    @Override
    public boolean reorderable() {
        return false;
    }

    private static enum ContextApiType {
        UNKNOWN,
        OPEN_GL,
        VULKAN,
        OPEN_CL;


        public static @NonNull ContextApiType fromPerfettoType(GpuRenderStageEventOuterClass.InternedGraphicsContext ctx) {
            if (ctx.hasApi()) {
                switch (ctx.getApi()) {
                    case OPEN_GL: {
                        return OPEN_GL;
                    }
                    case VULKAN: {
                        return VULKAN;
                    }
                    case OPEN_CL: {
                        return OPEN_CL;
                    }
                }
                return UNKNOWN;
            }
            return UNKNOWN;
        }
    }

    private static class ContextState {
        public final @NonNull ContextApiType api;
        public final int pid;

        public ContextState(@NonNull ContextApiType api, int pid) {
            this.api = api;
            this.pid = pid;
        }
    }

    private static interface EventConsumer {
        public void accept(TracePacketOuterClass.TracePacket var1) throws IOException;
    }

    private static class EventReorderBuffer {
        private final int bufferSize;
        private final @NonNull PriorityQueue<// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull TracePacketOuterClass.TracePacket> packetQueue;
        private final @NonNull EventConsumer consumer;

        public EventReorderBuffer(int bufferSize, @NonNull EventConsumer consumer) {
            this.bufferSize = bufferSize;
            this.consumer = consumer;
            this.packetQueue = new PriorityQueue(bufferSize, (a, b) -> {
                long diff = a.getTimestamp() - b.getTimestamp();
                if (diff < 0L) {
                    return -1;
                }
                if (diff == 0L) {
                    return 0;
                }
                return 1;
            });
        }

        public void queueEvent(// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull TracePacketOuterClass.TracePacket packet) throws IOException {
            this.packetQueue.offer(packet);
            while (this.packetQueue.size() > this.bufferSize) {
                this.consumer.accept((TracePacketOuterClass.TracePacket)NullChecking.neverNull((Object)this.packetQueue.poll()));
            }
        }

        public void flushAllEvents() throws IOException {
            while (!this.packetQueue.isEmpty()) {
                this.consumer.accept((TracePacketOuterClass.TracePacket)NullChecking.neverNull((Object)this.packetQueue.poll()));
            }
        }
    }

    private static enum QueueCategory {
        NON_FRAGMENT("Non-fragment"),
        FRAGMENT("Fragment"),
        COMPUTE("Compute"),
        UNKNOWN("Unknown");

        private String value;

        private QueueCategory(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    private static class TrackHierarchyManager {
        private static final @NonNull String VIEW_NAME = "Mali Timeline";
        private static final @NonNull String DEVICE_PREFIX = "Device";
        private static final @NonNull String PID_PREFIX = "PID";
        private static final @NonNull String CONTEXT_PREFIX = "Context";
        private static final int CONTEXT_RESERVED_TRACKS = 16;
        private final @NonNull IExternalProtocolEventStream eventStream;
        private boolean viewEmitted = false;
        private Map<@NonNull Integer, @NonNull Integer> mapOfContextTrackCounters = new HashMap<Integer, Integer>();
        private final @NonNull Map<@NonNull Long, @NonNull QueueCategory> gpuQueueDefinitionTable = new HashMap<Long, QueueCategory>();
        private final @NonNull TLongObjectHashMap<ContextState> contextIdToStateTable;
        private final @NonNull Map<@NonNull TrackKey, Integer> keyToTrackIdTable;
        private int trackIdCounter;

        public TrackHierarchyManager(@NonNull IExternalProtocolEventStream eventStream) {
            this.eventStream = eventStream;
            this.keyToTrackIdTable = new HashMap<TrackKey, Integer>();
            this.contextIdToStateTable = new TLongObjectHashMap(10, 0.5f, -1L);
        }

        public void defineGpuQueue(long id, @NonNull QueueCategory type) {
            this.gpuQueueDefinitionTable.put(id, type);
        }

        public void defineGraphicsContext(long id, GpuRenderStageEventOuterClass.InternedGraphicsContext ctx) {
            ContextState state = new ContextState(ContextApiType.fromPerfettoType(ctx), ctx.getPid());
            this.contextIdToStateTable.put(id, (Object)state);
        }

        public @NonNull ContextApiType getApiTypeForContext(long contextId) {
            ContextState value = (ContextState)this.contextIdToStateTable.get(contextId);
            return value == null ? ContextApiType.UNKNOWN : value.api;
        }

        public @NonNull QueueCategory getQueueForId(long queueHwId) {
            return this.gpuQueueDefinitionTable.getOrDefault(queueHwId, QueueCategory.UNKNOWN);
        }

        public int getTrackId(int gpuId, long contextId, long queueId) throws IOException {
            return this.getOrCreateQueueTrack(gpuId, contextId, queueId);
        }

        private int getOrCreateQueueTrack(int gpuId, long contextId, long queueId) throws IOException {
            ContextState state = (ContextState)this.contextIdToStateTable.get(contextId);
            TrackKey key = new TrackKey(gpuId, state.pid, contextId, queueId);
            Integer id = this.keyToTrackIdTable.get(key);
            if (id == null) {
                Object trackName;
                int parentId = this.getOrCreateContextTrack(gpuId, state.pid, contextId);
                QueueCategory queueType = this.getQueueForId(queueId);
                if (queueType == QueueCategory.UNKNOWN) {
                    this.eventStream.warning(WarningsFactory.unknownMaliTimelineQueue(queueId));
                    trackName = "Queue 0x" + Long.toHexString(queueId);
                } else {
                    trackName = String.format("%s Queue", queueType.getValue());
                }
                if (queueType == QueueCategory.NON_FRAGMENT) {
                    id = parentId + 1;
                } else if (queueType == QueueCategory.FRAGMENT) {
                    id = parentId + 2;
                } else {
                    @NonNull Integer counter = 0;
                    counter = (Integer)NullChecking.neverNull((Object)this.mapOfContextTrackCounters.get(parentId));
                    id = parentId + counter;
                    counter = counter + 1;
                    this.mapOfContextTrackCounters.put(parentId, counter);
                }
                this.eventStream.camTrack(20220613, parentId, id, (String)trackName);
                this.keyToTrackIdTable.put(key, id);
            }
            return id;
        }

        private int getOrCreateContextTrack(int gpuId, int pid, long contextId) throws IOException {
            TrackKey key = new TrackKey(gpuId, pid, contextId);
            Integer id = this.keyToTrackIdTable.get(key);
            if (id == null) {
                int parentId = this.getOrCreatePidTrack(gpuId, pid);
                id = this.trackIdCounter++;
                this.trackIdCounter += 16;
                this.mapOfContextTrackCounters.put(id, 3);
                this.eventStream.camTrack(20220613, parentId, id, String.format("%s 0x%08X", CONTEXT_PREFIX, contextId));
                this.keyToTrackIdTable.put(key, id);
            }
            return id;
        }

        private int getOrCreatePidTrack(int gpuId, int pid) throws IOException {
            TrackKey key = new TrackKey(gpuId, pid);
            Integer id = this.keyToTrackIdTable.get(key);
            if (id == null) {
                int parentId = this.getOrCreateDeviceTrack(gpuId);
                id = this.trackIdCounter++;
                this.eventStream.camTrack(20220613, parentId, id, String.format("%s %d", PID_PREFIX, pid));
                this.keyToTrackIdTable.put(key, id);
            }
            return id;
        }

        private int getOrCreateDeviceTrack(int gpuId) throws IOException {
            TrackKey key;
            Integer id;
            if (!this.viewEmitted) {
                this.eventStream.camView(20220613, VIEW_NAME);
                this.viewEmitted = true;
            }
            if ((id = this.keyToTrackIdTable.get(key = new TrackKey(gpuId))) == null) {
                id = this.trackIdCounter++;
                this.eventStream.camTrack(20220613, -1, id, String.format("%s %d", DEVICE_PREFIX, gpuId));
                this.keyToTrackIdTable.put(key, id);
            }
            return id;
        }

        private static class TrackKey {
            int gpuId;
            int pid;
            long contextId;
            long queueId;

            TrackKey(int gpuId) {
                this(gpuId, -1, -1L, -1L);
            }

            TrackKey(int gpuId, int pid) {
                this(gpuId, pid, -1L, -1L);
            }

            TrackKey(int gpuId, int pid, long contextId) {
                this(gpuId, pid, contextId, -1L);
            }

            TrackKey(int gpuId, int pid, long contextId, long queueId) {
                this.gpuId = gpuId;
                this.pid = pid;
                this.contextId = contextId;
                this.queueId = queueId;
            }

            public int hashCode() {
                return Objects.hash(this.contextId, this.gpuId, this.pid, this.queueId);
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                TrackKey other = (TrackKey)obj;
                return this.contextId == other.contextId && this.gpuId == other.gpuId && this.pid == other.pid && this.queueId == other.queueId;
            }
        }
    }
}

