/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.external;

import com.arm.streamline.protocol.capture.apc.pass_two.warnings.WarningsFactory;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolEventStream;
import com.arm.streamline.protocol.capture.apc.protocol.external.IMaliOpenCLCAMGenerator;
import com.arm.streamline.protocol.capture.apc.protocol.external.IMaliProtocolDecoder;
import com.arm.streamline.protocol.capture.apc.protocol.external.IMidgardActivityParser;
import com.arm.streamline.protocol.capture.apc.protocol.external.mipe.MipeVersion;
import com.arm.streamline.protocol.gator.io.ByteBufferAPCByteReader;
import com.arm.utils.NullChecking;
import com.arm.utils.text.BasicStringUtils;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class EStateMaliSWTrace
implements IMaliProtocolDecoder {
    private static final Charset CHARSET = Charset.forName("US-ASCII");
    private static final boolean LOG = false;
    private final @NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator;
    private final @NonNull TIntObjectMap<String> mApiNameMap = new TIntObjectHashMap();
    private final @NonNull ByteArrayOutputStream mBaos = new ByteArrayOutputStream();
    private final @NonNull IMidgardActivityParser midgardActivityParser;
    private IMessage mMessage;
    private IMessage[] mMessages;
    private int mPointerBytes;
    private State mState = State.STREAM_VERSION;
    private int mStreamVersion;
    private int mStrLen = Integer.MIN_VALUE;
    private int mThreadIdBytes;
    private final @NonNull IExternalProtocolEventStream outputStream;
    private final int protocolVersionMajor;

    private static int readS32(byte[] buf) {
        return (buf[0] & 0xFF) << 0 | (buf[1] & 0xFF) << 8 | (buf[2] & 0xFF) << 16 | (buf[3] & 0xFF) << 24;
    }

    private static long readS64(byte[] buf) {
        return ((long)buf[0] & 0xFFL) << 0 | ((long)buf[1] & 0xFFL) << 8 | ((long)buf[2] & 0xFFL) << 16 | ((long)buf[3] & 0xFFL) << 24 | ((long)buf[4] & 0xFFL) << 32 | ((long)buf[5] & 0xFFL) << 40 | ((long)buf[6] & 0xFFL) << 48 | ((long)buf[7] & 0xFFL) << 56;
    }

    private static long readU32(byte[] buf) {
        return ((long)buf[0] & 0xFFL) << 0 | ((long)buf[1] & 0xFFL) << 8 | ((long)buf[2] & 0xFFL) << 16 | ((long)buf[3] & 0xFFL) << 24;
    }

    private static long readU64(byte[] buf) {
        return ((long)buf[0] & 0xFFL) << 0 | ((long)buf[1] & 0xFFL) << 8 | ((long)buf[2] & 0xFFL) << 16 | ((long)buf[3] & 0xFFL) << 24 | ((long)buf[4] & 0xFFL) << 32 | ((long)buf[5] & 0xFFL) << 40 | ((long)buf[6] & 0xFFL) << 48 | ((long)buf[7] & 0xFFL) << 56;
    }

    private static int readU8(byte b) {
        return b & 0xFF;
    }

    public EStateMaliSWTrace(@NonNull IExternalProtocolEventStream outputStream, @Nullable MipeVersion protocolVersion, @NonNull IMidgardActivityParser midgardActivityParser, @NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator) {
        this.outputStream = outputStream;
        this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
        this.midgardActivityParser = midgardActivityParser;
        this.protocolVersionMajor = protocolVersion != null ? protocolVersion.major : 0;
        maliOpenCLCAMGenerator.setProtocolVersion(protocolVersion);
    }

    @Override
    public void process(byte @NonNull [] data) throws IOException {
        ByteBufferAPCByteReader in = new ByteBufferAPCByteReader(data);
        int size = in.remaining();
        int origPos = in.position();
        block14: while (in.position() < origPos + size) {
            switch (this.mState) {
                case STREAM_VERSION: {
                    this.mStreamVersion = EStateMaliSWTrace.readU8(in.getSignedByte());
                    if (this.mStreamVersion != 3 && this.mStreamVersion != 4) {
                        this.outputStream.warning(WarningsFactory.unsupportedMaliProtocol(this.mStreamVersion));
                        this.mState = State.ERROR;
                        return;
                    }
                    this.mState = State.POINTER_BYTES;
                    break;
                }
                case POINTER_BYTES: {
                    this.mPointerBytes = EStateMaliSWTrace.readU8(in.getSignedByte());
                    this.mState = State.THREAD_ID_BYTES;
                    break;
                }
                case THREAD_ID_BYTES: {
                    this.mThreadIdBytes = this.mStreamVersion == 3 ? 4 : EStateMaliSWTrace.readU8(in.getSignedByte());
                    this.mState = State.DATA;
                    this.mMessage = new DirectoryMessage(this.maliOpenCLCAMGenerator, this.midgardActivityParser, this.protocolVersionMajor, this.mApiNameMap, this.mPointerBytes, this.mThreadIdBytes);
                    break;
                }
                case FINISH_DIRECTORY: {
                    DirectoryMessage directoryMessage = (DirectoryMessage)this.mMessage;
                    this.mMessages = directoryMessage.mMessages;
                    this.mState = State.DECL_ID;
                    break;
                }
                case DECL_ID: {
                    this.mBaos.write(in.getSignedByte());
                    if (this.mBaos.size() != 4) continue block14;
                    byte[] buf = this.mBaos.toByteArray();
                    this.mBaos.reset();
                    int declId = (int)EStateMaliSWTrace.readU32(buf);
                    if (declId < 0 || declId >= this.mMessages.length) {
                        throw new IOException();
                    }
                    this.mMessage = this.mMessages[declId].constructMessage();
                    this.mState = State.DATA;
                    break;
                }
                case DATA: 
                case DATA_1: 
                case DATA_2: 
                case DATA_3: 
                case DATA_4: 
                case DATA_5: 
                case DATA_6: {
                    Type type = this.mMessage.getType(this.mState.ordinal() - State.DATA.ordinal());
                    switch (type) {
                        case U8: {
                            int i = EStateMaliSWTrace.readU8(in.getSignedByte());
                            this.mState = this.mMessage.setLong(this.mState, i);
                            break;
                        }
                        case S32: 
                        case U32: {
                            this.mBaos.write(in.getSignedByte());
                            if (this.mBaos.size() != 4) continue block14;
                            byte[] buf = this.mBaos.toByteArray();
                            this.mBaos.reset();
                            if (type == Type.S32) {
                                int i = EStateMaliSWTrace.readS32(buf);
                                this.mState = this.mMessage.setLong(this.mState, i);
                                break;
                            }
                            long l = EStateMaliSWTrace.readU32(buf);
                            this.mState = this.mMessage.setLong(this.mState, l);
                            break;
                        }
                        case S64: 
                        case U64: {
                            this.mBaos.write(in.getSignedByte());
                            if (this.mBaos.size() != 8) continue block14;
                            byte[] buf = this.mBaos.toByteArray();
                            this.mBaos.reset();
                            long l = type == Type.S64 ? EStateMaliSWTrace.readS64(buf) : EStateMaliSWTrace.readU64(buf);
                            this.mState = this.mMessage.setLong(this.mState, l);
                            break;
                        }
                        default: {
                            throw new IOException();
                        }
                        case STRING: {
                            if (this.mStrLen == Integer.MIN_VALUE) {
                                this.mBaos.write(in.getSignedByte());
                                if (this.mBaos.size() != 4) continue block14;
                                this.mStrLen = (int)EStateMaliSWTrace.readU32(this.mBaos.toByteArray());
                                this.mBaos.reset();
                                if (this.mStrLen >= 0 && this.mStrLen < 1024) continue block14;
                                throw new IOException();
                            }
                            int remove = size - in.position() + origPos;
                            if (remove > this.mStrLen - this.mBaos.size()) {
                                remove = this.mStrLen - this.mBaos.size();
                            }
                            in.get(this.mBaos, remove);
                            if (this.mStrLen != this.mBaos.size()) continue block14;
                            String s = new String(this.mBaos.toByteArray(), 0, this.mStrLen - 1, CHARSET);
                            this.mBaos.reset();
                            this.mStrLen = Integer.MIN_VALUE;
                            this.mState = this.mMessage.setString(this.mState, s);
                            break;
                        }
                    }
                    continue block14;
                }
                default: {
                    return;
                }
            }
        }
    }

    private static class AttributeClosureTimestampsMessage
    implements IMessage {
        public static final String DECL_NAME = "CINSTR_TL_ATTRIB_CLOSURE_TIMESTAMPS";
        private static final String CLOSURE_NAME = "closure";
        private static final String THREAD_ID_NAME = "thread_id";
        private static final String TIMESTAMP_END_NAME = "timestamp_end";
        private static final String TIMESTAMP_NAME = "timestamp";
        private static final String TIMESTAMP_START_NAME = "timestamp_start";
        private final @NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator;
        private long mClosure;
        private final int mClosurePos;
        private long mThreadID;
        private final int mThreadIDPos;
        private long mTimestamp;
        private long mTimestampEnd;
        private final int mTimestampEndPos;
        private final int mTimestampPos;
        private long mTimestampStart;
        private final int mTimestampStartPos;
        private final Type[] mTypes;

        public AttributeClosureTimestampsMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, String[] argNames, Type[] argTypes) throws IOException {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            int timestampPos = -1;
            int threadIDPos = -1;
            int closurePos = -1;
            int timestampStartPos = -1;
            int timestampEndPos = -1;
            int i = 0;
            while (i < argNames.length) {
                switch (argNames[i]) {
                    case "timestamp": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        timestampPos = i;
                        break;
                    }
                    case "thread_id": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        threadIDPos = i;
                        break;
                    }
                    case "closure": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        closurePos = i;
                        break;
                    }
                    case "timestamp_start": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        timestampStartPos = i;
                        break;
                    }
                    case "timestamp_end": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        timestampEndPos = i;
                        break;
                    }
                }
                ++i;
            }
            if (timestampPos == -1 || threadIDPos == -1 || closurePos == -1 || timestampStartPos == -1 || timestampEndPos == -1) {
                throw new IOException();
            }
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mClosurePos = closurePos;
            this.mTimestampStartPos = timestampStartPos;
            this.mTimestampEndPos = timestampEndPos;
        }

        private AttributeClosureTimestampsMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, int timestampPos, int threadIDPos, int closurePos, int timestampStartPos, int timestampEndPos, Type[] argTypes) {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mClosurePos = closurePos;
            this.mTimestampStartPos = timestampStartPos;
            this.mTimestampEndPos = timestampEndPos;
        }

        @Override
        public IMessage constructMessage() {
            return new AttributeClosureTimestampsMessage(this.maliOpenCLCAMGenerator, this.mTimestampPos, this.mThreadIDPos, this.mClosurePos, this.mTimestampStartPos, this.mTimestampEndPos, this.mTypes);
        }

        @Override
        public Type getType(int i) {
            return this.mTypes[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mTimestampPos) {
                this.mTimestamp = l;
            } else if (pos == this.mThreadIDPos) {
                this.mThreadID = l;
            } else if (pos == this.mClosurePos) {
                this.mClosure = l;
            } else if (pos == this.mTimestampStartPos) {
                this.mTimestampStart = l;
            } else if (pos == this.mTimestampEndPos) {
                this.mTimestampEnd = l;
            }
            return this.advance(state);
        }

        @Override
        public State setString(State state, String s) throws IOException {
            return this.advance(state);
        }

        private State advance(State state) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos + 1 < this.mTypes.length) {
                return State.values()[state.ordinal() + 1];
            }
            long mappedTimestamp = this.mTimestamp;
            long mappedTimestampStart = this.mTimestampStart - this.mTimestamp + mappedTimestamp;
            long mappedTimestampEnd = this.mTimestampEnd - this.mTimestamp + mappedTimestamp;
            this.maliOpenCLCAMGenerator.attributeClosureTimestamps(mappedTimestamp, this.mThreadID, this.mClosure, mappedTimestampStart, mappedTimestampEnd);
            return State.DECL_ID;
        }
    }

    private static class AttributeCommandAPINameMessage
    implements IMessage {
        public static final String DECL_NAME = "CINSTR_TL_ATTRIB_COMMAND_API_NAME";
        private static final String API_NAME_NAME = "api_name";
        private static final String COMMAND_NAME = "command";
        private static final String THREAD_ID_NAME = "thread_id";
        private static final String TIMESTAMP_NAME = "timestamp";
        private final @NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator;
        private long mApiName;
        private final TIntObjectMap<String> mApiNameMap;
        private final int mApiNamePos;
        private long mCommand;
        private final int mCommandPos;
        private long mThreadID;
        private final int mThreadIDPos;
        private long mTimestamp;
        private final int mTimestampPos;
        private final Type[] mTypes;

        public AttributeCommandAPINameMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, TIntObjectMap<String> apiNameMap, String[] argNames, Type[] argTypes) throws IOException {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mApiNameMap = apiNameMap;
            this.mTypes = argTypes;
            int timestampPos = -1;
            int threadIDPos = -1;
            int commandPos = -1;
            int apiNamePos = -1;
            int i = 0;
            while (i < argNames.length) {
                switch (argNames[i]) {
                    case "timestamp": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        timestampPos = i;
                        break;
                    }
                    case "thread_id": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        threadIDPos = i;
                        break;
                    }
                    case "command": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        commandPos = i;
                        break;
                    }
                    case "api_name": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        apiNamePos = i;
                        break;
                    }
                }
                ++i;
            }
            if (timestampPos == -1 || threadIDPos == -1 || commandPos == -1 || apiNamePos == -1) {
                throw new IOException();
            }
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mCommandPos = commandPos;
            this.mApiNamePos = apiNamePos;
        }

        private AttributeCommandAPINameMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, TIntObjectMap<String> apiNameMap, int timestampPos, int threadIDPos, int commandPos, int apiNamePos, Type[] argTypes) {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mApiNameMap = apiNameMap;
            this.mTypes = argTypes;
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mCommandPos = commandPos;
            this.mApiNamePos = apiNamePos;
        }

        @Override
        public IMessage constructMessage() {
            return new AttributeCommandAPINameMessage(this.maliOpenCLCAMGenerator, this.mApiNameMap, this.mTimestampPos, this.mThreadIDPos, this.mCommandPos, this.mApiNamePos, this.mTypes);
        }

        @Override
        public Type getType(int i) {
            return this.mTypes[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mTimestampPos) {
                this.mTimestamp = l;
            } else if (pos == this.mThreadIDPos) {
                this.mThreadID = l;
            } else if (pos == this.mCommandPos) {
                this.mCommand = l;
            } else if (pos == this.mApiNamePos) {
                this.mApiName = l;
            }
            return this.advance(state);
        }

        @Override
        public State setString(State state, String s) throws IOException {
            return this.advance(state);
        }

        private State advance(State state) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos + 1 < this.mTypes.length) {
                return State.values()[state.ordinal() + 1];
            }
            this.maliOpenCLCAMGenerator.attributeCommandAPIName(this.mTimestamp, this.mThreadID, this.mCommand, (String)NullChecking.neverNull((Object)((String)this.mApiNameMap.get((int)this.mApiName))));
            return State.DECL_ID;
        }
    }

    private static class AttributeKernelNameMessage
    implements IMessage {
        public static final String DECL_NAME = "CINSTR_TL_ATTRIB_KERNEL_NAME";
        private static final String KERNEL_NAME = "kernel";
        private static final String NAME_NAME = "name";
        private static final String THREAD_ID_NAME = "thread_id";
        private static final String TIMESTAMP_NAME = "timestamp";
        private final @NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator;
        private long mKernel;
        private final int mKernelPos;
        private String mName;
        private final int mNamePos;
        private long mThreadID;
        private final int mThreadIDPos;
        private long mTimestamp;
        private final int mTimestampPos;
        private final Type[] mTypes;

        public AttributeKernelNameMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, String[] argNames, Type[] argTypes) throws IOException {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            int timestampPos = -1;
            int threadIDPos = -1;
            int kernelPos = -1;
            int namePos = -1;
            int i = 0;
            while (i < argNames.length) {
                switch (argNames[i]) {
                    case "timestamp": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        timestampPos = i;
                        break;
                    }
                    case "thread_id": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        threadIDPos = i;
                        break;
                    }
                    case "kernel": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        kernelPos = i;
                        break;
                    }
                    case "name": {
                        if (!argTypes[i].isStringType()) {
                            throw new IOException();
                        }
                        namePos = i;
                        break;
                    }
                }
                ++i;
            }
            if (timestampPos == -1 || threadIDPos == -1 || kernelPos == -1 || namePos == -1) {
                throw new IOException();
            }
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mKernelPos = kernelPos;
            this.mNamePos = namePos;
        }

        private AttributeKernelNameMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, int timestampPos, int threadIDPos, int queuePos, int deviceNamePos, Type[] argTypes) {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mKernelPos = queuePos;
            this.mNamePos = deviceNamePos;
        }

        @Override
        public IMessage constructMessage() {
            return new AttributeKernelNameMessage(this.maliOpenCLCAMGenerator, this.mTimestampPos, this.mThreadIDPos, this.mKernelPos, this.mNamePos, this.mTypes);
        }

        @Override
        public Type getType(int i) {
            return this.mTypes[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mTimestampPos) {
                this.mTimestamp = l;
            } else if (pos == this.mThreadIDPos) {
                this.mThreadID = l;
            } else if (pos == this.mKernelPos) {
                this.mKernel = l;
            }
            return this.advance(state);
        }

        @Override
        public State setString(State state, String s) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mNamePos) {
                this.mName = s;
            }
            return this.advance(state);
        }

        private State advance(State state) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos + 1 < this.mTypes.length) {
                return State.values()[state.ordinal() + 1];
            }
            this.maliOpenCLCAMGenerator.attributeKernelName(this.mTimestamp, this.mThreadID, this.mKernel, (String)NullChecking.neverNullOr((Object)this.mName, (Object)""));
            return State.DECL_ID;
        }
    }

    private static class AttributeQueueDeviceNameMessage
    implements IMessage {
        public static final String DECL_NAME = "CINSTR_TL_ATTRIB_QUEUE_DEVICE_NAME";
        private static final String DEVICE_NAME_NAME = "device_name";
        private static final String QUEUE_NAME = "queue";
        private static final String THREAD_ID_NAME = "thread_id";
        private static final String TIMESTAMP_NAME = "timestamp";
        private final @NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator;
        private String mDeviceName;
        private final int mDeviceNamePos;
        private long mQueue;
        private final int mQueuePos;
        private long mThreadID;
        private final int mThreadIDPos;
        private long mTimestamp;
        private final int mTimestampPos;
        private final Type[] mTypes;

        public AttributeQueueDeviceNameMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, String[] argNames, Type[] argTypes) throws IOException {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            int timestampPos = -1;
            int threadIDPos = -1;
            int queuePos = -1;
            int deviceNamePos = -1;
            int i = 0;
            while (i < argNames.length) {
                switch (argNames[i]) {
                    case "timestamp": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        timestampPos = i;
                        break;
                    }
                    case "thread_id": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        threadIDPos = i;
                        break;
                    }
                    case "queue": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        queuePos = i;
                        break;
                    }
                    case "device_name": {
                        if (!argTypes[i].isStringType()) {
                            throw new IOException();
                        }
                        deviceNamePos = i;
                        break;
                    }
                }
                ++i;
            }
            if (timestampPos == -1 || threadIDPos == -1 || queuePos == -1 || deviceNamePos == -1) {
                throw new IOException();
            }
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mQueuePos = queuePos;
            this.mDeviceNamePos = deviceNamePos;
        }

        private AttributeQueueDeviceNameMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, int timestampPos, int threadIDPos, int queuePos, int deviceNamePos, Type[] argTypes) {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mQueuePos = queuePos;
            this.mDeviceNamePos = deviceNamePos;
        }

        @Override
        public IMessage constructMessage() {
            return new AttributeQueueDeviceNameMessage(this.maliOpenCLCAMGenerator, this.mTimestampPos, this.mThreadIDPos, this.mQueuePos, this.mDeviceNamePos, this.mTypes);
        }

        @Override
        public Type getType(int i) {
            return this.mTypes[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mTimestampPos) {
                this.mTimestamp = l;
            } else if (pos == this.mThreadIDPos) {
                this.mThreadID = l;
            } else if (pos == this.mQueuePos) {
                this.mQueue = l;
            }
            return this.advance(state);
        }

        @Override
        public State setString(State state, String s) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mDeviceNamePos) {
                this.mDeviceName = s;
            }
            return this.advance(state);
        }

        private State advance(State state) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos + 1 < this.mTypes.length) {
                return State.values()[state.ordinal() + 1];
            }
            this.maliOpenCLCAMGenerator.attributeQueueDeviceName(this.mTimestamp, this.mThreadID, this.mQueue, (String)NullChecking.neverNull((Object)this.mDeviceName));
            return State.DECL_ID;
        }
    }

    private static class AttributeThreadApiNameMessage
    implements IMessage {
        public static final String DECL_NAME = "CINSTR_TL_ATTRIB_THREAD_API_NAME";
        private static final String API_NAME = "api_name";
        private static final String THREAD_ID_NAME = "thread_id";
        private static final String TIMESTAMP_NAME = "timestamp";
        private final @NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator;
        private long mApiName;
        private final TIntObjectMap<String> mApiNameMap;
        private final int mApiNamePos;
        private long mThreadID;
        private final int mThreadIDPos;
        private long mTimestamp;
        private final int mTimestampPos;
        private final Type[] mTypes;

        public AttributeThreadApiNameMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, TIntObjectMap<String> apiNameMap, String[] argNames, Type[] argTypes) throws IOException {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mApiNameMap = apiNameMap;
            this.mTypes = argTypes;
            int timestampPos = -1;
            int threadIDPos = -1;
            int apiNamePos = -1;
            int i = 0;
            while (i < argNames.length) {
                switch (argNames[i]) {
                    case "timestamp": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        timestampPos = i;
                        break;
                    }
                    case "thread_id": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        threadIDPos = i;
                        break;
                    }
                    case "api_name": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        apiNamePos = i;
                        break;
                    }
                }
                ++i;
            }
            if (timestampPos == -1 || threadIDPos == -1 || apiNamePos == -1) {
                throw new IOException();
            }
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mApiNamePos = apiNamePos;
        }

        private AttributeThreadApiNameMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, TIntObjectMap<String> apiNameMap, int timestampPos, int threadIDPos, int apiNamePos, Type[] argTypes) {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mApiNameMap = apiNameMap;
            this.mTypes = argTypes;
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mApiNamePos = apiNamePos;
        }

        @Override
        public IMessage constructMessage() {
            return new AttributeThreadApiNameMessage(this.maliOpenCLCAMGenerator, this.mApiNameMap, this.mTimestampPos, this.mThreadIDPos, this.mApiNamePos, this.mTypes);
        }

        @Override
        public Type getType(int i) {
            return this.mTypes[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mTimestampPos) {
                this.mTimestamp = l;
            } else if (pos == this.mThreadIDPos) {
                this.mThreadID = l;
            } else if (pos == this.mApiNamePos) {
                this.mApiName = l;
            }
            return this.advance(state);
        }

        @Override
        public State setString(State state, String s) throws IOException {
            return this.advance(state);
        }

        private State advance(State state) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos + 1 < this.mTypes.length) {
                return State.values()[state.ordinal() + 1];
            }
            this.maliOpenCLCAMGenerator.attributeThreadAPIName(this.mTimestamp, this.mThreadID, (String)NullChecking.neverNull((Object)((String)this.mApiNameMap.get((int)this.mApiName))));
            return State.DECL_ID;
        }
    }

    private static class BlockQueueMessage
    implements IMessage {
        public static final String DECL_NAME = "CINSTR_TL_BLOCK_QUEUE";
        private static final String QUEUE_NAME = "queue";
        private static final String THREAD_ID_NAME = "thread_id";
        private static final String TIMESTAMP_NAME = "timestamp";
        private final @NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator;
        private long mQueue;
        private final int mQueuePos;
        private long mThreadID;
        private final int mThreadIDPos;
        private long mTimestamp;
        private final int mTimestampPos;
        private final Type[] mTypes;

        public BlockQueueMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, String[] argNames, Type[] argTypes) throws IOException {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            int timestampPos = -1;
            int threadIDPos = -1;
            int queuePos = -1;
            int i = 0;
            while (i < argNames.length) {
                switch (argNames[i]) {
                    case "timestamp": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        timestampPos = i;
                        break;
                    }
                    case "thread_id": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        threadIDPos = i;
                        break;
                    }
                    case "queue": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        queuePos = i;
                        break;
                    }
                }
                ++i;
            }
            if (timestampPos == -1 || threadIDPos == -1 || queuePos == -1) {
                throw new IOException();
            }
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mQueuePos = queuePos;
        }

        private BlockQueueMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, int timestampPos, int threadIDPos, int queuePos, Type[] argTypes) {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mQueuePos = queuePos;
        }

        @Override
        public IMessage constructMessage() {
            return new BlockQueueMessage(this.maliOpenCLCAMGenerator, this.mTimestampPos, this.mThreadIDPos, this.mQueuePos, this.mTypes);
        }

        @Override
        public Type getType(int i) {
            return this.mTypes[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mTimestampPos) {
                this.mTimestamp = l;
            } else if (pos == this.mThreadIDPos) {
                this.mThreadID = l;
            } else if (pos == this.mQueuePos) {
                this.mQueue = l;
            }
            return this.advance(state);
        }

        @Override
        public State setString(State state, String s) throws IOException {
            return this.advance(state);
        }

        private State advance(State state) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos + 1 < this.mTypes.length) {
                return State.values()[state.ordinal() + 1];
            }
            this.maliOpenCLCAMGenerator.blockQueue(this.mTimestamp, this.mThreadID, this.mQueue);
            return State.DECL_ID;
        }
    }

    private static class CinstrContextAddNrMessage
    implements IMessage {
        public static final String DECL_NAME = "CINSTR_TL_ATTRIB_CTX_CTX_NR";
        private static final String CTX_NAME = "ctx";
        private static final String CTX_NR_NAME = "ctx_nr";
        private static final String TIMESTAMP_NAME = "timestamp";
        private long mCtx;
        private long mCtxNr;
        private final int mCtxNrPos;
        private final int mCtxPos;
        private final @NonNull IMidgardActivityParser midgardActivityParser;
        private long mTimestamp;
        private final int mTimestampPos;
        private final Type[] mTypes;

        public CinstrContextAddNrMessage(@NonNull IMidgardActivityParser midgardActivityParser, String[] argNames, Type[] argTypes) throws IOException {
            this.midgardActivityParser = midgardActivityParser;
            this.mTypes = argTypes;
            int timestampPos = -1;
            int ctxPos = -1;
            int ctxNrPos = -1;
            int i = 0;
            while (i < argNames.length) {
                switch (argNames[i]) {
                    case "timestamp": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        timestampPos = i;
                        break;
                    }
                    case "ctx": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        ctxPos = i;
                        break;
                    }
                    case "ctx_nr": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        ctxNrPos = i;
                        break;
                    }
                }
                ++i;
            }
            if (timestampPos == -1 || ctxPos == -1 || ctxNrPos == -1) {
                throw new IOException();
            }
            this.mTimestampPos = timestampPos;
            this.mCtxPos = ctxPos;
            this.mCtxNrPos = ctxNrPos;
        }

        private CinstrContextAddNrMessage(@NonNull IMidgardActivityParser midgardActivityParser, int timestampPos, int ctxPos, int ctxNrPos, Type[] argTypes) {
            this.midgardActivityParser = midgardActivityParser;
            this.mTypes = argTypes;
            this.mTimestampPos = timestampPos;
            this.mCtxPos = ctxPos;
            this.mCtxNrPos = ctxNrPos;
        }

        @Override
        public IMessage constructMessage() {
            return new CinstrContextAddNrMessage(this.midgardActivityParser, this.mTimestampPos, this.mCtxPos, this.mCtxNrPos, this.mTypes);
        }

        @Override
        public Type getType(int i) {
            return this.mTypes[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mTimestampPos) {
                this.mTimestamp = l;
            } else if (pos == this.mCtxPos) {
                this.mCtx = l;
            } else if (pos == this.mCtxNrPos) {
                this.mCtxNr = l;
            }
            return this.advance(state);
        }

        @Override
        public State setString(State state, String s) throws IOException {
            return this.advance(state);
        }

        private State advance(State state) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos + 1 < this.mTypes.length) {
                return State.values()[state.ordinal() + 1];
            }
            this.midgardActivityParser.cinstrContextAddNr(this.mTimestamp, this.mCtx, this.mCtxNr);
            return State.DECL_ID;
        }
    }

    private static class CinstrDeleteAtomMessage
    implements IMessage {
        public static final String DECL_NAME = "CINSTR_TL_DEL_ATOM";
        private static final String ATOM_NAME = "atom";
        private static final String TIMESTAMP_NAME = "timestamp";
        private long mAtom;
        private final int mAtomPos;
        private final @NonNull IMidgardActivityParser midgardActivityParser;
        private long mTimestamp;
        private final int mTimestampPos;
        private final Type[] mTypes;

        public CinstrDeleteAtomMessage(@NonNull IMidgardActivityParser midgardActivityParser, String[] argNames, Type[] argTypes) throws IOException {
            this.midgardActivityParser = midgardActivityParser;
            this.mTypes = argTypes;
            int timestampPos = -1;
            int atomPos = -1;
            int i = 0;
            while (i < argNames.length) {
                switch (argNames[i]) {
                    case "timestamp": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        timestampPos = i;
                        break;
                    }
                    case "atom": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        atomPos = i;
                        break;
                    }
                }
                ++i;
            }
            if (timestampPos == -1 || atomPos == -1) {
                throw new IOException();
            }
            this.mTimestampPos = timestampPos;
            this.mAtomPos = atomPos;
        }

        private CinstrDeleteAtomMessage(@NonNull IMidgardActivityParser midgardActivityParser, int timestampPos, int atomPos, Type[] argTypes) {
            this.midgardActivityParser = midgardActivityParser;
            this.mTypes = argTypes;
            this.mTimestampPos = timestampPos;
            this.mAtomPos = atomPos;
        }

        @Override
        public IMessage constructMessage() {
            return new CinstrDeleteAtomMessage(this.midgardActivityParser, this.mTimestampPos, this.mAtomPos, this.mTypes);
        }

        @Override
        public Type getType(int i) {
            return this.mTypes[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mTimestampPos) {
                this.mTimestamp = l;
            } else if (pos == this.mAtomPos) {
                this.mAtom = l;
            }
            return this.advance(state);
        }

        @Override
        public State setString(State state, String s) throws IOException {
            return this.advance(state);
        }

        private State advance(State state) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos + 1 < this.mTypes.length) {
                return State.values()[state.ordinal() + 1];
            }
            this.midgardActivityParser.cinstrDeleteAtom(this.mTimestamp, this.mAtom);
            return State.DECL_ID;
        }
    }

    private static class CinstrDeleteContextMessage
    implements IMessage {
        public static final String DECL_NAME = "CINSTR_TL_DEL_CTX";
        private static final String CTX_NAME = "ctx";
        private static final String TIMESTAMP_NAME = "timestamp";
        private long mCtx;
        private final int mCtxPos;
        private final @NonNull IMidgardActivityParser midgardActivityParser;
        private long mTimestamp;
        private final int mTimestampPos;
        private final Type[] mTypes;

        public CinstrDeleteContextMessage(@NonNull IMidgardActivityParser midgardActivityParser, String[] argNames, Type[] argTypes) throws IOException {
            this.midgardActivityParser = midgardActivityParser;
            this.mTypes = argTypes;
            int timestampPos = -1;
            int ctxPos = -1;
            int i = 0;
            while (i < argNames.length) {
                switch (argNames[i]) {
                    case "timestamp": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        timestampPos = i;
                        break;
                    }
                    case "ctx": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        ctxPos = i;
                        break;
                    }
                }
                ++i;
            }
            if (timestampPos == -1 || ctxPos == -1) {
                throw new IOException();
            }
            this.mTimestampPos = timestampPos;
            this.mCtxPos = ctxPos;
        }

        private CinstrDeleteContextMessage(@NonNull IMidgardActivityParser midgardActivityParser, int timestampPos, int ctxPos, Type[] argTypes) {
            this.midgardActivityParser = midgardActivityParser;
            this.mTypes = argTypes;
            this.mTimestampPos = timestampPos;
            this.mCtxPos = ctxPos;
        }

        @Override
        public IMessage constructMessage() {
            return new CinstrDeleteContextMessage(this.midgardActivityParser, this.mTimestampPos, this.mCtxPos, this.mTypes);
        }

        @Override
        public Type getType(int i) {
            return this.mTypes[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mTimestampPos) {
                this.mTimestamp = l;
            } else if (pos == this.mCtxPos) {
                this.mCtx = l;
            }
            return this.advance(state);
        }

        @Override
        public State setString(State state, String s) throws IOException {
            return this.advance(state);
        }

        private State advance(State state) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos + 1 < this.mTypes.length) {
                return State.values()[state.ordinal() + 1];
            }
            this.midgardActivityParser.cinstrDeleteContext(this.mTimestamp, this.mCtx);
            return State.DECL_ID;
        }
    }

    private static class CinstrNewAtomMessage
    implements IMessage {
        public static final String DECL_NAME = "CINSTR_TL_NEW_ATOM";
        private static final String ATOM_NAME = "atom";
        private static final String ATOM_NR_NAME = "atom_nr";
        private static final String TIMESTAMP_NAME = "timestamp";
        private long mAtom;
        private long mAtomNr;
        private final int mAtomNrPos;
        private final int mAtomPos;
        private final @NonNull IMidgardActivityParser midgardActivityParser;
        private long mTimestamp;
        private final int mTimestampPos;
        private final Type[] mTypes;

        public CinstrNewAtomMessage(@NonNull IMidgardActivityParser midgardActivityParser, String[] argNames, Type[] argTypes) throws IOException {
            this.midgardActivityParser = midgardActivityParser;
            this.mTypes = argTypes;
            int timestampPos = -1;
            int atomPos = -1;
            int atomNrPos = -1;
            int i = 0;
            while (i < argNames.length) {
                switch (argNames[i]) {
                    case "timestamp": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        timestampPos = i;
                        break;
                    }
                    case "atom": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        atomPos = i;
                        break;
                    }
                    case "atom_nr": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        atomNrPos = i;
                        break;
                    }
                }
                ++i;
            }
            if (timestampPos == -1 || atomPos == -1 || atomNrPos == -1) {
                throw new IOException();
            }
            this.mTimestampPos = timestampPos;
            this.mAtomPos = atomPos;
            this.mAtomNrPos = atomNrPos;
        }

        private CinstrNewAtomMessage(@NonNull IMidgardActivityParser midgardActivityParser, int timestampPos, int atomPos, int atomNrPos, Type[] argTypes) {
            this.midgardActivityParser = midgardActivityParser;
            this.mTypes = argTypes;
            this.mTimestampPos = timestampPos;
            this.mAtomPos = atomPos;
            this.mAtomNrPos = atomNrPos;
        }

        @Override
        public IMessage constructMessage() {
            return new CinstrNewAtomMessage(this.midgardActivityParser, this.mTimestampPos, this.mAtomPos, this.mAtomNrPos, this.mTypes);
        }

        @Override
        public Type getType(int i) {
            return this.mTypes[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mTimestampPos) {
                this.mTimestamp = l;
            } else if (pos == this.mAtomPos) {
                this.mAtom = l;
            } else if (pos == this.mAtomNrPos) {
                this.mAtomNr = l;
            }
            return this.advance(state);
        }

        @Override
        public State setString(State state, String s) throws IOException {
            return this.advance(state);
        }

        private State advance(State state) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos + 1 < this.mTypes.length) {
                return State.values()[state.ordinal() + 1];
            }
            this.midgardActivityParser.cinstrNewAtom(this.mTimestamp, this.mAtom, this.mAtomNr);
            return State.DECL_ID;
        }
    }

    private static class CinstrRetainAtomContextMessage
    implements IMessage {
        public static final String DECL_NAME = "CINSTR_TL_RET_ATOM_CTX";
        private static final String ATOM_NAME = "atom";
        private static final String CTX_NAME = "ctx";
        private static final String TIMESTAMP_NAME = "timestamp";
        private long mAtom;
        private final int mAtomPos;
        private long mCtx;
        private final int mCtxPos;
        private final @NonNull IMidgardActivityParser midgardActivityParser;
        private long mTimestamp;
        private final int mTimestampPos;
        private final Type[] mTypes;

        public CinstrRetainAtomContextMessage(@NonNull IMidgardActivityParser midgardActivityParser, String[] argNames, Type[] argTypes) throws IOException {
            this.midgardActivityParser = midgardActivityParser;
            this.mTypes = argTypes;
            int timestampPos = -1;
            int atomPos = -1;
            int ctxPos = -1;
            int i = 0;
            while (i < argNames.length) {
                switch (argNames[i]) {
                    case "timestamp": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        timestampPos = i;
                        break;
                    }
                    case "atom": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        atomPos = i;
                        break;
                    }
                    case "ctx": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        ctxPos = i;
                        break;
                    }
                }
                ++i;
            }
            if (timestampPos == -1 || atomPos == -1 || ctxPos == -1) {
                throw new IOException();
            }
            this.mTimestampPos = timestampPos;
            this.mAtomPos = atomPos;
            this.mCtxPos = ctxPos;
        }

        private CinstrRetainAtomContextMessage(@NonNull IMidgardActivityParser midgardActivityParser, int timestampPos, int atomPos, int ctxPos, Type[] argTypes) {
            this.midgardActivityParser = midgardActivityParser;
            this.mTypes = argTypes;
            this.mTimestampPos = timestampPos;
            this.mAtomPos = atomPos;
            this.mCtxPos = ctxPos;
        }

        @Override
        public IMessage constructMessage() {
            return new CinstrRetainAtomContextMessage(this.midgardActivityParser, this.mTimestampPos, this.mAtomPos, this.mCtxPos, this.mTypes);
        }

        @Override
        public Type getType(int i) {
            return this.mTypes[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mTimestampPos) {
                this.mTimestamp = l;
            } else if (pos == this.mAtomPos) {
                this.mAtom = l;
            } else if (pos == this.mCtxPos) {
                this.mCtx = l;
            }
            return this.advance(state);
        }

        @Override
        public State setString(State state, String s) throws IOException {
            return this.advance(state);
        }

        private State advance(State state) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos + 1 < this.mTypes.length) {
                return State.values()[state.ordinal() + 1];
            }
            this.midgardActivityParser.cinstrRetainAtomContext(this.mTimestamp, this.mAtom, this.mCtx);
            return State.DECL_ID;
        }
    }

    private static class CinstrUnretainAtomContextMessage
    implements IMessage {
        public static final String DECL_NAME = "CINSTR_TL_NRET_ATOM_CTX";
        private static final String ATOM_NAME = "atom";
        private static final String CTX_NAME = "ctx";
        private static final String TIMESTAMP_NAME = "timestamp";
        private long mAtom;
        private final int mAtomPos;
        private long mCtx;
        private final int mCtxPos;
        private final @NonNull IMidgardActivityParser midgardActivityParser;
        private long mTimestamp;
        private final int mTimestampPos;
        private final Type[] mTypes;

        public CinstrUnretainAtomContextMessage(@NonNull IMidgardActivityParser midgardActivityParser, String[] argNames, Type[] argTypes) throws IOException {
            this.midgardActivityParser = midgardActivityParser;
            this.mTypes = argTypes;
            int timestampPos = -1;
            int atomPos = -1;
            int ctxPos = -1;
            int i = 0;
            while (i < argNames.length) {
                switch (argNames[i]) {
                    case "timestamp": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        timestampPos = i;
                        break;
                    }
                    case "atom": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        atomPos = i;
                        break;
                    }
                    case "ctx": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        ctxPos = i;
                        break;
                    }
                }
                ++i;
            }
            if (timestampPos == -1 || atomPos == -1 || ctxPos == -1) {
                throw new IOException();
            }
            this.mTimestampPos = timestampPos;
            this.mAtomPos = atomPos;
            this.mCtxPos = ctxPos;
        }

        private CinstrUnretainAtomContextMessage(@NonNull IMidgardActivityParser midgardActivityParser, int timestampPos, int atomPos, int ctxPos, Type[] argTypes) {
            this.midgardActivityParser = midgardActivityParser;
            this.mTypes = argTypes;
            this.mTimestampPos = timestampPos;
            this.mAtomPos = atomPos;
            this.mCtxPos = ctxPos;
        }

        @Override
        public IMessage constructMessage() {
            return new CinstrUnretainAtomContextMessage(this.midgardActivityParser, this.mTimestampPos, this.mAtomPos, this.mCtxPos, this.mTypes);
        }

        @Override
        public Type getType(int i) {
            return this.mTypes[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mTimestampPos) {
                this.mTimestamp = l;
            } else if (pos == this.mAtomPos) {
                this.mAtom = l;
            } else if (pos == this.mCtxPos) {
                this.mCtx = l;
            }
            return this.advance(state);
        }

        @Override
        public State setString(State state, String s) throws IOException {
            return this.advance(state);
        }

        private State advance(State state) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos + 1 < this.mTypes.length) {
                return State.values()[state.ordinal() + 1];
            }
            this.midgardActivityParser.cinstrUnretainAtomContext(this.mTimestamp, this.mAtom, this.mCtx);
            return State.DECL_ID;
        }
    }

    private static class DeleteClosureMessage
    implements IMessage {
        public static final String DECL_NAME = "CINSTR_TL_DEL_CLOSURE";
        private static final String CLOSURE_NAME = "closure";
        private static final String THREAD_ID_NAME = "thread_id";
        private static final String TIMESTAMP_NAME = "timestamp";
        private final @NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator;
        private long mClosure;
        private final int mClosurePos;
        private long mThreadID;
        private final int mThreadIDPos;
        private long mTimestamp;
        private final int mTimestampPos;
        private final Type[] mTypes;

        public DeleteClosureMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, String[] argNames, Type[] argTypes) throws IOException {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            int timestampPos = -1;
            int threadIDPos = -1;
            int closurePos = -1;
            int i = 0;
            while (i < argNames.length) {
                switch (argNames[i]) {
                    case "timestamp": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        timestampPos = i;
                        break;
                    }
                    case "thread_id": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        threadIDPos = i;
                        break;
                    }
                    case "closure": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        closurePos = i;
                        break;
                    }
                }
                ++i;
            }
            if (timestampPos == -1 || threadIDPos == -1 || closurePos == -1) {
                throw new IOException();
            }
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mClosurePos = closurePos;
        }

        private DeleteClosureMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, int timestampPos, int threadIDPos, int closurePos, Type[] argTypes) {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mClosurePos = closurePos;
        }

        @Override
        public IMessage constructMessage() {
            return new DeleteClosureMessage(this.maliOpenCLCAMGenerator, this.mTimestampPos, this.mThreadIDPos, this.mClosurePos, this.mTypes);
        }

        @Override
        public Type getType(int i) {
            return this.mTypes[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mTimestampPos) {
                this.mTimestamp = l;
            } else if (pos == this.mThreadIDPos) {
                this.mThreadID = l;
            } else if (pos == this.mClosurePos) {
                this.mClosure = l;
            }
            return this.advance(state);
        }

        @Override
        public State setString(State state, String s) throws IOException {
            return this.advance(state);
        }

        private State advance(State state) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos + 1 < this.mTypes.length) {
                return State.values()[state.ordinal() + 1];
            }
            this.maliOpenCLCAMGenerator.deleteClosure(this.mTimestamp, this.mThreadID, this.mClosure);
            return State.DECL_ID;
        }
    }

    private static class DeleteCommandMessage
    implements IMessage {
        public static final String DECL_NAME = "CINSTR_TL_DEL_COMMAND";
        private static final String COMMAND_NAME = "command";
        private static final String THREAD_ID_NAME = "thread_id";
        private static final String TIMESTAMP_NAME = "timestamp";
        private final @NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator;
        private long mCommand;
        private final int mCommandPos;
        private long mThreadID;
        private final int mThreadIDPos;
        private long mTimestamp;
        private final int mTimestampPos;
        private final Type[] mTypes;

        public DeleteCommandMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, String[] argNames, Type[] argTypes) throws IOException {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            int timestampPos = -1;
            int threadIDPos = -1;
            int commandPos = -1;
            int i = 0;
            while (i < argNames.length) {
                switch (argNames[i]) {
                    case "timestamp": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        timestampPos = i;
                        break;
                    }
                    case "thread_id": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        threadIDPos = i;
                        break;
                    }
                    case "command": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        commandPos = i;
                        break;
                    }
                }
                ++i;
            }
            if (timestampPos == -1 || threadIDPos == -1 || commandPos == -1) {
                throw new IOException();
            }
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mCommandPos = commandPos;
        }

        private DeleteCommandMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, int timestampPos, int threadIDPos, int commandPos, Type[] argTypes) {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mCommandPos = commandPos;
        }

        @Override
        public IMessage constructMessage() {
            return new DeleteCommandMessage(this.maliOpenCLCAMGenerator, this.mTimestampPos, this.mThreadIDPos, this.mCommandPos, this.mTypes);
        }

        @Override
        public Type getType(int i) {
            return this.mTypes[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mTimestampPos) {
                this.mTimestamp = l;
            } else if (pos == this.mThreadIDPos) {
                this.mThreadID = l;
            } else if (pos == this.mCommandPos) {
                this.mCommand = l;
            }
            return this.advance(state);
        }

        @Override
        public State setString(State state, String s) throws IOException {
            return this.advance(state);
        }

        private State advance(State state) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos + 1 < this.mTypes.length) {
                return State.values()[state.ordinal() + 1];
            }
            this.maliOpenCLCAMGenerator.deleteCommand(this.mTimestamp, this.mThreadID, this.mCommand);
            return State.DECL_ID;
        }
    }

    private static class DeleteEventMessage
    implements IMessage {
        public static final String DECL_NAME = "CINSTR_TL_DEL_EVENT";
        private static final String EVENT_NAME = "event";
        private static final String THREAD_ID_NAME = "thread_id";
        private static final String TIMESTAMP_NAME = "timestamp";
        private final @NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator;
        private long mEvent;
        private final int mEventPos;
        private long mThreadID;
        private final int mThreadIDPos;
        private long mTimestamp;
        private final int mTimestampPos;
        private final Type[] mTypes;

        public DeleteEventMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, String[] argNames, Type[] argTypes) throws IOException {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            int timestampPos = -1;
            int threadIDPos = -1;
            int eventPos = -1;
            int i = 0;
            while (i < argNames.length) {
                switch (argNames[i]) {
                    case "timestamp": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        timestampPos = i;
                        break;
                    }
                    case "thread_id": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        threadIDPos = i;
                        break;
                    }
                    case "event": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        eventPos = i;
                        break;
                    }
                }
                ++i;
            }
            if (timestampPos == -1 || threadIDPos == -1 || eventPos == -1) {
                throw new IOException();
            }
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mEventPos = eventPos;
        }

        private DeleteEventMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, int timestampPos, int threadIDPos, int eventPos, Type[] argTypes) {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mEventPos = eventPos;
        }

        @Override
        public IMessage constructMessage() {
            return new DeleteEventMessage(this.maliOpenCLCAMGenerator, this.mTimestampPos, this.mThreadIDPos, this.mEventPos, this.mTypes);
        }

        @Override
        public Type getType(int i) {
            return this.mTypes[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mTimestampPos) {
                this.mTimestamp = l;
            } else if (pos == this.mThreadIDPos) {
                this.mThreadID = l;
            } else if (pos == this.mEventPos) {
                this.mEvent = l;
            }
            return this.advance(state);
        }

        @Override
        public State setString(State state, String s) throws IOException {
            return this.advance(state);
        }

        private State advance(State state) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos + 1 < this.mTypes.length) {
                return State.values()[state.ordinal() + 1];
            }
            this.maliOpenCLCAMGenerator.deleteEvent(this.mTimestamp, this.mThreadID, this.mEvent);
            return State.DECL_ID;
        }
    }

    private static class DependencyCommandToEventMessage
    implements IMessage {
        public static final String DECL_NAME = "CINSTR_TL_DEP_COMMAND_EVENT";
        private static final String COMMAND_NAME = "command";
        private static final String EVENT_NAME = "event";
        private static final String THREAD_ID_NAME = "thread_id";
        private static final String TIMESTAMP_NAME = "timestamp";
        private final @NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator;
        private long mCommand;
        private final int mCommandPos;
        private long mEvent;
        private final int mEventPos;
        private long mThreadID;
        private final int mThreadIDPos;
        private long mTimestamp;
        private final int mTimestampPos;
        private final Type[] mTypes;

        public DependencyCommandToEventMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, String[] argNames, Type[] argTypes) throws IOException {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            int timestampPos = -1;
            int threadIDPos = -1;
            int commandPos = -1;
            int eventPos = -1;
            int i = 0;
            while (i < argNames.length) {
                switch (argNames[i]) {
                    case "timestamp": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        timestampPos = i;
                        break;
                    }
                    case "thread_id": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        threadIDPos = i;
                        break;
                    }
                    case "command": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        commandPos = i;
                        break;
                    }
                    case "event": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        eventPos = i;
                        break;
                    }
                }
                ++i;
            }
            if (timestampPos == -1 || threadIDPos == -1 || commandPos == -1 || eventPos == -1) {
                throw new IOException();
            }
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mCommandPos = commandPos;
            this.mEventPos = eventPos;
        }

        private DependencyCommandToEventMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, int timestampPos, int threadIDPos, int commandPos, int eventPos, Type[] argTypes) {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mCommandPos = commandPos;
            this.mEventPos = eventPos;
        }

        @Override
        public IMessage constructMessage() {
            return new DependencyCommandToEventMessage(this.maliOpenCLCAMGenerator, this.mTimestampPos, this.mThreadIDPos, this.mCommandPos, this.mEventPos, this.mTypes);
        }

        @Override
        public Type getType(int i) {
            return this.mTypes[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mTimestampPos) {
                this.mTimestamp = l;
            } else if (pos == this.mThreadIDPos) {
                this.mThreadID = l;
            } else if (pos == this.mCommandPos) {
                this.mCommand = l;
            } else if (pos == this.mEventPos) {
                this.mEvent = l;
            }
            return this.advance(state);
        }

        @Override
        public State setString(State state, String s) throws IOException {
            return this.advance(state);
        }

        private State advance(State state) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos + 1 < this.mTypes.length) {
                return State.values()[state.ordinal() + 1];
            }
            this.maliOpenCLCAMGenerator.dependencyCommandToEvent(this.mTimestamp, this.mThreadID, this.mCommand, this.mEvent);
            return State.DECL_ID;
        }
    }

    private static class DependencyEventToCommandMessage
    implements IMessage {
        public static final String DECL_NAME = "CINSTR_TL_DEP_EVENT_COMMAND";
        private static final String COMMAND_NAME = "command";
        private static final String EVENT_NAME = "event";
        private static final String THREAD_ID_NAME = "thread_id";
        private static final String TIMESTAMP_NAME = "timestamp";
        private final @NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator;
        private long mCommand;
        private final int mCommandPos;
        private long mEvent;
        private final int mEventPos;
        private long mThreadID;
        private final int mThreadIDPos;
        private long mTimestamp;
        private final int mTimestampPos;
        private final Type[] mTypes;

        public DependencyEventToCommandMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, String[] argNames, Type[] argTypes) throws IOException {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            int timestampPos = -1;
            int threadIDPos = -1;
            int commandPos = -1;
            int eventPos = -1;
            int i = 0;
            while (i < argNames.length) {
                switch (argNames[i]) {
                    case "timestamp": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        timestampPos = i;
                        break;
                    }
                    case "thread_id": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        threadIDPos = i;
                        break;
                    }
                    case "event": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        eventPos = i;
                        break;
                    }
                    case "command": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        commandPos = i;
                        break;
                    }
                }
                ++i;
            }
            if (timestampPos == -1 || threadIDPos == -1 || commandPos == -1 || eventPos == -1) {
                throw new IOException();
            }
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mEventPos = eventPos;
            this.mCommandPos = commandPos;
        }

        private DependencyEventToCommandMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, int timestampPos, int threadIDPos, int eventPos, int commandPos, Type[] argTypes) {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mEventPos = eventPos;
            this.mCommandPos = commandPos;
        }

        @Override
        public IMessage constructMessage() {
            return new DependencyEventToCommandMessage(this.maliOpenCLCAMGenerator, this.mTimestampPos, this.mThreadIDPos, this.mEventPos, this.mCommandPos, this.mTypes);
        }

        @Override
        public Type getType(int i) {
            return this.mTypes[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mTimestampPos) {
                this.mTimestamp = l;
            } else if (pos == this.mThreadIDPos) {
                this.mThreadID = l;
            } else if (pos == this.mCommandPos) {
                this.mCommand = l;
            } else if (pos == this.mEventPos) {
                this.mEvent = l;
            }
            return this.advance(state);
        }

        @Override
        public State setString(State state, String s) throws IOException {
            return this.advance(state);
        }

        private State advance(State state) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos + 1 < this.mTypes.length) {
                return State.values()[state.ordinal() + 1];
            }
            this.maliOpenCLCAMGenerator.dependencyEventToCommand(this.mTimestamp, this.mThreadID, this.mEvent, this.mCommand);
            return State.DECL_ID;
        }
    }

    private static class DependencyThreadToQueueMessage
    implements IMessage {
        public static final String DECL_NAME = "CINSTR_TL_DEP_THREAD_QUEUE";
        private static final String QUEUE_NAME = "queue";
        private static final String THREAD_ID_NAME = "thread_id";
        private static final String TIMESTAMP_NAME = "timestamp";
        private final @NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator;
        private long mQueue;
        private final int mQueuePos;
        private long mThreadID;
        private final int mThreadIDPos;
        private long mTimestamp;
        private final int mTimestampPos;
        private final Type[] mTypes;

        public DependencyThreadToQueueMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, String[] argNames, Type[] argTypes) throws IOException {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            int timestampPos = -1;
            int threadIDPos = -1;
            int queuePos = -1;
            int i = 0;
            while (i < argNames.length) {
                switch (argNames[i]) {
                    case "timestamp": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        timestampPos = i;
                        break;
                    }
                    case "thread_id": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        threadIDPos = i;
                        break;
                    }
                    case "queue": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        queuePos = i;
                        break;
                    }
                }
                ++i;
            }
            if (timestampPos == -1 || threadIDPos == -1 || queuePos == -1) {
                throw new IOException();
            }
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mQueuePos = queuePos;
        }

        private DependencyThreadToQueueMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, int timestampPos, int threadIDPos, int queuePos, Type[] argTypes) {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mQueuePos = queuePos;
        }

        @Override
        public IMessage constructMessage() {
            return new DependencyThreadToQueueMessage(this.maliOpenCLCAMGenerator, this.mTimestampPos, this.mThreadIDPos, this.mQueuePos, this.mTypes);
        }

        @Override
        public Type getType(int i) {
            return this.mTypes[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mTimestampPos) {
                this.mTimestamp = l;
            } else if (pos == this.mThreadIDPos) {
                this.mThreadID = l;
            } else if (pos == this.mQueuePos) {
                this.mQueue = l;
            }
            return this.advance(state);
        }

        @Override
        public State setString(State state, String s) throws IOException {
            return this.advance(state);
        }

        private State advance(State state) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos + 1 < this.mTypes.length) {
                return State.values()[state.ordinal() + 1];
            }
            this.maliOpenCLCAMGenerator.dependencyThreadToQueue(this.mTimestamp, this.mThreadID, this.mQueue);
            return State.DECL_ID;
        }
    }

    private static class DirectoryMessage
    implements IMessage {
        private static final @NonNull Pattern ARG_NAMES_PATTERN = Pattern.compile(", *");
        private static final Type[] TYPES = new Type[]{Type.U32, Type.U32, Type.STRING, Type.STRING, Type.STRING, Type.STRING};
        protected IMessage[] mMessages;
        private final @NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator;
        private final @NonNull TIntObjectMap<String> mApiNameMap;
        private char[] mArgTypes;
        private int mDeclCount;
        private int mDeclId;
        private String mDeclName;
        private final @NonNull IMidgardActivityParser midgardActivityParser;
        private final int mPointerBytes;
        private final int mThreadIdBytes;
        private final int protocolVersionMajor;

        private static void logEventMessage(String declName, String[] argNames, Type[] argTypes) {
        }

        public DirectoryMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, @NonNull IMidgardActivityParser midgardActivityParser, int protocolVersionMajor, @NonNull TIntObjectMap<String> apiNameMap, int pointerBytes, int threadIdBytes) {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.midgardActivityParser = midgardActivityParser;
            this.protocolVersionMajor = protocolVersionMajor;
            this.mApiNameMap = apiNameMap;
            this.mPointerBytes = pointerBytes;
            this.mThreadIdBytes = threadIdBytes;
        }

        @Override
        public IMessage constructMessage() {
            return new DirectoryMessage(this.maliOpenCLCAMGenerator, this.midgardActivityParser, this.protocolVersionMajor, this.mApiNameMap, this.mPointerBytes, this.mThreadIdBytes);
        }

        @Override
        public Type getType(int i) {
            return TYPES[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            switch (state) {
                case DATA: {
                    if ((int)l < 0) {
                        throw new IOException();
                    }
                    this.mMessages = new IMessage[(int)l];
                    this.mDeclCount = (int)l;
                    return State.DATA_1;
                }
                case DATA_1: {
                    this.mDeclId = (int)l;
                    if (this.mDeclId >= this.mMessages.length) {
                        throw new IOException();
                    }
                    return State.DATA_2;
                }
            }
            throw new IOException();
        }

        @Override
        public State setString(State state, @NonNull String s) throws IOException {
            switch (state) {
                case DATA_2: {
                    this.mDeclName = s;
                    return State.DATA_3;
                }
                case DATA_3: {
                    return State.DATA_4;
                }
                case DATA_4: {
                    this.mArgTypes = s.toCharArray();
                    return State.DATA_5;
                }
                case DATA_5: {
                    String[] rawArgNames = BasicStringUtils.splitHandlingEmpty((CharSequence)s, (Pattern)ARG_NAMES_PATTERN);
                    String[] argNames = new String[this.mArgTypes.length];
                    Type[] argTypes = new Type[this.mArgTypes.length];
                    int argNamePos = 0;
                    int i = 0;
                    while (i < this.mArgTypes.length) {
                        argNames[i] = this.mArgTypes[i] == '@' ? "timestamp" : (this.mArgTypes[i] == 't' ? "thread_id" : rawArgNames[argNamePos++]);
                        block6 : switch (this.mArgTypes[i]) {
                            case '@': {
                                argTypes[i] = Type.U64;
                                break;
                            }
                            case 't': {
                                switch (this.mThreadIdBytes) {
                                    case 4: {
                                        argTypes[i] = Type.U32;
                                        break block6;
                                    }
                                    case 8: {
                                        argTypes[i] = Type.U64;
                                        break block6;
                                    }
                                }
                                throw new IOException();
                            }
                            case 'i': {
                                argTypes[i] = Type.S32;
                                break;
                            }
                            case 'I': {
                                argTypes[i] = Type.U32;
                                break;
                            }
                            case 'l': {
                                argTypes[i] = Type.S64;
                                break;
                            }
                            case 'L': {
                                argTypes[i] = Type.U64;
                                break;
                            }
                            case 'F': {
                                argTypes[i] = Type.DOUBLE;
                                break;
                            }
                            case 'p': {
                                switch (this.mPointerBytes) {
                                    case 4: {
                                        argTypes[i] = Type.U32;
                                        break block6;
                                    }
                                    case 8: {
                                        argTypes[i] = Type.U64;
                                        break block6;
                                    }
                                }
                                throw new IOException();
                            }
                            case 's': {
                                argTypes[i] = Type.STRING;
                                break;
                            }
                            default: {
                                throw new IOException();
                            }
                        }
                        ++i;
                    }
                    if (argNamePos != rawArgNames.length) {
                        throw new IOException();
                    }
                    DirectoryMessage.logEventMessage(this.mDeclName, argNames, argTypes);
                    switch (this.mDeclName) {
                        case "CINSTR_TL_ENUM": {
                            this.mMessages[this.mDeclId] = new EnumMessage(this.mApiNameMap, argNames, argTypes);
                            break;
                        }
                        case "CINSTR_TL_NEW_CTX": {
                            if (this.protocolVersionMajor >= 2) {
                                this.mMessages[this.mDeclId] = new NewContextMessage(this.midgardActivityParser, argNames, argTypes);
                                break;
                            }
                            this.mMessages[this.mDeclId] = new EventMessage(this.mDeclName, argNames, argTypes);
                            break;
                        }
                        case "CINSTR_TL_NEW_QUEUE": {
                            this.mMessages[this.mDeclId] = new NewQueueMessage(this.maliOpenCLCAMGenerator, argNames, argTypes);
                            break;
                        }
                        case "CINSTR_TL_RET_QUEUE_CTX": {
                            this.mMessages[this.mDeclId] = new RetainQueueToContextMessage(this.maliOpenCLCAMGenerator, argNames, argTypes);
                            break;
                        }
                        case "CINSTR_TL_ATTRIB_QUEUE_DEVICE_NAME": {
                            this.mMessages[this.mDeclId] = new AttributeQueueDeviceNameMessage(this.maliOpenCLCAMGenerator, argNames, argTypes);
                            break;
                        }
                        case "CINSTR_TL_DEP_THREAD_QUEUE": {
                            this.mMessages[this.mDeclId] = new DependencyThreadToQueueMessage(this.maliOpenCLCAMGenerator, argNames, argTypes);
                            break;
                        }
                        case "CINSTR_TL_BLOCK_QUEUE": {
                            this.mMessages[this.mDeclId] = new BlockQueueMessage(this.maliOpenCLCAMGenerator, argNames, argTypes);
                            break;
                        }
                        case "CINSTR_TL_ATTRIB_THREAD_API_NAME": {
                            this.mMessages[this.mDeclId] = new AttributeThreadApiNameMessage(this.maliOpenCLCAMGenerator, this.mApiNameMap, argNames, argTypes);
                            break;
                        }
                        case "CINSTR_TL_NEW_COMMAND": {
                            this.mMessages[this.mDeclId] = new NewCommandMessage(this.maliOpenCLCAMGenerator, argNames, argTypes);
                            break;
                        }
                        case "CINSTR_TL_NEW_CLOSURE": {
                            this.mMessages[this.mDeclId] = new NewClosureMessage(this.maliOpenCLCAMGenerator, argNames, argTypes);
                            break;
                        }
                        case "CINSTR_TL_RET_COMMAND_QUEUE": {
                            this.mMessages[this.mDeclId] = new RetainCommandToQueueMessage(this.maliOpenCLCAMGenerator, argNames, argTypes);
                            break;
                        }
                        case "CINSTR_TL_ATTRIB_COMMAND_API_NAME": {
                            this.mMessages[this.mDeclId] = new AttributeCommandAPINameMessage(this.maliOpenCLCAMGenerator, this.mApiNameMap, argNames, argTypes);
                            break;
                        }
                        case "CINSTR_TL_RET_CLOSURE_LPU": {
                            this.mMessages[this.mDeclId] = new RetainClosureToLpuMessage(this.maliOpenCLCAMGenerator, argNames, argTypes);
                            break;
                        }
                        case "CINSTR_TL_NRET_CLOSURE_LPU": {
                            this.mMessages[this.mDeclId] = new NRetainClosureToLpuMessage(this.maliOpenCLCAMGenerator, argNames, argTypes);
                            break;
                        }
                        case "CINSTR_TL_DEL_COMMAND": {
                            this.mMessages[this.mDeclId] = new DeleteCommandMessage(this.maliOpenCLCAMGenerator, argNames, argTypes);
                            break;
                        }
                        case "CINSTR_TL_RET_CLOSURE_COMMAND": {
                            this.mMessages[this.mDeclId] = new RetainClosureToCommandMessage(this.maliOpenCLCAMGenerator, argNames, argTypes);
                            break;
                        }
                        case "CINSTR_TL_RET_COMMAND_CLOSURE": {
                            this.mMessages[this.mDeclId] = new RetainCommandToClosureMessage(this.maliOpenCLCAMGenerator, argNames, argTypes);
                            break;
                        }
                        case "CINSTR_TL_ATTRIB_KERNEL_NAME": {
                            this.mMessages[this.mDeclId] = new AttributeKernelNameMessage(this.maliOpenCLCAMGenerator, argNames, argTypes);
                            break;
                        }
                        case "CINSTR_TL_RET_CLOSURE_KERNEL": {
                            this.mMessages[this.mDeclId] = new RetainClosureToKernelMessage(this.maliOpenCLCAMGenerator, argNames, argTypes);
                            break;
                        }
                        case "CINSTR_TL_RET_CLOSURE_ATOM": {
                            this.mMessages[this.mDeclId] = new RetainClosureToAtomMessage(this.maliOpenCLCAMGenerator, argNames, argTypes);
                            break;
                        }
                        case "CINSTR_TL_NRET_CLOSURE_ATOM": {
                            this.mMessages[this.mDeclId] = new NRetainClosureToAtomMessage(this.maliOpenCLCAMGenerator, argNames, argTypes);
                            break;
                        }
                        case "CINSTR_TL_ATTRIB_CLOSURE_TIMESTAMPS": {
                            this.mMessages[this.mDeclId] = new AttributeClosureTimestampsMessage(this.maliOpenCLCAMGenerator, argNames, argTypes);
                            break;
                        }
                        case "CINSTR_TL_DEL_CLOSURE": {
                            this.mMessages[this.mDeclId] = new DeleteClosureMessage(this.maliOpenCLCAMGenerator, argNames, argTypes);
                            break;
                        }
                        case "CINSTR_TL_RET_EVENT_COMMAND": {
                            this.mMessages[this.mDeclId] = new RetainEventToCommandMessage(this.maliOpenCLCAMGenerator, argNames, argTypes);
                            break;
                        }
                        case "CINSTR_TL_DEP_EVENT_COMMAND": {
                            this.mMessages[this.mDeclId] = new DependencyEventToCommandMessage(this.maliOpenCLCAMGenerator, argNames, argTypes);
                            break;
                        }
                        case "CINSTR_TL_DEP_COMMAND_EVENT": {
                            this.mMessages[this.mDeclId] = new DependencyCommandToEventMessage(this.maliOpenCLCAMGenerator, argNames, argTypes);
                            break;
                        }
                        case "CINSTR_TL_DEL_EVENT": {
                            this.mMessages[this.mDeclId] = new DeleteEventMessage(this.maliOpenCLCAMGenerator, argNames, argTypes);
                            break;
                        }
                        case "CINSTR_TL_NEW_ATOM": {
                            if (this.protocolVersionMajor >= 2) {
                                this.mMessages[this.mDeclId] = new CinstrNewAtomMessage(this.midgardActivityParser, argNames, argTypes);
                                break;
                            }
                            this.mMessages[this.mDeclId] = new EventMessage(this.mDeclName, argNames, argTypes);
                            break;
                        }
                        case "CINSTR_TL_DEL_ATOM": {
                            if (this.protocolVersionMajor >= 2) {
                                this.mMessages[this.mDeclId] = new CinstrDeleteAtomMessage(this.midgardActivityParser, argNames, argTypes);
                                break;
                            }
                            this.mMessages[this.mDeclId] = new EventMessage(this.mDeclName, argNames, argTypes);
                            break;
                        }
                        case "CINSTR_TL_DEL_CTX": {
                            if (this.protocolVersionMajor >= 2) {
                                this.mMessages[this.mDeclId] = new CinstrDeleteContextMessage(this.midgardActivityParser, argNames, argTypes);
                                break;
                            }
                            this.mMessages[this.mDeclId] = new EventMessage(this.mDeclName, argNames, argTypes);
                            break;
                        }
                        case "CINSTR_TL_ATTRIB_CTX_CTX_NR": {
                            if (this.protocolVersionMajor >= 2) {
                                this.mMessages[this.mDeclId] = new CinstrContextAddNrMessage(this.midgardActivityParser, argNames, argTypes);
                                break;
                            }
                            this.mMessages[this.mDeclId] = new EventMessage(this.mDeclName, argNames, argTypes);
                            break;
                        }
                        case "CINSTR_TL_RET_ATOM_CTX": {
                            if (this.protocolVersionMajor >= 2) {
                                this.mMessages[this.mDeclId] = new CinstrRetainAtomContextMessage(this.midgardActivityParser, argNames, argTypes);
                                break;
                            }
                            this.mMessages[this.mDeclId] = new EventMessage(this.mDeclName, argNames, argTypes);
                            break;
                        }
                        case "CINSTR_TL_NRET_ATOM_CTX": {
                            if (this.protocolVersionMajor >= 2) {
                                this.mMessages[this.mDeclId] = new CinstrUnretainAtomContextMessage(this.midgardActivityParser, argNames, argTypes);
                                break;
                            }
                            this.mMessages[this.mDeclId] = new EventMessage(this.mDeclName, argNames, argTypes);
                            break;
                        }
                        case "KBASE_TL_NEW_CTX": {
                            if (this.protocolVersionMajor >= 2) {
                                this.mMessages[this.mDeclId] = new KbaseNewContextMessage(this.midgardActivityParser, argNames, argTypes);
                                break;
                            }
                            this.mMessages[this.mDeclId] = new EventMessage(this.mDeclName, argNames, argTypes);
                            break;
                        }
                        case "KBASE_TL_NEW_LPU": {
                            if (this.protocolVersionMajor >= 2) {
                                this.mMessages[this.mDeclId] = new KbaseNewJobSlotMessage(this.midgardActivityParser, argNames, argTypes);
                                break;
                            }
                            this.mMessages[this.mDeclId] = new EventMessage(this.mDeclName, argNames, argTypes);
                            break;
                        }
                        case "KBASE_TL_NEW_ATOM": {
                            if (this.protocolVersionMajor >= 2) {
                                this.mMessages[this.mDeclId] = new KbaseNewAtomMessage(this.midgardActivityParser, argNames, argTypes);
                                break;
                            }
                            this.mMessages[this.mDeclId] = new EventMessage(this.mDeclName, argNames, argTypes);
                            break;
                        }
                        case "KBASE_TL_DEL_CTX": {
                            if (this.protocolVersionMajor >= 2) {
                                this.mMessages[this.mDeclId] = new KbaseDeleteContextMessage(this.midgardActivityParser, argNames, argTypes);
                                break;
                            }
                            this.mMessages[this.mDeclId] = new EventMessage(this.mDeclName, argNames, argTypes);
                            break;
                        }
                        case "KBASE_TL_DEL_ATOM": {
                            if (this.protocolVersionMajor >= 2) {
                                this.mMessages[this.mDeclId] = new KbaseDeleteAtomMessage(this.midgardActivityParser, argNames, argTypes);
                                break;
                            }
                            this.mMessages[this.mDeclId] = new EventMessage(this.mDeclName, argNames, argTypes);
                            break;
                        }
                        case "KBASE_TL_RET_ATOM_CTX": {
                            if (this.protocolVersionMajor >= 2) {
                                this.mMessages[this.mDeclId] = new KbaseRetainAtomContextMessage(this.midgardActivityParser, argNames, argTypes);
                                break;
                            }
                            this.mMessages[this.mDeclId] = new EventMessage(this.mDeclName, argNames, argTypes);
                            break;
                        }
                        case "KBASE_TL_RET_ATOM_LPU": {
                            if (this.protocolVersionMajor >= 2) {
                                this.mMessages[this.mDeclId] = new KbaseRetainAtomJobSlotMessage(this.midgardActivityParser, argNames, argTypes);
                                break;
                            }
                            this.mMessages[this.mDeclId] = new EventMessage(this.mDeclName, argNames, argTypes);
                            break;
                        }
                        case "KBASE_TL_NRET_ATOM_CTX": {
                            if (this.protocolVersionMajor >= 2) {
                                this.mMessages[this.mDeclId] = new KbaseUnretainAtomContextMessage(this.midgardActivityParser, argNames, argTypes);
                                break;
                            }
                            this.mMessages[this.mDeclId] = new EventMessage(this.mDeclName, argNames, argTypes);
                            break;
                        }
                        case "KBASE_TL_NRET_ATOM_LPU": {
                            if (this.protocolVersionMajor >= 2) {
                                this.mMessages[this.mDeclId] = new KbaseUnretainAtomJobSlotMessage(this.midgardActivityParser, argNames, argTypes);
                                break;
                            }
                            this.mMessages[this.mDeclId] = new EventMessage(this.mDeclName, argNames, argTypes);
                            break;
                        }
                        default: {
                            this.mMessages[this.mDeclId] = new EventMessage(this.mDeclName, argNames, argTypes);
                        }
                    }
                    --this.mDeclCount;
                    return this.mDeclCount == 0 ? State.FINISH_DIRECTORY : State.DATA_1;
                }
            }
            throw new IOException();
        }
    }

    private static class EnumMessage
    implements IMessage {
        public static final String DECL_NAME = "CINSTR_TL_ENUM";
        private static final String API_NAME = "api_name";
        private static final String ARG_NAME_NAME = "arg_name";
        private static final String ENUM_NAME_NAME = "enum_name";
        private static final String ENUM_VALUE_NAME = "enum_value";
        private final TIntObjectMap<String> mApiNameMap;
        private String mArgName;
        private final int mArgNamePos;
        private String mEnumName;
        private final int mEnumNamePos;
        private long mEnumValue;
        private final int mEnumValuePos;
        private final Type[] mTypes;

        public EnumMessage(TIntObjectMap<String> apiNameMap, String[] argNames, Type[] argTypes) throws IOException {
            this.mApiNameMap = apiNameMap;
            this.mTypes = argTypes;
            int argNamePos = -1;
            int enumValuePos = -1;
            int enumNamePos = -1;
            int i = 0;
            while (i < argNames.length) {
                switch (argNames[i]) {
                    case "arg_name": {
                        if (!argTypes[i].isStringType()) {
                            throw new IOException();
                        }
                        argNamePos = i;
                        break;
                    }
                    case "enum_value": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        enumValuePos = i;
                        break;
                    }
                    case "enum_name": {
                        if (!argTypes[i].isStringType()) {
                            throw new IOException();
                        }
                        enumNamePos = i;
                        break;
                    }
                }
                ++i;
            }
            if (argNamePos == -1 || enumValuePos == -1 || enumNamePos == -1) {
                throw new IOException();
            }
            this.mArgNamePos = argNamePos;
            this.mEnumValuePos = enumValuePos;
            this.mEnumNamePos = enumNamePos;
        }

        private EnumMessage(TIntObjectMap<String> apiNameMap, int argNamePos, int enumValuePos, int enumNamePos, Type[] argTypes) {
            this.mApiNameMap = apiNameMap;
            this.mTypes = argTypes;
            this.mArgNamePos = argNamePos;
            this.mEnumValuePos = enumValuePos;
            this.mEnumNamePos = enumNamePos;
        }

        @Override
        public IMessage constructMessage() {
            return new EnumMessage(this.mApiNameMap, this.mArgNamePos, this.mEnumValuePos, this.mEnumNamePos, this.mTypes);
        }

        @Override
        public Type getType(int i) {
            return this.mTypes[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mEnumValuePos) {
                this.mEnumValue = l;
            }
            return this.advance(state);
        }

        @Override
        public State setString(State state, String s) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mArgNamePos) {
                this.mArgName = s;
            } else if (pos == this.mEnumNamePos) {
                this.mEnumName = s;
            }
            return this.advance(state);
        }

        private State advance(State state) {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos + 1 < this.mTypes.length) {
                return State.values()[state.ordinal() + 1];
            }
            switch (this.mArgName) {
                case "api_name": {
                    this.mApiNameMap.put((int)this.mEnumValue, (Object)this.mEnumName);
                    break;
                }
            }
            return State.DECL_ID;
        }
    }

    private static class EventMessage
    implements IMessage {
        private final String[] mArgNames;
        private final String mDeclName;
        private final Type[] mTypes;

        public EventMessage(String declName, String[] argNames, Type[] argTypes) {
            this.mDeclName = declName;
            this.mArgNames = argNames;
            this.mTypes = argTypes;
        }

        @Override
        public IMessage constructMessage() {
            return new EventMessage(this.mDeclName, this.mArgNames, this.mTypes);
        }

        @Override
        public Type getType(int i) {
            return this.mTypes[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            return this.advance(state);
        }

        @Override
        public State setString(State state, String s) throws IOException {
            return this.advance(state);
        }

        private State advance(State state) {
            int count = state.ordinal() - State.DATA.ordinal();
            if (count + 1 < this.mTypes.length) {
                return State.values()[state.ordinal() + 1];
            }
            return State.DECL_ID;
        }

        private void printArgName(State state) {
            int i = state.ordinal() - State.DATA.ordinal();
            if (i == 0) {
                System.out.print(this.mDeclName + ": ");
            }
            System.out.print(this.mArgNames[i] + "=");
        }
    }

    private static interface IMessage {
        public IMessage constructMessage();

        public Type getType(int var1);

        public State setLong(State var1, long var2) throws IOException;

        public State setString(State var1, @NonNull String var2) throws IOException;
    }

    private static class KbaseDeleteAtomMessage
    implements IMessage {
        public static final String DECL_NAME = "KBASE_TL_DEL_ATOM";
        private static final String ATOM_NAME = "atom";
        private static final String TIMESTAMP_NAME = "timestamp";
        private long mAtom;
        private final int mAtomPos;
        private final @NonNull IMidgardActivityParser midgardActivityParser;
        private long mTimestamp;
        private final int mTimestampPos;
        private final Type[] mTypes;

        public KbaseDeleteAtomMessage(@NonNull IMidgardActivityParser midgardActivityParser, String[] argNames, Type[] argTypes) throws IOException {
            this.midgardActivityParser = midgardActivityParser;
            this.mTypes = argTypes;
            int timestampPos = -1;
            int atomPos = -1;
            int i = 0;
            while (i < argNames.length) {
                switch (argNames[i]) {
                    case "timestamp": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        timestampPos = i;
                        break;
                    }
                    case "atom": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        atomPos = i;
                        break;
                    }
                }
                ++i;
            }
            if (timestampPos == -1 || atomPos == -1) {
                throw new IOException();
            }
            this.mTimestampPos = timestampPos;
            this.mAtomPos = atomPos;
        }

        private KbaseDeleteAtomMessage(@NonNull IMidgardActivityParser midgardActivityParser, int timestampPos, int atomPos, Type[] argTypes) {
            this.midgardActivityParser = midgardActivityParser;
            this.mTypes = argTypes;
            this.mTimestampPos = timestampPos;
            this.mAtomPos = atomPos;
        }

        @Override
        public IMessage constructMessage() {
            return new KbaseDeleteAtomMessage(this.midgardActivityParser, this.mTimestampPos, this.mAtomPos, this.mTypes);
        }

        @Override
        public Type getType(int i) {
            return this.mTypes[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mTimestampPos) {
                this.mTimestamp = l;
            } else if (pos == this.mAtomPos) {
                this.mAtom = l;
            }
            return this.advance(state);
        }

        @Override
        public State setString(State state, String s) throws IOException {
            return this.advance(state);
        }

        private State advance(State state) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos + 1 < this.mTypes.length) {
                return State.values()[state.ordinal() + 1];
            }
            this.midgardActivityParser.kbaseDeleteAtom(this.mTimestamp, this.mAtom);
            return State.DECL_ID;
        }
    }

    private static class KbaseDeleteContextMessage
    implements IMessage {
        public static final String DECL_NAME = "KBASE_TL_DEL_CTX";
        private static final String CTX_NAME = "ctx";
        private static final String TIMESTAMP_NAME = "timestamp";
        private long mCtx;
        private final int mCtxPos;
        private final @NonNull IMidgardActivityParser midgardActivityParser;
        private long mTimestamp;
        private final int mTimestampPos;
        private final Type[] mTypes;

        public KbaseDeleteContextMessage(@NonNull IMidgardActivityParser midgardActivityParser, String[] argNames, Type[] argTypes) throws IOException {
            this.midgardActivityParser = midgardActivityParser;
            this.mTypes = argTypes;
            int timestampPos = -1;
            int ctxPos = -1;
            int i = 0;
            while (i < argNames.length) {
                switch (argNames[i]) {
                    case "timestamp": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        timestampPos = i;
                        break;
                    }
                    case "ctx": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        ctxPos = i;
                        break;
                    }
                }
                ++i;
            }
            if (timestampPos == -1 || ctxPos == -1) {
                throw new IOException();
            }
            this.mTimestampPos = timestampPos;
            this.mCtxPos = ctxPos;
        }

        private KbaseDeleteContextMessage(@NonNull IMidgardActivityParser midgardActivityParser, int timestampPos, int ctxPos, Type[] argTypes) {
            this.midgardActivityParser = midgardActivityParser;
            this.mTypes = argTypes;
            this.mTimestampPos = timestampPos;
            this.mCtxPos = ctxPos;
        }

        @Override
        public IMessage constructMessage() {
            return new KbaseDeleteContextMessage(this.midgardActivityParser, this.mTimestampPos, this.mCtxPos, this.mTypes);
        }

        @Override
        public Type getType(int i) {
            return this.mTypes[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mTimestampPos) {
                this.mTimestamp = l;
            } else if (pos == this.mCtxPos) {
                this.mCtx = l;
            }
            return this.advance(state);
        }

        @Override
        public State setString(State state, String s) throws IOException {
            return this.advance(state);
        }

        private State advance(State state) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos + 1 < this.mTypes.length) {
                return State.values()[state.ordinal() + 1];
            }
            this.midgardActivityParser.kbaseDeleteContext(this.mTimestamp, this.mCtx);
            return State.DECL_ID;
        }
    }

    private static class KbaseNewAtomMessage
    implements IMessage {
        public static final String DECL_NAME = "KBASE_TL_NEW_ATOM";
        private static final String ATOM_NAME = "atom";
        private static final String ATOM_NR_NAME = "atom_nr";
        private static final String TIMESTAMP_NAME = "timestamp";
        private long mAtom;
        private long mAtomNr;
        private final int mAtomNrPos;
        private final int mAtomPos;
        private final @NonNull IMidgardActivityParser midgardActivityParser;
        private long mTimestamp;
        private final int mTimestampPos;
        private final Type[] mTypes;

        public KbaseNewAtomMessage(@NonNull IMidgardActivityParser midgardActivityParser, String[] argNames, Type[] argTypes) throws IOException {
            this.midgardActivityParser = midgardActivityParser;
            this.mTypes = argTypes;
            int timestampPos = -1;
            int atomPos = -1;
            int atomNrPos = -1;
            int i = 0;
            while (i < argNames.length) {
                switch (argNames[i]) {
                    case "timestamp": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        timestampPos = i;
                        break;
                    }
                    case "atom": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        atomPos = i;
                        break;
                    }
                    case "atom_nr": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        atomNrPos = i;
                        break;
                    }
                }
                ++i;
            }
            if (timestampPos == -1 || atomPos == -1 || atomNrPos == -1) {
                throw new IOException();
            }
            this.mTimestampPos = timestampPos;
            this.mAtomPos = atomPos;
            this.mAtomNrPos = atomNrPos;
        }

        private KbaseNewAtomMessage(@NonNull IMidgardActivityParser midgardActivityParser, int timestampPos, int atomPos, int atomNrPos, Type[] argTypes) {
            this.midgardActivityParser = midgardActivityParser;
            this.mTypes = argTypes;
            this.mTimestampPos = timestampPos;
            this.mAtomPos = atomPos;
            this.mAtomNrPos = atomNrPos;
        }

        @Override
        public IMessage constructMessage() {
            return new KbaseNewAtomMessage(this.midgardActivityParser, this.mTimestampPos, this.mAtomPos, this.mAtomNrPos, this.mTypes);
        }

        @Override
        public Type getType(int i) {
            return this.mTypes[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mTimestampPos) {
                this.mTimestamp = l;
            } else if (pos == this.mAtomPos) {
                this.mAtom = l;
            } else if (pos == this.mAtomNrPos) {
                this.mAtomNr = l;
            }
            return this.advance(state);
        }

        @Override
        public State setString(State state, String s) throws IOException {
            return this.advance(state);
        }

        private State advance(State state) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos + 1 < this.mTypes.length) {
                return State.values()[state.ordinal() + 1];
            }
            this.midgardActivityParser.kbaseNewAtom(this.mTimestamp, this.mAtom, this.mAtomNr);
            return State.DECL_ID;
        }
    }

    private static class KbaseNewContextMessage
    implements IMessage {
        public static final String DECL_NAME = "KBASE_TL_NEW_CTX";
        private static final String CTX_NAME = "ctx";
        private static final String CTX_NR_NAME = "ctx_nr";
        private static final String TIMESTAMP_NAME = "timestamp";
        private long mCtx;
        private long mCtxNr;
        private final int mCtxNrPos;
        private final int mCtxPos;
        private final @NonNull IMidgardActivityParser midgardActivityParser;
        private long mTimestamp;
        private final int mTimestampPos;
        private final Type[] mTypes;

        public KbaseNewContextMessage(@NonNull IMidgardActivityParser midgardActivityParser, String[] argNames, Type[] argTypes) throws IOException {
            this.midgardActivityParser = midgardActivityParser;
            this.mTypes = argTypes;
            int timestampPos = -1;
            int ctxPos = -1;
            int ctxNrPos = -1;
            int i = 0;
            while (i < argNames.length) {
                switch (argNames[i]) {
                    case "timestamp": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        timestampPos = i;
                        break;
                    }
                    case "ctx": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        ctxPos = i;
                        break;
                    }
                    case "ctx_nr": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        ctxNrPos = i;
                        break;
                    }
                }
                ++i;
            }
            if (timestampPos == -1 || ctxPos == -1 || ctxNrPos == -1) {
                throw new IOException();
            }
            this.mTimestampPos = timestampPos;
            this.mCtxPos = ctxPos;
            this.mCtxNrPos = ctxNrPos;
        }

        private KbaseNewContextMessage(@NonNull IMidgardActivityParser midgardActivityParser, int timestampPos, int ctxPos, int ctxNrPos, Type[] argTypes) {
            this.midgardActivityParser = midgardActivityParser;
            this.mTypes = argTypes;
            this.mTimestampPos = timestampPos;
            this.mCtxPos = ctxPos;
            this.mCtxNrPos = ctxNrPos;
        }

        @Override
        public IMessage constructMessage() {
            return new KbaseNewContextMessage(this.midgardActivityParser, this.mTimestampPos, this.mCtxPos, this.mCtxNrPos, this.mTypes);
        }

        @Override
        public Type getType(int i) {
            return this.mTypes[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mTimestampPos) {
                this.mTimestamp = l;
            } else if (pos == this.mCtxPos) {
                this.mCtx = l;
            } else if (pos == this.mCtxNrPos) {
                this.mCtxNr = l;
            }
            return this.advance(state);
        }

        @Override
        public State setString(State state, String s) throws IOException {
            return this.advance(state);
        }

        private State advance(State state) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos + 1 < this.mTypes.length) {
                return State.values()[state.ordinal() + 1];
            }
            this.midgardActivityParser.kbaseNewContext(this.mTimestamp, this.mCtx, this.mCtxNr);
            return State.DECL_ID;
        }
    }

    private static class KbaseNewJobSlotMessage
    implements IMessage {
        public static final String DECL_NAME = "KBASE_TL_NEW_LPU";
        private static final String LPU_FN_NAME = "lpu_fn";
        private static final String LPU_NAME = "lpu";
        private static final String LPU_NR_NAME = "lpu_nr";
        private static final String TIMESTAMP_NAME = "timestamp";
        private final @NonNull IMidgardActivityParser midgardActivityParser;
        private long mLpu;
        private long mLpuFn;
        private final int mLpuFnPos;
        private long mLpuNr;
        private final int mLpuNrPos;
        private final int mLpuPos;
        private long mTimestamp;
        private final int mTimestampPos;
        private final Type[] mTypes;

        public KbaseNewJobSlotMessage(@NonNull IMidgardActivityParser midgardActivityParser, String[] argNames, Type[] argTypes) throws IOException {
            this.midgardActivityParser = midgardActivityParser;
            this.mTypes = argTypes;
            int timestampPos = -1;
            int lpuPos = -1;
            int lpuNrPos = -1;
            int lpuFnPos = -1;
            int i = 0;
            while (i < argNames.length) {
                switch (argNames[i]) {
                    case "timestamp": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        timestampPos = i;
                        break;
                    }
                    case "lpu": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        lpuPos = i;
                        break;
                    }
                    case "lpu_nr": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        lpuNrPos = i;
                        break;
                    }
                    case "lpu_fn": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        lpuFnPos = i;
                        break;
                    }
                }
                ++i;
            }
            if (timestampPos == -1 || lpuPos == -1 || lpuNrPos == -1 || lpuFnPos == -1) {
                throw new IOException();
            }
            this.mTimestampPos = timestampPos;
            this.mLpuPos = lpuPos;
            this.mLpuNrPos = lpuNrPos;
            this.mLpuFnPos = lpuFnPos;
        }

        private KbaseNewJobSlotMessage(@NonNull IMidgardActivityParser midgardActivityParser, int timestampPos, int lpuPos, int lpuNrPos, int lpuFnPos, Type[] argTypes) {
            this.midgardActivityParser = midgardActivityParser;
            this.mTypes = argTypes;
            this.mTimestampPos = timestampPos;
            this.mLpuPos = lpuPos;
            this.mLpuNrPos = lpuNrPos;
            this.mLpuFnPos = lpuFnPos;
        }

        @Override
        public IMessage constructMessage() {
            return new KbaseNewJobSlotMessage(this.midgardActivityParser, this.mTimestampPos, this.mLpuPos, this.mLpuNrPos, this.mLpuFnPos, this.mTypes);
        }

        @Override
        public Type getType(int i) {
            return this.mTypes[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mTimestampPos) {
                this.mTimestamp = l;
            } else if (pos == this.mLpuPos) {
                this.mLpu = l;
            } else if (pos == this.mLpuNrPos) {
                this.mLpuNr = l;
            } else if (pos == this.mLpuFnPos) {
                this.mLpuFn = l;
            }
            return this.advance(state);
        }

        @Override
        public State setString(State state, String s) throws IOException {
            return this.advance(state);
        }

        private State advance(State state) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos + 1 < this.mTypes.length) {
                return State.values()[state.ordinal() + 1];
            }
            this.midgardActivityParser.kbaseNewJobSlot(this.mTimestamp, this.mLpu, this.mLpuNr, this.mLpuFn);
            return State.DECL_ID;
        }
    }

    private static class KbaseRetainAtomContextMessage
    implements IMessage {
        public static final String DECL_NAME = "KBASE_TL_RET_ATOM_CTX";
        private static final String ATOM_NAME = "atom";
        private static final String CTX_NAME = "ctx";
        private static final String TIMESTAMP_NAME = "timestamp";
        private long mAtom;
        private final int mAtomPos;
        private long mCtx;
        private final int mCtxPos;
        private final @NonNull IMidgardActivityParser midgardActivityParser;
        private long mTimestamp;
        private final int mTimestampPos;
        private final Type[] mTypes;

        public KbaseRetainAtomContextMessage(@NonNull IMidgardActivityParser midgardActivityParser, String[] argNames, Type[] argTypes) throws IOException {
            this.midgardActivityParser = midgardActivityParser;
            this.mTypes = argTypes;
            int timestampPos = -1;
            int atomPos = -1;
            int ctxPos = -1;
            int i = 0;
            while (i < argNames.length) {
                switch (argNames[i]) {
                    case "timestamp": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        timestampPos = i;
                        break;
                    }
                    case "atom": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        atomPos = i;
                        break;
                    }
                    case "ctx": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        ctxPos = i;
                        break;
                    }
                }
                ++i;
            }
            if (timestampPos == -1 || atomPos == -1 || ctxPos == -1) {
                throw new IOException();
            }
            this.mTimestampPos = timestampPos;
            this.mAtomPos = atomPos;
            this.mCtxPos = ctxPos;
        }

        private KbaseRetainAtomContextMessage(@NonNull IMidgardActivityParser midgardActivityParser, int timestampPos, int atomPos, int ctxPos, Type[] argTypes) {
            this.midgardActivityParser = midgardActivityParser;
            this.mTypes = argTypes;
            this.mTimestampPos = timestampPos;
            this.mAtomPos = atomPos;
            this.mCtxPos = ctxPos;
        }

        @Override
        public IMessage constructMessage() {
            return new KbaseRetainAtomContextMessage(this.midgardActivityParser, this.mTimestampPos, this.mAtomPos, this.mCtxPos, this.mTypes);
        }

        @Override
        public Type getType(int i) {
            return this.mTypes[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mTimestampPos) {
                this.mTimestamp = l;
            } else if (pos == this.mAtomPos) {
                this.mAtom = l;
            } else if (pos == this.mCtxPos) {
                this.mCtx = l;
            }
            return this.advance(state);
        }

        @Override
        public State setString(State state, String s) throws IOException {
            return this.advance(state);
        }

        private State advance(State state) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos + 1 < this.mTypes.length) {
                return State.values()[state.ordinal() + 1];
            }
            this.midgardActivityParser.kbaseRetainAtomContext(this.mTimestamp, this.mAtom, this.mCtx);
            return State.DECL_ID;
        }
    }

    private static class KbaseRetainAtomJobSlotMessage
    implements IMessage {
        public static final String DECL_NAME = "KBASE_TL_RET_ATOM_LPU";
        private static final String ATOM_NAME = "atom";
        private static final String ATTRIB_MATCH_LIST_NAME = "attrib_match_list";
        private static final String LPU_NAME = "lpu";
        private static final String TIMESTAMP_NAME = "timestamp";
        private long mAtom;
        private final int mAtomPos;
        private String mAttribMatchList;
        private final int mAttribMatchListPos;
        private final @NonNull IMidgardActivityParser midgardActivityParser;
        private long mLpu;
        private final int mLpuPos;
        private long mTimestamp;
        private final int mTimestampPos;
        private final Type[] mTypes;

        public KbaseRetainAtomJobSlotMessage(@NonNull IMidgardActivityParser midgardActivityParser, String[] argNames, Type[] argTypes) throws IOException {
            this.midgardActivityParser = midgardActivityParser;
            this.mTypes = argTypes;
            int timestampPos = -1;
            int atomPos = -1;
            int lpuPos = -1;
            int attribMatchListPos = -1;
            int i = 0;
            while (i < argNames.length) {
                switch (argNames[i]) {
                    case "timestamp": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        timestampPos = i;
                        break;
                    }
                    case "atom": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        atomPos = i;
                        break;
                    }
                    case "lpu": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        lpuPos = i;
                        break;
                    }
                    case "attrib_match_list": {
                        if (!argTypes[i].isStringType()) {
                            throw new IOException();
                        }
                        attribMatchListPos = i;
                        break;
                    }
                }
                ++i;
            }
            if (timestampPos == -1 || atomPos == -1 || lpuPos == -1 || attribMatchListPos == -1) {
                throw new IOException();
            }
            this.mTimestampPos = timestampPos;
            this.mAtomPos = atomPos;
            this.mLpuPos = lpuPos;
            this.mAttribMatchListPos = attribMatchListPos;
        }

        private KbaseRetainAtomJobSlotMessage(@NonNull IMidgardActivityParser midgardActivityParser, int timestampPos, int atomPos, int lpuPos, int attribMatchListPos, Type[] argTypes) {
            this.midgardActivityParser = midgardActivityParser;
            this.mTypes = argTypes;
            this.mTimestampPos = timestampPos;
            this.mAtomPos = atomPos;
            this.mLpuPos = lpuPos;
            this.mAttribMatchListPos = attribMatchListPos;
        }

        @Override
        public IMessage constructMessage() {
            return new KbaseRetainAtomJobSlotMessage(this.midgardActivityParser, this.mTimestampPos, this.mAtomPos, this.mLpuPos, this.mAttribMatchListPos, this.mTypes);
        }

        @Override
        public Type getType(int i) {
            return this.mTypes[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mTimestampPos) {
                this.mTimestamp = l;
            } else if (pos == this.mAtomPos) {
                this.mAtom = l;
            } else if (pos == this.mLpuPos) {
                this.mLpu = l;
            }
            return this.advance(state);
        }

        @Override
        public State setString(State state, String s) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mAttribMatchListPos) {
                this.mAttribMatchList = s;
            }
            return this.advance(state);
        }

        private State advance(State state) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos + 1 < this.mTypes.length) {
                return State.values()[state.ordinal() + 1];
            }
            this.midgardActivityParser.kbaseRetainAtomJobSlot(this.mTimestamp, this.mAtom, this.mLpu, this.mAttribMatchList);
            return State.DECL_ID;
        }
    }

    private static class KbaseUnretainAtomContextMessage
    implements IMessage {
        public static final String DECL_NAME = "KBASE_TL_NRET_ATOM_CTX";
        private static final String ATOM_NAME = "atom";
        private static final String CTX_NAME = "ctx";
        private static final String TIMESTAMP_NAME = "timestamp";
        private long mAtom;
        private final int mAtomPos;
        private long mCtx;
        private final int mCtxPos;
        private final @NonNull IMidgardActivityParser midgardActivityParser;
        private long mTimestamp;
        private final int mTimestampPos;
        private final Type[] mTypes;

        public KbaseUnretainAtomContextMessage(@NonNull IMidgardActivityParser midgardActivityParser, String[] argNames, Type[] argTypes) throws IOException {
            this.midgardActivityParser = midgardActivityParser;
            this.mTypes = argTypes;
            int timestampPos = -1;
            int atomPos = -1;
            int ctxPos = -1;
            int i = 0;
            while (i < argNames.length) {
                switch (argNames[i]) {
                    case "timestamp": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        timestampPos = i;
                        break;
                    }
                    case "atom": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        atomPos = i;
                        break;
                    }
                    case "ctx": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        ctxPos = i;
                        break;
                    }
                }
                ++i;
            }
            if (timestampPos == -1 || atomPos == -1 || ctxPos == -1) {
                throw new IOException();
            }
            this.mTimestampPos = timestampPos;
            this.mAtomPos = atomPos;
            this.mCtxPos = ctxPos;
        }

        private KbaseUnretainAtomContextMessage(@NonNull IMidgardActivityParser midgardActivityParser, int timestampPos, int atomPos, int ctxPos, Type[] argTypes) {
            this.midgardActivityParser = midgardActivityParser;
            this.mTypes = argTypes;
            this.mTimestampPos = timestampPos;
            this.mAtomPos = atomPos;
            this.mCtxPos = ctxPos;
        }

        @Override
        public IMessage constructMessage() {
            return new KbaseUnretainAtomContextMessage(this.midgardActivityParser, this.mTimestampPos, this.mAtomPos, this.mCtxPos, this.mTypes);
        }

        @Override
        public Type getType(int i) {
            return this.mTypes[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mTimestampPos) {
                this.mTimestamp = l;
            } else if (pos == this.mAtomPos) {
                this.mAtom = l;
            } else if (pos == this.mCtxPos) {
                this.mCtx = l;
            }
            return this.advance(state);
        }

        @Override
        public State setString(State state, String s) throws IOException {
            return this.advance(state);
        }

        private State advance(State state) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos + 1 < this.mTypes.length) {
                return State.values()[state.ordinal() + 1];
            }
            this.midgardActivityParser.kbaseUnretainAtomContext(this.mTimestamp, this.mAtom, this.mCtx);
            return State.DECL_ID;
        }
    }

    private static class KbaseUnretainAtomJobSlotMessage
    implements IMessage {
        public static final String DECL_NAME = "KBASE_TL_NRET_ATOM_LPU";
        private static final String ATOM_NAME = "atom";
        private static final String LPU_NAME = "lpu";
        private static final String TIMESTAMP_NAME = "timestamp";
        private long mAtom;
        private final int mAtomPos;
        private final @NonNull IMidgardActivityParser midgardActivityParser;
        private long mLpu;
        private final int mLpuPos;
        private long mTimestamp;
        private final int mTimestampPos;
        private final Type[] mTypes;

        public KbaseUnretainAtomJobSlotMessage(@NonNull IMidgardActivityParser midgardActivityParser, String[] argNames, Type[] argTypes) throws IOException {
            this.midgardActivityParser = midgardActivityParser;
            this.mTypes = argTypes;
            int timestampPos = -1;
            int atomPos = -1;
            int lpuPos = -1;
            int i = 0;
            while (i < argNames.length) {
                switch (argNames[i]) {
                    case "timestamp": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        timestampPos = i;
                        break;
                    }
                    case "atom": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        atomPos = i;
                        break;
                    }
                    case "lpu": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        lpuPos = i;
                        break;
                    }
                }
                ++i;
            }
            if (timestampPos == -1 || atomPos == -1 || lpuPos == -1) {
                throw new IOException();
            }
            this.mTimestampPos = timestampPos;
            this.mAtomPos = atomPos;
            this.mLpuPos = lpuPos;
        }

        private KbaseUnretainAtomJobSlotMessage(@NonNull IMidgardActivityParser midgardActivityParser, int timestampPos, int atomPos, int lpuPos, Type[] argTypes) {
            this.midgardActivityParser = midgardActivityParser;
            this.mTypes = argTypes;
            this.mTimestampPos = timestampPos;
            this.mAtomPos = atomPos;
            this.mLpuPos = lpuPos;
        }

        @Override
        public IMessage constructMessage() {
            return new KbaseUnretainAtomJobSlotMessage(this.midgardActivityParser, this.mTimestampPos, this.mAtomPos, this.mLpuPos, this.mTypes);
        }

        @Override
        public Type getType(int i) {
            return this.mTypes[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mTimestampPos) {
                this.mTimestamp = l;
            } else if (pos == this.mAtomPos) {
                this.mAtom = l;
            } else if (pos == this.mLpuPos) {
                this.mLpu = l;
            }
            return this.advance(state);
        }

        @Override
        public State setString(State state, String s) throws IOException {
            return this.advance(state);
        }

        private State advance(State state) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos + 1 < this.mTypes.length) {
                return State.values()[state.ordinal() + 1];
            }
            this.midgardActivityParser.kbaseUnretainAtomJobSlot(this.mTimestamp, this.mAtom, this.mLpu);
            return State.DECL_ID;
        }
    }

    private static class NRetainClosureToAtomMessage
    implements IMessage {
        public static final String DECL_NAME = "CINSTR_TL_NRET_CLOSURE_ATOM";
        private static final String ATOM_NAME = "atom";
        private static final String CLOSURE_NAME = "closure";
        private static final String THREAD_ID_NAME = "thread_id";
        private static final String TIMESTAMP_NAME = "timestamp";
        private final @NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator;
        private long mAtom;
        private final int mAtomPos;
        private long mClosure;
        private final int mClosurePos;
        private long mThreadID;
        private final int mThreadIDPos;
        private long mTimestamp;
        private final int mTimestampPos;
        private final Type[] mTypes;

        public NRetainClosureToAtomMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, String[] argNames, Type[] argTypes) throws IOException {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            int timestampPos = -1;
            int threadIDPos = -1;
            int closurePos = -1;
            int atomPos = -1;
            int i = 0;
            while (i < argNames.length) {
                switch (argNames[i]) {
                    case "timestamp": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        timestampPos = i;
                        break;
                    }
                    case "thread_id": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        threadIDPos = i;
                        break;
                    }
                    case "closure": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        closurePos = i;
                        break;
                    }
                    case "atom": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        atomPos = i;
                        break;
                    }
                }
                ++i;
            }
            if (timestampPos == -1 || threadIDPos == -1 || atomPos == -1 || closurePos == -1) {
                throw new IOException();
            }
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mAtomPos = atomPos;
            this.mClosurePos = closurePos;
        }

        private NRetainClosureToAtomMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, int timestampPos, int threadIDPos, int atomPos, int closurePos, Type[] argTypes) {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mAtomPos = atomPos;
            this.mClosurePos = closurePos;
        }

        @Override
        public IMessage constructMessage() {
            return new NRetainClosureToAtomMessage(this.maliOpenCLCAMGenerator, this.mTimestampPos, this.mThreadIDPos, this.mAtomPos, this.mClosurePos, this.mTypes);
        }

        @Override
        public Type getType(int i) {
            return this.mTypes[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mTimestampPos) {
                this.mTimestamp = l;
            } else if (pos == this.mThreadIDPos) {
                this.mThreadID = l;
            } else if (pos == this.mAtomPos) {
                this.mAtom = l;
            } else if (pos == this.mClosurePos) {
                this.mClosure = l;
            }
            return this.advance(state);
        }

        @Override
        public State setString(State state, String s) throws IOException {
            return this.advance(state);
        }

        private State advance(State state) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos + 1 < this.mTypes.length) {
                return State.values()[state.ordinal() + 1];
            }
            this.maliOpenCLCAMGenerator.nRetainClosureToAtom(this.mTimestamp, this.mThreadID, this.mClosure, this.mAtom);
            return State.DECL_ID;
        }
    }

    private static class NRetainClosureToLpuMessage
    implements IMessage {
        public static final String DECL_NAME = "CINSTR_TL_NRET_CLOSURE_LPU";
        private static final String CLOSURE_NAME = "closure";
        private static final String LPU_NAME = "lpu";
        private static final String THREAD_ID_NAME = "thread_id";
        private static final String TIMESTAMP_NAME = "timestamp";
        private final @NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator;
        private long mClosure;
        private final int mClosurePos;
        private long mLpu;
        private final int mLpuPos;
        private long mThreadID;
        private final int mThreadIDPos;
        private long mTimestamp;
        private final int mTimestampPos;
        private final Type[] mTypes;

        public NRetainClosureToLpuMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, String[] argNames, Type[] argTypes) throws IOException {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            int timestampPos = -1;
            int threadIDPos = -1;
            int closurePos = -1;
            int lpuPos = -1;
            int i = 0;
            while (i < argNames.length) {
                switch (argNames[i]) {
                    case "timestamp": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        timestampPos = i;
                        break;
                    }
                    case "thread_id": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        threadIDPos = i;
                        break;
                    }
                    case "closure": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        closurePos = i;
                        break;
                    }
                    case "lpu": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        lpuPos = i;
                        break;
                    }
                }
                ++i;
            }
            if (timestampPos == -1 || threadIDPos == -1 || closurePos == -1 || lpuPos == -1) {
                throw new IOException();
            }
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mClosurePos = closurePos;
            this.mLpuPos = lpuPos;
        }

        private NRetainClosureToLpuMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, int timestampPos, int threadIDPos, int closurePos, int lpuPos, Type[] argTypes) {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mClosurePos = closurePos;
            this.mLpuPos = lpuPos;
        }

        @Override
        public IMessage constructMessage() {
            return new NRetainClosureToLpuMessage(this.maliOpenCLCAMGenerator, this.mTimestampPos, this.mThreadIDPos, this.mClosurePos, this.mLpuPos, this.mTypes);
        }

        @Override
        public Type getType(int i) {
            return this.mTypes[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mTimestampPos) {
                this.mTimestamp = l;
            } else if (pos == this.mThreadIDPos) {
                this.mThreadID = l;
            } else if (pos == this.mClosurePos) {
                this.mClosure = l;
            } else if (pos == this.mLpuPos) {
                this.mLpu = l;
            }
            return this.advance(state);
        }

        @Override
        public State setString(State state, String s) throws IOException {
            return this.advance(state);
        }

        private State advance(State state) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos + 1 < this.mTypes.length) {
                return State.values()[state.ordinal() + 1];
            }
            this.maliOpenCLCAMGenerator.nRetainClosureToLPU(this.mTimestamp, this.mThreadID, this.mClosure, this.mLpu);
            return State.DECL_ID;
        }
    }

    private static class NewClosureMessage
    implements IMessage {
        public static final String DECL_NAME = "CINSTR_TL_NEW_CLOSURE";
        private static final String CLOSURE_NAME = "closure";
        private static final String THREAD_ID_NAME = "thread_id";
        private static final String TIMESTAMP_NAME = "timestamp";
        private final @NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator;
        private long mClosure;
        private final int mClosurePos;
        private long mThreadID;
        private final int mThreadIDPos;
        private long mTimestamp;
        private final int mTimestampPos;
        private final Type[] mTypes;

        public NewClosureMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, String[] argNames, Type[] argTypes) throws IOException {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            int timestampPos = -1;
            int threadIDPos = -1;
            int closurePos = -1;
            int i = 0;
            while (i < argNames.length) {
                switch (argNames[i]) {
                    case "timestamp": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        timestampPos = i;
                        break;
                    }
                    case "thread_id": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        threadIDPos = i;
                        break;
                    }
                    case "closure": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        closurePos = i;
                        break;
                    }
                }
                ++i;
            }
            if (timestampPos == -1 || threadIDPos == -1 || closurePos == -1) {
                throw new IOException();
            }
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mClosurePos = closurePos;
        }

        private NewClosureMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, int timestampPos, int threadIDPos, int closurePos, Type[] argTypes) {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mClosurePos = closurePos;
        }

        @Override
        public IMessage constructMessage() {
            return new NewClosureMessage(this.maliOpenCLCAMGenerator, this.mTimestampPos, this.mThreadIDPos, this.mClosurePos, this.mTypes);
        }

        @Override
        public Type getType(int i) {
            return this.mTypes[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mTimestampPos) {
                this.mTimestamp = l;
            } else if (pos == this.mThreadIDPos) {
                this.mThreadID = l;
            } else if (pos == this.mClosurePos) {
                this.mClosure = l;
            }
            return this.advance(state);
        }

        @Override
        public State setString(State state, String s) throws IOException {
            return this.advance(state);
        }

        private State advance(State state) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos + 1 < this.mTypes.length) {
                return State.values()[state.ordinal() + 1];
            }
            this.maliOpenCLCAMGenerator.newClosure(this.mTimestamp, this.mThreadID, this.mClosure);
            return State.DECL_ID;
        }
    }

    private static class NewCommandMessage
    implements IMessage {
        public static final String DECL_NAME = "CINSTR_TL_NEW_COMMAND";
        private static final String COMMAND_NAME = "command";
        private static final String THREAD_ID_NAME = "thread_id";
        private static final String TIMESTAMP_NAME = "timestamp";
        private final @NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator;
        private long mCommand;
        private final int mCommandPos;
        private long mThreadID;
        private final int mThreadIDPos;
        private long mTimestamp;
        private final int mTimestampPos;
        private final Type[] mTypes;

        public NewCommandMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, String[] argNames, Type[] argTypes) throws IOException {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            int timestampPos = -1;
            int threadIDPos = -1;
            int commandPos = -1;
            int i = 0;
            while (i < argNames.length) {
                switch (argNames[i]) {
                    case "timestamp": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        timestampPos = i;
                        break;
                    }
                    case "thread_id": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        threadIDPos = i;
                        break;
                    }
                    case "command": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        commandPos = i;
                        break;
                    }
                }
                ++i;
            }
            if (timestampPos == -1 || threadIDPos == -1 || commandPos == -1) {
                throw new IOException();
            }
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mCommandPos = commandPos;
        }

        private NewCommandMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, int timestampPos, int threadIDPos, int commandPos, Type[] argTypes) {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mCommandPos = commandPos;
        }

        @Override
        public IMessage constructMessage() {
            return new NewCommandMessage(this.maliOpenCLCAMGenerator, this.mTimestampPos, this.mThreadIDPos, this.mCommandPos, this.mTypes);
        }

        @Override
        public Type getType(int i) {
            return this.mTypes[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mTimestampPos) {
                this.mTimestamp = l;
            } else if (pos == this.mThreadIDPos) {
                this.mThreadID = l;
            } else if (pos == this.mCommandPos) {
                this.mCommand = l;
            }
            return this.advance(state);
        }

        @Override
        public State setString(State state, String s) throws IOException {
            return this.advance(state);
        }

        private State advance(State state) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos + 1 < this.mTypes.length) {
                return State.values()[state.ordinal() + 1];
            }
            this.maliOpenCLCAMGenerator.newCommand(this.mTimestamp, this.mThreadID, this.mCommand);
            return State.DECL_ID;
        }
    }

    private static class NewContextMessage
    implements IMessage {
        public static final String DECL_NAME = "CINSTR_TL_NEW_CTX";
        private static final String CTX_NAME = "ctx";
        private static final String THREAD_ID_NAME = "thread_id";
        private static final String TIMESTAMP_NAME = "timestamp";
        private long mCtx;
        private final int mCtxPos;
        private final @NonNull IMidgardActivityParser midgardActivityParser;
        private long mThreadID;
        private final int mThreadIDPos;
        private long mTimestamp;
        private final int mTimestampPos;
        private final Type[] mTypes;

        public NewContextMessage(@NonNull IMidgardActivityParser midgardActivityParser, String[] argNames, Type[] argTypes) throws IOException {
            this.midgardActivityParser = midgardActivityParser;
            this.mTypes = argTypes;
            int timestampPos = -1;
            int threadIDPos = -1;
            int ctxPos = -1;
            int i = 0;
            while (i < argNames.length) {
                switch (argNames[i]) {
                    case "timestamp": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        timestampPos = i;
                        break;
                    }
                    case "thread_id": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        threadIDPos = i;
                        break;
                    }
                    case "ctx": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        ctxPos = i;
                        break;
                    }
                }
                ++i;
            }
            if (timestampPos == -1 || threadIDPos == -1 || ctxPos == -1) {
                throw new IOException();
            }
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mCtxPos = ctxPos;
        }

        private NewContextMessage(@NonNull IMidgardActivityParser midgardActivityParser, int timestampPos, int threadIDPos, int ctxPos, Type[] argTypes) {
            this.midgardActivityParser = midgardActivityParser;
            this.mTypes = argTypes;
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mCtxPos = ctxPos;
        }

        @Override
        public IMessage constructMessage() {
            return new NewContextMessage(this.midgardActivityParser, this.mTimestampPos, this.mThreadIDPos, this.mCtxPos, this.mTypes);
        }

        @Override
        public Type getType(int i) {
            return this.mTypes[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mTimestampPos) {
                this.mTimestamp = l;
            } else if (pos == this.mThreadIDPos) {
                this.mThreadID = l;
            } else if (pos == this.mCtxPos) {
                this.mCtx = l;
            }
            return this.advance(state);
        }

        @Override
        public State setString(State state, String s) throws IOException {
            return this.advance(state);
        }

        private State advance(State state) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos + 1 < this.mTypes.length) {
                return State.values()[state.ordinal() + 1];
            }
            this.midgardActivityParser.cinstrNewContext(this.mTimestamp, this.mCtx);
            return State.DECL_ID;
        }
    }

    private static class NewQueueMessage
    implements IMessage {
        public static final String DECL_NAME = "CINSTR_TL_NEW_QUEUE";
        private static final String QUEUE_NAME = "queue";
        private static final String THREAD_ID_NAME = "thread_id";
        private static final String TIMESTAMP_NAME = "timestamp";
        private final @NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator;
        private long mQueue;
        private final int mQueuePos;
        private long mThreadID;
        private final int mThreadIDPos;
        private long mTimestamp;
        private final int mTimestampPos;
        private final Type[] mTypes;

        public NewQueueMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, String[] argNames, Type[] argTypes) throws IOException {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            int timestampPos = -1;
            int threadIDPos = -1;
            int queuePos = -1;
            int i = 0;
            while (i < argNames.length) {
                switch (argNames[i]) {
                    case "timestamp": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        timestampPos = i;
                        break;
                    }
                    case "thread_id": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        threadIDPos = i;
                        break;
                    }
                    case "queue": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        queuePos = i;
                        break;
                    }
                }
                ++i;
            }
            if (timestampPos == -1 || threadIDPos == -1 || queuePos == -1) {
                throw new IOException();
            }
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mQueuePos = queuePos;
        }

        private NewQueueMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, int timestampPos, int threadIDPos, int queuePos, Type[] argTypes) {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mQueuePos = queuePos;
        }

        @Override
        public IMessage constructMessage() {
            return new NewQueueMessage(this.maliOpenCLCAMGenerator, this.mTimestampPos, this.mThreadIDPos, this.mQueuePos, this.mTypes);
        }

        @Override
        public Type getType(int i) {
            return this.mTypes[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mTimestampPos) {
                this.mTimestamp = l;
            } else if (pos == this.mThreadIDPos) {
                this.mThreadID = l;
            } else if (pos == this.mQueuePos) {
                this.mQueue = l;
            }
            return this.advance(state);
        }

        @Override
        public State setString(State state, String s) throws IOException {
            return this.advance(state);
        }

        private State advance(State state) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos + 1 < this.mTypes.length) {
                return State.values()[state.ordinal() + 1];
            }
            this.maliOpenCLCAMGenerator.newQueue(this.mTimestamp, this.mThreadID, this.mQueue);
            return State.DECL_ID;
        }
    }

    private static class RetainClosureToAtomMessage
    implements IMessage {
        public static final String DECL_NAME = "CINSTR_TL_RET_CLOSURE_ATOM";
        private static final String ATOM_NAME = "atom";
        private static final String CLOSURE_NAME = "closure";
        private static final String THREAD_ID_NAME = "thread_id";
        private static final String TIMESTAMP_NAME = "timestamp";
        private final @NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator;
        private long mAtom;
        private final int mAtomPos;
        private long mClosure;
        private final int mClosurePos;
        private long mThreadID;
        private final int mThreadIDPos;
        private long mTimestamp;
        private final int mTimestampPos;
        private final Type[] mTypes;

        public RetainClosureToAtomMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, String[] argNames, Type[] argTypes) throws IOException {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            int timestampPos = -1;
            int threadIDPos = -1;
            int closurePos = -1;
            int atomPos = -1;
            int i = 0;
            while (i < argNames.length) {
                switch (argNames[i]) {
                    case "timestamp": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        timestampPos = i;
                        break;
                    }
                    case "thread_id": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        threadIDPos = i;
                        break;
                    }
                    case "closure": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        closurePos = i;
                        break;
                    }
                    case "atom": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        atomPos = i;
                        break;
                    }
                }
                ++i;
            }
            if (timestampPos == -1 || threadIDPos == -1 || atomPos == -1 || closurePos == -1) {
                throw new IOException();
            }
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mAtomPos = atomPos;
            this.mClosurePos = closurePos;
        }

        private RetainClosureToAtomMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, int timestampPos, int threadIDPos, int atomPos, int closurePos, Type[] argTypes) {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mAtomPos = atomPos;
            this.mClosurePos = closurePos;
        }

        @Override
        public IMessage constructMessage() {
            return new RetainClosureToAtomMessage(this.maliOpenCLCAMGenerator, this.mTimestampPos, this.mThreadIDPos, this.mAtomPos, this.mClosurePos, this.mTypes);
        }

        @Override
        public Type getType(int i) {
            return this.mTypes[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mTimestampPos) {
                this.mTimestamp = l;
            } else if (pos == this.mThreadIDPos) {
                this.mThreadID = l;
            } else if (pos == this.mAtomPos) {
                this.mAtom = l;
            } else if (pos == this.mClosurePos) {
                this.mClosure = l;
            }
            return this.advance(state);
        }

        @Override
        public State setString(State state, String s) throws IOException {
            return this.advance(state);
        }

        private State advance(State state) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos + 1 < this.mTypes.length) {
                return State.values()[state.ordinal() + 1];
            }
            this.maliOpenCLCAMGenerator.retainClosureToAtom(this.mTimestamp, this.mThreadID, this.mClosure, this.mAtom);
            return State.DECL_ID;
        }
    }

    private static class RetainClosureToCommandMessage
    implements IMessage {
        public static final String DECL_NAME = "CINSTR_TL_RET_CLOSURE_COMMAND";
        private static final String CLOSURE_NAME = "closure";
        private static final String COMMAND_NAME = "command";
        private static final String THREAD_ID_NAME = "thread_id";
        private static final String TIMESTAMP_NAME = "timestamp";
        private final @NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator;
        private long mClosure;
        private final int mClosurePos;
        private long mCommand;
        private final int mCommandPos;
        private long mThreadID;
        private final int mThreadIDPos;
        private long mTimestamp;
        private final int mTimestampPos;
        private final Type[] mTypes;

        public RetainClosureToCommandMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, String[] argNames, Type[] argTypes) throws IOException {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            int timestampPos = -1;
            int threadIDPos = -1;
            int commandPos = -1;
            int closurePos = -1;
            int i = 0;
            while (i < argNames.length) {
                switch (argNames[i]) {
                    case "timestamp": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        timestampPos = i;
                        break;
                    }
                    case "thread_id": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        threadIDPos = i;
                        break;
                    }
                    case "closure": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        closurePos = i;
                        break;
                    }
                    case "command": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        commandPos = i;
                        break;
                    }
                }
                ++i;
            }
            if (timestampPos == -1 || threadIDPos == -1 || commandPos == -1 || closurePos == -1) {
                throw new IOException();
            }
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mClosurePos = closurePos;
            this.mCommandPos = commandPos;
        }

        private RetainClosureToCommandMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, int timestampPos, int threadIDPos, int closurePos, int commandPos, Type[] argTypes) {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mClosurePos = closurePos;
            this.mCommandPos = commandPos;
        }

        @Override
        public IMessage constructMessage() {
            return new RetainClosureToCommandMessage(this.maliOpenCLCAMGenerator, this.mTimestampPos, this.mThreadIDPos, this.mClosurePos, this.mCommandPos, this.mTypes);
        }

        @Override
        public Type getType(int i) {
            return this.mTypes[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mTimestampPos) {
                this.mTimestamp = l;
            } else if (pos == this.mThreadIDPos) {
                this.mThreadID = l;
            } else if (pos == this.mCommandPos) {
                this.mCommand = l;
            } else if (pos == this.mClosurePos) {
                this.mClosure = l;
            }
            return this.advance(state);
        }

        @Override
        public State setString(State state, String s) throws IOException {
            return this.advance(state);
        }

        private State advance(State state) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos + 1 < this.mTypes.length) {
                return State.values()[state.ordinal() + 1];
            }
            this.maliOpenCLCAMGenerator.retainClosureToCommand(this.mTimestamp, this.mThreadID, this.mClosure, this.mCommand);
            return State.DECL_ID;
        }
    }

    private static class RetainClosureToKernelMessage
    implements IMessage {
        public static final String DECL_NAME = "CINSTR_TL_RET_CLOSURE_KERNEL";
        private static final String CLOSURE_NAME = "closure";
        private static final String KERNEL_NAME = "kernel";
        private static final String THREAD_ID_NAME = "thread_id";
        private static final String TIMESTAMP_NAME = "timestamp";
        private final @NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator;
        private long mClosure;
        private final int mClosurePos;
        private long mKernel;
        private final int mKernelPos;
        private long mThreadID;
        private final int mThreadIDPos;
        private long mTimestamp;
        private final int mTimestampPos;
        private final Type[] mTypes;

        public RetainClosureToKernelMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, String[] argNames, Type[] argTypes) throws IOException {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            int timestampPos = -1;
            int threadIDPos = -1;
            int closurePos = -1;
            int kernelPos = -1;
            int i = 0;
            while (i < argNames.length) {
                switch (argNames[i]) {
                    case "timestamp": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        timestampPos = i;
                        break;
                    }
                    case "thread_id": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        threadIDPos = i;
                        break;
                    }
                    case "closure": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        closurePos = i;
                        break;
                    }
                    case "kernel": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        kernelPos = i;
                        break;
                    }
                }
                ++i;
            }
            if (timestampPos == -1 || threadIDPos == -1 || kernelPos == -1 || closurePos == -1) {
                throw new IOException();
            }
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mClosurePos = closurePos;
            this.mKernelPos = kernelPos;
        }

        private RetainClosureToKernelMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, int timestampPos, int threadIDPos, int closurePos, int kernelPos, Type[] argTypes) {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mClosurePos = closurePos;
            this.mKernelPos = kernelPos;
        }

        @Override
        public IMessage constructMessage() {
            return new RetainClosureToKernelMessage(this.maliOpenCLCAMGenerator, this.mTimestampPos, this.mThreadIDPos, this.mClosurePos, this.mKernelPos, this.mTypes);
        }

        @Override
        public Type getType(int i) {
            return this.mTypes[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mTimestampPos) {
                this.mTimestamp = l;
            } else if (pos == this.mThreadIDPos) {
                this.mThreadID = l;
            } else if (pos == this.mClosurePos) {
                this.mClosure = l;
            } else if (pos == this.mKernelPos) {
                this.mKernel = l;
            }
            return this.advance(state);
        }

        @Override
        public State setString(State state, String s) throws IOException {
            return this.advance(state);
        }

        private State advance(State state) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos + 1 < this.mTypes.length) {
                return State.values()[state.ordinal() + 1];
            }
            this.maliOpenCLCAMGenerator.retainClosureToKernel(this.mTimestamp, this.mThreadID, this.mClosure, this.mKernel);
            return State.DECL_ID;
        }
    }

    private static class RetainClosureToLpuMessage
    implements IMessage {
        public static final String DECL_NAME = "CINSTR_TL_RET_CLOSURE_LPU";
        private static final String CLOSURE_NAME = "closure";
        private static final String LPU_NAME = "lpu";
        private static final String THREAD_ID_NAME = "thread_id";
        private static final String TIMESTAMP_NAME = "timestamp";
        private final @NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator;
        private long mClosure;
        private final int mClosurePos;
        private long mLpu;
        private final int mLpuPos;
        private long mThreadID;
        private final int mThreadIDPos;
        private long mTimestamp;
        private final int mTimestampPos;
        private final Type[] mTypes;

        public RetainClosureToLpuMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, String[] argNames, Type[] argTypes) throws IOException {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            int timestampPos = -1;
            int threadIDPos = -1;
            int closurePos = -1;
            int lpuPos = -1;
            int i = 0;
            while (i < argNames.length) {
                switch (argNames[i]) {
                    case "timestamp": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        timestampPos = i;
                        break;
                    }
                    case "thread_id": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        threadIDPos = i;
                        break;
                    }
                    case "closure": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        closurePos = i;
                        break;
                    }
                    case "lpu": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        lpuPos = i;
                        break;
                    }
                }
                ++i;
            }
            if (timestampPos == -1 || threadIDPos == -1 || closurePos == -1 || lpuPos == -1) {
                throw new IOException();
            }
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mClosurePos = closurePos;
            this.mLpuPos = lpuPos;
        }

        private RetainClosureToLpuMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, int timestampPos, int threadIDPos, int closurePos, int lpuPos, Type[] argTypes) {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mClosurePos = closurePos;
            this.mLpuPos = lpuPos;
        }

        @Override
        public IMessage constructMessage() {
            return new RetainClosureToLpuMessage(this.maliOpenCLCAMGenerator, this.mTimestampPos, this.mThreadIDPos, this.mClosurePos, this.mLpuPos, this.mTypes);
        }

        @Override
        public Type getType(int i) {
            return this.mTypes[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mTimestampPos) {
                this.mTimestamp = l;
            } else if (pos == this.mThreadIDPos) {
                this.mThreadID = l;
            } else if (pos == this.mClosurePos) {
                this.mClosure = l;
            } else if (pos == this.mLpuPos) {
                this.mLpu = l;
            }
            return this.advance(state);
        }

        @Override
        public State setString(State state, String s) throws IOException {
            return this.advance(state);
        }

        private State advance(State state) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos + 1 < this.mTypes.length) {
                return State.values()[state.ordinal() + 1];
            }
            this.maliOpenCLCAMGenerator.retainClosureToLPU(this.mTimestamp, this.mThreadID, this.mClosure, this.mLpu);
            return State.DECL_ID;
        }
    }

    private static class RetainCommandToClosureMessage
    implements IMessage {
        public static final String DECL_NAME = "CINSTR_TL_RET_COMMAND_CLOSURE";
        private static final String CLOSURE_NAME = "closure";
        private static final String COMMAND_NAME = "command";
        private static final String THREAD_ID_NAME = "thread_id";
        private static final String TIMESTAMP_NAME = "timestamp";
        private final @NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator;
        private long mClosure;
        private final int mClosurePos;
        private long mCommand;
        private final int mCommandPos;
        private long mThreadID;
        private final int mThreadIDPos;
        private long mTimestamp;
        private final int mTimestampPos;
        private final Type[] mTypes;

        public RetainCommandToClosureMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, String[] argNames, Type[] argTypes) throws IOException {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            int timestampPos = -1;
            int threadIDPos = -1;
            int commandPos = -1;
            int closurePos = -1;
            int i = 0;
            while (i < argNames.length) {
                switch (argNames[i]) {
                    case "timestamp": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        timestampPos = i;
                        break;
                    }
                    case "thread_id": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        threadIDPos = i;
                        break;
                    }
                    case "command": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        commandPos = i;
                        break;
                    }
                    case "closure": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        closurePos = i;
                        break;
                    }
                }
                ++i;
            }
            if (timestampPos == -1 || threadIDPos == -1 || commandPos == -1 || closurePos == -1) {
                throw new IOException();
            }
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mCommandPos = commandPos;
            this.mClosurePos = closurePos;
        }

        private RetainCommandToClosureMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, int timestampPos, int threadIDPos, int commandPos, int closurePos, Type[] argTypes) {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mCommandPos = commandPos;
            this.mClosurePos = closurePos;
        }

        @Override
        public IMessage constructMessage() {
            return new RetainCommandToClosureMessage(this.maliOpenCLCAMGenerator, this.mTimestampPos, this.mThreadIDPos, this.mCommandPos, this.mClosurePos, this.mTypes);
        }

        @Override
        public Type getType(int i) {
            return this.mTypes[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mTimestampPos) {
                this.mTimestamp = l;
            } else if (pos == this.mThreadIDPos) {
                this.mThreadID = l;
            } else if (pos == this.mCommandPos) {
                this.mCommand = l;
            } else if (pos == this.mClosurePos) {
                this.mClosure = l;
            }
            return this.advance(state);
        }

        @Override
        public State setString(State state, String s) throws IOException {
            return this.advance(state);
        }

        private State advance(State state) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos + 1 < this.mTypes.length) {
                return State.values()[state.ordinal() + 1];
            }
            this.maliOpenCLCAMGenerator.retainCommandToClosure(this.mTimestamp, this.mThreadID, this.mCommand, this.mClosure);
            return State.DECL_ID;
        }
    }

    private static class RetainCommandToQueueMessage
    implements IMessage {
        public static final String DECL_NAME = "CINSTR_TL_RET_COMMAND_QUEUE";
        private static final String COMMAND_NAME = "command";
        private static final String QUEUE_NAME = "queue";
        private static final String THREAD_ID_NAME = "thread_id";
        private static final String TIMESTAMP_NAME = "timestamp";
        private final @NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator;
        private long mCommand;
        private final int mCommandPos;
        private long mQueue;
        private final int mQueuePos;
        private long mThreadID;
        private final int mThreadIDPos;
        private long mTimestamp;
        private final int mTimestampPos;
        private final Type[] mTypes;

        public RetainCommandToQueueMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, String[] argNames, Type[] argTypes) throws IOException {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            int timestampPos = -1;
            int threadIDPos = -1;
            int commandPos = -1;
            int queuePos = -1;
            int i = 0;
            while (i < argNames.length) {
                switch (argNames[i]) {
                    case "timestamp": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        timestampPos = i;
                        break;
                    }
                    case "thread_id": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        threadIDPos = i;
                        break;
                    }
                    case "command": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        commandPos = i;
                        break;
                    }
                    case "queue": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        queuePos = i;
                        break;
                    }
                }
                ++i;
            }
            if (timestampPos == -1 || threadIDPos == -1 || commandPos == -1 || queuePos == -1) {
                throw new IOException();
            }
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mCommandPos = commandPos;
            this.mQueuePos = queuePos;
        }

        private RetainCommandToQueueMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, int timestampPos, int threadIDPos, int commandPos, int queuePos, Type[] argTypes) {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mCommandPos = commandPos;
            this.mQueuePos = queuePos;
        }

        @Override
        public IMessage constructMessage() {
            return new RetainCommandToQueueMessage(this.maliOpenCLCAMGenerator, this.mTimestampPos, this.mThreadIDPos, this.mCommandPos, this.mQueuePos, this.mTypes);
        }

        @Override
        public Type getType(int i) {
            return this.mTypes[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mTimestampPos) {
                this.mTimestamp = l;
            } else if (pos == this.mThreadIDPos) {
                this.mThreadID = l;
            } else if (pos == this.mCommandPos) {
                this.mCommand = l;
            } else if (pos == this.mQueuePos) {
                this.mQueue = l;
            }
            return this.advance(state);
        }

        @Override
        public State setString(State state, String s) throws IOException {
            return this.advance(state);
        }

        private State advance(State state) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos + 1 < this.mTypes.length) {
                return State.values()[state.ordinal() + 1];
            }
            this.maliOpenCLCAMGenerator.retainCommandToQueue(this.mTimestamp, this.mThreadID, this.mCommand, this.mQueue);
            return State.DECL_ID;
        }
    }

    private static class RetainEventToCommandMessage
    implements IMessage {
        public static final String DECL_NAME = "CINSTR_TL_RET_EVENT_COMMAND";
        private static final String COMMAND_NAME = "command";
        private static final String EVENT_NAME = "event";
        private static final String THREAD_ID_NAME = "thread_id";
        private static final String TIMESTAMP_NAME = "timestamp";
        private final @NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator;
        private long mCommand;
        private final int mCommandPos;
        private long mEvent;
        private final int mEventPos;
        private long mThreadID;
        private final int mThreadIDPos;
        private long mTimestamp;
        private final int mTimestampPos;
        private final Type[] mTypes;

        public RetainEventToCommandMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, String[] argNames, Type[] argTypes) throws IOException {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            int timestampPos = -1;
            int threadIDPos = -1;
            int eventPos = -1;
            int commandPos = -1;
            int i = 0;
            while (i < argNames.length) {
                switch (argNames[i]) {
                    case "timestamp": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        timestampPos = i;
                        break;
                    }
                    case "thread_id": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        threadIDPos = i;
                        break;
                    }
                    case "event": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        eventPos = i;
                        break;
                    }
                    case "command": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        commandPos = i;
                        break;
                    }
                }
                ++i;
            }
            if (timestampPos == -1 || threadIDPos == -1 || eventPos == -1 || commandPos == -1) {
                throw new IOException();
            }
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mEventPos = eventPos;
            this.mCommandPos = commandPos;
        }

        private RetainEventToCommandMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, int timestampPos, int threadIDPos, int eventPos, int commandPos, Type[] argTypes) {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mEventPos = eventPos;
            this.mCommandPos = commandPos;
        }

        @Override
        public IMessage constructMessage() {
            return new RetainEventToCommandMessage(this.maliOpenCLCAMGenerator, this.mTimestampPos, this.mThreadIDPos, this.mEventPos, this.mCommandPos, this.mTypes);
        }

        @Override
        public Type getType(int i) {
            return this.mTypes[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mTimestampPos) {
                this.mTimestamp = l;
            } else if (pos == this.mThreadIDPos) {
                this.mThreadID = l;
            } else if (pos == this.mEventPos) {
                this.mEvent = l;
            } else if (pos == this.mCommandPos) {
                this.mCommand = l;
            }
            return this.advance(state);
        }

        @Override
        public State setString(State state, String s) throws IOException {
            return this.advance(state);
        }

        private State advance(State state) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos + 1 < this.mTypes.length) {
                return State.values()[state.ordinal() + 1];
            }
            this.maliOpenCLCAMGenerator.retainEventToCommand(this.mTimestamp, this.mThreadID, this.mEvent, this.mCommand);
            return State.DECL_ID;
        }
    }

    private static class RetainQueueToContextMessage
    implements IMessage {
        public static final String DECL_NAME = "CINSTR_TL_RET_QUEUE_CTX";
        private static final String CTX_NAME = "ctx";
        private static final String QUEUE_NAME = "queue";
        private static final String THREAD_ID_NAME = "thread_id";
        private static final String TIMESTAMP_NAME = "timestamp";
        private final @NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator;
        private long mCtx;
        private final int mCtxPos;
        private long mQueue;
        private final int mQueuePos;
        private long mThreadID;
        private final int mThreadIDPos;
        private long mTimestamp;
        private final int mTimestampPos;
        private final Type[] mTypes;

        public RetainQueueToContextMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, String[] argNames, Type[] argTypes) throws IOException {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            int timestampPos = -1;
            int threadIDPos = -1;
            int queuePos = -1;
            int ctxPos = -1;
            int i = 0;
            while (i < argNames.length) {
                switch (argNames[i]) {
                    case "timestamp": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        timestampPos = i;
                        break;
                    }
                    case "thread_id": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        threadIDPos = i;
                        break;
                    }
                    case "queue": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        queuePos = i;
                        break;
                    }
                    case "ctx": {
                        if (!argTypes[i].isLongType()) {
                            throw new IOException();
                        }
                        ctxPos = i;
                        break;
                    }
                }
                ++i;
            }
            if (timestampPos == -1 || threadIDPos == -1 || queuePos == -1 || ctxPos == -1) {
                throw new IOException();
            }
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mQueuePos = queuePos;
            this.mCtxPos = ctxPos;
        }

        private RetainQueueToContextMessage(@NonNull IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator, int timestampPos, int threadIDPos, int queuePos, int ctxPos, Type[] argTypes) {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator;
            this.mTypes = argTypes;
            this.mTimestampPos = timestampPos;
            this.mThreadIDPos = threadIDPos;
            this.mQueuePos = queuePos;
            this.mCtxPos = ctxPos;
        }

        @Override
        public IMessage constructMessage() {
            return new RetainQueueToContextMessage(this.maliOpenCLCAMGenerator, this.mTimestampPos, this.mThreadIDPos, this.mQueuePos, this.mCtxPos, this.mTypes);
        }

        @Override
        public Type getType(int i) {
            return this.mTypes[i];
        }

        @Override
        public State setLong(State state, long l) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos == this.mTimestampPos) {
                this.mTimestamp = l;
            } else if (pos == this.mThreadIDPos) {
                this.mThreadID = l;
            } else if (pos == this.mQueuePos) {
                this.mQueue = l;
            } else if (pos == this.mCtxPos) {
                this.mCtx = l;
            }
            return this.advance(state);
        }

        @Override
        public State setString(State state, String s) throws IOException {
            return this.advance(state);
        }

        private State advance(State state) throws IOException {
            int pos = state.ordinal() - State.DATA.ordinal();
            if (pos + 1 < this.mTypes.length) {
                return State.values()[state.ordinal() + 1];
            }
            this.maliOpenCLCAMGenerator.retainQueueToContext(this.mTimestamp, this.mThreadID, this.mQueue, this.mCtx);
            return State.DECL_ID;
        }
    }

    private static enum State {
        DATA,
        DATA_1,
        DATA_2,
        DATA_3,
        DATA_4,
        DATA_5,
        DATA_6,
        DECL_ID,
        ERROR,
        FINISH_DIRECTORY,
        POINTER_BYTES,
        STREAM_VERSION,
        THREAD_ID_BYTES;

    }

    private static enum Type {
        DOUBLE,
        S32,
        S64,
        STRING,
        U32,
        U64,
        U8;


        public boolean isLongType() {
            switch (this) {
                case S32: 
                case S64: 
                case U32: 
                case U64: 
                case U8: {
                    return true;
                }
            }
            return false;
        }

        public boolean isStringType() {
            return this == STRING;
        }
    }
}

