/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.external;

import com.arm.streamline.analysis.model.ICounterSeriesKey;
import com.arm.streamline.analysis.model.StaticCounterSeriesKey;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.utility.io.BufferUtils;
import com.arm.streamline.ftrace.TracepointField;
import com.arm.streamline.ftrace.TracepointFormat;
import com.arm.streamline.protocol.capture.apc.pass_two.warnings.WarningsFactory;
import com.arm.streamline.protocol.capture.apc.protocol.external.AtraceParser;
import com.arm.streamline.protocol.capture.apc.protocol.external.ExternalProtocolChannel;
import com.arm.streamline.protocol.capture.apc.protocol.external.FTraceCommon;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolDecoder;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolEventStream;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolPassTwoState;
import com.arm.streamline.protocol.capture.apc.time.ClockSource;
import com.arm.streamline.protocol.misc.TaskId;
import com.arm.utils.NullChecking;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class EStateFtraceV2
implements IExternalProtocolDecoder {
    public static final @NonNull String PROTOCOL = "FTRACE 2";
    private static final @NonNull String COMMON_PID = "common_pid";
    private static final @NonNull String FIELD_BUF_OLD_KERNEL = "buf";
    private static final @NonNull String FIELD_BUF = "buf[]";
    private static final @NonNull String FIELD_COMMIT = "commit";
    private static final @NonNull String FIELD_DATA = "data";
    private static final @NonNull String FIELD_TIMESTAMP = "timestamp";
    private static final @NonNull String FORMAT_PRINT = "print";
    private static final int RINGBUF_TYPE_PADDING = 29;
    private static final int RINGBUF_TYPE_TIME_EXTEND = 30;
    private static final int RINGBUF_TYPE_TIME_STAMP = 31;
    private static final int TIME_EXTEND_SHIFT = 27;
    private final @NonNull AtraceParser atraceParser;
    private final @NonNull ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private final @NonNull FTraceCommon commonProcessing;
    private final @NonNull TracepointFormat mHeaderPage;
    private final int mPageSize;
    private final @NonNull IExternalProtocolEventStream outputStream;
    private final @NonNull IExternalProtocolPassTwoState passTwoState;
    private final @NonNull ProcessingElementReference systemWidePeReference;
    private final @NonNull Map<@NonNull String, @NonNull FtraceCounter> tracepointCounterSeries = new HashMap<String, FtraceCounter>();

    private static long headerToDelta(int header) {
        return header >>> 5;
    }

    private static int headerToLen(int header) {
        return header & 0x1F;
    }

    public EStateFtraceV2(@NonNull ExternalProtocolChannel channel, @NonNull IExternalProtocolPassTwoState passTwoState, @NonNull IExternalProtocolEventStream outputStream) throws IOException {
        this.passTwoState = passTwoState;
        this.outputStream = outputStream;
        this.systemWidePeReference = passTwoState.getSystemWideProcessingElementReference();
        this.atraceParser = new AtraceParser(channel, passTwoState, outputStream);
        for (Map.Entry<String, StaticCounterSeriesKey> entry : passTwoState.getStaticCounterSeries().getTracepointCountersByName().entrySet()) {
            this.tracepointCounterSeries.put(entry.getKey(), new FtraceCounter(entry.getValue()));
        }
        @Nullable TracepointFormat headerPageFormat = passTwoState.getTracepointFormat(-2147483647);
        if (headerPageFormat == null) {
            throw new IOException("Missing header page tracepoint format");
        }
        @NonNull TracepointField data = (TracepointField)NullChecking.neverNull((Object)headerPageFormat.getField(FIELD_DATA));
        this.mHeaderPage = headerPageFormat;
        this.mPageSize = data.getOffset() + data.getSize();
        if (this.mPageSize <= 0) {
            throw new IOException("Invalid header page size");
        }
        this.commonProcessing = new FTraceCommon(passTwoState, outputStream);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void process(byte @NonNull [] data) throws IOException {
        if (data.length <= 0) {
            return;
        }
        int pos = 0;
        while (pos < data.length) {
            int baosSize = this.baos.size();
            if (baosSize > 0) {
                if (baosSize + data.length - pos < this.mPageSize) {
                    this.baos.write(data, pos, data.length - pos);
                    return;
                }
                byte[] page = new byte[this.mPageSize];
                System.arraycopy(this.baos.toByteArray(), 0, page, 0, baosSize);
                System.arraycopy(data, pos, page, baosSize, this.mPageSize - baosSize);
                this.baos.reset();
                this.processPage(page, 0);
                pos += this.mPageSize - baosSize;
                continue;
            }
            if (data.length - pos < this.mPageSize) {
                this.baos.write(data, pos, data.length - pos);
                return;
            }
            this.processPage(data, pos);
            pos += this.mPageSize;
        }
    }

    @Override
    public boolean reorderable() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processPage(byte @NonNull [] buf, int bufPos) throws IOException {
        long timestamp = this.mHeaderPage.getInt(FIELD_TIMESTAMP, buf, bufPos);
        long commit = this.mHeaderPage.getInt(FIELD_COMMIT, buf, bufPos);
        int pos = this.mHeaderPage.getField(FIELD_DATA).getOffset();
        while ((long)pos < commit) {
            int header = BufferUtils.readLEInt((byte[])buf, (int)(bufPos + pos));
            pos += 4;
            int typeLen = EStateFtraceV2.headerToLen(header);
            long delta = EStateFtraceV2.headerToDelta(header);
            int length = 0;
            switch (typeLen) {
                case 29: {
                    int pLength = BufferUtils.readLEInt((byte[])buf, (int)(bufPos + pos));
                    pos += pLength;
                    break;
                }
                case 30: {
                    int extend = BufferUtils.readLEInt((byte[])buf, (int)(bufPos + pos));
                    pos += 4;
                    delta = (long)(extend << 27) + delta;
                    break;
                }
                case 31: {
                    pos += 12;
                    break;
                }
                case 0: {
                    length = BufferUtils.readLEInt((byte[])buf, (int)(bufPos + pos)) - 1 & 0xFFFFFFFC;
                    pos += 4;
                    break;
                }
                default: {
                    length = 4 * typeLen;
                }
            }
            if (length > 0) {
                int commonType = (int)BufferUtils.readLEIntSize((byte[])buf, (int)(bufPos + pos + 0), (int)2, (boolean)false);
                @Nullable TracepointFormat format = this.passTwoState.getTracepointFormat(commonType);
                long time = timestamp + delta;
                if (format != null) {
                    assert (buf.length - (bufPos + pos) >= length) : String.format("bp=%d, p=%d, b.l=%d, l=%d", bufPos, pos, buf.length, length);
                    byte[] rawBytes = new byte[length];
                    System.arraycopy(buf, bufPos + pos, rawBytes, 0, length);
                    int tid = (int)format.getInt(COMMON_PID, rawBytes);
                    TaskId taskId = new TaskId(tid);
                    if (time != -1L) {
                        switch (format.getName()) {
                            case "print": {
                                TracepointField bufField = format.getField(FIELD_BUF);
                                if (bufField == null) {
                                    bufField = format.getField(FIELD_BUF_OLD_KERNEL);
                                }
                                if (bufField == null) {
                                    throw new IOException("Bad format for ftrace 'print' event.");
                                }
                                String data = bufField.getString(rawBytes, 0);
                                if (!data.isEmpty() && data.charAt(data.length() - 1) == '\n') {
                                    data = data.substring(0, data.length() - 1);
                                }
                                this.atraceParser.parseAtrace(ClockSource.MONOTONIC_RAW, time, taskId, data);
                                break;
                            }
                            default: {
                                @Nullable FtraceCounter counterSeriesDescriptor = this.tracepointCounterSeries.get(format.getName());
                                if (counterSeriesDescriptor != null) {
                                    switch (format.getName()) {
                                        case "cpu_frequency": {
                                            int cpuId = (int)format.getInt("cpu_id", rawBytes);
                                            int state = (int)format.getInt("state", rawBytes);
                                            this.commonProcessing.onCpuFrequency((ICounterSeriesKey)counterSeriesDescriptor.counterSeriesKey, time, cpuId, state);
                                            break;
                                        }
                                        default: {
                                            @Nullable String arg = counterSeriesDescriptor.arg;
                                            if (arg == null) {
                                                this.outputStream.counter((ICounterSeriesKey)counterSeriesDescriptor.counterSeriesKey, ClockSource.MONOTONIC_RAW, time, this.systemWidePeReference, taskId, 1L);
                                                break;
                                            }
                                            long value = format.getInt(arg, rawBytes);
                                            this.outputStream.counter((ICounterSeriesKey)counterSeriesDescriptor.counterSeriesKey, ClockSource.MONOTONIC_RAW, time, this.systemWidePeReference, taskId, value);
                                        }
                                    }
                                }
                                this.outputStream.tracepointEvent(ClockSource.MONOTONIC_RAW, time, taskId, format, rawBytes);
                                break;
                            }
                        }
                    }
                } else {
                    this.outputStream.warning(WarningsFactory.missingTracepointFormat(commonType));
                }
            }
            pos += length;
        }
    }

    private static class FtraceCounter {
        public final @Nullable String arg;
        public final @NonNull StaticCounterSeriesKey counterSeriesKey;

        public FtraceCounter(@NonNull StaticCounterSeriesKey counterSeriesKey) {
            this.counterSeriesKey = counterSeriesKey;
            CounterRecord cr = counterSeriesKey.getCounterRecord();
            this.arg = cr.getArg();
        }
    }
}

