/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.external;

import com.arm.armnn.timeline.ITimelineConsumer;
import com.arm.armnn.timeline.MissingStreamMetadataPacketException;
import com.arm.armnn.timeline.TimelineDecoder;
import com.arm.armnn.timeline.TimelineDecoderException;
import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolDecoder;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolEventStream;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolPassTwoState;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.TimelineConsumer;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.eclipse.jdt.annotation.NonNull;

public final class EStateArmNNV1
implements IExternalProtocolDecoder {
    public static final String PROTOCOL = "ARMNN_V1";
    private final @NonNull TimelineDecoder decoder;
    private boolean ignoreAllSubsequentData = false;

    public EStateArmNNV1(@NonNull IExternalProtocolPassTwoState passTwoState, @NonNull IExternalProtocolEventStream outputStream) {
        this.decoder = new TimelineDecoder((ITimelineConsumer)new TimelineConsumer(outputStream));
    }

    @Override
    public void process(byte @NonNull [] data) throws IOException {
        if (!this.ignoreAllSubsequentData) {
            try {
                this.decoder.consumePacket(data);
            }
            catch (MissingStreamMetadataPacketException e) {
                CommonPlugin.warning((String)"Missing Arm NN Metadata packet", (Throwable)e);
            }
            catch (TimelineDecoderException e) {
                CommonPlugin.warning((String)"Failure decoding Arm NN packet", (Throwable)e);
                this.ignoreAllSubsequentData = true;
            }
            catch (UncheckedIOException e) {
                throw e.getCause();
            }
        }
    }

    @Override
    public boolean reorderable() {
        return false;
    }

    @Override
    public void close() throws IOException {
        this.decoder.close();
    }
}

