/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.external;

import com.arm.streamline.protocol.capture.apc.protocol.external.ExternalProtocolChannel;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolEventStream;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolPassTwoState;
import com.arm.streamline.protocol.capture.apc.time.ClockSource;
import com.arm.streamline.protocol.misc.TaskId;
import com.arm.utils.NullChecking;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AtraceParser {
    private static final @NonNull String ANDROID_ASYNC = "Android Async";
    private static final @NonNull String ANDROID_FLAMECHART = "Android Flamechart";
    private static final Pattern ATRACE_ASYNC_BEGIN = Pattern.compile("^S\\|([0-9]+)\\|(.*)\\|([0-9]+)$");
    private static final Pattern ATRACE_ASYNC_END = Pattern.compile("^F\\|([0-9]+)\\|(.*)\\|([0-9]+)$");
    private static final Pattern ATRACE_BEGIN = Pattern.compile("^B\\|([0-9]+)\\|(.*)$");
    private static final Pattern ATRACE_INT = Pattern.compile("^C\\|([0-9]+)\\|(.*)\\|([0-9]+)$");
    private final @NonNull IExternalProtocolEventStream outputStream;
    private final @NonNull IExternalProtocolPassTwoState passTwoState;

    public AtraceParser(@NonNull ExternalProtocolChannel channel, @NonNull IExternalProtocolPassTwoState passTwoState, @NonNull IExternalProtocolEventStream outputStream) {
        this.passTwoState = passTwoState;
        this.outputStream = outputStream;
    }

    public void parseAtrace(@NonNull ClockSource clockSource, long timestamp, @NonNull TaskId originalTaskId, @NonNull String data) throws IOException {
        Matcher atraceMatcher = ATRACE_BEGIN.matcher(data);
        if (atraceMatcher.find()) {
            int pid = Integer.parseInt(atraceMatcher.group(1));
            @NonNull TaskId taskId = AtraceParser.makePid(pid, originalTaskId);
            @NonNull String text = (String)NullChecking.neverNull((Object)atraceMatcher.group(2));
            this.outputStream.annotationTextPush(clockSource, timestamp, taskId, ANDROID_FLAMECHART, this.passTwoState.mapTextToAnnotationColour(text), text);
        } else if ("E".equals(data) || data.startsWith("E|")) {
            this.outputStream.annotationTextPop(clockSource, timestamp, originalTaskId, ANDROID_FLAMECHART);
        } else {
            atraceMatcher = ATRACE_ASYNC_BEGIN.matcher(data);
            if (atraceMatcher.find()) {
                int pid = Integer.parseInt(atraceMatcher.group(1));
                @NonNull TaskId taskId = AtraceParser.makePid(pid, originalTaskId);
                @NonNull String text = (String)NullChecking.neverNull((Object)atraceMatcher.group(2));
                int id = Integer.parseInt(atraceMatcher.group(3));
                this.outputStream.annotationTextAsync(clockSource, timestamp, taskId, ANDROID_ASYNC, id, this.passTwoState.mapTextToAnnotationColour(text), text);
            } else {
                atraceMatcher = ATRACE_ASYNC_END.matcher(data);
                if (atraceMatcher.find()) {
                    int pid = Integer.parseInt(atraceMatcher.group(1));
                    @NonNull TaskId taskId = AtraceParser.makePid(pid, originalTaskId);
                    int id = Integer.parseInt(atraceMatcher.group(3));
                    this.outputStream.annotationTextAsyncEnd(clockSource, timestamp, taskId, ANDROID_ASYNC, id);
                } else {
                    atraceMatcher = ATRACE_INT.matcher(data);
                    if (atraceMatcher.find()) {
                        int pid = Integer.parseInt(atraceMatcher.group(1));
                        @NonNull TaskId taskId = AtraceParser.makePid(pid, originalTaskId);
                        @NonNull String name = (String)NullChecking.neverNull((Object)atraceMatcher.group(2));
                        long value = Long.parseLong(atraceMatcher.group(3));
                        this.outputStream.atraceCounter(clockSource, timestamp, name, taskId, value);
                    }
                }
            }
        }
    }

    private static @NonNull TaskId makePid(int pid, @NonNull TaskId taskId) {
        @Nullable Integer originalPid = taskId.pid;
        int tid = taskId.tid;
        if (originalPid != null) {
            assert (originalPid == pid);
            return taskId;
        }
        return new TaskId(pid, tid);
    }
}

