/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.pass_two.annotations;

import com.arm.streamline.analysis.database.api.annotations.AnnotationTextGroupChannelIdentifier;
import com.arm.streamline.analysis.database.api.annotations.IAnalysisAnnotationsWriter;
import com.arm.streamline.analysis.model.threads.IUniqueThread;
import com.arm.streamline.common.analysis.model.AnnotationColour;
import com.arm.streamline.protocol.capture.apc.pass_two.annotations.IPushPopAnnotationTextTracker;
import com.arm.streamline.report.model.uids.IUniqueThreadID;
import com.arm.utils.collections.Pair;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;

public class PushPopAnnotationTracker
implements IPushPopAnnotationTextTracker {
    public static final int GROUP = 0;
    public static final int BASE_CHANNEL = 0;
    private final @NonNull Map<@NonNull Pair<@NonNull IUniqueThread, @NonNull String>, @NonNull ChannelData> channelData = new HashMap<Pair<IUniqueThread, String>, ChannelData>();

    private static @NonNull Pair<@NonNull IUniqueThread, @NonNull String> makeKey(@NonNull IUniqueThread uniqueThread, @NonNull String title) {
        return new Pair((Object)uniqueThread, (Object)title);
    }

    @Override
    public void annotationTextPop(@NonNull IAnalysisAnnotationsWriter annotationsWriter, long timestamp, @NonNull IUniqueThread uniqueThread, @NonNull String title) throws IOException {
        @NonNull Pair<@NonNull IUniqueThread, @NonNull String> key = PushPopAnnotationTracker.makeKey(uniqueThread, title);
        @NonNull ChannelData channel = this.channelData.computeIfAbsent(key, k -> new ChannelData((IUniqueThread)k.first, (String)k.second));
        channel.pop(annotationsWriter, timestamp);
    }

    @Override
    public void annotationTextPush(@NonNull IAnalysisAnnotationsWriter annotationsWriter, long timestamp, @NonNull IUniqueThread uniqueThread, @NonNull String title, @NonNull AnnotationColour colour, @NonNull String text) throws IOException {
        @NonNull Pair<@NonNull IUniqueThread, @NonNull String> key = PushPopAnnotationTracker.makeKey(uniqueThread, title);
        @NonNull ChannelData channel = this.channelData.computeIfAbsent(key, k -> new ChannelData((IUniqueThread)k.first, (String)k.second));
        channel.push(annotationsWriter, timestamp, colour, text);
    }

    private static class ChannelData {
        private boolean createdGroup = false;
        private int currentChannel = 0;
        private int highestChannel = Integer.MIN_VALUE;
        private int lowestChannel = Integer.MAX_VALUE;
        private final @NonNull String title;
        private final @NonNull IUniqueThread uniqueThread;

        public ChannelData(@NonNull IUniqueThread uniqueThread, @NonNull String title) {
            this.uniqueThread = uniqueThread;
            this.title = title;
        }

        public void pop(@NonNull IAnalysisAnnotationsWriter annotationsWriter, long timestamp) throws IOException {
            int channel = this.setupChannel(annotationsWriter, timestamp, false);
            annotationsWriter.consumeAnnotationText((IUniqueThreadID)this.uniqueThread, timestamp, AnnotationTextGroupChannelIdentifier.pushPop((IUniqueThreadID)this.uniqueThread, (String)this.title, (int)channel), -3092272, "");
        }

        public void push(@NonNull IAnalysisAnnotationsWriter annotationsWriter, long timestamp, @NonNull AnnotationColour colour, @NonNull String text) throws IOException {
            int channel = this.setupChannel(annotationsWriter, timestamp, true);
            annotationsWriter.consumeAnnotationText((IUniqueThreadID)this.uniqueThread, timestamp, AnnotationTextGroupChannelIdentifier.pushPop((IUniqueThreadID)this.uniqueThread, (String)this.title, (int)channel), colour.toInt(), text);
        }

        private int setupChannel(@NonNull IAnalysisAnnotationsWriter annotationsWriter, long timestamp, boolean inc) throws IOException {
            int channel;
            String channelTitle;
            @NonNull String @NonNull [] split = this.title.split("[\\n\\r]+", 2);
            @NonNull String groupTitle = split.length == 2 ? split[0] : this.title;
            String string = channelTitle = split.length == 2 ? split[1] : this.title;
            if (!this.createdGroup) {
                this.createdGroup = true;
                annotationsWriter.consumeAnnotationNameGroup((IUniqueThreadID)this.uniqueThread, timestamp, AnnotationTextGroupChannelIdentifier.pushPop((IUniqueThreadID)this.uniqueThread, (String)this.title, (int)0), groupTitle);
            }
            if (inc) {
                int n = this.currentChannel;
                v2 = n;
                this.currentChannel = n + 1;
            } else {
                v2 = channel = (this.currentChannel = this.currentChannel - 1);
            }
            if (channel > this.highestChannel || channel < this.lowestChannel) {
                this.highestChannel = Math.max(channel, this.highestChannel);
                this.lowestChannel = Math.min(channel, this.lowestChannel);
                annotationsWriter.consumeAnnotationNameChannel((IUniqueThreadID)this.uniqueThread, timestamp, AnnotationTextGroupChannelIdentifier.pushPop((IUniqueThreadID)this.uniqueThread, (String)this.title, (int)channel), AnnotationTextGroupChannelIdentifier.pushPop((IUniqueThreadID)this.uniqueThread, (String)this.title, (int)0), channelTitle);
            }
            return channel;
        }
    }
}

