/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.pass_two.annotations;

import com.arm.streamline.analysis.database.api.annotations.AnnotationTextGroupChannelIdentifier;
import com.arm.streamline.analysis.database.api.annotations.IAnalysisAnnotationsWriter;
import com.arm.streamline.analysis.model.threads.IUniqueThread;
import com.arm.streamline.common.analysis.model.AnnotationColour;
import com.arm.streamline.protocol.capture.apc.pass_two.annotations.IAsyncAnnotationTextTracker;
import com.arm.streamline.report.model.uids.IUniqueThreadID;
import com.arm.utils.collections.Pair;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AsyncAnnotationTracker
implements IAsyncAnnotationTextTracker {
    public static final int BASE_CHANNEL = Integer.MAX_VALUE;
    public static final int GROUP = 0;
    private final @NonNull Map<@NonNull Pair<@NonNull IUniqueThread, @NonNull String>, @NonNull ChannelData> channelData = new HashMap<Pair<IUniqueThread, String>, ChannelData>();

    private static @NonNull Pair<@NonNull IUniqueThread, @NonNull String> makeKey(@NonNull IUniqueThread uniqueThread, @NonNull String title) {
        return new Pair((Object)uniqueThread, (Object)title);
    }

    @Override
    public void annotationTextAsync(@NonNull IAnalysisAnnotationsWriter annotationsWriter, long timestamp, @NonNull IUniqueThread uniqueThread, @NonNull String title, int id, @NonNull AnnotationColour colour, @NonNull String text) throws IOException {
        @NonNull Pair<@NonNull IUniqueThread, @NonNull String> key = AsyncAnnotationTracker.makeKey(uniqueThread, title);
        @NonNull ChannelData channel = this.channelData.computeIfAbsent(key, k -> new ChannelData((IUniqueThread)k.first, (String)k.second));
        channel.async(annotationsWriter, timestamp, id, colour, text);
    }

    @Override
    public void annotationTextAsyncEnd(@NonNull IAnalysisAnnotationsWriter annotationsWriter, long timestamp, @NonNull IUniqueThread uniqueThread, @NonNull String title, int id) throws IOException {
        @NonNull Pair<@NonNull IUniqueThread, @NonNull String> key = AsyncAnnotationTracker.makeKey(uniqueThread, title);
        @Nullable ChannelData channel = this.channelData.get(key);
        if (channel != null) {
            channel.end(annotationsWriter, timestamp, id);
        }
    }

    private static class ChannelData {
        private boolean createdGroup;
        private int channelAllocator = Integer.MAX_VALUE;
        private final @NonNull TIntList channelsAvailable = new TIntArrayList();
        private final @NonNull TIntIntMap channelsInUse = new TIntIntHashMap(10, 0.5f, Integer.MIN_VALUE, Integer.MIN_VALUE);
        private final @NonNull String title;
        private final @NonNull IUniqueThread uniqueThread;

        public ChannelData(@NonNull IUniqueThread uniqueThread, @NonNull String title) {
            this.uniqueThread = uniqueThread;
            this.title = title;
        }

        public void async(@NonNull IAnalysisAnnotationsWriter annotationsWriter, long timestamp, int id, @NonNull AnnotationColour colour, @NonNull String text) throws IOException {
            int channel;
            int currentChannel;
            if (!this.createdGroup) {
                this.createdGroup = true;
                annotationsWriter.consumeAnnotationNameGroup((IUniqueThreadID)this.uniqueThread, timestamp, AnnotationTextGroupChannelIdentifier.async((IUniqueThreadID)this.uniqueThread, (String)this.title, (int)0), this.title);
            }
            if ((currentChannel = this.channelsInUse.get(id)) == this.channelsInUse.getNoEntryValue()) {
                if (this.channelsAvailable.isEmpty()) {
                    channel = this.channelAllocator--;
                    annotationsWriter.consumeAnnotationNameChannel((IUniqueThreadID)this.uniqueThread, timestamp, AnnotationTextGroupChannelIdentifier.async((IUniqueThreadID)this.uniqueThread, (String)this.title, (int)channel), AnnotationTextGroupChannelIdentifier.async((IUniqueThreadID)this.uniqueThread, (String)this.title, (int)0), this.title);
                } else {
                    channel = this.channelsAvailable.removeAt(this.channelsAvailable.size() - 1);
                }
                this.channelsInUse.put(id, channel);
            } else {
                channel = currentChannel;
            }
            annotationsWriter.consumeAnnotationText((IUniqueThreadID)this.uniqueThread, timestamp, AnnotationTextGroupChannelIdentifier.async((IUniqueThreadID)this.uniqueThread, (String)this.title, (int)channel), colour.toInt(), text);
        }

        public void end(@NonNull IAnalysisAnnotationsWriter annotationsWriter, long timestamp, int id) throws IOException {
            int channel = this.channelsInUse.remove(id);
            if (channel != this.channelsInUse.getNoEntryValue()) {
                this.channelsAvailable.add(channel);
                this.channelsAvailable.sort();
                annotationsWriter.consumeAnnotationText((IUniqueThreadID)this.uniqueThread, timestamp, AnnotationTextGroupChannelIdentifier.async((IUniqueThreadID)this.uniqueThread, (String)this.title, (int)channel), -3092272, "");
            }
        }
    }
}

