/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.pass_two;

import com.arm.streamline.analysis.model.ICounterSeriesKey;
import com.arm.streamline.analysis.model.StaticCounterSeriesKey;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.streamline.ftrace.TracepointFormat;
import com.arm.streamline.protocol.capture.apc.pass_two.IGatorPassTwoEventStream;
import com.arm.streamline.protocol.capture.apc.pass_two.IMaliUserspaceSoftwareCounters;
import com.arm.streamline.protocol.misc.StaticCounterSerieses;
import com.arm.streamline.protocol.misc.TaskId;
import gnu.trove.map.TObjectLongMap;
import gnu.trove.map.hash.TObjectLongHashMap;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class MaliUserspaceSoftwareCounters
implements IMaliUserspaceSoftwareCounters {
    private static final @NonNull String FIELD_EVENT_ID = "event_id";
    private static final @NonNull String FIELD_PID = "pid";
    private static final @NonNull String FIELD_TGID = "tgid";
    private static final @NonNull String FIELD_VALUE = "value";
    private static final @NonNull String FIELD_GPU_ID = "gpu_id";
    private static final long PM_EVENT_ID_L2_PRESENT_LO = 288L;
    private static final long PM_EVENT_ID_SHADER_PRESENT_LO = 256L;
    private static final long PM_EVENT_ID_TILER_PRESENT_LO = 272L;
    private static final @NonNull String TRACEPOINT_MALI_JOB_SLOTS_EVENT = "mali_job_slots_event";
    private static final @NonNull String TRACEPOINT_MALI_MMU_AS_IN_USE = "mali_mmu_as_in_use";
    private static final @NonNull String TRACEPOINT_MALI_MMU_AS_RELEASED = "mali_mmu_as_released";
    private static final @NonNull String TRACEPOINT_MALI_PAGE_FAULT_INSERT_PAGES = "mali_page_fault_insert_pages";
    private static final @NonNull String TRACEPOINT_MALI_PM_STATUS = "mali_pm_status";
    private static final @NonNull String TRACEPOINT_MALI_TOTAL_ALLOC_PAGES_CHANGE = "mali_total_alloc_pages_change";
    private final @NonNull TObjectLongMap<ICounterSeriesKey> absoluteCounters = new TObjectLongHashMap(10, 0.5f, 0L);
    private final @Nullable ICounterSeriesKey computeActivityKey;
    private final @Nullable ICounterSeriesKey fragmentActivityKey;
    private final @Nullable ICounterSeriesKey @NonNull [] l2PresentBitMap;
    private final @Nullable ICounterSeriesKey @NonNull [] mmuAddressSpaceKeys;
    private final @NonNull IGatorPassTwoEventStream output;
    private final @Nullable ICounterSeriesKey @NonNull [] pageFaultKeys;
    private final @NonNull ProcessingElementReferenceSet peReferenceSet;
    private long previousL2PresentBitmask;
    private long previousShaderPresentBitmask;
    private long previousTilerPresentBitmask;
    private final @Nullable ICounterSeriesKey @NonNull [] shaderPresentBitMap;
    private final @Nullable ICounterSeriesKey @NonNull [] tilerPresentBitMap;
    private final @Nullable ICounterSeriesKey totalAllocPagesKey;
    private final @Nullable ICounterSeriesKey vertexActivityKey;
    private final long vmUID;

    private static @Nullable ICounterSeriesKey mapEventIdToKey(long eventId, @Nullable ICounterSeriesKey @NonNull [] keys) {
        if (eventId >= 0L && eventId < (long)keys.length) {
            return keys[(int)eventId];
        }
        return null;
    }

    public MaliUserspaceSoftwareCounters(long vmUID, @NonNull StaticCounterSerieses staticCounters, @NonNull ProcessingElementReferenceSet peReferenceSet, @NonNull IGatorPassTwoEventStream output) {
        this.vmUID = vmUID;
        this.peReferenceSet = peReferenceSet;
        this.output = output;
        @NonNull HashMap<@NonNull String, @NonNull StaticCounterSeriesKey> counterMap = new HashMap<String, StaticCounterSeriesKey>();
        for (StaticCounterSeriesKey staticSeriesKey : staticCounters.getAllStaticCounterSeries()) {
            @NonNull CounterRecord counterRecord = staticSeriesKey.getCounterRecord();
            @Nullable String counterName = counterRecord.getCounter();
            if (counterName == null || !counterName.startsWith("ARM_Mali-")) continue;
            @NonNull String eventName = counterName.replaceAll("^ARM_Mali-(Midgard|Bifrost|Valhall)_", "");
            counterMap.put(eventName, staticSeriesKey);
        }
        this.shaderPresentBitMap = new ICounterSeriesKey[]{(ICounterSeriesKey)counterMap.get("PM_SHADER_0"), (ICounterSeriesKey)counterMap.get("PM_SHADER_1"), (ICounterSeriesKey)counterMap.get("PM_SHADER_2"), (ICounterSeriesKey)counterMap.get("PM_SHADER_3"), (ICounterSeriesKey)counterMap.get("PM_SHADER_4"), (ICounterSeriesKey)counterMap.get("PM_SHADER_5"), (ICounterSeriesKey)counterMap.get("PM_SHADER_6"), (ICounterSeriesKey)counterMap.get("PM_SHADER_7")};
        this.tilerPresentBitMap = new ICounterSeriesKey[]{(ICounterSeriesKey)counterMap.get("PM_TILER_0")};
        ICounterSeriesKey[] iCounterSeriesKeyArray = new ICounterSeriesKey[5];
        iCounterSeriesKeyArray[0] = (ICounterSeriesKey)counterMap.get("PM_L2_0");
        iCounterSeriesKeyArray[4] = (ICounterSeriesKey)counterMap.get("PM_L2_1");
        this.l2PresentBitMap = iCounterSeriesKeyArray;
        this.mmuAddressSpaceKeys = new ICounterSeriesKey[]{(ICounterSeriesKey)counterMap.get("MMU_AS_0"), (ICounterSeriesKey)counterMap.get("MMU_AS_1"), (ICounterSeriesKey)counterMap.get("MMU_AS_2"), (ICounterSeriesKey)counterMap.get("MMU_AS_3")};
        this.pageFaultKeys = new ICounterSeriesKey[]{(ICounterSeriesKey)counterMap.get("MMU_PAGE_FAULT_0"), (ICounterSeriesKey)counterMap.get("MMU_PAGE_FAULT_1"), (ICounterSeriesKey)counterMap.get("MMU_PAGE_FAULT_2"), (ICounterSeriesKey)counterMap.get("MMU_PAGE_FAULT_3")};
        this.totalAllocPagesKey = (ICounterSeriesKey)counterMap.get("TOTAL_ALLOC_PAGES");
        this.computeActivityKey = (ICounterSeriesKey)counterMap.get("opencl");
        this.fragmentActivityKey = (ICounterSeriesKey)counterMap.get("fragment");
        this.vertexActivityKey = (ICounterSeriesKey)counterMap.get("vertex");
    }

    @Override
    public boolean isMaliSoftwareCounterTracepoint(@NonNull TracepointFormat tracepointFormat) {
        return tracepointFormat.getName().startsWith("mali_");
    }

    @Override
    public boolean processTracepointData(long timestamp, @NonNull TracepointFormat tracepointFormat, byte @NonNull [] raw) throws IOException {
        switch (tracepointFormat.getName()) {
            case "mali_pm_status": {
                long eventId = tracepointFormat.getInt(FIELD_EVENT_ID, raw);
                long value = tracepointFormat.getInt(FIELD_VALUE, raw);
                this.processPowerManagementStatusEvent(timestamp, eventId, value, MaliUserspaceSoftwareCounters.getGpuId(tracepointFormat, raw));
                break;
            }
            case "mali_mmu_as_in_use": {
                long eventId = tracepointFormat.getInt(FIELD_EVENT_ID, raw);
                @Nullable ICounterSeriesKey key = this.mapMmuTimelineEventId(eventId);
                if (key == null) break;
                this.processTimelineEventEvent(timestamp, key, true, MaliUserspaceSoftwareCounters.getGpuId(tracepointFormat, raw));
                break;
            }
            case "mali_mmu_as_released": {
                long eventId = tracepointFormat.getInt(FIELD_EVENT_ID, raw);
                @Nullable ICounterSeriesKey key = this.mapMmuTimelineEventId(eventId);
                if (key == null) break;
                this.processTimelineEventEvent(timestamp, key, false, MaliUserspaceSoftwareCounters.getGpuId(tracepointFormat, raw));
                break;
            }
            case "mali_page_fault_insert_pages": {
                long eventId = tracepointFormat.getInt(FIELD_EVENT_ID, raw);
                long value = tracepointFormat.getInt(FIELD_VALUE, raw);
                @Nullable ICounterSeriesKey key = this.mapPageFaultEventId(eventId);
                if (key == null) break;
                this.processDeltaCounterEvent(timestamp, key, value, MaliUserspaceSoftwareCounters.getGpuId(tracepointFormat, raw));
                break;
            }
            case "mali_total_alloc_pages_change": {
                @Nullable ICounterSeriesKey key = this.totalAllocPagesKey;
                if (key == null) break;
                long eventId = tracepointFormat.getInt(FIELD_EVENT_ID, raw);
                this.processAbsoluteCounterEvent(timestamp, key, eventId, MaliUserspaceSoftwareCounters.getGpuId(tracepointFormat, raw));
                break;
            }
            case "mali_job_slots_event": {
                if (this.computeActivityKey == null && this.fragmentActivityKey == null && this.vertexActivityKey == null) break;
                long eventId = tracepointFormat.getInt(FIELD_EVENT_ID, raw);
                long tgid = tracepointFormat.getInt(FIELD_TGID, raw);
                long pid = tracepointFormat.getInt(FIELD_PID, raw);
                this.processJobSlotEvent(timestamp, eventId, tgid, pid, MaliUserspaceSoftwareCounters.getGpuId(tracepointFormat, raw));
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private static int getGpuId(TracepointFormat tracepointFormat, byte @NonNull [] raw) throws IOException {
        if (tracepointFormat.getField(FIELD_GPU_ID) != null) {
            return Math.toIntExact(tracepointFormat.getInt(FIELD_GPU_ID, raw));
        }
        return 0;
    }

    private @Nullable ICounterSeriesKey mapMmuTimelineEventId(long eventId) {
        return MaliUserspaceSoftwareCounters.mapEventIdToKey(eventId, this.mmuAddressSpaceKeys);
    }

    private @Nullable ICounterSeriesKey mapPageFaultEventId(long eventId) {
        return MaliUserspaceSoftwareCounters.mapEventIdToKey(eventId, this.pageFaultKeys);
    }

    private @NonNull ProcessingElementReference mapPeReference(@NonNull ICounterSeriesKey key, int deviceNumber) {
        return this.peReferenceSet.get(key.getDeviceTypeOrDefault(), this.vmUID, deviceNumber);
    }

    private void processAbsoluteCounterEvent(long timestamp, @NonNull ICounterSeriesKey key, long value, int deviceNumber) throws IOException {
        long previousValue = this.absoluteCounters.get((Object)key);
        this.absoluteCounters.put((Object)key, value);
        this.output.counter(key, timestamp, this.mapPeReference(key, deviceNumber), null, previousValue);
    }

    private void processDeltaCounterEvent(long timestamp, @NonNull ICounterSeriesKey key, long value, int deviceNumber) throws IOException {
        this.output.counter(key, timestamp, this.mapPeReference(key, deviceNumber), null, value);
    }

    private void processJobSlotEvent(long timestamp, long eventId, long tgid, long pid, int deviceNumber) throws IOException {
        int component = (int)(eventId >> 16 & 0xFFL);
        int state = (int)(eventId >> 24 & 0xFL);
        ICounterSeriesKey targetKey = switch (component) {
            case 0 -> this.fragmentActivityKey;
            case 1 -> this.vertexActivityKey;
            case 2 -> this.computeActivityKey;
            default -> null;
        };
        if (targetKey != null) {
            boolean isActive = state == 1 || state == 4;
            int tid = (int)(pid != 0L ? pid : tgid);
            if (isActive) {
                this.output.activitySwitch(targetKey, timestamp, this.mapPeReference(targetKey, deviceNumber), new TaskId(tid), 1, 0);
            } else {
                this.output.activitySwitch(targetKey, timestamp, this.mapPeReference(targetKey, deviceNumber), new TaskId(tid), 0, 0);
            }
        }
    }

    private void processPowerManagementEventBit(long timestamp, long value, long changedBits, @Nullable ICounterSeriesKey @NonNull [] keyMap, int deviceNumber) throws IOException {
        int bit = 0;
        while (bit < keyMap.length) {
            long shift = 1 << bit;
            ICounterSeriesKey key = keyMap[bit];
            if (key != null && (changedBits & shift) != 0L) {
                this.processTimelineEventEvent(timestamp, key, (value & shift) != 0L, deviceNumber);
            }
            ++bit;
        }
    }

    private void processPowerManagementStatusEvent(long timestamp, long eventId, long value, int deviceNumber) throws IOException {
        if (eventId == 256L) {
            long changedBits = this.previousShaderPresentBitmask ^ value;
            this.previousShaderPresentBitmask = value;
            this.processPowerManagementEventBit(timestamp, value, changedBits, this.shaderPresentBitMap, deviceNumber);
        } else if (eventId == 272L) {
            long changedBits = this.previousTilerPresentBitmask ^ value;
            this.previousTilerPresentBitmask = value;
            this.processPowerManagementEventBit(timestamp, value, changedBits, this.tilerPresentBitMap, deviceNumber);
        } else if (eventId == 288L) {
            long changedBits = this.previousL2PresentBitmask ^ value;
            this.previousL2PresentBitmask = value;
            this.processPowerManagementEventBit(timestamp, value, changedBits, this.l2PresentBitMap, deviceNumber);
        }
    }

    private void processTimelineEventEvent(long timestamp, @NonNull ICounterSeriesKey key, boolean start, int deviceNumber) throws IOException {
        if (start) {
            this.output.counter(key, timestamp, this.mapPeReference(key, deviceNumber), null, 100L);
        } else {
            this.output.counter(key, timestamp, this.mapPeReference(key, deviceNumber), null, 0L);
        }
    }
}

