/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.pass_two;

import com.arm.streamline.analysis.model.threads.IExecutablePath;
import com.arm.streamline.analysis.model.threads.IUniqueThread;
import com.arm.streamline.protocol.capture.apc.pass_two.IUniqueThreadTracker;
import com.arm.streamline.protocol.capture.apc.pass_two.LinuxThreadTrackerUniqueThread;
import com.arm.streamline.protocol.misc.ApkEntries;
import com.arm.streamline.protocol.misc.ApkEntry;
import com.arm.streamline.protocol.misc.ApkEntryUtility;
import com.arm.streamline.protocol.misc.AttachedApkEntries;
import com.arm.streamline.protocol.misc.TaskId;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class LinuxThreadTracker
implements IUniqueThreadTracker {
    public static final long DELTA_FREE = 1000000000L;
    private final boolean appTracingMode;
    private final @NonNull AttachedApkEntries attachedApkEntries;
    private long lastTimestamp = -1L;
    private final @NonNull TIntObjectMap<LinuxThreadTrackerUniqueThread> threads = new TIntObjectHashMap(10, 0.5f, 0);
    private final @NonNull ToIntFunction<@NonNull IUniqueThreadTracker.ITrackedUniqueThread> uidSupplier;
    private final long vmUID;

    public LinuxThreadTracker(long vmUID, @NonNull ToIntFunction<@NonNull IUniqueThreadTracker.ITrackedUniqueThread> uidSupplier, @NonNull List< @NonNull LinuxKAllSymsSymbolToModuleTransform.ModuleInfo> kernelModules, @NonNull AttachedApkEntries attachedApkEntries, boolean appTracingMode) throws IOException {
        this.vmUID = vmUID;
        this.uidSupplier = uidSupplier;
        this.attachedApkEntries = attachedApkEntries;
        this.appTracingMode = appTracingMode;
        @NonNull LinuxThreadTrackerUniqueThread kernelProcessThread = this.get(-1L, new TaskId(0, 0));
        kernelModules.forEach(module -> {
            @NonNull String moduleName = module.name;
            kernelProcessThread.mmap(module.address, module.address, module.length, moduleName.isEmpty() ? IExecutablePath.KERNEL : IExecutablePath.createFromPath((String)moduleName));
        });
    }

    @Override
    public @NonNull Set<@NonNull IUniqueThreadTracker.ITrackedUniqueThread> getAllActiveThreads(@NonNull IUniqueThread uniqueThread) {
        return this.threads.valueCollection().stream().filter(t -> t.getEndTimestamp() == null && (t == uniqueThread || t.getProcessThread() == uniqueThread)).collect(Collectors.toSet());
    }

    @Override
    public @NonNull IUniqueThreadTracker.ITrackedUniqueThread threadExec(long timestamp, @Nullable TaskId oldTaskId, @NonNull TaskId taskId, @Nullable IExecutablePath executablePath) {
        return this.track(timestamp, taskId, false);
    }

    @Override
    public @NonNull IUniqueThreadTracker.ITrackedUniqueThread threadExit(long timestamp, @NonNull TaskId taskId) {
        @NonNull LinuxThreadTrackerUniqueThread result = this.get(timestamp, taskId);
        result.setFree(timestamp);
        return result;
    }

    @Override
    public @NonNull IUniqueThreadTracker.ITrackedUniqueThread threadFork(long timestamp, @Nullable TaskId parentTaskId, @NonNull TaskId taskId) {
        assert (taskId.pid != null);
        LinuxThreadTrackerUniqueThread parentThread = parentTaskId != null ? this.get(timestamp, parentTaskId) : null;
        @NonNull LinuxThreadTrackerUniqueThread result = parentThread != null && parentThread.isKernel() ? this.get(timestamp, new TaskId(0, taskId.tid)) : this.get(timestamp, taskId);
        result.fork(timestamp, parentThread);
        return result;
    }

    @Override
    public @NonNull IUniqueThreadTracker.ITrackedUniqueThread threadLinkExecutablePath(long timestamp, @NonNull TaskId taskId, @Nullable IExecutablePath executablePath) {
        @NonNull LinuxThreadTrackerUniqueThread result = this.get(timestamp, taskId);
        this.linkExecutablePath(timestamp, taskId, result, executablePath);
        return result;
    }

    @Override
    public void threadMMap(@NonNull IUniqueThreadTracker.ITrackedUniqueThread uniqueThread, long fileOffset, long mapAddress, long length, @Nullable IExecutablePath executablePath) {
        if (executablePath != null) {
            ApkEntry entry;
            ApkEntries apkEntries;
            @Nullable IUniqueThreadTracker.ITrackedUniqueThread processThread = uniqueThread.getProcessThread();
            assert (processThread != null) : "mmap without pid";
            if (this.attachedApkEntries.hasApksAttached() && (apkEntries = ApkEntryUtility.findZipFileByExecutablePath(executablePath, this.attachedApkEntries, this.appTracingMode)) != null && (entry = apkEntries.findEntryByOffset(fileOffset, length)) != null) {
                fileOffset -= entry.baseOffset;
                executablePath = IExecutablePath.createFromZipEntry((String)entry.zipFileName, (String)entry.entryName);
            }
            processThread.mmap(fileOffset, mapAddress, length, executablePath);
        }
    }

    @Override
    public @NonNull IUniqueThreadTracker.ITrackedUniqueThread threadProperties(long timestamp, @Nullable TaskId parentTaskId, @NonNull TaskId taskId, @NonNull String name, @Nullable IExecutablePath executablePath) {
        LinuxThreadTrackerUniqueThread parent = parentTaskId != null ? this.get(timestamp, parentTaskId).getProcessThread() : null;
        @NonNull LinuxThreadTrackerUniqueThread result = this.get(timestamp, taskId);
        result.fork(timestamp, parent);
        result.setName(name, false);
        this.linkExecutablePath(timestamp, taskId, result, executablePath);
        return result;
    }

    @Override
    public @NonNull IUniqueThreadTracker.ITrackedUniqueThread threadRename(long timestamp, @NonNull TaskId taskId, @NonNull String name, boolean exec) {
        @NonNull LinuxThreadTrackerUniqueThread result = this.get(timestamp, taskId);
        if (exec && result.isKernel()) {
            result.setProcess(result);
        }
        result.setName(name, exec);
        return result;
    }

    @Override
    public @NonNull LinuxThreadTrackerUniqueThread track(long timestamp, @NonNull TaskId taskId, boolean tracked) {
        @NonNull LinuxThreadTrackerUniqueThread result = this.get(timestamp, taskId);
        if (tracked) {
            result.setTracked();
        }
        return result;
    }

    private @NonNull LinuxThreadTrackerUniqueThread executablePath(long timestamp, int pid, @Nullable IExecutablePath executablePath) {
        if (executablePath == null) {
            return this.get(timestamp, new TaskId(pid, pid));
        }
        switch (executablePath.getType()) {
            case FILE_OR_ZIP: {
                if (pid == 0) {
                    throw new AssertionError();
                }
                @NonNull LinuxThreadTrackerUniqueThread result = this.get(timestamp, new TaskId(pid, pid));
                result.setProcess(result);
                result.setExecutablePath(executablePath);
                return result;
            }
            case SPECIAL_IDLE: 
            case SPECIAL_KERNEL: 
            case SPECIAL_NONE: {
                @Nullable LinuxThreadTrackerUniqueThread currentThread = this.getIfNotExpired(timestamp, pid);
                if (currentThread != null && currentThread.getExecutablePath() != null) {
                    this.validateTimestamp(timestamp);
                    currentThread.updateSeen(timestamp);
                    return currentThread;
                }
                if (executablePath.getType() == IExecutablePath.Type.SPECIAL_IDLE) {
                    if (pid != 0) {
                        throw new AssertionError();
                    }
                    return this.get(timestamp, new TaskId(0, 0));
                }
                return this.get(timestamp, new TaskId(0, pid));
            }
        }
        throw new AssertionError(executablePath);
    }

    private @NonNull LinuxThreadTrackerUniqueThread get(long timestamp, @NonNull TaskId taskId) {
        this.validateTimestamp(timestamp);
        int tid = taskId.tid;
        @Nullable Integer taskPid = tid != 0 ? taskId.pid : Integer.valueOf(tid);
        LinuxThreadTrackerUniqueThread result = this.getIfNotExpired(timestamp, tid);
        if (result != null) {
            @Nullable LinuxThreadTrackerUniqueThread currentProcessThread = result.getProcessThread();
            if (taskPid != null && tid != 0) {
                LinuxThreadTrackerUniqueThread newProcessThread;
                int pid = taskPid;
                LinuxThreadTrackerUniqueThread linuxThreadTrackerUniqueThread = newProcessThread = pid != tid ? this.get(timestamp, new TaskId(pid, pid)) : result;
                if (currentProcessThread == null || !newProcessThread.isKernel() || currentProcessThread == result && result.getExecutablePath() == null) {
                    result.setProcess(newProcessThread);
                }
            }
        } else {
            result = new LinuxThreadTrackerUniqueThread(this.vmUID, timestamp, this.uidSupplier, tid);
            this.threads.put(tid, (Object)result);
            if (taskPid != null) {
                int pid = taskPid;
                @NonNull LinuxThreadTrackerUniqueThread processThread = pid != tid ? this.get(timestamp, new TaskId(pid, pid)) : result;
                result.setProcess(processThread);
            }
        }
        result.updateSeen(timestamp);
        return result;
    }

    private @Nullable LinuxThreadTrackerUniqueThread getIfNotExpired(long timestamp, int tid) {
        LinuxThreadTrackerUniqueThread result = (LinuxThreadTrackerUniqueThread)this.threads.get(tid);
        if (result != null && !result.isFreed(timestamp)) {
            return result;
        }
        return null;
    }

    private void linkExecutablePath(long timestamp, @NonNull TaskId taskId, @NonNull LinuxThreadTrackerUniqueThread result, @Nullable IExecutablePath executablePath) {
        @Nullable LinuxThreadTrackerUniqueThread processThread = result.getProcessThread();
        if (executablePath != null) {
            int pid;
            int taskPid = taskId.getPidOrTid();
            int parentPid = processThread != null ? processThread.getOriginalID() : taskPid;
            int n = pid = parentPid != 0 ? parentPid : taskPid;
            if (pid != 0) {
                @NonNull LinuxThreadTrackerUniqueThread newProcessThread = this.executablePath(timestamp, pid, executablePath);
                assert (pid == taskId.tid && result == newProcessThread || pid != taskId.tid && result.getProcessThread() == newProcessThread || result.isKernel() && newProcessThread.isKernel());
            }
        }
    }

    private void validateTimestamp(long timestamp) {
        if (timestamp < this.lastTimestamp) {
            assert (false) : String.format("Out of Order timestamp %d vs %d", timestamp, this.lastTimestamp);
        } else {
            this.lastTimestamp = timestamp;
        }
    }
}

