/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.pass_two;

import com.arm.streamline.analysis.database.api.IAnalysisWriterFactoryV2;
import com.arm.streamline.analysis.database.api.activity.IAnalysisActivityWriter;
import com.arm.streamline.analysis.database.api.annotations.AnnotationTextGroupChannelIdentifier;
import com.arm.streamline.analysis.database.api.annotations.IAnalysisAnnotationsWriter;
import com.arm.streamline.analysis.database.api.cam.IAnalysisCAMWriter;
import com.arm.streamline.analysis.database.api.counters.IAnalysisHardwareCounterWriter;
import com.arm.streamline.analysis.database.api.icounter.spe.ISpeCounterValueConsumer;
import com.arm.streamline.analysis.database.api.icounter.spe.ISpeEventsInstructionCounterConsumer;
import com.arm.streamline.analysis.database.api.idle.IAnalysisIdleStateWriter;
import com.arm.streamline.analysis.database.api.idle.IdleState;
import com.arm.streamline.analysis.database.api.profiling.IAnalysisCodeProfilingWriter;
import com.arm.streamline.analysis.database.api.profiling.IBacktraceSource;
import com.arm.streamline.analysis.database.api.scheduler.IAnalysisSchedulerTraceWriter;
import com.arm.streamline.analysis.database.stream.cam.CAMJobAggregator;
import com.arm.streamline.analysis.database.stream.cam.ICAMJobAggregator;
import com.arm.streamline.analysis.model.AtraceCounterSeriesKey;
import com.arm.streamline.analysis.model.DynamicCounterSeriesKey;
import com.arm.streamline.analysis.model.ICounterSeriesKey;
import com.arm.streamline.analysis.model.KernelAnnotationSeriesKey;
import com.arm.streamline.analysis.model.threads.ExecutablePathMapping;
import com.arm.streamline.analysis.model.threads.IExecutablePath;
import com.arm.streamline.analysis.model.threads.IUniqueThread;
import com.arm.streamline.common.analysis.model.AnnotationColour;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.streamline.common.model.warnings.WarningItem;
import com.arm.streamline.common.xml.spe.SpeOperationTypeClass;
import com.arm.streamline.ftrace.TracepointFormat;
import com.arm.streamline.protocol.capture.apc.pass_two.GatorPassTwoForAnalysisEventStreamLogger;
import com.arm.streamline.protocol.capture.apc.pass_two.IGatorPassTwoForAnalysisEventStream;
import com.arm.streamline.protocol.capture.apc.pass_two.annotations.AsyncAnnotationTracker;
import com.arm.streamline.protocol.capture.apc.pass_two.annotations.IAsyncAnnotationTextTracker;
import com.arm.streamline.protocol.capture.apc.pass_two.annotations.IPushPopAnnotationTextTracker;
import com.arm.streamline.protocol.capture.apc.pass_two.annotations.PushPopAnnotationTracker;
import com.arm.streamline.protocol.capture.apc.pass_two.cam.CAMViewUIDMapper;
import com.arm.streamline.protocol.capture.apc.pass_two.cam.ICAMViewTracker;
import com.arm.streamline.protocol.capture.apc.pass_two.cam.ICAMViewUIDMapper;
import com.arm.streamline.protocol.capture.apc.protocol.IGatorPerVirtualMachineProtocolEventConsumer;
import com.arm.streamline.report.model.uids.IUniqueThreadID;
import com.arm.utils.MapUtils;
import com.arm.utils.collections.ObjLongPair;
import com.arm.utils.function.Throwing;
import gnu.trove.TShortCollection;
import gnu.trove.map.TByteShortMap;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.TShortSet;
import gnu.trove.set.hash.TIntHashSet;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class GatorPassTwoForAnalysisEventStreamDatabaseWriter
implements IGatorPassTwoForAnalysisEventStream {
    private final @NonNull Map<@NonNull ICounterSeriesKey, @NonNull IAnalysisActivityWriter> activityWriters = new HashMap<ICounterSeriesKey, IAnalysisActivityWriter>();
    private final @NonNull IAnalysisWriterFactoryV2 analysisWriterFactory;
    private final @NonNull IAnalysisAnnotationsWriter annotationsWriter;
    private final @NonNull IAsyncAnnotationTextTracker asyncAnnotationTracker;
    private final @NonNull Set<@NonNull AtraceCounterSeriesKey> atraceCounters = new HashSet<AtraceCounterSeriesKey>();
    private final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull CAMJobAggregator.ICAMJobAggregatorFactory camJobAggregatorFactory;
    private final @NonNull TIntObjectMap<ICAMJobAggregator> camJobAggregatorsByViewUID = new TIntObjectHashMap(10, 0.5f, 0);
    private final @NonNull TIntObjectMap<IAnalysisCAMWriter> camJobWritersByViewUID = new TIntObjectHashMap(10, 0.5f, 0);
    private final @NonNull ICAMViewTracker camViewTracker;
    private final @NonNull ICAMViewUIDMapper camViewUIDMapper;
    private final @NonNull IAnalysisCodeProfilingWriter codeProfilingWriter;
    private final @NonNull BiConsumer<@NonNull ICounterSeriesKey, @NonNull CounterRecord> dynamicOrKernelAnnotationCounterSeriesConsumer;
    private final @NonNull Map<@NonNull ICounterSeriesKey, @NonNull IAnalysisHardwareCounterWriter> counterWriters = new HashMap<ICounterSeriesKey, IAnalysisHardwareCounterWriter>();
    private final @NonNull IAnalysisIdleStateWriter idleStateWriter;
    private final @NonNull IUniqueThread kernelProcessThread;
    private final @NonNull IPushPopAnnotationTextTracker pushPopAnnotationTracker;
    private final @NonNull IAnalysisSchedulerTraceWriter schedulerTraceWriter;
    private final @NonNull TIntObjectMap<// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IAnalysisWriterFactoryV2.SpeWriters> speWritersByKey = new TIntObjectHashMap();
    private final long vmEndTimestamp;
    private final long vmUID;
    private final @NonNull Consumer<@NonNull WarningItem> warningsHandler;
    private final boolean generateSpeSampleLog;
    private final @NonNull ProcessingElementReferenceSet peReferenceSet;

    public GatorPassTwoForAnalysisEventStreamDatabaseWriter(long vmUID, long vmEndTimestamp, boolean generateSpeSampleLog, @NonNull ProcessingElementReferenceSet peReferenceSet, @NonNull IUniqueThread kernelProcessThread, @NonNull BiConsumer<@NonNull ICounterSeriesKey, @NonNull CounterRecord> dynamicOrKernelAnnotationCounterSeriesConsumer, @NonNull ICAMViewTracker camViewTracker, @NonNull Consumer<@NonNull WarningItem> warningsHandler, @NonNull IAnalysisWriterFactoryV2 analysisWriterFactory) throws IOException {
        this(vmUID, vmEndTimestamp, generateSpeSampleLog, peReferenceSet, kernelProcessThread, dynamicOrKernelAnnotationCounterSeriesConsumer, camViewTracker, new CAMViewUIDMapper(), CAMJobAggregator::new, warningsHandler, new AsyncAnnotationTracker(), new PushPopAnnotationTracker(), analysisWriterFactory);
    }

    protected GatorPassTwoForAnalysisEventStreamDatabaseWriter(long vmUID, long vmEndTimestamp, boolean generateSpeSampleLog, @NonNull ProcessingElementReferenceSet peReferenceSet, @NonNull IUniqueThread kernelProcessThread, @NonNull BiConsumer<@NonNull ICounterSeriesKey, @NonNull CounterRecord> dynamicOrKernelAnnotationCounterSeriesConsumer, @NonNull ICAMViewTracker camViewTracker, @NonNull ICAMViewUIDMapper camViewUIDMapper, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull CAMJobAggregator.ICAMJobAggregatorFactory camJobAggregatorFactory, @NonNull Consumer<@NonNull WarningItem> warningsHandler, @NonNull IAsyncAnnotationTextTracker asyncAnnotationTracker, @NonNull IPushPopAnnotationTextTracker pushPopAnnotationTracker, @NonNull IAnalysisWriterFactoryV2 analysisWriterFactory) throws IOException {
        this.vmUID = vmUID;
        this.vmEndTimestamp = vmEndTimestamp;
        this.generateSpeSampleLog = generateSpeSampleLog;
        this.peReferenceSet = peReferenceSet;
        this.kernelProcessThread = kernelProcessThread;
        this.dynamicOrKernelAnnotationCounterSeriesConsumer = dynamicOrKernelAnnotationCounterSeriesConsumer;
        this.camViewTracker = camViewTracker;
        this.camViewUIDMapper = camViewUIDMapper;
        this.camJobAggregatorFactory = camJobAggregatorFactory;
        this.warningsHandler = warningsHandler;
        this.asyncAnnotationTracker = asyncAnnotationTracker;
        this.pushPopAnnotationTracker = pushPopAnnotationTracker;
        this.analysisWriterFactory = analysisWriterFactory;
        this.codeProfilingWriter = analysisWriterFactory.createCodeProfilingWriter();
        this.idleStateWriter = analysisWriterFactory.createIdleStateWriter();
        this.schedulerTraceWriter = analysisWriterFactory.createSchedulerTraceWriter();
        this.annotationsWriter = analysisWriterFactory.createAnnotationsWriter();
    }

    private @NonNull ObjLongPair<@Nullable IExecutablePath> mapAbsolutesAddresses(@NonNull IUniqueThread uniqueThread, long address) {
        @Nullable ExecutablePathMapping mapping = uniqueThread.findMMapping(address);
        if (mapping != null) {
            return new ObjLongPair((Object)mapping.executablePath, mapping.mapAddressToOffset(address));
        }
        @Nullable ExecutablePathMapping kernelMapping = this.kernelProcessThread.findMMapping(address);
        if (kernelMapping != null) {
            return new ObjLongPair((Object)kernelMapping.executablePath, kernelMapping.mapAddressToOffset(address));
        }
        return new ObjLongPair(null, address);
    }

    @Override
    public void absoluteBacktrace(long timestamp, IBacktraceSource backtraceSource, @NonNull ProcessingElementReference peReference, @NonNull IUniqueThread uniqueThread, long @NonNull [] addresses) throws IOException {
        if (addresses.length == 0) {
            return;
        }
        @Nullable IExecutablePath @NonNull [] offsetExecutablePaths = new IExecutablePath[addresses.length];
        long @NonNull [] offsetOrAddresses = new long[addresses.length];
        int i = 0;
        while (i < addresses.length) {
            ObjLongPair<@Nullable IExecutablePath> pair = this.mapAbsolutesAddresses(uniqueThread, addresses[i]);
            offsetExecutablePaths[i] = (IExecutablePath)pair.first;
            offsetOrAddresses[i] = pair.second;
            ++i;
        }
        this.codeProfilingWriter.consumeBacktrace(timestamp, backtraceSource, (IUniqueThreadID)uniqueThread, offsetExecutablePaths, offsetOrAddresses);
    }

    @Override
    public void activityStop(@NonNull ICounterSeriesKey counterKey, long timestamp, @NonNull ProcessingElementReference peReference, @Nullable IUniqueThread uniqueThread, int activity) throws IOException {
        @NonNull IAnalysisActivityWriter activityWriter = this.getOrCreateActivityWriter(counterKey);
        activityWriter.consumeActivityStop(peReference, timestamp, activity);
    }

    @Override
    public void activitySwitch(@NonNull ICounterSeriesKey counterKey, long timestamp, @NonNull ProcessingElementReference peReference, @Nullable IUniqueThread uniqueThread, int activity, int reason) throws IOException {
        @NonNull IAnalysisActivityWriter activityWriter = this.getOrCreateActivityWriter(counterKey);
        activityWriter.consumeActivitySwitch(peReference, (IUniqueThreadID)uniqueThread, timestamp, activity, reason);
    }

    @Override
    public void annotationMarker(long timestamp, @NonNull IUniqueThread uniqueThread, @NonNull AnnotationColour colour, @NonNull String text) throws IOException {
        this.annotationsWriter.consumeAnnotationMarker((IUniqueThreadID)uniqueThread, timestamp, colour.toInt(), text);
    }

    @Override
    public void annotationText(long timestamp, @NonNull IUniqueThread uniqueThread, int channel, @NonNull AnnotationColour colour, @NonNull String text) throws IOException {
        this.annotationsWriter.consumeAnnotationText((IUniqueThreadID)uniqueThread, timestamp, AnnotationTextGroupChannelIdentifier.user((IUniqueThreadID)uniqueThread, (int)channel), colour.toInt(), text);
    }

    @Override
    public void annotationTextAsync(long timestamp, @NonNull IUniqueThread uniqueThread, @NonNull String title, int id, @NonNull AnnotationColour colour, @NonNull String text) throws IOException {
        this.asyncAnnotationTracker.annotationTextAsync(this.annotationsWriter, timestamp, uniqueThread, title, id, colour, text);
    }

    @Override
    public void annotationTextAsyncEnd(long timestamp, @NonNull IUniqueThread uniqueThread, @NonNull String title, int id) throws IOException {
        this.asyncAnnotationTracker.annotationTextAsyncEnd(this.annotationsWriter, timestamp, uniqueThread, title, id);
    }

    @Override
    public void annotationTextNameChannel(long timestamp, @NonNull IUniqueThread uniqueThread, int channel, int group, @NonNull String text) throws IOException {
        this.annotationsWriter.consumeAnnotationNameChannel((IUniqueThreadID)uniqueThread, timestamp, AnnotationTextGroupChannelIdentifier.user((IUniqueThreadID)uniqueThread, (int)channel), AnnotationTextGroupChannelIdentifier.user((IUniqueThreadID)uniqueThread, (int)group), text);
    }

    @Override
    public void annotationTextNameGroup(long timestamp, @NonNull IUniqueThread uniqueThread, int group, @NonNull String text) throws IOException {
        this.annotationsWriter.consumeAnnotationNameGroup((IUniqueThreadID)uniqueThread, timestamp, AnnotationTextGroupChannelIdentifier.user((IUniqueThreadID)uniqueThread, (int)group), text);
    }

    @Override
    public void annotationTextPop(long timestamp, @NonNull IUniqueThread uniqueThread, @NonNull String title) throws IOException {
        this.pushPopAnnotationTracker.annotationTextPop(this.annotationsWriter, timestamp, uniqueThread, title);
    }

    @Override
    public void annotationTextPush(long timestamp, @NonNull IUniqueThread uniqueThread, @NonNull String title, @NonNull AnnotationColour colour, @NonNull String text) throws IOException {
        this.pushPopAnnotationTracker.annotationTextPush(this.annotationsWriter, timestamp, uniqueThread, title, colour, text);
    }

    @Override
    public void annotationVisual(long timestamp, @NonNull IUniqueThread uniqueThread, @NonNull String text, byte @NonNull [] image) throws IOException {
        this.annotationsWriter.consumeAnnotationVisual((IUniqueThreadID)uniqueThread, timestamp, text, image);
    }

    @Override
    public void atraceCounter(long timestamp, @NonNull String name, @NonNull IUniqueThread uniqueThread, long value) throws IOException {
        AtraceCounterSeriesKey key = new AtraceCounterSeriesKey(name);
        if (this.atraceCounters.add(key)) {
            this.dynamicOrKernelAnnotationCounterSeriesConsumer.accept((ICounterSeriesKey)key, key.getCounterRecord());
        }
        @NonNull IAnalysisHardwareCounterWriter threadCounterWriter = this.getOrCreateCounterWriter((ICounterSeriesKey)key);
        threadCounterWriter.consumerCounterValue(this.peReferenceSet.get(DeviceType.SYSTEM_WIDE, this.vmUID, 0), timestamp, (IUniqueThreadID)uniqueThread, value);
    }

    @Override
    public void camJob(int viewUID, long startTime, long duration, int track, int jobUID, @NonNull String name, @NonNull AnnotationColour colour, int primaryDependency, int @NonNull [] dependencies) throws IOException {
        @NonNull IAnalysisCAMWriter camJobWriter = this.getOrCreateCAMJobWriter(this.camViewUIDMapper.map(viewUID));
        camJobWriter.consumeCAMJob(jobUID, startTime, name, track, duration + startTime, primaryDependency, (TIntSet)new TIntHashSet(dependencies), colour.toInt(), "");
    }

    @Override
    public void camJob(@NonNull IUniqueThread uniqueThread, int viewUID, long startTime, long duration, int track, int jobUID, @NonNull String name, @NonNull AnnotationColour colour, int primaryDependency, int @NonNull [] dependencies) throws IOException {
        this.camJob(uniqueThread, viewUID, startTime, duration, track, jobUID, name, colour, primaryDependency, dependencies, "");
    }

    @Override
    public void camJob(@NonNull IUniqueThread uniqueThread, int viewUID, long startTime, long duration, int track, int jobUID, @NonNull String name, @NonNull AnnotationColour colour, int primaryDependency, int @NonNull [] dependencies, @NonNull String detailText) throws IOException {
        @NonNull IAnalysisCAMWriter camJobWriter = this.getOrCreateCAMJobWriter(this.camViewUIDMapper.map(uniqueThread, viewUID));
        camJobWriter.consumeCAMJob(jobUID, startTime, name, track, duration + startTime, primaryDependency, (TIntSet)new TIntHashSet(dependencies), colour.toInt(), detailText);
    }

    @Override
    public void camJobDependencies(@NonNull IUniqueThread uniqueThread, int viewUID, long timestamp, int jobUID, int primaryDependency, int @NonNull [] dependencies) throws IOException {
        @NonNull ICAMJobAggregator camJobAggregator = this.getOrCreateCAMJobAggregator(this.camViewUIDMapper.map(uniqueThread, viewUID));
        camJobAggregator.camJobDependencies(jobUID, timestamp, primaryDependency, (TIntSet)new TIntHashSet(dependencies));
    }

    @Override
    public void camJobStart(@NonNull IUniqueThread uniqueThread, int viewUID, long timestamp, int track, int jobUID, @NonNull String name, @NonNull AnnotationColour colour) throws IOException {
        this.camJobStart(uniqueThread, viewUID, timestamp, track, jobUID, name, colour, "");
    }

    @Override
    public void camJobStart(@NonNull IUniqueThread uniqueThread, int viewUID, long timestamp, int track, int jobUID, @NonNull String name, @NonNull AnnotationColour colour, @NonNull String detailText) throws IOException {
        @NonNull ICAMJobAggregator camJobAggregator = this.getOrCreateCAMJobAggregator(this.camViewUIDMapper.map(uniqueThread, viewUID));
        camJobAggregator.camJobStart(jobUID, timestamp, track, name, colour.toInt(), detailText);
    }

    @Override
    public void camJobStop(@NonNull IUniqueThread uniqueThread, int viewUID, long timestamp, int jobUID) throws IOException {
        @NonNull ICAMJobAggregator camJobAggregator = this.getOrCreateCAMJobAggregator(this.camViewUIDMapper.map(uniqueThread, viewUID));
        camJobAggregator.camJobStop(jobUID, timestamp);
    }

    @Override
    public void camTrack(int viewUID, int parentTrack, int trackUID, @NonNull String name) throws IOException {
        this.camViewTracker.camTrack(this.camViewUIDMapper.map(viewUID), parentTrack, trackUID, name);
    }

    @Override
    public void camTrack(@NonNull IUniqueThread uniqueThread, int viewUID, long timestamp, int parentTrack, int trackUID, @NonNull String name) throws IOException {
        this.camViewTracker.camTrack(this.camViewUIDMapper.map(uniqueThread, viewUID), parentTrack, trackUID, name);
    }

    @Override
    public void camView(int viewUID, @NonNull String name) throws IOException {
        this.camViewTracker.camView(this.camViewUIDMapper.map(viewUID), name);
    }

    @Override
    public void camView(@NonNull IUniqueThread uniqueThread, int viewUID, long timestamp, @NonNull String name) throws IOException {
        this.camViewTracker.camView(this.camViewUIDMapper.map(uniqueThread, viewUID), name);
    }

    @Override
    public void close() throws IOException {
        Throwing.closeAll((Iterable[])new Iterable[]{this.camJobAggregatorsByViewUID.valueCollection()});
    }

    @Override
    public void counter(@NonNull ICounterSeriesKey counterKey, long timestamp, @NonNull ProcessingElementReference peReference, @Nullable IUniqueThread uniqueThread, long value) throws IOException {
        if (!counterKey.isMapCounterToActivity()) {
            @NonNull IAnalysisHardwareCounterWriter counterWriter = this.getOrCreateCounterWriter(counterKey);
            counterWriter.consumerCounterValue(peReference, timestamp, (IUniqueThreadID)uniqueThread, value);
        } else {
            this.activitySwitch(counterKey, timestamp, peReference, uniqueThread, (int)value, 0);
        }
    }

    @Override
    public void createDynamicCounterSeries(@NonNull DynamicCounterSeriesKey counterKey, @NonNull CounterRecord counterRecord) {
        this.dynamicOrKernelAnnotationCounterSeriesConsumer.accept((ICounterSeriesKey)counterKey, counterRecord);
    }

    @Override
    public void createKernelAnnotationsCounterSeries(@NonNull KernelAnnotationSeriesKey counterKey, @NonNull CounterRecord counterRecord) {
        this.dynamicOrKernelAnnotationCounterSeriesConsumer.accept((ICounterSeriesKey)counterKey, counterRecord);
    }

    @Override
    public void gatorBacktrace(long timestamp, IBacktraceSource backtraceSource, @NonNull ProcessingElementReference peReference, @NonNull IUniqueThread uniqueThread, @Nullable IExecutablePath appExecutablePath, @Nullable IExecutablePath @NonNull [] offsetExecutablePaths, long @NonNull [] offsets) throws IOException {
        this.codeProfilingWriter.consumeBacktrace(timestamp, backtraceSource, (IUniqueThreadID)uniqueThread, offsetExecutablePaths, offsets);
    }

    @Override
    public void idle(long timestamp, @NonNull ProcessingElementReference peReference, boolean online) throws IOException {
        this.idleStateWriter.consumeIdleEvent(peReference, timestamp, online ? IdleState.ONLINE : IdleState.IDLE);
    }

    @Override
    public void schedSwitch(long timestamp, @NonNull ProcessingElementReference peReference, @NonNull IUniqueThread uniqueThread,  @NonNull IGatorPerVirtualMachineProtocolEventConsumer.SchedulerSwitchReason reason) throws IOException {
        this.schedulerTraceWriter.consumeSchedSwitch(peReference, (IUniqueThreadID)uniqueThread, timestamp, switch (reason) {
            case IGatorPerVirtualMachineProtocolEventConsumer.SchedulerSwitchReason.CONTENTION -> 1;
            case IGatorPerVirtualMachineProtocolEventConsumer.SchedulerSwitchReason.SCHEDULED -> 0;
            case IGatorPerVirtualMachineProtocolEventConsumer.SchedulerSwitchReason.WAIT_IO -> 2;
            default -> throw new AssertionError((Object)reason);
        });
    }

    @Override
    public void speSample(int key, long timestamp, @NonNull ProcessingElementReference peReference, @NonNull IUniqueThread uniqueThread, long pc, @Nullable SpeOperationTypeClass opTypeClass, byte opTypeSubclass, long events, @NonNull TShortSet dataSources, @NonNull TByteShortMap counterMap) throws IOException {
        // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull IAnalysisWriterFactoryV2.SpeWriters writers = this.getOrCreateSpeWriter(key);
        ObjLongPair<@Nullable IExecutablePath> pair = this.mapAbsolutesAddresses(uniqueThread, pc);
        for (ISpeEventsInstructionCounterConsumer eventWriter : writers.eventWriters) {
            eventWriter.consume(timestamp, peReference, (IUniqueThreadID)uniqueThread, (IExecutablePath)pair.first, pair.second, opTypeClass, opTypeSubclass, events);
        }
        Throwing.forEach((TShortCollection)dataSources, dataSource -> speWriters.dataSourceWriter.consume(timestamp, peReference, (IUniqueThreadID)uniqueThread, (IExecutablePath)objLongPair.first, objLongPair.second, dataSource));
        Throwing.forEach((TByteShortMap)counterMap, (index, value) -> {
            ISpeCounterValueConsumer writer = (ISpeCounterValueConsumer)speWriters.counterWriters.get(index);
            if (writer != null) {
                writer.consume(timestamp, peReference, (IUniqueThreadID)uniqueThread, (IExecutablePath)objLongPair.first, objLongPair.second, value);
            }
        });
        if (this.generateSpeSampleLog) {
            AnnotationColour color = opTypeClass != null ? AnnotationColour.mapCyclicColour((int)opTypeClass.ordinal()) : AnnotationColour.DEFAULT_COLOUR_OBJ;
            String message = GatorPassTwoForAnalysisEventStreamLogger.speSampleLogText(pc, opTypeClass, opTypeSubclass, events, dataSources, counterMap);
            this.annotationsWriter.consumeAnnotationMarker((IUniqueThreadID)uniqueThread, timestamp, color.toInt(), message);
        }
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IAnalysisWriterFactoryV2.SpeWriters getOrCreateSpeWriter(int key) throws IOException {
        if (this.speWritersByKey.containsKey(key)) {
            return (IAnalysisWriterFactoryV2.SpeWriters)this.speWritersByKey.get(key);
        }
        // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable IAnalysisWriterFactoryV2.SpeWriters speWriters = this.analysisWriterFactory.createSpeWriter(key);
        if (speWriters == null) {
            throw new IOException("Could not write SPE sample, no writer for key: " + key);
        }
        this.speWritersByKey.put(key, (Object)speWriters);
        return speWriters;
    }

    @Override
    public void threadExit(long timestamp, @NonNull IUniqueThread uniqueThread) throws IOException {
        if (!uniqueThread.isIgnored()) {
            this.schedulerTraceWriter.consumeSchedFree((IUniqueThreadID)uniqueThread, timestamp);
            for (IAnalysisActivityWriter activityWriter : this.activityWriters.values()) {
                activityWriter.consumeActivityFree((IUniqueThreadID)uniqueThread, timestamp);
            }
        }
    }

    @Override
    public void tracepointEvent(long timestamp, @Nullable IUniqueThread uniqueThread, @NonNull TracepointFormat tracepointFormat, byte @NonNull [] raw) throws IOException {
    }

    @Override
    public void warning(long timestamp, @NonNull IUniqueThread uniqueThread, @NonNull WarningItem warning) throws IOException {
        if (timestamp > -1L) {
            this.annotationsWriter.consumeAnnotationMarker((IUniqueThreadID)uniqueThread, timestamp, AnnotationColour.WARNING_COLOUR.toInt(), warning.getDescription());
        }
        this.warningsHandler.accept(warning);
    }

    @Override
    public void warning(@NonNull WarningItem warning) throws IOException {
        this.warningsHandler.accept(warning);
    }

    private @NonNull IAnalysisActivityWriter getOrCreateActivityWriter(@NonNull ICounterSeriesKey key) throws IOException {
        return (IAnalysisActivityWriter)MapUtils.computeIfAbsentThrows(this.activityWriters, (Object)key, arg_0 -> ((IAnalysisWriterFactoryV2)this.analysisWriterFactory).createActivityWriter(arg_0));
    }

    private @NonNull ICAMJobAggregator getOrCreateCAMJobAggregator(int viewUID) throws IOException {
        ICAMJobAggregator result = (ICAMJobAggregator)this.camJobAggregatorsByViewUID.get(viewUID);
        if (result == null) {
            @NonNull IAnalysisCAMWriter camJobWriter = this.getOrCreateCAMJobWriter(viewUID);
            result = this.camJobAggregatorFactory.create(this.vmEndTimestamp, camJobWriter, this.warningsHandler);
            this.camJobAggregatorsByViewUID.put(viewUID, (Object)result);
        }
        return result;
    }

    private @NonNull IAnalysisCAMWriter getOrCreateCAMJobWriter(int viewUID) throws IOException {
        IAnalysisCAMWriter result = (IAnalysisCAMWriter)this.camJobWritersByViewUID.get(viewUID);
        if (result == null) {
            result = this.analysisWriterFactory.createCAMJobWriter(this.vmUID, viewUID);
            this.camJobWritersByViewUID.put(viewUID, (Object)result);
        }
        return result;
    }

    private @NonNull IAnalysisHardwareCounterWriter getOrCreateCounterWriter(@NonNull ICounterSeriesKey key) throws IOException {
        return (IAnalysisHardwareCounterWriter)MapUtils.computeIfAbsentThrows(this.counterWriters, (Object)key, arg_0 -> ((IAnalysisWriterFactoryV2)this.analysisWriterFactory).createCounterWriter(arg_0));
    }
}

