/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.pass_two;

import com.arm.streamline.protocol.capture.apc.io.APCFrameAddress;
import com.arm.streamline.protocol.capture.apc.pass_two.ExternalAPCFrameAddress;
import com.arm.streamline.protocol.capture.apc.protocol.DelayProcessingException;
import com.arm.streamline.protocol.capture.apc.protocol.external.ExternalProtocolChannel;
import com.arm.streamline.protocol.capture.apc.protocol.external.ExternalProtocols;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolDecoder;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolEventStream;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolPassTwoState;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolProvider;
import com.arm.streamline.protocol.capture.apc.protocol.external.TimestampTrackingExternalProtocolEventStream;
import com.arm.streamline.protocol.capture.apc.time.ClockSource;
import com.arm.streamline.protocol.capture.apc.time.ITimestampMapper;
import com.arm.streamline.protocol.capture.apc.time.Timestamp;
import com.arm.utils.function.IThrowingConsumer;
import com.arm.utils.function.IThrowingFunction;
import com.arm.utils.function.IThrowingIntFunction;
import com.arm.utils.function.IThrowingLongFunction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.LongFunction;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class ExternalFramePassTwoIndexGenerator {
    private final @NonNull IExternalProtocolProvider externalProtocolProvider;
    private final @NonNull IThrowingFunction<@NonNull APCFrameAddress, byte @NonNull [], IOException> frameLoader;
    private final @NonNull IThrowingLongFunction<@NonNull IExternalProtocolPassTwoState, IOException> stateProvider;

    private static @NonNull ExternalAPCFrameAddress @NonNull [] createExternalAddressForNonSortableData(@NonNull ITimestampMapper mapper, @NonNull List<@NonNull APCFrameAddress> addresses, @NonNull List<@NonNull Timestamp> earliestTimestamps, @NonNull List<@NonNull Timestamp> latestTimestamps) throws DelayProcessingException {
        assert (addresses.size() == earliestTimestamps.size());
        assert (latestTimestamps.size() == earliestTimestamps.size());
        @NonNull ExternalAPCFrameAddress @NonNull [] result = new ExternalAPCFrameAddress[addresses.size()];
        ExternalFramePassTwoIndexGenerator.enforceNonOverlapingFrames(result, (IThrowingIntFunction<ExternalAPCFrameAddress, DelayProcessingException>)((IThrowingIntFunction)i -> new ExternalAPCFrameAddress((APCFrameAddress)addresses.get(i), ExternalFramePassTwoIndexGenerator.map(mapper, (Timestamp)earliestTimestamps.get(i)), ExternalFramePassTwoIndexGenerator.map(mapper, (Timestamp)latestTimestamps.get(i)))));
        return result;
    }

    private static @NonNull ExternalAPCFrameAddress @NonNull [] createExternalAddressForSortableData(@NonNull ITimestampMapper mapper, @NonNull List<@NonNull APCFrameAddress> addresses, @NonNull List<@NonNull Timestamp> earliestTimestamps, @NonNull List<@NonNull Timestamp> latestTimestamps, @NonNull BitSet isIncomplete) throws DelayProcessingException {
        assert (addresses.size() == earliestTimestamps.size());
        assert (latestTimestamps.size() == earliestTimestamps.size());
        int frameCount = addresses.size();
        @NonNull ExternalAPCFrameAddress @NonNull [] result = new ExternalAPCFrameAddress[frameCount];
        long nextFramesEarliestTimestamp = ExternalFramePassTwoIndexGenerator.map(mapper, earliestTimestamps.get(frameCount - 1));
        APCFrameAddress nextAddress = addresses.get(frameCount - 1);
        result[result.length - 1] = new ExternalAPCFrameAddress(nextAddress, nextFramesEarliestTimestamp, ExternalFramePassTwoIndexGenerator.map(mapper, latestTimestamps.get(frameCount - 1)));
        int frameIndex = frameCount - 2;
        while (frameIndex >= 0) {
            long latest;
            long earliest;
            APCFrameAddress currentAddress = addresses.get(frameIndex);
            long currentFramesEarliestTimestamp = ExternalFramePassTwoIndexGenerator.map(mapper, earliestTimestamps.get(frameIndex));
            long currentFramesLatestTimestamp = ExternalFramePassTwoIndexGenerator.map(mapper, latestTimestamps.get(frameIndex));
            assert (currentAddress.compareTo(nextAddress) < 0);
            if (isIncomplete.get(frameIndex)) {
                earliest = nextFramesEarliestTimestamp;
                latest = nextFramesEarliestTimestamp;
            } else {
                earliest = currentFramesEarliestTimestamp;
                latest = currentFramesLatestTimestamp;
            }
            nextFramesEarliestTimestamp = earliest;
            nextAddress = currentAddress;
            result[frameIndex] = new ExternalAPCFrameAddress(currentAddress, earliest, latest);
            --frameIndex;
        }
        ExternalFramePassTwoIndexGenerator.sortByTimestampInfo(result);
        ExternalFramePassTwoIndexGenerator.enforceNonOverlapingFrames(result, (IThrowingIntFunction<ExternalAPCFrameAddress, DelayProcessingException>)((IThrowingIntFunction)i -> result[i]));
        return result;
    }

    private static void enforceNonOverlapingFrames(@NonNull ExternalAPCFrameAddress @NonNull [] result, @NonNull IThrowingIntFunction<@NonNull ExternalAPCFrameAddress, DelayProcessingException> getter) throws DelayProcessingException {
        assert (result.length > 1);
        result[result.length - 1] = (ExternalAPCFrameAddress)getter.apply(result.length - 1);
        long nextFramesEarliestTimestamp = result[result.length - 1].earliestTimestamp;
        int frameIndex = result.length - 2;
        while (frameIndex >= 0) {
            ExternalAPCFrameAddress currentEntry = (ExternalAPCFrameAddress)getter.apply(frameIndex);
            long earliest = ITimestampMapper.min(currentEntry.earliestTimestamp, nextFramesEarliestTimestamp);
            long latest = ITimestampMapper.min(currentEntry.latestTimestamp, nextFramesEarliestTimestamp);
            nextFramesEarliestTimestamp = earliest;
            result[frameIndex] = currentEntry.earliestTimestamp == earliest && currentEntry.latestTimestamp == latest ? currentEntry : new ExternalAPCFrameAddress(currentEntry.address, earliest, latest);
            --frameIndex;
        }
    }

    private static long map(@NonNull ITimestampMapper mapper, @NonNull Timestamp timestamp) throws DelayProcessingException {
        return mapper.mapTimestamp(timestamp.clockSource, timestamp.timestamp);
    }

    private static @NonNull IThrowingFunction<@NonNull ITimestampMapper, @NonNull ExternalAPCFrameAddress @Nullable [], DelayProcessingException> mapperForExternalAddressForNonSortableData(@NonNull ArrayList<@NonNull APCFrameAddress> entryAddresses, @NonNull ArrayList<@NonNull Timestamp> entryEarliestTimestamps, @NonNull ArrayList<@NonNull Timestamp> entryLatestTimestamps) {
        return mapper -> ExternalFramePassTwoIndexGenerator.createExternalAddressForNonSortableData(mapper, entryAddresses, entryEarliestTimestamps, entryLatestTimestamps);
    }

    private static @NonNull IThrowingFunction<@NonNull ITimestampMapper, @NonNull ExternalAPCFrameAddress @Nullable [], DelayProcessingException> mapperForExternalAddressForSortableData(@NonNull List<@NonNull APCFrameAddress> entryAddresses, @NonNull List<@NonNull Timestamp> entryEarliestTimestamps, @NonNull List<@NonNull Timestamp> entryLatestTimestamps, @NonNull BitSet entryIsIncomplete) {
        return mapper -> ExternalFramePassTwoIndexGenerator.createExternalAddressForSortableData(mapper, entryAddresses, entryEarliestTimestamps, entryLatestTimestamps, entryIsIncomplete);
    }

    private static @NonNull IThrowingFunction<@NonNull ITimestampMapper, @NonNull ExternalAPCFrameAddress @Nullable [], DelayProcessingException> mapSingle(@NonNull APCFrameAddress address, @NonNull Timestamp earliest, @NonNull Timestamp latest) {
        return mapper -> new ExternalAPCFrameAddress[]{new ExternalAPCFrameAddress(address, mapper.mapTimestamp(timestamp.clockSource, timestamp.timestamp), mapper.mapTimestamp(timestamp2.clockSource, timestamp2.timestamp))};
    }

    private static void sortByTimestampInfo(@NonNull ExternalAPCFrameAddress @NonNull [] frameAddresses) {
        Arrays.sort(frameAddresses, new Comparator<ExternalAPCFrameAddress>(){

            @Override
            public int compare(ExternalAPCFrameAddress o1, ExternalAPCFrameAddress o2) {
                int byEarlyTimestamp = Long.compare(o1.earliestTimestamp, o2.earliestTimestamp);
                if (byEarlyTimestamp != 0) {
                    return byEarlyTimestamp;
                }
                int byTimeSpan = Long.compare(ExternalFramePassTwoIndexGenerator.timespan(o1), ExternalFramePassTwoIndexGenerator.timespan(o2));
                if (byTimeSpan != 0) {
                    return byTimeSpan;
                }
                return o1.address.compareTo(o2.address);
            }
        });
    }

    private static long timespan(@NonNull ExternalAPCFrameAddress addr) {
        return addr.latestTimestamp - addr.earliestTimestamp;
    }

    public ExternalFramePassTwoIndexGenerator(@NonNull IExternalProtocolProvider externalProtocolProvider, @NonNull IThrowingFunction<@NonNull APCFrameAddress, byte @NonNull [], IOException> frameLoader, @NonNull IThrowingLongFunction<@NonNull IExternalProtocolPassTwoState, IOException> stateProvider) {
        this.externalProtocolProvider = externalProtocolProvider;
        this.frameLoader = frameLoader;
        this.stateProvider = stateProvider;
    }

    public ExternalFramePassTwoIndexGenerator(@NonNull IThrowingFunction<@NonNull APCFrameAddress, byte @NonNull [], IOException> frameLoader, @NonNull IThrowingLongFunction<@NonNull IExternalProtocolPassTwoState, IOException> stateProvider) {
        this(ExternalProtocols::get, frameLoader, stateProvider);
    }

    public @NonNull SortedMap<@NonNull ExternalProtocolChannel, @NonNull IThrowingFunction<@NonNull ITimestampMapper, @NonNull ExternalAPCFrameAddress @Nullable [], DelayProcessingException>> forAll(@NonNull SortedMap<@NonNull ExternalProtocolChannel, @NonNull List<@NonNull APCFrameAddress>> externalIndex, @NonNull LongFunction<@NonNull ITimeRangeTracker> timerangeTrackerSupplier, @NonNull IThrowingConsumer<@NonNull ExternalProtocolChannel, IOException> flusher) throws IOException {
        @NonNull TreeMap<@NonNull ExternalProtocolChannel, @NonNull IThrowingFunction<@NonNull ITimestampMapper, @NonNull ExternalAPCFrameAddress @Nullable [], DelayProcessingException>> result = new TreeMap<ExternalProtocolChannel, IThrowingFunction<ITimestampMapper, ExternalAPCFrameAddress[], DelayProcessingException>>();
        for (Map.Entry<ExternalProtocolChannel, List<APCFrameAddress>> entry : externalIndex.entrySet()) {
            List<APCFrameAddress> addresses;
            @NonNull ExternalProtocolChannel externalChannel = entry.getKey();
            @Nullable IThrowingFunction<@NonNull ITimestampMapper, @NonNull ExternalAPCFrameAddress @Nullable [], DelayProcessingException> indexMapper = this.processChannel(externalChannel, addresses = entry.getValue(), timerangeTrackerSupplier, flusher);
            if (indexMapper == null) continue;
            result.put(externalChannel, indexMapper);
        }
        return result;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final @Nullable IThrowingFunction<@NonNull ITimestampMapper, @NonNull ExternalAPCFrameAddress @Nullable [], DelayProcessingException> processChannel(@NonNull ExternalProtocolChannel externalChannel, @NonNull List<@NonNull APCFrameAddress> addresses, @NonNull LongFunction<@NonNull ITimeRangeTracker> timerangeTrackerSupplier, @NonNull IThrowingConsumer<@NonNull ExternalProtocolChannel, IOException> flusher) throws IOException {
        @NonNull ITimeRangeTracker timerangeTracker = timerangeTrackerSupplier.apply(externalChannel.vmUID);
        @NonNull TimestampTrackingExternalProtocolEventStream timestampTracker = new TimestampTrackingExternalProtocolEventStream();
        @NonNull @NonNull IThrowingLongFunction outputProvider = ignored -> timestampTracker;
        @Nullable IExternalProtocolDecoder nullableExternalProtocol = this.externalProtocolProvider.get(externalChannel, this.stateProvider, (IThrowingLongFunction<IExternalProtocolEventStream, IOException>)outputProvider, false);
        if (nullableExternalProtocol == null) {
            return null;
        }
        Throwable throwable = null;
        Object var10_11 = null;
        try (IExternalProtocolDecoder externalProtocol = nullableExternalProtocol;){
            int frameCount = addresses.size();
            if (frameCount == 0) {
                return null;
            }
            BitSet entryIsIncomplete = new BitSet();
            ArrayList<Timestamp> entryEarliestTimestamps = new ArrayList<Timestamp>(frameCount);
            ArrayList<Timestamp> entryLatestTimestamps = new ArrayList<Timestamp>(frameCount);
            ArrayList<APCFrameAddress> entryAddresses = new ArrayList<APCFrameAddress>(frameCount);
            int frameIndex = 0;
            while (frameIndex < frameCount) {
                @NonNull APCFrameAddress address = addresses.get(frameIndex);
                byte @NonNull [] data = (byte[])this.frameLoader.apply((Object)address);
                externalProtocol.process(data);
                if (frameIndex + 1 == frameCount) {
                    flusher.accept((Object)externalChannel);
                }
                for (TimestampTrackingExternalProtocolEventStream.Entry entry : timestampTracker.takeEntries(address.length)) {
                    APCFrameAddress entryAddress;
                    Timestamp earliestTimestampInFrame = entry.earliestTimestamp;
                    Timestamp latestTimestampInFrame = entry.latestTimestamp;
                    boolean wholeFrame = entry.offset == 0 && entry.length == address.length;
                    APCFrameAddress aPCFrameAddress = entryAddress = wholeFrame ? address : address.subMessage(entry.offset, entry.length);
                    if (latestTimestampInFrame != null) {
                        entryIsIncomplete.set(entryAddresses.size(), false);
                        entryAddresses.add(entryAddress);
                        entryEarliestTimestamps.add(earliestTimestampInFrame);
                        entryLatestTimestamps.add(latestTimestampInFrame);
                        timerangeTracker.track(earliestTimestampInFrame.clockSource, earliestTimestampInFrame.timestamp);
                        timerangeTracker.track(latestTimestampInFrame.clockSource, latestTimestampInFrame.timestamp);
                        continue;
                    }
                    @NonNull Timestamp timestamp = entryLatestTimestamps.size() > 0 ? entryLatestTimestamps.get(entryLatestTimestamps.size() - 1) : Timestamp.BEFORE_START;
                    entryIsIncomplete.set(entryAddresses.size(), true);
                    entryAddresses.add(entryAddress);
                    entryEarliestTimestamps.add(timestamp);
                    entryLatestTimestamps.add(timestamp);
                }
                ++frameIndex;
            }
            if (entryAddresses.size() == 1) {
                return ExternalFramePassTwoIndexGenerator.mapSingle(entryAddresses.get(0), entryEarliestTimestamps.get(0), entryLatestTimestamps.get(0));
            }
            if (!externalProtocol.reorderable()) return ExternalFramePassTwoIndexGenerator.mapperForExternalAddressForNonSortableData(entryAddresses, entryEarliestTimestamps, entryLatestTimestamps);
            return ExternalFramePassTwoIndexGenerator.mapperForExternalAddressForSortableData(entryAddresses, entryEarliestTimestamps, entryLatestTimestamps, entryIsIncomplete);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    @FunctionalInterface
    public static interface ITimeRangeTracker {
        public void track(@NonNull ClockSource var1, long var2);
    }
}

