/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.pass_two;

import com.arm.streamline.analysis.database.api.IAnalysisWriterFactoryV2;
import com.arm.streamline.analysis.database.stream.factory.AnalysisDatabaseWriterFactoryV2;
import com.arm.streamline.analysis.database.stream.factory.AnalysisDatabaseWriterStateTracker;
import com.arm.streamline.analysis.database.stream.factory.IAnalysisDatabaseWriterStateTracker;
import com.arm.streamline.analysis.model.DeviceTypeCalculator;
import com.arm.streamline.analysis.model.ICounterSeriesKey;
import com.arm.streamline.analysis.model.IVirtualMachineProperties;
import com.arm.streamline.analysis.model.KernelSymbol;
import com.arm.streamline.analysis.model.threads.ExecutablePathMapping;
import com.arm.streamline.analysis.model.threads.IExecutablePath;
import com.arm.streamline.analysis.model.threads.IUniqueProcess;
import com.arm.streamline.analysis.model.threads.IUniqueThread;
import com.arm.streamline.analysis.model.topology.ClusterInformationRewriter;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.counters.SpeCaptureRecord;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.streamline.common.model.warnings.IWarnings;
import com.arm.streamline.common.model.warnings.WarningItem;
import com.arm.streamline.perf.records.EventAttribute;
import com.arm.streamline.protocol.ProtocolException;
import com.arm.streamline.protocol.capture.apc.index.APCFrameAddressWithVmUIDAndTimestamp;
import com.arm.streamline.protocol.capture.apc.index.IAPCFrameAddressIndex;
import com.arm.streamline.protocol.capture.apc.io.APCFrameAddress;
import com.arm.streamline.protocol.capture.apc.io.APCFrameLoader;
import com.arm.streamline.protocol.capture.apc.pass_one.APCPassOne;
import com.arm.streamline.protocol.capture.apc.pass_one.ICookieTracker;
import com.arm.streamline.protocol.capture.apc.pass_two.APCFrameRecordReloader;
import com.arm.streamline.protocol.capture.apc.pass_two.ExternalAPCFrameAddress;
import com.arm.streamline.protocol.capture.apc.pass_two.ExternalProtocolPassTwoState;
import com.arm.streamline.protocol.capture.apc.pass_two.GatorPassTwoForAnalysisEventStreamDatabaseWriter;
import com.arm.streamline.protocol.capture.apc.pass_two.GatorPassTwoPerVirtualMachineProtocolEventConsumer;
import com.arm.streamline.protocol.capture.apc.pass_two.GatorPassTwoProtocolEventConsumer;
import com.arm.streamline.protocol.capture.apc.pass_two.GatorPassTwoSortedEventStreamConsumer;
import com.arm.streamline.protocol.capture.apc.pass_two.IExternalProtocolFrameConsumer;
import com.arm.streamline.protocol.capture.apc.pass_two.IGatorPassTwoEventStream;
import com.arm.streamline.protocol.capture.apc.pass_two.IGatorPassTwoForAnalysisEventStream;
import com.arm.streamline.protocol.capture.apc.pass_two.KernelTracepointProcessor;
import com.arm.streamline.protocol.capture.apc.pass_two.LinuxThreadTracker;
import com.arm.streamline.protocol.capture.apc.pass_two.MaliUserspaceSoftwareCounters;
import com.arm.streamline.protocol.capture.apc.pass_two.PerfDataBufferPassTwoEventConsumer;
import com.arm.streamline.protocol.capture.apc.pass_two.cam.ICAMViewTracker;
import com.arm.streamline.protocol.capture.apc.pass_two.event_queue.APCEventQueues;
import com.arm.streamline.protocol.capture.apc.protocol.IAPCProtocolVersionPassAdapter;
import com.arm.streamline.protocol.capture.apc.protocol.IGatorPerVirtualMachineProtocolEventConsumer;
import com.arm.streamline.protocol.capture.apc.protocol.IGatorProtocolEventConsumer;
import com.arm.streamline.protocol.capture.apc.protocol.external.ExternalProtocolChannel;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolDecoder;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolEventStream;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolPassTwoState;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolProvider;
import com.arm.streamline.protocol.capture.apc.protocol.external.TimestampMappingExternalProtocolEventStream;
import com.arm.streamline.protocol.capture.apc.protocol.perf.IPerfProtocolStateTracker;
import com.arm.streamline.protocol.capture.apc.protocol.perf.PerfDataBufferPassProcessor;
import com.arm.streamline.protocol.capture.apc.time.ITimestampMapper;
import com.arm.streamline.protocol.misc.AttachedApkEntries;
import com.arm.streamline.protocol.misc.IDeviceNumberToClusterNumber;
import com.arm.streamline.protocol.misc.LinuxKAllSymsSymbolToModuleTransform;
import com.arm.streamline.protocol.misc.StaticCounterSerieses;
import com.arm.streamline.protocol.misc.TaskId;
import com.arm.streamline.report.model.VariableReplacer;
import com.arm.streamline.report.model.pe.ProcessingElementDescriptor;
import com.arm.streamline.report.model.topology.IClustersInfo;
import com.arm.streamline.spe.decoders.SpeDecoder;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.Pair;
import com.arm.utils.function.IThrowingConsumer;
import com.arm.utils.function.IThrowingFunction;
import com.arm.utils.function.IThrowingLongFunction;
import com.arm.utils.function.Throwing;
import gnu.trove.TCollections;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.iterator.TLongObjectIterator;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.TLongSet;
import gnu.trove.set.hash.TIntHashSet;
import gnu.trove.set.hash.TLongHashSet;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class APCPassTwo
implements Closeable {
    private static final boolean DEBUG = false;
    protected final @NonNull AnalysisDatabaseWriterStateTracker analysisWriterStateTracker;
    protected final @NonNull ProcessingElementReferenceSet peReferenceSet;
    protected final @NonNull StaticCounterSerieses staticCounterSerieses;
    private final @NonNull IAnalysisWriterFactoryV2 analysisWriterFactory;
    private final @NonNull String captureName;
    private final @NonNull IClustersInfo clusterInfo;
    private final @NonNull Collection<@NonNull IGatorPassTwoForAnalysisEventStream> databaseWriterEventStreams = new ArrayList<IGatorPassTwoForAnalysisEventStream>();
    private final long duration;
    private final @NonNull APCEventQueues eventQueues;
    private final @NonNull IExternalProtocolProvider externalProtocolProvider;
    private final @NonNull TLongObjectMap<ExternalProtocolPassTwoState> externalProtocolStates = new TLongObjectHashMap(10, 0.5f, 0L);
    private final boolean hasApplicationTracingMode;
    private final @NonNull TLongObjectMap<List<@NonNull KernelSymbol>> kernelSymbolsByVm = new TLongObjectHashMap(10, 0.5f, 0L);
    private final @NonNull List<@NonNull APCFrameAddressWithVmUIDAndTimestamp> normalIndex;
    private final @NonNull IGatorProtocolEventConsumer passTwoConsumer;
    private final @NonNull Map<@NonNull ProcessingElementReference, @NonNull ProcessingElementDescriptor> processingElementProperties;
    private final @NonNull IAPCProtocolVersionPassAdapter protocolVersionPassAdapter;
    private final @NonNull List<@NonNull ProcessingElementReference> sortedCpuList;
    private final @NonNull UniqueThreadsCollection uniqueThreads = new UniqueThreadsCollection();
    private final @NonNull TLongObjectMap<IVirtualMachineProperties> vmStatesMap = new TLongObjectHashMap(10, 0.5f, 0L);
    private final @NonNull AttachedApkEntries attachedApkEntries;
    private final @NonNull SortedMap<@NonNull ExternalProtocolChannel, @NonNull ExternalAPCFrameAddress @NonNull []> timestampedExternalIndex;

    protected static @NonNull TIntObjectMap<TLongSet> getApplicationCounterAttributabilityByVm(@NonNull TLongObjectMap<APCPassOne.APCPassOnePerVmState> passOneVmStates) {
        TIntObjectHashMap result = new TIntObjectHashMap(10, 0.5f, 0);
        TLongObjectIterator vmIt = passOneVmStates.iterator();
        while (vmIt.hasNext()) {
            vmIt.advance();
            long vmUID = vmIt.key();
            APCPassOne.APCPassOnePerVmState state = (APCPassOne.APCPassOnePerVmState)vmIt.value();
            if (!state.isApplicationTracingMode()) continue;
            TIntObjectMap<EventAttribute> attrs = state.getPerfProtocolStateTracker().getAllPerfEventAttributesByKey();
            TIntObjectIterator attrsIt = attrs.iterator();
            while (attrsIt.hasNext()) {
                attrsIt.advance();
                int key = attrsIt.key();
                EventAttribute attr = (EventAttribute)attrsIt.value();
                long sampleType = attr.getSampleType();
                if ((sampleType & 2L) == 0L || attr.isFlagSet(EventAttribute.Flags.INHERIT) && !attr.isFlagSet(EventAttribute.Flags.INHERIT_STAT)) continue;
                TLongSet set = (TLongSet)result.get(key);
                if (set == null) {
                    set = new TLongHashSet(10, 0.5f, 0L);
                    result.put(key, (Object)set);
                }
                set.add(vmUID);
            }
        }
        return result;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public APCPassTwo(@NonNull File dbDirectory, @NonNull String captureName, boolean alwaysSupportMultipleClusterRewrite, boolean hasApplicationTracingMode, boolean generateSpeSampleLog, boolean filterPerVmEbsCounters, long duration, @NonNull DeviceTypeCalculator deviceTypeCalculator, @NonNull Set<@NonNull SpeCaptureRecord> speCaptureRecords, @NonNull List<@NonNull CounterRecord> staticCounterRecords, @NonNull ProcessingElementReferenceSet peReferenceSet, @NonNull Map<@NonNull ProcessingElementReference, @NonNull ProcessingElementDescriptor> processingElementProperties, @NonNull IClustersInfo originalClusterInfo, @NonNull TLongObjectMap<APCPassOne.APCPassOnePerVmState> passOneVmStates, @NonNull IAPCFrameAddressIndex frameIndex, @NonNull IAPCProtocolVersionPassAdapter protocolVersionPassAdapter, @NonNull IExternalProtocolProvider externalProtocolProvider, @NonNull IWarnings warnings, @NonNull AttachedApkEntries attachedApkEntries, @NonNull SortedMap<@NonNull ExternalProtocolChannel, @NonNull ExternalAPCFrameAddress @NonNull []> timestampedExternalIndex) throws IOException {
        processingElementProperties = new HashMap<ProcessingElementReference, ProcessingElementDescriptor>(processingElementProperties);
        this.captureName = captureName;
        this.hasApplicationTracingMode = hasApplicationTracingMode;
        this.peReferenceSet = peReferenceSet;
        this.protocolVersionPassAdapter = protocolVersionPassAdapter;
        this.duration = duration;
        this.externalProtocolProvider = externalProtocolProvider;
        this.processingElementProperties = processingElementProperties;
        this.attachedApkEntries = attachedApkEntries;
        this.timestampedExternalIndex = timestampedExternalIndex;
        this.normalIndex = frameIndex.createIndex();
        if (!dbDirectory.isDirectory() && !dbDirectory.mkdirs()) {
            throw new FileNotFoundException(dbDirectory.getAbsolutePath());
        }
        @NonNull @NonNull @NonNull @NonNull Pair mappedClusterInfo = ClusterInformationRewriter.write((OutputStream)VariableReplacer.getOutPutStream((File)dbDirectory), staticCounterRecords, (boolean)alwaysSupportMultipleClusterRewrite, (IClustersInfo)originalClusterInfo, (ProcessingElementReferenceSet)peReferenceSet, processingElementProperties);
        @NonNull @NonNull List sortedCpuList = (List)mappedClusterInfo.first;
        @NonNull IClustersInfo clusterInfo = (IClustersInfo)mappedClusterInfo.second;
        this.staticCounterSerieses = new StaticCounterSerieses(staticCounterRecords, (TIntObjectMap<String>)clusterInfo.getClusterNames(), speCaptureRecords);
        @NonNull IDeviceNumberToClusterNumber clusterMapper = clusterInfo.hasClusters() ? (vmUID, deviceNumber) -> {
            @NonNull ProcessingElementReference peReference = peReferenceSet.get(DeviceType.CPU, vmUID, deviceNumber);
            int index = sortedCpuList.indexOf(peReference);
            assert (index >= 0);
            return clusterInfo.getClusterIndex(index);
        } : (vmUID, deviceNumber) -> 0;
        this.sortedCpuList = sortedCpuList;
        this.clusterInfo = clusterInfo;
        TIntObjectMap<TLongSet> countersAttributableByTid = APCPassTwo.getApplicationCounterAttributabilityByVm(passOneVmStates);
        @NonNull IntFunction<@Nullable ICounterSeriesKey> staticCounterKeyToSeriesMapper = this.staticCounterSerieses::getStaticCounterRecordByKey;
        @NonNull Function<@NonNull String, @Nullable ICounterSeriesKey> tracepointCounterMapper = this.staticCounterSerieses::getTracepointCounterSeriesKeyByName;
        this.analysisWriterStateTracker = new AnalysisDatabaseWriterStateTracker(dbDirectory, deviceTypeCalculator, this.staticCounterSerieses.getAllStaticCounterSeries(), speCaptureRecords, warnings);
        AnalysisDatabaseWriterFactoryV2 analysisWriterFactory = new AnalysisDatabaseWriterFactoryV2((IAnalysisDatabaseWriterStateTracker)this.analysisWriterStateTracker, peReferenceSet, countersAttributableByTid);
        this.analysisWriterFactory = analysisWriterFactory;
        @NonNull TLongObjectHashMap passTwoEventStreams = new TLongObjectHashMap(10, 0.5f, 0L);
        this.eventQueues = new APCEventQueues(null, (IThrowingLongFunction<IGatorPassTwoEventStream, IOException>)((IThrowingLongFunction)arg_0 -> APCPassTwo.lambda$4((TLongObjectMap)passTwoEventStreams, arg_0)));
        try {
            @NonNull TLongObjectHashMap passTwoVmConsumers = new TLongObjectHashMap();
            TLongObjectIterator it = passOneVmStates.iterator();
            while (it.hasNext()) {
                it.advance();
                long vmUID2 = it.key();
                @NonNull APCPassOne.APCPassOnePerVmState state = (APCPassOne.APCPassOnePerVmState)NullChecking.neverNull((Object)((APCPassOne.APCPassOnePerVmState)it.value()));
                boolean appTracingMode = state.isApplicationTracingMode();
                long vmEndTimestamp = state.getVirtualMachineProperties().getVmEndTimestamp();
                @NonNull ICookieTracker cookieTracker = state.getCookieTracker();
                @NonNull List<@NonNull KernelSymbol> kernelSymbols = state.getKallsymsTracker().getAllSymbols();
                this.kernelSymbolsByVm.put(vmUID2, kernelSymbols);
                passTwoEventStreams.put(vmUID2, (Object)this.createSortedEventStreamConsumer(generateSpeSampleLog, dbDirectory, vmUID2, vmEndTimestamp, cookieTracker, kernelSymbols, appTracingMode));
                passTwoVmConsumers.put(vmUID2, (Object)this.createPerVmProtocolEventConsumer(vmUID2, state, this.staticCounterSerieses, clusterMapper, peReferenceSet, staticCounterKeyToSeriesMapper, tracepointCounterMapper));
                this.vmStatesMap.put(vmUID2, (Object)state.getVirtualMachineProperties());
                this.externalProtocolStates.put(vmUID2, (Object)new ExternalProtocolPassTwoState(vmUID2, state.getTimestampMapper(), state.getPerfProtocolStateTracker(), peReferenceSet, this.staticCounterSerieses));
            }
            this.passTwoConsumer = new GatorPassTwoProtocolEventConsumer((TLongObjectMap<IGatorPerVirtualMachineProtocolEventConsumer>)passTwoVmConsumers);
        }
        catch (Throwable t) {
            try {
                analysisWriterFactory.close();
            }
            catch (Throwable t1) {
                t.addSuppressed(t1);
            }
            throw t;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            for (ExternalProtocolPassTwoState eps : this.externalProtocolStates.valueCollection()) {
                eps.close();
            }
        }
        catch (Throwable throwable) {
            Throwing.closeAll((Iterable[])new Iterable[]{this.databaseWriterEventStreams});
            this.analysisWriterFactory.close();
            throw throwable;
        }
        Throwing.closeAll((Iterable[])new Iterable[]{this.databaseWriterEventStreams});
        this.analysisWriterFactory.close();
        this.analysisWriterStateTracker.writeState(this.peReferenceSet, this.vmStatesMap, this.uniqueThreads.createMap(), this.duration, this.captureName, this.hasApplicationTracingMode, this.sortedCpuList, this.processingElementProperties, this.clusterInfo, this.kernelSymbolsByVm);
    }

    public @NonNull TIntSet getIdleUtids() {
        return this.uniqueThreads.getIdleUtids();
    }

    public @NonNull ProcessingElementReferenceSet getProcessingElementReferenceSet() {
        return this.peReferenceSet;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void run() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (APCFrameLoader loader = new APCFrameLoader();){
            @NonNull @NonNull IThrowingConsumer frameConsumer = address -> {
                byte @NonNull [] data = loader.load((APCFrameAddress)address);
                this.protocolVersionPassAdapter.process(this.passTwoConsumer, (APCFrameAddress)address, data);
            };
            @NonNull IExternalProtocolFrameConsumer externalFrameConsumer = (address, decoder) -> {
                byte @NonNull [] data = loader.load(address);
                decoder.process(data);
            };
            @NonNull @NonNull IThrowingLongFunction stateProvider = vmUID -> {
                @Nullable IExternalProtocolPassTwoState state = (IExternalProtocolPassTwoState)this.externalProtocolStates.get(vmUID);
                if (state == null) {
                    throw new AssertionError();
                }
                return state;
            };
            @NonNull @NonNull @Nullable IThrowingFunction externalProtocolProvider_ = channel -> this.externalProtocolProvider.get((ExternalProtocolChannel)channel, (IThrowingLongFunction<IExternalProtocolPassTwoState, IOException>)stateProvider, (IThrowingLongFunction<IExternalProtocolEventStream, IOException>)((IThrowingLongFunction)vmUID -> {
                IExternalProtocolPassTwoState state = (IExternalProtocolPassTwoState)stateProvider.apply(vmUID);
                ITimestampMapper timestampMapper = state.getTimestampMapper();
                return new TimestampMappingExternalProtocolEventStream(timestampMapper, this.eventQueues.getQueueingEventStreamFor(vmUID));
            }), false);
            APCFrameRecordReloader reloader = new APCFrameRecordReloader((IThrowingConsumer<APCFrameAddress, IOException>)frameConsumer, (IThrowingFunction<ExternalProtocolChannel, IExternalProtocolDecoder, IOException>)externalProtocolProvider_, externalFrameConsumer, this.normalIndex, this.timestampedExternalIndex, this.eventQueues);
            reloader.run();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.eventQueues.flushAll();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull IGatorPerVirtualMachineProtocolEventConsumer createPerVmProtocolEventConsumer(long vmUID, @NonNull APCPassOne.APCPassOnePerVmState state, @NonNull StaticCounterSerieses staticCounterSerieses, @NonNull IDeviceNumberToClusterNumber clusterMapper, @NonNull ProcessingElementReferenceSet peReferenceSet, @NonNull IntFunction<@Nullable ICounterSeriesKey> staticCounterKeyToSeriesMapper, @NonNull Function<@NonNull String, @Nullable ICounterSeriesKey> tracepointCounterMapper) throws ProtocolException, IOException {
        @NonNull IntFunction<@Nullable ICounterSeriesKey> cpuFrequencyTracepointKeyProvider = deviceNumber -> {
            int clusterNumber = clusterMapper.map(vmUID, deviceNumber);
            return staticCounterSerieses.getLinuxPowerCpuFreq(clusterNumber);
        };
        @NonNull IntPredicate isSpeKey = key -> staticCounterSerieses.getSpeCaptureRecordByKey(key) != null;
        @NonNull ITimestampMapper timestampMapper = state.getTimestampMapper();
        @NonNull IPerfProtocolStateTracker perfAttributesState = state.getPerfProtocolStateTracker();
        @NonNull IGatorPassTwoEventStream output = this.eventQueues.getQueueingEventStreamFor(vmUID);
        @NonNull MaliUserspaceSoftwareCounters maliUserspaceSoftwareCounters = new MaliUserspaceSoftwareCounters(vmUID, staticCounterSerieses, peReferenceSet, output);
        KernelTracepointProcessor kernelTracepointProcessor = new KernelTracepointProcessor(vmUID, output, peReferenceSet);
        @NonNull PerfDataBufferPassProcessor perfDataBufferPassProcessor = new PerfDataBufferPassProcessor(ByteOrder.LITTLE_ENDIAN, perfAttributesState);
        boolean allowArbitraryEbsBacktraceSources = false;
        @NonNull @NonNull PerfDataBufferPassTwoEventConsumer perfDataBufferPassTwoEventConsumer = new PerfDataBufferPassTwoEventConsumer(vmUID, state.isApplicationTracingMode(), perfAttributesState, timestampMapper, peReferenceSet, staticCounterKeyToSeriesMapper, cpuFrequencyTracepointKeyProvider, tracepointCounterMapper, maliUserspaceSoftwareCounters, kernelTracepointProcessor, isSpeKey, SpeDecoder::decode, false, false, output);
        return new GatorPassTwoPerVirtualMachineProtocolEventConsumer(vmUID, peReferenceSet, staticCounterKeyToSeriesMapper, timestampMapper, perfAttributesState, perfDataBufferPassProcessor, perfDataBufferPassTwoEventConsumer, output);
    }

    private @NonNull IGatorPassTwoEventStream createSortedEventStreamConsumer(boolean generateSpeSampleLog, @NonNull File dbDirectory, final long vmUID, long vmEndTimestamp, @NonNull ICookieTracker cookieTracker, @NonNull List<@NonNull KernelSymbol> kernelSymbols, boolean appTracingMode) throws IOException {
        @NonNull List<@NonNull LinuxKAllSymsSymbolToModuleTransform.ModuleInfo> kernelModules = LinuxKAllSymsSymbolToModuleTransform.map(kernelSymbols);
        @NonNull LinuxThreadTracker uniqueThreadTracker = new LinuxThreadTracker(vmUID, this.uniqueThreads::allocateUniqueThreadUID, kernelModules, this.attachedApkEntries, appTracingMode);
        @NonNull BiConsumer<@NonNull ICounterSeriesKey, @NonNull CounterRecord> dynamicOrAnnotationCounterRecordConsumer = (arg_0, arg_1) -> ((AnalysisDatabaseWriterStateTracker)this.analysisWriterStateTracker).addDynamicOrKernelAnnotationCounterRecord(arg_0, arg_1);
        @NonNull ICAMViewTracker camViewTracker = new ICAMViewTracker(){

            @Override
            public void camTrack(int viewUID, int parentTrack, int trackUID, @NonNull String name) {
                APCPassTwo.this.analysisWriterStateTracker.trackCAMTrack(vmUID, viewUID, parentTrack, trackUID, name);
            }

            @Override
            public void camView(int viewUID, @NonNull String name) {
                APCPassTwo.this.analysisWriterStateTracker.trackCAMView(vmUID, viewUID, name);
            }
        };
        @NonNull Consumer<@NonNull WarningItem> warningHandler = arg_0 -> ((AnalysisDatabaseWriterStateTracker)this.analysisWriterStateTracker).warning(arg_0);
         @NonNull IUniqueThreadTracker.ITrackedUniqueThread kernelProcessThread = uniqueThreadTracker.track(-1L, new TaskId(0, 0));
        @NonNull GatorPassTwoForAnalysisEventStreamDatabaseWriter databaseWriterEventStream = new GatorPassTwoForAnalysisEventStreamDatabaseWriter(vmUID, vmEndTimestamp, generateSpeSampleLog, this.peReferenceSet, kernelProcessThread, dynamicOrAnnotationCounterRecordConsumer, camViewTracker, warningHandler, this.analysisWriterFactory);
        this.databaseWriterEventStreams.add(databaseWriterEventStream);
        return new GatorPassTwoSortedEventStreamConsumer(cookieTracker, uniqueThreadTracker, databaseWriterEventStream);
    }

    private static /* synthetic */ IGatorPassTwoEventStream lambda$4(TLongObjectMap tLongObjectMap, long vmUID) throws IOException {
        @Nullable IGatorPassTwoEventStream result = (IGatorPassTwoEventStream)tLongObjectMap.get(vmUID);
        if (result == null) {
            throw new AssertionError();
        }
        return result;
    }

    protected static final class UniqueThreadsCollection {
        private final @NonNull List<@NonNull IUniqueThread> threads = new ArrayList<IUniqueThread>();
        private int uniqueThreadUIDCounter = 1;

        private static @NonNull IUniqueThread wrapMagicThread(final @NonNull IUniqueThread thread, final boolean idle, final int uid) {
            return new IUniqueThread(){

                public @Nullable ExecutablePathMapping findMMapping(long address) {
                    return null;
                }

                public long getEarliestSeenTimestamp() {
                    return thread.getEarliestSeenTimestamp();
                }

                public @Nullable Long getEndTimestamp() {
                    return thread.getEndTimestamp();
                }

                public @Nullable IExecutablePath getExecutablePath() {
                    return idle ? IExecutablePath.IDLE : IExecutablePath.KERNEL;
                }

                public long getLastSeenTimestamp() {
                    return thread.getLastSeenTimestamp();
                }

                public @NonNull List<@NonNull ExecutablePathMapping> getMMaps() {
                    return Collections.emptyList();
                }

                public @Nullable String getName() {
                    return idle ? "idle" : "kernel";
                }

                public int getOriginalID() {
                    return idle ? 0 : -1;
                }

                public @Nullable IUniqueThread getProcessThread() {
                    return this;
                }

                public @Nullable Long getStartTimestamp() {
                    return thread.getStartTimestamp();
                }

                public int getUID() {
                    return uid;
                }

                public long getVmUID() {
                    return thread.getVmUID();
                }

                public boolean isIdle() {
                    return idle;
                }

                public boolean isIgnored() {
                    return false;
                }

                public boolean isKernel() {
                    return !idle;
                }

                public boolean isProcessThread() {
                    return true;
                }
            };
        }

        public int allocateUniqueThreadUID(@NonNull IUniqueThread uniqueThread) {
            this.threads.add(uniqueThread);
            return this.uniqueThreadUIDCounter++;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public @NonNull Map<@NonNull IUniqueProcess, @NonNull Set<@NonNull IUniqueThread>> createMap() {
            @NonNull HashMap<@NonNull IUniqueThread, @NonNull @NonNull Set> mapProcessThreadToThreads = new HashMap<IUniqueThread, Set>();
            @NonNull @Nullable @Nullable TLongObjectHashMap kernelProcessAndIdleThreadByVm = new TLongObjectHashMap();
            for (IUniqueThread thread : this.threads) {
                IUniqueThread idleThread;
                @NonNull IUniqueThread processThread2 = (IUniqueThread)NullChecking.neverNullOr((Object)thread.getProcessThread(), (Object)thread);
                @NonNull @NonNull Set set = mapProcessThreadToThreads.computeIfAbsent(processThread2, ignored -> new HashSet());
                set.add(thread);
                @Nullable @Nullable @Nullable Pair currentPair = (Pair)kernelProcessAndIdleThreadByVm.get(thread.getVmUID());
                IUniqueThread kernelProcess = currentPair != null ? (IUniqueThread)currentPair.first : null;
                IUniqueThread iUniqueThread = idleThread = currentPair != null ? (IUniqueThread)currentPair.second : null;
                if (thread.isIdle()) {
                    idleThread = thread;
                }
                if (processThread2.isKernel()) {
                    kernelProcess = processThread2;
                }
                kernelProcessAndIdleThreadByVm.put(thread.getVmUID(), (Object)new Pair((Object)kernelProcess, (Object)idleThread));
            }
            @Nullable @Nullable TLongObjectIterator it = kernelProcessAndIdleThreadByVm.iterator();
            while (it.hasNext()) {
                int n;
                IUniqueThread idleThread;
                it.advance();
                @Nullable @Nullable @Nullable Pair currentPair = (Pair)it.value();
                IUniqueThread kernelProcess = currentPair != null ? (IUniqueThread)currentPair.first : null;
                IUniqueThread iUniqueThread = idleThread = currentPair != null ? (IUniqueThread)currentPair.second : null;
                if (kernelProcess == null) continue;
                @Nullable @NonNull Set kernelThreads = (Set)mapProcessThreadToThreads.remove(kernelProcess);
                assert (kernelThreads != null);
                if (idleThread != null) {
                    kernelThreads.remove(idleThread);
                    @NonNull IUniqueThread wrappedIdleThread = UniqueThreadsCollection.wrapMagicThread(idleThread, true, idleThread.getUID());
                    mapProcessThreadToThreads.put(wrappedIdleThread, new HashSet<IUniqueThread>(Arrays.asList(wrappedIdleThread)));
                }
                if (idleThread != null && idleThread.getUID() == kernelProcess.getUID()) {
                    int n2 = this.uniqueThreadUIDCounter;
                    n = n2;
                    this.uniqueThreadUIDCounter = n2 + 1;
                } else {
                    n = kernelProcess.getUID();
                }
                int kernelUID = n;
                @NonNull IUniqueThread wrappedKernelThread = UniqueThreadsCollection.wrapMagicThread(kernelProcess, false, kernelUID);
                kernelThreads.remove(kernelProcess);
                mapProcessThreadToThreads.put(wrappedKernelThread, kernelThreads);
            }
            @NonNull HashMap<@NonNull K, @NonNull @NonNull V> result = new HashMap();
            mapProcessThreadToThreads.forEach((processThread, threads) -> {
                @NonNull IUniqueProcess process = this.wrapProcessThread((IUniqueThread)processThread);
                result.put(process, threads);
            });
            return Collections.unmodifiableMap(result);
        }

        public @NonNull TIntSet getIdleUtids() {
            @NonNull TIntHashSet idleUtids = new TIntHashSet(10, 0.5f, -1);
            this.threads.forEach(arg_0 -> UniqueThreadsCollection.lambda$2((TIntSet)idleUtids, arg_0));
            return TCollections.unmodifiableSet((TIntSet)idleUtids);
        }

        private @NonNull IUniqueProcess wrapProcessThread(final @NonNull IUniqueThread processThread) {
            final int uid = this.uniqueThreadUIDCounter++;
            return new IUniqueProcess(){

                public long getEarliestSeenTimestamp() {
                    return processThread.getEarliestSeenTimestamp();
                }

                public @Nullable Long getEndTimestamp() {
                    return processThread.getEndTimestamp();
                }

                public long getLastSeenTimestamp() {
                    return processThread.getLastSeenTimestamp();
                }

                public @Nullable String getName() {
                    IExecutablePath executablePath;
                    if (!processThread.isIdle() && !processThread.isKernel() && (executablePath = processThread.getExecutablePath()) != null) {
                        return executablePath.getBaseName();
                    }
                    return processThread.getName();
                }

                public int getOriginalID() {
                    return processThread.getOriginalID();
                }

                public @Nullable Long getStartTimestamp() {
                    return processThread.getStartTimestamp();
                }

                public int getUID() {
                    return uid;
                }

                public long getVmUID() {
                    return processThread.getVmUID();
                }

                public boolean isIdle() {
                    return processThread.isIdle();
                }

                public boolean isKernel() {
                    return processThread.isKernel();
                }
            };
        }

        private static /* synthetic */ void lambda$2(TIntSet tIntSet, IUniqueThread t) {
            if (t.isIdle() && !t.isIgnored()) {
                tIntSet.add(t.getUID());
            }
        }
    }
}

