/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.pass_one;

import com.arm.streamline.protocol.capture.apc.pass_one.ISpeSyncEventTracker;
import com.arm.utils.numbers.UnsignedLong;
import gnu.trove.map.TLongLongMap;
import gnu.trove.map.hash.TLongLongHashMap;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.function.LongUnaryOperator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class SpeSyncEventTracker
implements ISpeSyncEventTracker {
    private long archClockFreq;
    private final @NonNull TLongLongMap syncPointsByArchCountToMonotonicRaw = new TLongLongHashMap(10, 0.5f, 0L, 0L);

    @Override
    public @Nullable LongUnaryOperator getTimestampMapper() {
        if (this.syncPointsByArchCountToMonotonicRaw.isEmpty()) {
            return null;
        }
        assert (this.archClockFreq != 0L);
        long @NonNull [] archClockCounts = this.syncPointsByArchCountToMonotonicRaw.keys();
        UnsignedLong.sort((long[])archClockCounts);
        long @NonNull [] monotonicRaws = new long[archClockCounts.length];
        int i = 0;
        while (i < archClockCounts.length) {
            long value;
            long key = archClockCounts[i];
            monotonicRaws[i] = value = this.syncPointsByArchCountToMonotonicRaw.get(key);
            assert (i == 0 || UnsignedLong.compare((long)key, (long)archClockCounts[i - 1]) >= 0);
            assert (i == 0 || UnsignedLong.compare((long)value, (long)monotonicRaws[i - 1]) >= 0);
            ++i;
        }
        return new SpeTimestampMapper(this.archClockFreq, archClockCounts, monotonicRaws);
    }

    @Override
    public void track(int deviceNumber, long monotonicRaw, long archClockCount, long archClockFreq) {
        if (archClockFreq == 0L) {
            if (this.archClockFreq != 0L) {
                throw new IllegalArgumentException();
            }
            return;
        }
        if (this.archClockFreq == 0L) {
            this.archClockFreq = archClockFreq;
        } else if (this.archClockFreq != archClockFreq) {
            throw new IllegalArgumentException();
        }
        this.syncPointsByArchCountToMonotonicRaw.put(archClockCount, monotonicRaw);
    }

    private static final class SpeTimestampMapper
    implements LongUnaryOperator {
        private final long @NonNull [] archClockCounts;
        private final long archClockDivisor;
        private final long archClockMultiplier;
        private int lastSearchIndex;
        private final long @NonNull [] monotonicRaws;

        public SpeTimestampMapper(long archClockFreq, long @NonNull [] archClockCounts, long @NonNull [] monotonicRaws) {
            assert (archClockFreq != 0L);
            assert (archClockCounts.length == monotonicRaws.length);
            assert (archClockCounts.length > 0);
            this.archClockCounts = archClockCounts;
            this.monotonicRaws = monotonicRaws;
            BigInteger tmpTimestampMultiplier = BigInteger.valueOf(1000000000L);
            BigInteger tmpTimestampDivisor = BigInteger.valueOf(archClockFreq);
            BigInteger gcd = tmpTimestampMultiplier.gcd(tmpTimestampDivisor);
            this.archClockMultiplier = tmpTimestampMultiplier.divide(gcd).longValue();
            this.archClockDivisor = tmpTimestampDivisor.divide(gcd).longValue();
            this.lastSearchIndex = archClockCounts.length - 1;
        }

        @Override
        public long applyAsLong(long timestamp) {
            int syncPointIndex = this.findIndex(timestamp);
            assert (syncPointIndex == -1 || syncPointIndex >= 0 && syncPointIndex < this.archClockCounts.length);
            if (syncPointIndex >= 0) {
                long syncPoint = this.archClockCounts[syncPointIndex];
                long monotonicRaw = this.monotonicRaws[syncPointIndex];
                long syncPointNs = this.clockToNs(syncPoint);
                long timestampNs = this.clockToNs(timestamp);
                long deltaInNanoseconds = timestampNs - syncPointNs;
                long result = monotonicRaw + deltaInNanoseconds;
                assert (syncPointIndex + 1 >= this.archClockCounts.length || UnsignedLong.compare((long)result, (long)this.monotonicRaws[syncPointIndex + 1]) <= 0);
                return result;
            }
            long syncPoint = this.archClockCounts[0];
            long monotonicRaw = this.monotonicRaws[0];
            long syncPointNs = this.clockToNs(syncPoint);
            long timestampNs = this.clockToNs(timestamp);
            long deltaInNanoseconds = timestampNs - syncPointNs;
            long result = monotonicRaw + deltaInNanoseconds;
            assert (UnsignedLong.compare((long)result, (long)monotonicRaw) <= 0);
            return result;
        }

        private long clockToNs(long clock) {
            return clock * this.archClockMultiplier / this.archClockDivisor;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int findIndex(long timestamp) {
            int binarySearchLimit;
            int binarySearchBase;
            int lastSearchIndex = this.lastSearchIndex;
            if (lastSearchIndex >= 0 && UnsignedLong.compare((long)this.archClockCounts[lastSearchIndex], (long)timestamp) <= 0) {
                if (lastSearchIndex + 1 >= this.archClockCounts.length) {
                    return lastSearchIndex;
                }
                int sortOrder = UnsignedLong.compare((long)timestamp, (long)this.archClockCounts[lastSearchIndex + 1]);
                if (sortOrder < 0) {
                    return lastSearchIndex;
                }
                if (sortOrder <= 0) return lastSearchIndex + 1;
                binarySearchBase = lastSearchIndex + 1;
                binarySearchLimit = this.archClockCounts.length;
            } else {
                if (lastSearchIndex == -1 && UnsignedLong.compare((long)timestamp, (long)this.archClockCounts[0]) <= 0) {
                    return -1;
                }
                binarySearchBase = 0;
                binarySearchLimit = lastSearchIndex;
            }
            int searchResult = Arrays.binarySearch(this.archClockCounts, binarySearchBase, binarySearchLimit, timestamp);
            if (searchResult >= 0) {
                return searchResult;
            }
            int insertionPoint = -(searchResult + 1);
            return insertionPoint - 1;
        }
    }
}

