/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.pass_one;

import com.arm.streamline.protocol.capture.apc.pass_one.GatordLegacySyncThreadTracker;
import com.arm.streamline.protocol.capture.apc.pass_one.GatordModernSyncThreadTracker;
import com.arm.streamline.protocol.capture.apc.pass_one.IGatordSyncThreadTracker;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class GatordSyncThreadTracker
implements IGatordSyncThreadTracker {
    private @Nullable GatordLegacySyncThreadTracker legacyImplementation;
    private @Nullable GatordModernSyncThreadTracker modernImplementation;

    public static @NonNull GatordSyncThreadTracker legacy() {
        return new GatordSyncThreadTracker(true, false);
    }

    public static @NonNull GatordSyncThreadTracker modern() {
        return new GatordSyncThreadTracker(false, true);
    }

    private GatordSyncThreadTracker(boolean legacy, boolean modern) {
        this.legacyImplementation = legacy ? new GatordLegacySyncThreadTracker() : null;
        this.modernImplementation = modern ? new GatordModernSyncThreadTracker() : null;
    }

    @Override
    public boolean canCalculateLocalClockBase() {
        @Nullable GatordModernSyncThreadTracker modernImplementation = this.modernImplementation;
        if (modernImplementation != null && modernImplementation.canCalculateLocalClockBase()) {
            return true;
        }
        @Nullable GatordLegacySyncThreadTracker legacyImplementation = this.legacyImplementation;
        if (legacyImplementation != null && legacyImplementation.canCalculateLocalClockBase()) {
            return true;
        }
        return modernImplementation == null && legacyImplementation == null;
    }

    @Override
    public @Nullable Long getLocalClockBase(long monotonicTime) {
        @Nullable GatordModernSyncThreadTracker modernImplementation = this.modernImplementation;
        if (modernImplementation != null && modernImplementation.canCalculateLocalClockBase()) {
            return modernImplementation.getLocalClockBase(monotonicTime);
        }
        @Nullable GatordLegacySyncThreadTracker legacyImplementation = this.legacyImplementation;
        if (legacyImplementation != null) {
            return legacyImplementation.getLocalClockBase(monotonicTime);
        }
        return null;
    }

    public boolean isNoSync() {
        @Nullable GatordModernSyncThreadTracker modernImplementation = this.modernImplementation;
        @Nullable GatordLegacySyncThreadTracker legacyImplementation = this.legacyImplementation;
        return modernImplementation == null && legacyImplementation == null;
    }

    @Override
    public void setNoSync(boolean nosync) {
        if (nosync) {
            @Nullable GatordModernSyncThreadTracker modernImplementation = this.modernImplementation;
            if (modernImplementation != null) {
                modernImplementation.setNoSync(true);
            }
            this.modernImplementation = null;
            @Nullable GatordLegacySyncThreadTracker legacyImplementation = this.legacyImplementation;
            if (legacyImplementation != null) {
                legacyImplementation.setNoSync(true);
            }
            this.legacyImplementation = null;
        }
    }

    @Override
    public void trackComm(int tid, @NonNull String comm, @Nullable Long localClock) {
        @Nullable GatordModernSyncThreadTracker modernImplementation = this.modernImplementation;
        @Nullable GatordLegacySyncThreadTracker legacyImplementation = this.legacyImplementation;
        if (modernImplementation != null) {
            modernImplementation.trackComm(tid, comm, localClock);
        }
        if (legacyImplementation != null) {
            legacyImplementation.trackComm(tid, comm, localClock);
        }
        if ("gator-sync-0".contentEquals(comm)) {
            if (legacyImplementation != null) {
                legacyImplementation.setNoSync(true);
            }
            this.legacyImplementation = null;
        } else if ("gatord-sync".contentEquals(comm)) {
            if (modernImplementation != null) {
                modernImplementation.setNoSync(true);
            }
            this.modernImplementation = null;
        }
    }

    @Override
    public void trackSwitch(long localClock, int tid) {
        @Nullable GatordLegacySyncThreadTracker legacyImplementation = this.legacyImplementation;
        if (legacyImplementation != null) {
            legacyImplementation.trackSwitch(localClock, tid);
        }
    }
}

