/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.pass_one;

import com.arm.streamline.analysis.database.MetadataEntry;
import com.arm.streamline.analysis.model.SummaryRecord;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.streamline.protocol.capture.apc.pass_one.IGatorPassOneGlobalStateTracker;
import com.arm.streamline.protocol.capture.apc.pass_one.IPassOneGlobalStateNotificationCallbacks;
import com.arm.streamline.report.model.pe.ProcessingElementDescriptor;
import com.arm.streamline.report.model.pe.ProcessingElementTopology;
import gnu.trove.TCollections;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class GatorPassOneGlobalStateTracker
implements IGatorPassOneGlobalStateTracker {
    private boolean anyVmIsApplicationTracingMode;
    private final @NonNull IPassOneGlobalStateNotificationCallbacks callbacks;
    private final @NonNull Map<@NonNull String, @NonNull String> globalAttributes = new HashMap<String, String>();
    private @Nullable SummaryRecord globalSummary;
    private boolean iksPlatform;
    private final @NonNull Set<@NonNull MetadataEntry> metadata = new HashSet<MetadataEntry>();
    private final @NonNull Map<@NonNull ProcessingElementReference, @NonNull ProcessingElementDescriptor> processingElementProperties = new HashMap<ProcessingElementReference, ProcessingElementDescriptor>();
    private final @NonNull ProcessingElementReferenceSet processingElements;
    private final @NonNull TLongObjectMap<Map<@NonNull String, @NonNull String>> vmAttributes = new TLongObjectHashMap(10, 0.5f, 0L);

    public GatorPassOneGlobalStateTracker(@NonNull ProcessingElementReferenceSet processingElements, @NonNull IPassOneGlobalStateNotificationCallbacks callbacks) {
        this.processingElements = processingElements;
        this.callbacks = callbacks;
    }

    @Override
    public void captureSummary(long vmUID, long wallClockTime, long bootTime, long monotonicTime, @NonNull Map<@NonNull String, @NonNull String> attributes, boolean applicationTracingMode) throws IOException {
        if (this.globalSummary == null && vmUID == 0L) {
            this.globalSummary = new SummaryRecord(wallClockTime, OptionalLong.of(bootTime), OptionalLong.of(monotonicTime));
        }
        this.iksPlatform |= attributes.containsKey("iks");
        this.anyVmIsApplicationTracingMode |= applicationTracingMode;
        HashMap<@NonNull String, @NonNull String> map = (HashMap<String, String>)this.vmAttributes.get(vmUID);
        if (map == null) {
            map = new HashMap<String, String>();
            this.vmAttributes.put(vmUID, map);
        }
        map.putAll(attributes);
        this.callbacks.notifyApplicationTracingMode(vmUID, applicationTracingMode);
    }

    public @NonNull Map<@NonNull String, @NonNull String> getGlobalAttributes() {
        return Collections.unmodifiableMap(this.globalAttributes);
    }

    public @Nullable SummaryRecord getGlobalSummary() {
        return this.globalSummary;
    }

    public @NonNull Set<@NonNull MetadataEntry> getMetadata() {
        return this.metadata;
    }

    public @NonNull Map<@NonNull ProcessingElementReference, @NonNull ProcessingElementDescriptor> getProcessingElementProperties() {
        return Collections.unmodifiableMap(this.processingElementProperties);
    }

    public @NonNull TLongObjectMap<Map<@NonNull String, @NonNull String>> getVmAttributes() {
        return TCollections.unmodifiableMap(this.vmAttributes);
    }

    @Override
    public void globalSummary(long wallClockTime, @NonNull Map<@NonNull String, @NonNull String> attributes) {
        this.globalSummary = new SummaryRecord(wallClockTime, OptionalLong.empty(), OptionalLong.empty());
        this.globalAttributes.putAll(attributes);
    }

    public boolean hasApplicationTracingMode() {
        return this.anyVmIsApplicationTracingMode;
    }

    public boolean isIksPlatform() {
        return this.iksPlatform;
    }

    @Override
    public void metadata(long vmUID, int key, @NonNull String value) throws IOException {
        this.metadata.add(new MetadataEntry(vmUID, key, value));
    }

    @Override
    public void processingElementProperties(long vmUID, int deviceNumber, int identifierCode, @NonNull String name, @Nullable ProcessingElementTopology processingElementTopology) {
        @NonNull ProcessingElementReference peReference = this.processingElements.get(DeviceType.CPU, vmUID, deviceNumber);
        this.processingElementProperties.put(peReference, new ProcessingElementDescriptor(identifierCode, name, processingElementTopology));
    }
}

