/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.pass_one;

import com.arm.streamline.protocol.capture.apc.pass_one.ICookieTracker;
import gnu.trove.TCollections;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CookieTracker
implements ICookieTracker {
    private int internalIdCounter = 1;
    private final @NonNull TIntObjectMap<String> mapByInternalId = new TIntObjectHashMap(10, 0.5f, 0);
    private final @NonNull TObjectIntMap<String> mapToInternalId = new TObjectIntHashMap(10, 0.5f, 0);
    private final @NonNull TIntIntMap mapUIDToInternalId = new TIntIntHashMap(10, 0.5f, 0, 0);

    public CookieTracker() {
        this.mapByInternalId.put(-2, (Object)"idle");
        this.mapByInternalId.put(-3, (Object)"kernel");
    }

    @Override
    public @Nullable String getByInternalId(int internalId) {
        return (String)this.mapByInternalId.get(internalId);
    }

    @Override
    public @Nullable String getByUID(int cookieUID) {
        int internalId = this.mapUIDToInternalId(cookieUID);
        return (String)this.mapByInternalId.get(internalId);
    }

    @Override
    public @NonNull TIntObjectMap<String> getMappings() {
        return TCollections.unmodifiableMap(this.mapByInternalId);
    }

    @Override
    public int map(@NonNull String value) {
        if (value.isEmpty()) {
            return 0;
        }
        int internalId = this.mapToInternalId.get((Object)value);
        if (internalId == 0) {
            internalId = this.internalIdCounter++;
            this.mapToInternalId.put((Object)value, internalId);
            this.mapByInternalId.put(internalId, (Object)value);
        }
        return internalId;
    }

    @Override
    public int mapUIDToInternalId(int cookieUID) {
        if (cookieUID == -2 || cookieUID == -3 || cookieUID == 0 || cookieUID == -1) {
            return cookieUID;
        }
        return this.mapUIDToInternalId.get(cookieUID);
    }

    @Override
    public int set(int cookieUID, String value) {
        if (cookieUID == -2 || cookieUID == -3 || cookieUID == 0 || cookieUID == -1) {
            assert (value.isEmpty()) : "Contains cookie definition " + cookieUID + "='" + value + "'";
            return cookieUID;
        }
        if (value.isEmpty()) {
            assert (false) : "Empty cookie";
            return 0;
        }
        int internalId = this.map(value);
        this.mapUIDToInternalId.put(cookieUID, internalId);
        return internalId;
    }
}

