/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.live;

import com.arm.streamline.protocol.capture.apc.io.APCFrameAddress;
import com.arm.streamline.protocol.capture.apc.pass_one.IGatorPassOneTimestampTracker;
import com.arm.streamline.protocol.capture.apc.pass_one.IGatordSyncThreadTracker;
import com.arm.streamline.protocol.capture.apc.pass_one.ISpeSyncEventTracker;
import com.arm.streamline.protocol.capture.apc.protocol.DelayProcessingException;
import com.arm.streamline.protocol.capture.apc.protocol.external.ExternalProtocolMessageProperties;
import com.arm.streamline.protocol.capture.apc.time.ClockSource;
import com.arm.streamline.protocol.capture.apc.time.ITimestampMapper;
import com.arm.streamline.protocol.capture.apc.time.Timestamp;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class LiveGatorPassOneTimestampTracker
implements IGatorPassOneTimestampTracker,
ITimestampMapper {
    private @Nullable Long localClockBase;
    private @Nullable Long monotonicRawBase;
    private final @NonNull ISpeSyncEventTracker speSyncEventTracker;
    private final @NonNull IGatordSyncThreadTracker syncThreadTracker;

    private static long mapClock(@Nullable Long base, long time) {
        if (base == null) {
            throw new AssertionError();
        }
        return time - base;
    }

    private static @NonNull Long selectBase(@Nullable Long base, long time) {
        if (base == null || base == 0L) {
            return time;
        }
        return base;
    }

    private static boolean useMonotonicRawForLocalClock(long localClockBase, @Nullable Long monotonicRawBase) {
        if (monotonicRawBase == null) {
            return false;
        }
        long delta = Math.abs(monotonicRawBase - localClockBase);
        return delta < 1000000000L;
    }

    public LiveGatorPassOneTimestampTracker(@NonNull IGatordSyncThreadTracker syncThreadTracker, @NonNull ISpeSyncEventTracker speSyncEventTracker) {
        this.syncThreadTracker = syncThreadTracker;
        this.speSyncEventTracker = speSyncEventTracker;
    }

    @Override
    public void addTimesyncEvent(long monotonicDelta, long localClock) {
        this.localClockBase = LiveGatorPassOneTimestampTracker.selectBase(this.localClockBase, localClock - monotonicDelta);
        this.syncThreadTracker.setNoSync(true);
    }

    @Override
    public void deferFrame(@NonNull APCFrameAddress address) {
    }

    @Override
    public long mapLocalClock(long time) throws DelayProcessingException {
        return this.mapLocalClockOrMonotonicRaw(time);
    }

    @Override
    public long mapLocalClockOrMonotonicRaw(long time) throws DelayProcessingException {
        @Nullable Long localClockBase = this.localClockBase;
        if (localClockBase != null) {
            return LiveGatorPassOneTimestampTracker.mapClock(localClockBase, time);
        }
        throw new DelayProcessingException();
    }

    @Override
    public long mapMonotonicDelta(long time) {
        return time;
    }

    @Override
    public long mapMonotonicRaw(long time) throws DelayProcessingException {
        @Nullable Long monotonicRawBase = this.monotonicRawBase;
        if (monotonicRawBase != null) {
            return LiveGatorPassOneTimestampTracker.mapClock(monotonicRawBase, time);
        }
        throw new DelayProcessingException();
    }

    @Override
    public long mapSpeClock(int deviceNumber, long clock) {
        return -1L;
    }

    @Override
    public void setSummaryInformation(long monotonicTime, boolean nosync) {
        this.syncThreadTracker.setNoSync(nosync);
        this.monotonicRawBase = LiveGatorPassOneTimestampTracker.selectBase(this.monotonicRawBase, monotonicTime);
        if (nosync) {
            this.localClockBase = LiveGatorPassOneTimestampTracker.selectBase(this.localClockBase, monotonicTime);
        } else {
            this.updateLocalClockBase();
        }
    }

    @Override
    public void trackExternalFrame(@NonNull APCFrameAddress address, @NonNull ExternalProtocolMessageProperties properties) {
    }

    @Override
    public @NonNull Timestamp trackNonPerfTimestamp(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long timestamp) {
        return this.createTimetstamp(clockSource, timestamp);
    }

    @Override
    public @NonNull Timestamp trackPerfTimestamp(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long timestamp, int deviceNumber) {
        return this.trackNonPerfTimestamp(address, clockSource, timestamp);
    }

    @Override
    public void trackPossibleSyncThreadComm(int tid, @NonNull String comm, @Nullable Long localClock) {
        this.syncThreadTracker.trackComm(tid, comm, localClock);
        this.updateLocalClockBase();
    }

    @Override
    public void trackPossibleSyncThreadTaskSwitch(long localClock, int nextTid) {
        this.syncThreadTracker.trackSwitch(localClock, nextTid);
        this.updateLocalClockBase();
    }

    @Override
    public void trackSpeSyncEvent(int deviceNumber, long monotonicRaw, long archClockCount, long archClockFreq) {
        this.speSyncEventTracker.track(deviceNumber, monotonicRaw, archClockCount, archClockFreq);
    }

    @Override
    public void updateTimeRange(@NonNull ClockSource clockSource, long timestamp) {
        this.createTimetstamp(clockSource, timestamp);
    }

    private @NonNull Timestamp createTimetstamp(@NonNull ClockSource clockSource, long timestamp) {
        @Nullable Long localClockBase = this.localClockBase;
        @Nullable Long monotonicRawBase = this.monotonicRawBase;
        switch (clockSource) {
            case BEFORE_START: {
                return Timestamp.BEFORE_START;
            }
            case LOCAL_CLOCK: 
            case LOCAL_CLOCK_OR_MONOTONIC_RAW: {
                if (localClockBase != null) break;
                return Timestamp.BEFORE_START;
            }
            case MONOTONIC_DELTA: {
                break;
            }
            case MONOTONIC_RAW: {
                if (monotonicRawBase != null) break;
                return Timestamp.BEFORE_START;
            }
            default: {
                throw new AssertionError((Object)clockSource);
            }
        }
        return new Timestamp(clockSource, timestamp);
    }

    private void updateLocalClockBase() {
        @Nullable Long monotonicRawBase = this.monotonicRawBase;
        @Nullable Long localClockBase = this.localClockBase;
        if (monotonicRawBase != null && localClockBase == null && this.syncThreadTracker.canCalculateLocalClockBase()) {
            @Nullable Long base = this.syncThreadTracker.getLocalClockBase(monotonicRawBase);
            this.syncThreadTracker.setNoSync(true);
            @Nullable Long newLocalClockBase = base == null ? LiveGatorPassOneTimestampTracker.selectBase(localClockBase, monotonicRawBase) : LiveGatorPassOneTimestampTracker.selectBase(localClockBase, base);
            this.localClockBase = LiveGatorPassOneTimestampTracker.useMonotonicRawForLocalClock(newLocalClockBase, monotonicRawBase) ? monotonicRawBase : newLocalClockBase;
        }
    }
}

