/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.io;

import com.arm.streamline.protocol.capture.apc.io.APCFrame;
import com.arm.streamline.protocol.capture.apc.io.IAPCCaptureFrameStream;
import com.arm.streamline.protocol.capture.apc.io.IAPCCaptureFrameWriter;
import com.arm.streamline.protocol.capture.apc.io.IAPCLiveFrameCapturer;
import com.arm.streamline.protocol.capture.apc.io.IAPCLiveFrameSource;
import java.io.EOFException;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class APCLiveFrameCapturer
implements IAPCCaptureFrameStream,
IAPCLiveFrameCapturer {
    private final @NonNull AtomicBoolean eosFlag = new AtomicBoolean(false);
    private final @NonNull Queue<APCFrame> frameQueue;
    private final @NonNull IAPCLiveFrameSource frameSource;
    private final @NonNull IAPCCaptureFrameWriter frameWriter;
    private final @NonNull Object waitObject = new Object();

    public APCLiveFrameCapturer(@NonNull IAPCLiveFrameSource frameSource, @NonNull IAPCCaptureFrameWriter frameWriter, byte[] ... extraFrames) throws IOException {
        this.frameSource = frameSource;
        this.frameWriter = frameWriter;
        this.frameQueue = new ConcurrentLinkedQueue<APCFrame>();
        byte[][] byArray = extraFrames;
        int n = extraFrames.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] frame = byArray[n2];
            this.addFrame(frame);
            ++n2;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.eosFlag.set(true);
        }
        finally {
            this.frameWriter.close();
        }
    }

    @Override
    public boolean consumeOneFrameFromSource() throws IOException {
        block4: {
            if (this.eosFlag.get()) {
                return false;
            }
            try {
                byte @Nullable [] data = this.frameSource.nextFrame();
                if (data == null) break block4;
                this.addFrame(data);
                return true;
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.eosFlag.set(true);
                throw t;
            }
        }
        this.eosFlag.set(true);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull APCFrame nextFrame() throws IOException {
        while (!this.eosFlag.get() || !this.frameQueue.isEmpty()) {
            APCFrame result = this.frameQueue.poll();
            if (result != null) {
                return result;
            }
            Object object = this.waitObject;
            synchronized (object) {
                try {
                    this.waitObject.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        throw new EOFException();
    }

    private void addFrame(byte @NonNull [] data) throws IOException {
        assert (data.length > 0);
        @NonNull APCFrame frame = this.frameWriter.writeFrame(data);
        this.frameQueue.add(frame);
    }
}

