/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.io;

import com.arm.streamline.protocol.capture.apc.APCFile;
import com.arm.utils.numbers.UnsignedLong;
import org.eclipse.jdt.annotation.NonNull;

public final class APCFrameAddress
implements Comparable<APCFrameAddress> {
    public final int length;
    public final @NonNull APCFile sourceFile;
    public final long sourceOffset;

    public APCFrameAddress(@NonNull APCFile sourceFile, long sourceOffset, int length) {
        this.sourceFile = sourceFile;
        this.sourceOffset = sourceOffset;
        this.length = length;
    }

    @Override
    public int compareTo(APCFrameAddress o) {
        int fileResult = this.sourceFile.compareTo(o.sourceFile);
        if (fileResult != 0) {
            return fileResult;
        }
        return UnsignedLong.compare((long)this.sourceOffset, (long)o.sourceOffset);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof APCFrameAddress) {
            APCFrameAddress that = (APCFrameAddress)obj;
            return this.sourceOffset == that.sourceOffset && this.length == that.length && this.sourceFile.equals(that.sourceFile);
        }
        return false;
    }

    public int hashCode() {
        return Long.hashCode(this.sourceOffset);
    }

    public @NonNull APCFrameAddress subMessage(int offset, int length) {
        assert (offset >= 0);
        assert (offset + length <= this.length);
        return new APCFrameAddress(this.sourceFile, this.sourceOffset + (long)offset, length);
    }

    public String toString() {
        return String.format("%s@%d+%s", this.sourceFile, this.sourceOffset, Integer.toUnsignedString(this.length));
    }
}

