/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.io;

import com.arm.streamline.protocol.capture.apc.APCFile;
import com.arm.streamline.protocol.capture.apc.io.APCFrame;
import com.arm.streamline.protocol.capture.apc.io.APCFrameAddress;
import com.arm.streamline.protocol.capture.apc.io.IAPCCaptureFrameWriter;
import com.arm.utils.function.Throwing;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class APCCaptureFrameWriter
implements IAPCCaptureFrameWriter {
    private static final int MAX_FILE_SIZE = 0x40000000;
    private static final String TEMP_SUFFIX = ".temp";
    private final @NonNull File apcDirectory;
    private @NonNull APCFile currentFile;
    private int nextFileIndex;
    private @Nullable OutputStream outputStream;
    private long writeOffset;
    private final long maxFileSize;

    public APCCaptureFrameWriter(@NonNull File apcDirectory) throws IOException {
        this(apcDirectory, 0x40000000L);
    }

    APCCaptureFrameWriter(@NonNull File apcDirectory, long maxFileSize) throws IOException {
        if (maxFileSize <= 0L) {
            throw new IllegalArgumentException();
        }
        this.apcDirectory = apcDirectory;
        this.maxFileSize = maxFileSize;
        this.currentFile = new APCFile(0, new File(apcDirectory, "0000000000"));
        this.writeOffset = 0L;
        this.nextFileIndex = 0;
        this.nextDataFile();
    }

    @Override
    public void close() {
        try {
            @Nullable OutputStream outputStream = this.outputStream;
            if (outputStream != null) {
                this.closeCurrentFile(outputStream);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public @NonNull APCFrame writeFrame(byte @NonNull [] data) throws IOException {
        @Nullable OutputStream outputStream = this.outputStream;
        assert (outputStream != null);
        assert (data.length > 0);
        outputStream.write(new byte[]{(byte)data.length, (byte)(data.length >>> 8), (byte)(data.length >>> 16), (byte)(data.length >>> 24)});
        this.writeOffset += 4L;
        long dataOffset = this.writeOffset;
        outputStream.write(data);
        this.writeOffset += (long)data.length;
        @NonNull APCFrameAddress frameAddress = new APCFrameAddress(this.currentFile, dataOffset, data.length);
        @NonNull APCFrame frame = new APCFrame(frameAddress, data);
        if (this.writeOffset > this.maxFileSize) {
            this.nextDataFile();
        }
        return frame;
    }

    private void closeCurrentFile(@NonNull OutputStream outputStream) throws IOException {
        outputStream.flush();
        outputStream.close();
        this.outputStream = null;
        this.rename();
    }

    private void nextDataFile() throws IOException {
        @Nullable OutputStream outputStream = this.outputStream;
        if (outputStream != null) {
            this.closeCurrentFile(outputStream);
        }
        String name = String.format("%010d", this.nextFileIndex);
        File file = new File(this.apcDirectory, name + TEMP_SUFFIX);
        this.currentFile = new APCFile(this.nextFileIndex, new File(this.apcDirectory, name));
        ++this.nextFileIndex;
        this.writeOffset = 0L;
        this.outputStream = (OutputStream)Throwing.closeIfThrows(BufferedOutputStream::new, (Object)new FileOutputStream(file), (Closeable[])new Closeable[0]);
    }

    private void rename() {
        @NonNull File from = new File(this.currentFile.file.getParentFile(), this.currentFile.file.getName() + TEMP_SUFFIX);
        @NonNull File to = this.currentFile.file;
        from.renameTo(to);
    }
}

