/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc;

import com.arm.utils.NullChecking;
import java.io.File;
import org.eclipse.jdt.annotation.NonNull;

public final class APCFile
implements Comparable<APCFile> {
    public final @NonNull File file;
    public final int index;

    public APCFile(int index, @NonNull File file) {
        this.index = index;
        this.file = file;
    }

    @Override
    public int compareTo(APCFile o) {
        assert (NullChecking.equalsNullable((Object)this.file.getParentFile(), (Object)o.file.getParentFile()));
        return Integer.compare(this.index, o.index);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof APCFile) {
            APCFile that = (APCFile)obj;
            return this.index == that.index && this.file.equals(that.file);
        }
        return false;
    }

    public int hashCode() {
        return this.index;
    }

    public String toString() {
        return String.format("%d[%s]", this.index, this.file);
    }
}

