/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc;

import com.arm.streamline.protocol.capture.apc.APCFile;
import com.arm.utils.NullChecking;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class APCDirectory
implements Iterable<File> {
    private static final @NonNull FileFilter CAPTURE_FILE_FILTER = file -> {
        if (!file.isFile()) {
            return false;
        }
        @NonNull String filename = file.getName();
        return filename.matches("^\\d{10}$");
    };
    private final @NonNull APCFile @NonNull [] captureFiles;
    private final @NonNull File directory;

    public APCDirectory(@NonNull File directory) throws IOException {
        this.directory = directory;
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(directory.getAbsolutePath() + " is not a directory");
        }
        @NonNull File @Nullable [] filesInDirectory = directory.listFiles(CAPTURE_FILE_FILTER);
        if (filesInDirectory == null || filesInDirectory.length == 0) {
            throw new FileNotFoundException("No files in " + directory.getPath());
        }
        this.captureFiles = new APCFile[filesInDirectory.length];
        File[] fileArray = filesInDirectory;
        int n = filesInDirectory.length;
        int n2 = 0;
        while (n2 < n) {
            File captureFile = fileArray[n2];
            int index = Integer.parseInt(captureFile.getName(), 10);
            if (index < 0 || index >= filesInDirectory.length || NullChecking.nullable((Object)this.captureFiles[index]) != null) {
                throw new IOException("Invalid capture directory");
            }
            this.captureFiles[index] = new APCFile(index, captureFile);
            ++n2;
        }
    }

    public int count() {
        return this.captureFiles.length;
    }

    public @NonNull Stream<@NonNull File> files() {
        return Stream.of(this.captureFiles).map(f -> f.file);
    }

    public @NonNull APCFile get(int index) {
        return this.captureFiles[index];
    }

    public @NonNull File getDirectory() {
        return this.directory;
    }

    public boolean isEmpty() {
        return this.totalLength() == 0L;
    }

    @Override
    public @NonNull Iterator<@NonNull File> iterator() {
        return this.files().iterator();
    }

    public long totalLength() {
        return this.files().mapToLong(File::length).sum();
    }
}

