/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.perf.records;

import com.arm.streamline.perf.InvalidPerfDataException;
import com.arm.streamline.perf.io.StringIO;
import com.arm.streamline.perf.records.EventAttribute;
import com.arm.streamline.perf.records.EventHeader;
import com.arm.streamline.perf.records.ReadFormat;
import com.arm.streamline.perf.records.RegisterValues;
import com.arm.utils.NullChecking;
import com.arm.utils.datainput.LittleEndianDataOutput;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class RecordBlob {
    private static final long ABI_32_REG_MASK = 65535L;
    private static final long ABI_32_REG_REQ = 49152L;
    private static final long ABI_64_REG_MASK = 0x1FFFFFFFFL;
    private static final long ABI_64_REG_REQ = 0x140000000L;
    private static final long SIZE_OF_PERF_BRANCH_ENTRY = 24L;
    private final @NonNull EventHeader header;
    private final byte @NonNull [] payload;

    private static @NonNull ByteBuffer createByteBuffer(byte @NonNull [] payload, @NonNull ByteOrder byteOrder) {
        return ByteBuffer.wrap(payload).order(byteOrder);
    }

    private static boolean isValid32BitRegMask(long sampleRegisters) {
        return (sampleRegisters & 0xFFFFFFFFFFFF0000L) == 0L && (sampleRegisters & 0xC000L) == 49152L;
    }

    private static boolean isValid64BitRegMask(long sampleRegisters) {
        return (sampleRegisters & 0xFFFFFFFE00000000L) == 0L && (sampleRegisters & 0x140000000L) == 0x140000000L;
    }

    public RecordBlob(@NonNull ByteBuffer input) throws IOException {
        try {
            this.header = EventHeader.fromByteBuffer(input);
            this.payload = new byte[this.header.getPayloadSizeAsInt()];
            input.get(this.payload);
        }
        catch (BufferUnderflowException e) {
            throw new IOException(e);
        }
    }

    public RecordBlob(@NonNull DataInput input) throws IOException {
        this.header = EventHeader.fromDataInput(input);
        this.payload = new byte[this.header.getPayloadSizeAsInt()];
        input.readFully(this.payload);
    }

    public RecordBlob(@NonNull EventHeader header, byte @NonNull [] payload) {
        this.header = header;
        this.payload = payload;
        int payloadLength = header.getPayloadSizeAsInt();
        if (payloadLength != payload.length) {
            throw new IllegalArgumentException("Expected payload length " + payloadLength + " but it's " + payload.length);
        }
        if ((payloadLength & 7) != 0) {
            throw new IllegalArgumentException("payload length isn't a multiple of 8");
        }
    }

    public <T, R, E extends Throwable> R accept(@NonNull IRecordBlobVisitor<T, R, E> visitor, @NonNull SampleId sampleId, @NonNull ByteOrder byteOrder, T data) throws InvalidPerfDataException, E {
        ByteBuffer buffer = ByteBuffer.wrap(this.payload).order(byteOrder);
        switch (this.header.getType()) {
            case 1: {
                int pid = buffer.getInt();
                int tid = buffer.getInt();
                long addr = buffer.getLong();
                long len = buffer.getLong();
                long pgOff = buffer.getLong();
                String filename = StringIO.readFixedStringNullTerminated(buffer, buffer.remaining() - sampleId.getSize());
                return visitor.mmap(this.header, sampleId, pid, tid, addr, len, pgOff, filename, data);
            }
            case 10: {
                int pid = buffer.getInt();
                int tid = buffer.getInt();
                long addr = buffer.getLong();
                long len = buffer.getLong();
                long pgOff = buffer.getLong();
                int maj = buffer.getInt();
                int min = buffer.getInt();
                long ino = buffer.getLong();
                long ino_generation = buffer.getLong();
                int prot = buffer.getInt();
                int flags = buffer.getInt();
                String filename = StringIO.readFixedStringNullTerminated(buffer, buffer.remaining() - sampleId.getSize());
                return visitor.mmap2(this.header, sampleId, pid, tid, addr, len, pgOff, maj, min, ino, ino_generation, prot, flags, filename, data);
            }
            case 2: {
                long id = buffer.getLong();
                long lost = buffer.getLong();
                return visitor.lost(this.header, sampleId, id, lost, data);
            }
            case 3: {
                int pid = buffer.getInt();
                int tid = buffer.getInt();
                String comm = StringIO.readFixedStringNullTerminated(buffer, buffer.remaining() - sampleId.getSize());
                return visitor.comm(this.header, sampleId, pid, tid, comm, data);
            }
            case 4: {
                int pid = buffer.getInt();
                int ppid = buffer.getInt();
                int tid = buffer.getInt();
                int ptid = buffer.getInt();
                long time = buffer.getLong();
                return visitor.exit(this.header, sampleId, ppid, ptid, pid, tid, time, data);
            }
            case 5: {
                long time = buffer.getLong();
                long id = buffer.getLong();
                long streamId = buffer.getLong();
                return visitor.throttle(this.header, sampleId, time, id, streamId, data);
            }
            case 6: {
                long time = buffer.getLong();
                long id = buffer.getLong();
                long streamId = buffer.getLong();
                return visitor.unthrottle(this.header, sampleId, time, id, streamId, data);
            }
            case 7: {
                int pid = buffer.getInt();
                int ppid = buffer.getInt();
                int tid = buffer.getInt();
                int ptid = buffer.getInt();
                long time = buffer.getLong();
                return visitor.fork(this.header, sampleId, ppid, ptid, pid, tid, time, data);
            }
            case 8: {
                @Nullable Long defaultId = sampleId.getAttributeId();
                @Nullable EventAttribute event = sampleId.attribute;
                int pid = buffer.getInt();
                int tid = buffer.getInt();
                ReadFormat readFormat = new ReadFormat(defaultId != null ? defaultId : Long.valueOf(0L), event != null ? event.getReadFormat() : 0L, buffer::getLong);
                return visitor.read(this.header, sampleId, pid, tid, readFormat, data);
            }
            case 9: {
                if (sampleId instanceof SampleRecord) {
                    byte[] raw;
                    long[] callchain;
                    SampleRecord sampleRecord = (SampleRecord)sampleId;
                    @NonNull EventAttribute attribute = (EventAttribute)NullChecking.neverNull((Object)sampleRecord.attribute);
                    RegisterValues registers = null;
                    IRecordBlobVisitor.Abi registersAbi = IRecordBlobVisitor.Abi.NONE;
                    boolean registersHostIs64bit = false;
                    @Nullable ReadFormat readFormat = sampleRecord.getReadFormat();
                    if ((attribute.getSampleType() & 0x20L) != 0L) {
                        long length = sampleRecord.buffer.getLong();
                        if (length < 0L || length > Integer.MAX_VALUE) {
                            throw new IndexOutOfBoundsException();
                        }
                        callchain = new long[(int)length];
                        int i = 0;
                        while (i < callchain.length) {
                            callchain[i] = sampleRecord.buffer.getLong();
                            ++i;
                        }
                    } else {
                        callchain = null;
                    }
                    if ((attribute.getSampleType() & 0x400L) != 0L) {
                        int length = sampleRecord.buffer.getInt();
                        if (length < 0 || length > Integer.MAX_VALUE) {
                            throw new IndexOutOfBoundsException();
                        }
                        raw = new byte[length];
                        sampleRecord.buffer.get(raw);
                    } else {
                        raw = null;
                    }
                    if ((attribute.getSampleType() & 0x800L) != 0L && sampleRecord.buffer.hasRemaining()) {
                        long num = sampleRecord.buffer.getLong();
                        if (num < 0L || num > Integer.MAX_VALUE) {
                            throw new IndexOutOfBoundsException();
                        }
                        long newPosition = Math.min((long)sampleRecord.buffer.position() + num * 24L, (long)sampleRecord.buffer.limit());
                        sampleRecord.buffer.position((int)newPosition);
                    }
                    if ((attribute.getSampleType() & 0x1000L) != 0L && sampleRecord.buffer.hasRemaining()) {
                        boolean registersAreValid;
                        long abi = sampleRecord.buffer.getLong();
                        long sampleRegisters = attribute.getSampleRegsUser();
                        int nBits = Long.bitCount(sampleRegisters);
                        assert (abi == 0L || abi == 1L || abi == 2L);
                        if (abi != 0L) {
                            int remainingLongs = sampleRecord.buffer.remaining() / 8;
                            int numRegistersToRead = Math.min(nBits, remainingLongs);
                            assert (numRegistersToRead < 64);
                            if (numRegistersToRead > 0) {
                                int[] registerNumbers = new int[numRegistersToRead];
                                long[] registerValues = new long[numRegistersToRead];
                                int registerIndex = 0;
                                int i = 0;
                                while (i < 64 && registerIndex < numRegistersToRead) {
                                    boolean registerRequested;
                                    long registerMask = 1L << i;
                                    boolean bl = registerRequested = (sampleRegisters & registerMask) != 0L;
                                    if (registerRequested) {
                                        registerNumbers[registerIndex] = i;
                                        registerValues[registerIndex] = sampleRecord.buffer.getLong();
                                        ++registerIndex;
                                    }
                                    ++i;
                                }
                                assert (registerIndex == numRegistersToRead);
                                registersAbi = IRecordBlobVisitor.Abi.find(abi);
                                registers = new RegisterValues(registerNumbers, registerValues);
                            }
                        }
                        switch (registersAbi) {
                            case ABI_64: {
                                registersAreValid = RecordBlob.isValid64BitRegMask(sampleRegisters);
                                registersHostIs64bit = true;
                                break;
                            }
                            case ABI_32: {
                                registersHostIs64bit = RecordBlob.isValid64BitRegMask(sampleRegisters);
                                registersAreValid = registersHostIs64bit || RecordBlob.isValid32BitRegMask(sampleRegisters);
                                break;
                            }
                            case NONE: {
                                registersAreValid = false;
                                registersHostIs64bit = false;
                                break;
                            }
                            default: {
                                throw new AssertionError((Object)registersAbi);
                            }
                        }
                        if (!registersAreValid) {
                            registersAbi = IRecordBlobVisitor.Abi.NONE;
                            registers = null;
                        }
                    }
                    return visitor.sample(this.header, sampleRecord, readFormat, callchain, raw, registersHostIs64bit, registersAbi, registers, data);
                }
                throw new AssertionError();
            }
            case 11: {
                long offset = buffer.getLong();
                long size = buffer.getLong();
                long flags = buffer.getLong();
                return visitor.aux(this.header, sampleId, offset, size, flags, data);
            }
            case 12: {
                int pid = buffer.getInt();
                int tid = buffer.getInt();
                return visitor.itraceStart(this.header, sampleId, pid, tid, data);
            }
            case 13: {
                long lost = buffer.getLong();
                return visitor.lostSamples(this.header, sampleId, lost, data);
            }
            case 14: {
                return visitor.swtch(this.header, sampleId, data);
            }
            case 15: {
                int pid = buffer.getInt();
                int tid = buffer.getInt();
                return visitor.swtchCpuWide(this.header, sampleId, pid, tid, data);
            }
            case 32769: {
                int length = buffer.getInt();
                byte[] bytes = new byte[length];
                buffer.get(bytes);
                String kallsyms = new String(bytes, StandardCharsets.UTF_8);
                return visitor.simplePerfKAllSyms(this.header, sampleId, kallsyms, data);
            }
            case 32775: {
                int pid = buffer.getInt();
                int tid = buffer.getInt();
                long chainType = buffer.getLong();
                long timestamp = buffer.getLong();
                int numIPs = Math.toIntExact(buffer.getLong());
                long[] ips = new long[numIPs];
                long[] sps = new long[numIPs];
                int i = 0;
                while (i < numIPs) {
                    ips[i] = buffer.getLong();
                    ++i;
                }
                i = 0;
                while (i < numIPs) {
                    sps[i] = buffer.getLong();
                    ++i;
                }
                return visitor.simplePerfCallchain(this.header, sampleId, pid, tid, chainType, timestamp, ips, sps, data);
            }
        }
        return visitor.other(this.header, sampleId, buffer, data);
    }

    public boolean equals(Object obj) {
        if (obj instanceof RecordBlob) {
            RecordBlob that = (RecordBlob)obj;
            return this.header.equals(that.header) && Arrays.equals(this.payload, that.payload);
        }
        return false;
    }

    public byte @NonNull [] getBytes() throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        this.header.write((DataOutput)new LittleEndianDataOutput((OutputStream)result));
        result.write(this.payload);
        return (byte[])NullChecking.neverNull((Object)result.toByteArray());
    }

    public @NonNull EventHeader getHeader() {
        return this.header;
    }

    public byte @NonNull [] getPayload() {
        return this.payload;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.header.hashCode();
        result = 31 * result + Arrays.hashCode(this.payload);
        return result;
    }

    public @NonNull SampleId parseSampleId(@NonNull ByteOrder byteOrder, long idBits, @NonNull IIdToAttributeMap attributesById) throws InvalidPerfDataException {
        int type = this.header.getType();
        if (type == 9) {
            SampleRecord sampleRecord = this.parseSampleRecord(byteOrder, idBits, attributesById);
            return sampleRecord;
        }
        if (type == 2) {
            return new SampleId(null, null, null, null, null, null, null, null, null);
        }
        if (type < 64) {
            Long identifier;
            EventAttribute event;
            Long attributeId;
            ByteBuffer buffer = RecordBlob.createByteBuffer(this.payload, byteOrder);
            if ((idBits & 0x10000L) != 0L || (idBits & 0x40L) != 0L) {
                int idOffset;
                int n = (idBits & 0x10000L) != 0L ? 8 : (idOffset = ((idBits & 0x40L) != 0L ? 8 : 0) + ((idBits & 0x200L) != 0L ? 8 : 0) + ((idBits & 0x80L) != 0L ? 8 : 0));
                if (idOffset > this.payload.length) {
                    throw new AssertionError();
                }
                buffer.position(this.payload.length - idOffset);
                attributeId = buffer.getLong();
            } else {
                attributeId = null;
            }
            try {
                event = attributesById.getEventAttributeById(attributeId);
            }
            catch (InvalidPerfDataException e) {
                if (attributeId != null && attributeId == 0L) {
                    return new SampleId(null, null, null, null, null, null, null, null, null);
                }
                throw e;
            }
            long sampleType = event.getSampleType();
            int readPosition = ((sampleType & 0x10000L) != 0L ? 8 : 0) + ((sampleType & 0x80L) != 0L ? 8 : 0) + ((sampleType & 0x200L) != 0L ? 8 : 0) + ((sampleType & 0x40L) != 0L ? 8 : 0) + ((sampleType & 4L) != 0L ? 8 : 0) + ((sampleType & 2L) != 0L ? 8 : 0);
            if (readPosition > this.payload.length) {
                throw new AssertionError();
            }
            buffer.position(this.payload.length - readPosition);
            Integer pid = (sampleType & 2L) != 0L ? Integer.valueOf(buffer.getInt()) : null;
            Integer tid = (sampleType & 2L) != 0L ? Integer.valueOf(buffer.getInt()) : null;
            Long time = (sampleType & 4L) != 0L ? Long.valueOf(buffer.getLong()) : null;
            Long id = (sampleType & 0x40L) != 0L ? Long.valueOf(buffer.getLong()) : null;
            Long stream_id = (sampleType & 0x200L) != 0L ? Long.valueOf(buffer.getLong()) : null;
            Integer cpu = (sampleType & 0x80L) != 0L ? Integer.valueOf(buffer.getInt()) : null;
            Integer res = (sampleType & 0x80L) != 0L ? Integer.valueOf(buffer.getInt()) : null;
            Long l = identifier = (sampleType & 0x10000L) != 0L ? Long.valueOf(buffer.getLong()) : null;
            assert (attributeId == null && id == null && identifier == null || (id == null || attributeId != null && attributeId.equals(id)) && (identifier == null || attributeId != null && attributeId.equals(identifier)));
            return new SampleId(event, identifier, pid, tid, time, id, stream_id, cpu, res);
        }
        return new SampleId(null, null, null, null, null, null, null, null, null);
    }

    public @NonNull SampleRecord parseSampleRecord(@NonNull ByteOrder byteOrder, long idBits, @NonNull IIdToAttributeMap attributesById) throws InvalidPerfDataException {
        Long id;
        Long identifier;
        assert (this.header.getType() == 9);
        @NonNull ByteBuffer buffer = RecordBlob.createByteBuffer(this.payload, byteOrder);
        EventAttribute event = null;
        if ((idBits & 0x10000L) != 0L) {
            identifier = buffer.getLong();
            event = attributesById.getEventAttributeById(identifier);
            idBits = event.getSampleType();
        } else {
            identifier = null;
        }
        Long ip = (idBits & 1L) != 0L ? Long.valueOf(buffer.getLong()) : null;
        Integer pid = (idBits & 2L) != 0L ? Integer.valueOf(buffer.getInt()) : null;
        Integer tid = (idBits & 2L) != 0L ? Integer.valueOf(buffer.getInt()) : null;
        Long time = (idBits & 4L) != 0L ? Long.valueOf(buffer.getLong()) : null;
        Long addr = (idBits & 8L) != 0L ? Long.valueOf(buffer.getLong()) : null;
        Long l = id = (idBits & 0x40L) != 0L ? Long.valueOf(buffer.getLong()) : null;
        if (event == null) {
            event = attributesById.getEventAttributeById(id);
        }
        assert (event != null);
        long sampleType = event.getSampleType();
        Long stream_id = (sampleType & 0x200L) != 0L ? Long.valueOf(buffer.getLong()) : null;
        Integer cpu = (sampleType & 0x80L) != 0L ? Integer.valueOf(buffer.getInt()) : null;
        Integer res = (sampleType & 0x80L) != 0L ? Integer.valueOf(buffer.getInt()) : null;
        Long period = (sampleType & 0x100L) != 0L ? Long.valueOf(buffer.getLong()) : null;
        return new SampleRecord(event, identifier, ip, pid, tid, time, addr, id, stream_id, cpu, res, period, buffer);
    }

    public String toString() {
        StringBuilder payloadStr = new StringBuilder();
        int i = 0;
        while (i < Math.min(32, this.payload.length)) {
            int byteVal = this.payload[i] & 0xFF;
            if (i > 0) {
                payloadStr.append(", ");
            }
            payloadStr.append("0x");
            if (byteVal < 16) {
                payloadStr.append("0");
            }
            payloadStr.append(Integer.toHexString(byteVal));
            ++i;
        }
        if (this.payload.length > 32) {
            payloadStr.append(", ...");
        }
        return String.format("RecordBlob [header=%s, payload=[%s]]", this.header, payloadStr);
    }

    public static interface IIdToAttributeMap {
        public @NonNull EventAttribute getEventAttributeById(@Nullable Long var1) throws InvalidPerfDataException;
    }

    public static interface IRecordBlobVisitor<T, R, E extends Throwable> {
        public R aux(@NonNull EventHeader var1, @NonNull SampleId var2, long var3, long var5, long var7, T var9) throws E;

        public R comm(@NonNull EventHeader var1, @NonNull SampleId var2, int var3, int var4, @NonNull String var5, T var6) throws E;

        public R exit(@NonNull EventHeader var1, @NonNull SampleId var2, int var3, int var4, int var5, int var6, long var7, T var9) throws E;

        public R fork(@NonNull EventHeader var1, @NonNull SampleId var2, int var3, int var4, int var5, int var6, long var7, T var9) throws E;

        public R itraceStart(@NonNull EventHeader var1, @NonNull SampleId var2, int var3, int var4, T var5) throws E;

        public R lost(@NonNull EventHeader var1, @NonNull SampleId var2, long var3, long var5, T var7) throws E;

        public R lostSamples(@NonNull EventHeader var1, @NonNull SampleId var2, long var3, T var5) throws E;

        public R mmap(@NonNull EventHeader var1, @NonNull SampleId var2, int var3, int var4, long var5, long var7, long var9, @NonNull String var11, T var12) throws E;

        public R mmap2(@NonNull EventHeader var1, @NonNull SampleId var2, int var3, int var4, long var5, long var7, long var9, int var11, int var12, long var13, long var15, int var17, int var18, @NonNull String var19, T var20) throws E;

        public R other(@NonNull EventHeader var1, @NonNull SampleId var2, @NonNull ByteBuffer var3, T var4) throws E;

        public R read(@NonNull EventHeader var1, @NonNull SampleId var2, int var3, int var4, @NonNull ReadFormat var5, T var6) throws E;

        public R sample(@NonNull EventHeader var1, @NonNull SampleRecord var2, @Nullable ReadFormat var3, long @Nullable [] var4, byte @Nullable [] var5, boolean var6, @NonNull Abi var7, @Nullable RegisterValues var8, T var9) throws E;

        public R simplePerfCallchain(@NonNull EventHeader var1, @NonNull SampleId var2, int var3, int var4, long var5, long var7, long @NonNull [] var9, long @NonNull [] var10, T var11) throws E;

        public R simplePerfKAllSyms(@NonNull EventHeader var1, @NonNull SampleId var2, @NonNull String var3, T var4) throws E;

        public R swtch(@NonNull EventHeader var1, @NonNull SampleId var2, T var3) throws E;

        public R swtchCpuWide(@NonNull EventHeader var1, @NonNull SampleId var2, int var3, int var4, T var5) throws E;

        public R throttle(@NonNull EventHeader var1, @NonNull SampleId var2, long var3, long var5, long var7, T var9) throws E;

        public R unthrottle(@NonNull EventHeader var1, @NonNull SampleId var2, long var3, long var5, long var7, T var9) throws E;

        public static enum Abi {
            ABI_32(1),
            ABI_64(2),
            NONE(0);

            public final int cEnum;

            public static @NonNull Abi find(long cEnum) {
                Abi[] abiArray = Abi.values();
                int n = abiArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Abi val = abiArray[n2];
                    if ((long)val.cEnum == cEnum) {
                        return val;
                    }
                    ++n2;
                }
                return NONE;
            }

            private Abi(int cEnum) {
                this.cEnum = cEnum;
            }
        }
    }

    public static class SampleId {
        public final @Nullable EventAttribute attribute;
        public final @Nullable Integer cpu;
        public final @Nullable Long id;
        public final @Nullable Long identifier;
        public final @Nullable Integer pid;
        public final @Nullable Integer res;
        public final @Nullable Long stream_id;
        public final @Nullable Integer tid;
        public final @Nullable Long time;

        public SampleId(@Nullable EventAttribute attribute, @Nullable Long identifier, @Nullable Integer pid, @Nullable Integer tid, @Nullable Long time, @Nullable Long id, @Nullable Long stream_id, @Nullable Integer cpu, @Nullable Integer res) {
            this.attribute = attribute;
            this.identifier = identifier;
            this.tid = tid;
            this.pid = pid;
            this.time = time;
            this.id = id;
            this.stream_id = stream_id;
            this.cpu = cpu;
            this.res = res;
            assert (identifier == null || id == null || identifier.equals(id));
        }

        public @Nullable Long getAttributeId() {
            return this.identifier != null ? this.identifier : this.id;
        }

        public int getSize() {
            return (this.identifier != null ? 8 : 0) + (this.id != null ? 8 : 0) + (this.cpu != null ? 8 : 0) + (this.stream_id != null ? 8 : 0) + (this.time != null ? 8 : 0) + (this.pid != null ? 8 : 0);
        }

        public String toString() {
            return String.format("SampleId [identifier=%s, tid=%s, pid=%s, time=%s, id=%s, stream_id=%s, cpu=%s, res=%s]", this.identifier, this.tid, this.pid, this.time, this.id, this.stream_id, this.cpu, this.res);
        }
    }

    public static final class SampleRecord
    extends SampleId {
        public final @Nullable Long addr;
        public final @NonNull ByteBuffer buffer;
        public final int bufferPosition;
        public final @Nullable Long ip;
        public final @Nullable Long period;

        public SampleRecord(@NonNull EventAttribute event, @Nullable Long identifier, @Nullable Long ip, @Nullable Integer pid, @Nullable Integer tid, @Nullable Long time, @Nullable Long addr, @Nullable Long id, @Nullable Long stream_id, @Nullable Integer cpu, @Nullable Integer res, @Nullable Long period, @NonNull ByteBuffer buffer) {
            super(event, identifier, pid, tid, time, id, stream_id, cpu, res);
            this.ip = ip;
            this.addr = addr;
            this.period = period;
            this.buffer = buffer;
            this.bufferPosition = buffer.position();
        }

        public @NonNull EventAttribute getEventAttribute() {
            return (EventAttribute)NullChecking.neverNull((Object)this.attribute);
        }

        public @Nullable ReadFormat getReadFormat() throws InvalidPerfDataException {
            EventAttribute attribute = this.attribute;
            this.buffer.position(this.bufferPosition);
            if (attribute != null && (attribute.getSampleType() & 0x10L) != 0L) {
                return new ReadFormat(this.getAttributeId(), attribute.getReadFormat(), this.buffer::getLong);
            }
            return null;
        }

        @Override
        public int getSize() {
            return super.getSize() + (this.addr != null ? 8 : 0) + (this.ip != null ? 8 : 0) + (this.period != null ? 8 : 0);
        }

        @Override
        public String toString() {
            return String.format("SampleRecord [ip=%s, addr=%s, period=%s, identifier=%s, tid=%s, pid=%s, time=%s, id=%s, stream_id=%s, cpu=%s, res=%s]", this.ip, this.addr, this.period, this.identifier, this.tid, this.pid, this.time, this.id, this.stream_id, this.cpu, this.res);
        }
    }
}

