/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.perf.records;

import com.arm.streamline.perf.InvalidPerfDataException;
import com.arm.utils.function.IThrowingLongConsumer;
import com.arm.utils.function.IThrowingLongSupplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ReadFormat {
    private final long @NonNull [] ids;
    private final long @NonNull [] values;

    public static <E extends Throwable> void write(long readFormat, long @NonNull [] ids, long @NonNull [] values, @NonNull IThrowingLongConsumer<E> consumer) throws InvalidPerfDataException, E {
        if ((readFormat & 0xFFFFFFFFFFFFFFF0L) != 0L) {
            throw new InvalidPerfDataException(InvalidPerfDataException.Reason.UNEXPECTED_READ_FORMAT);
        }
        if (ids.length != values.length) {
            throw new IllegalArgumentException("ids.lengh != values.length");
        }
        if ((readFormat & 8L) != 0L) {
            if ((readFormat & 4L) == 0L) {
                throw new InvalidPerfDataException(InvalidPerfDataException.Reason.UNEXPECTED_READ_FORMAT);
            }
            consumer.consume((long)ids.length);
            if ((readFormat & 1L) != 0L) {
                consumer.consume(0L);
            }
            if ((readFormat & 2L) != 0L) {
                consumer.consume(0L);
            }
            int i = 0;
            while (i < ids.length) {
                consumer.consume(values[i]);
                consumer.consume(ids[i]);
                ++i;
            }
        } else {
            if (ids.length != 1) {
                throw new IllegalArgumentException("ids.length must be 1");
            }
            consumer.consume(values[0]);
            if ((readFormat & 1L) != 0L) {
                consumer.consume(0L);
            }
            if ((readFormat & 2L) != 0L) {
                consumer.consume(0L);
            }
            if ((readFormat & 4L) != 0L) {
                consumer.consume(ids[0]);
            }
        }
    }

    public <E extends Throwable> ReadFormat(@Nullable Long defaultId, long readFormat, @NonNull IThrowingLongSupplier<E> buffer) throws InvalidPerfDataException, E {
        long timeRunning;
        if ((readFormat & 0xFFFFFFFFFFFFFFE0L) != 0L) {
            throw new InvalidPerfDataException(InvalidPerfDataException.Reason.UNEXPECTED_READ_FORMAT);
        }
        long nrOrValue = buffer.getLong();
        long timeEnabled = (readFormat & 1L) != 0L ? buffer.getLong() : 0L;
        long l = timeRunning = (readFormat & 2L) != 0L ? buffer.getLong() : 0L;
        if ((readFormat & 8L) != 0L) {
            if ((readFormat & 4L) == 0L) {
                throw new InvalidPerfDataException(InvalidPerfDataException.Reason.UNEXPECTED_READ_FORMAT);
            }
            if (nrOrValue < 0L || nrOrValue >= Integer.MAX_VALUE) {
                throw new InvalidPerfDataException(InvalidPerfDataException.Reason.UNEXPECTED_READ_FORMAT);
            }
            this.ids = new long[(int)nrOrValue];
            this.values = new long[(int)nrOrValue];
            long i = 0L;
            while (i < nrOrValue) {
                long value = buffer.getLong();
                long id = buffer.getLong();
                long lost = (readFormat & 0x10L) != 0L ? buffer.getLong() : 0L;
                this.ids[(int)i] = id;
                this.values[(int)i] = value;
                ++i;
            }
        } else {
            long id;
            if ((readFormat & 4L) == 0L) {
                if (defaultId == null) {
                    throw new InvalidPerfDataException(InvalidPerfDataException.Reason.UNEXPECTED_READ_FORMAT);
                }
                id = defaultId;
            } else {
                id = buffer.getLong();
            }
            long lost = (readFormat & 0x10L) != 0L ? buffer.getLong() : 0L;
            this.ids = new long[1];
            this.values = new long[1];
            this.ids[0] = id;
            this.values[0] = nrOrValue;
        }
    }

    public ReadFormat(long @NonNull [] ids, long @NonNull [] values) {
        if (ids.length != values.length) {
            throw new IllegalArgumentException();
        }
        this.ids = ids;
        this.values = values;
    }

    public long @NonNull [] getIds() {
        return this.ids;
    }

    public long @NonNull [] getValues() {
        return this.values;
    }
}

