/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.perf.records;

import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.perf.records.EventAndPmuNames;
import com.arm.streamline.protocol.gator.io.IAPCByteReader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class EventAttribute {
    private static final long SAMPLE_TYPE_MASK = 719L;
    private final int auxWatermark;
    private final int bpType;
    private final long branchSampleType;
    private final int clockId;
    private final long config;
    private final long config1OrBpAddr;
    private final long config2OrBpLen;
    private final long flagBits;
    private final long readFormat;
    private final long sampleFreqOrPeriod;
    private final long sampleRegsIntr;
    private final long sampleRegsUser;
    private final int sampleStackUser;
    private final long sampleType;
    private final int size;
    private final int type;
    private final int wakeupEventsOrWatermark;

    public static long makeSampleTypeIdMask(long sampleType) {
        return sampleType & 0x102CFL;
    }

    public static @Nullable Long validateSampleType(@NonNull Collection<@NonNull EventAttribute> attributes) {
        boolean first = true;
        long result = 0L;
        for (EventAttribute attribute : attributes) {
            if (!first) {
                if (EventAttribute.validateSampleType(attribute, result)) continue;
                return null;
            }
            result = attribute.getSampleType();
            first = false;
        }
        return EventAttribute.makeSampleTypeIdMask(result);
    }

    public static boolean validateSampleType(@NonNull EventAttribute attribute, long currentIdMask) {
        if ((currentIdMask & 0x10000L) != (attribute.getSampleType() & 0x10000L)) {
            return false;
        }
        return (currentIdMask & 0x10000L) != 0L || (currentIdMask & 0x2CFL) == (attribute.getSampleType() & 0x2CFL);
    }

    public EventAttribute(@NonNull ByteBuffer input) throws IOException {
        this(new ByteBufferDataInputAdapter(input), null);
    }

    public EventAttribute(@NonNull DataInput input) throws IOException {
        this(new DataInputAdapter(input), null);
    }

    public EventAttribute(@NonNull DataInput input, int attrSize) throws IOException {
        this(new DataInputAdapter(input), (Integer)attrSize);
    }

    public EventAttribute(@NonNull IDataInput input) throws IOException {
        this(input, null);
    }

    public EventAttribute(int type, long config, long sampleFreqOrPeriod, long sampleType, long readFormat, long flagBits, int wakeupEventsOrWatermark, int bpType, long config1OrBpAddr, long config2OrBpLen, long branchSampleType, long sampleRegsUser, int sampleStackUser, int clockId, long sampleRegsIntr, int auxWatermark) {
        this.size = 112;
        this.auxWatermark = auxWatermark;
        this.bpType = bpType;
        this.branchSampleType = branchSampleType;
        this.clockId = clockId;
        this.config = config;
        this.config1OrBpAddr = config1OrBpAddr;
        this.config2OrBpLen = config2OrBpLen;
        this.flagBits = flagBits;
        this.readFormat = readFormat;
        this.sampleFreqOrPeriod = sampleFreqOrPeriod;
        this.sampleRegsIntr = sampleRegsIntr;
        this.sampleRegsUser = sampleRegsUser;
        this.sampleStackUser = sampleStackUser;
        this.sampleType = sampleType;
        this.type = type;
        this.wakeupEventsOrWatermark = wakeupEventsOrWatermark;
    }

    public EventAttribute(@NonNull XMLParser xml) {
        this.auxWatermark = xml.getIntegerAttribute("auxWatermark");
        this.bpType = xml.getIntegerAttribute("bpType");
        this.branchSampleType = xml.getLongAttribute("branchSampleType");
        this.clockId = xml.getIntegerAttribute("clockId");
        this.config = xml.getLongAttribute("config");
        this.config1OrBpAddr = xml.getLongAttribute("config1OrBpAddr");
        this.config2OrBpLen = xml.getLongAttribute("config2OrBpLen");
        this.flagBits = xml.getLongAttribute("flagBits");
        this.readFormat = xml.getLongAttribute("readFormat");
        this.sampleFreqOrPeriod = xml.getLongAttribute("sampleFreqOrPeriod");
        this.sampleRegsIntr = xml.getLongAttribute("sampleRegsIntr");
        this.sampleRegsUser = xml.getLongAttribute("sampleRegsUser");
        this.sampleStackUser = xml.getIntegerAttribute("sampleStackUser");
        this.sampleType = xml.getLongAttribute("sampleType");
        this.size = xml.getIntegerAttribute("size");
        this.type = xml.getIntegerAttribute("type");
        this.wakeupEventsOrWatermark = xml.getIntegerAttribute("wakeupEventsOrWatermark");
    }

    private EventAttribute(@NonNull IDataInput input, @Nullable Integer attrSize) throws IOException {
        if (attrSize != null && attrSize < 48) {
            throw new IOException("Unexpectedly small attrSize: " + String.valueOf(attrSize));
        }
        this.type = input.readInt();
        this.size = input.readInt();
        this.config = input.readLong();
        this.sampleFreqOrPeriod = input.readLong();
        this.sampleType = input.readLong();
        this.readFormat = input.readLong();
        this.flagBits = input.readLong();
        assert (attrSize == null || this.size <= attrSize) : "size = " + this.size + ", attrSize = " + String.valueOf(attrSize);
        int minSize = attrSize != null ? Math.min(this.size, attrSize) : this.size;
        int alignTo = 48;
        this.wakeupEventsOrWatermark = minSize >= 52 ? input.readInt() : 0;
        alignTo = minSize >= 52 ? 52 : alignTo;
        this.bpType = minSize >= 56 ? input.readInt() : 0;
        alignTo = minSize >= 56 ? 56 : alignTo;
        this.config1OrBpAddr = minSize >= 64 ? input.readLong() : 0L;
        alignTo = minSize >= 64 ? 64 : alignTo;
        this.config2OrBpLen = minSize >= 72 ? input.readLong() : 0L;
        alignTo = minSize >= 72 ? 72 : alignTo;
        this.branchSampleType = minSize >= 80 ? input.readLong() : 0L;
        alignTo = minSize >= 80 ? 80 : alignTo;
        this.sampleRegsUser = minSize >= 88 ? input.readLong() : 0L;
        alignTo = minSize >= 88 ? 88 : alignTo;
        this.sampleStackUser = minSize >= 92 ? input.readInt() : 0;
        alignTo = minSize >= 92 ? 92 : alignTo;
        this.clockId = minSize >= 96 ? input.readInt() : 0;
        alignTo = minSize >= 96 ? 96 : alignTo;
        this.sampleRegsIntr = minSize >= 104 ? input.readLong() : 0L;
        alignTo = minSize >= 104 ? 104 : alignTo;
        this.auxWatermark = minSize >= 108 ? input.readInt() : 0;
        int n = alignTo = minSize >= 108 ? 108 : alignTo;
        assert (attrSize == null || attrSize >= alignTo);
        if (attrSize != null) {
            input.skipBytes(attrSize - alignTo);
        } else {
            input.skipBytes(this.size - alignTo);
        }
    }

    public EventAttribute(@NonNull IAPCByteReader input) throws IOException {
        this(new APCByteReaderInputAdapter(input));
    }

    public boolean equals(Object obj) {
        if (obj instanceof EventAttribute) {
            EventAttribute that = (EventAttribute)obj;
            return this.auxWatermark == that.auxWatermark && this.bpType == that.bpType && this.branchSampleType == that.branchSampleType && this.clockId == that.clockId && this.config == that.config && this.config1OrBpAddr == that.config1OrBpAddr && this.config2OrBpLen == that.config2OrBpLen && this.flagBits == that.flagBits && this.readFormat == that.readFormat && this.sampleFreqOrPeriod == that.sampleFreqOrPeriod && this.sampleRegsIntr == that.sampleRegsIntr && this.sampleRegsUser == that.sampleRegsUser && this.sampleStackUser == that.sampleStackUser && this.sampleType == that.sampleType && this.size == that.size && this.type == that.type && this.wakeupEventsOrWatermark == that.wakeupEventsOrWatermark;
        }
        return false;
    }

    public int getAuxWatermark() {
        return this.auxWatermark;
    }

    public int getBpType() {
        return this.bpType;
    }

    public long getBranchSampleType() {
        return this.branchSampleType;
    }

    public int getClockId() {
        return this.clockId;
    }

    public long getConfig() {
        return this.config;
    }

    public long getConfig1OrBpAddr() {
        return this.config1OrBpAddr;
    }

    public long getConfig2OrBpLen() {
        return this.config2OrBpLen;
    }

    public long getFlagBits() {
        return this.flagBits;
    }

    public long getReadFormat() {
        return this.readFormat;
    }

    public long getSampleFreqOrPeriod() {
        return this.sampleFreqOrPeriod;
    }

    public long getSampleRegsIntr() {
        return this.sampleRegsIntr;
    }

    public long getSampleRegsUser() {
        return this.sampleRegsUser;
    }

    public int getSampleStackUser() {
        return this.sampleStackUser;
    }

    public long getSampleType() {
        return this.sampleType;
    }

    public int getSize() {
        return this.size;
    }

    public int getType() {
        return this.type;
    }

    public @NonNull EventAndPmuNames.TypeAndConfig getTypeAndConfig() {
        return new EventAndPmuNames.TypeAndConfig(this.type, this.config);
    }

    public int getWakeupEventsOrWatermark() {
        return this.wakeupEventsOrWatermark;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.auxWatermark;
        result = 31 * result + this.bpType;
        result = 31 * result + (int)(this.branchSampleType ^ this.branchSampleType >>> 32);
        result = 31 * result + this.clockId;
        result = 31 * result + (int)(this.config ^ this.config >>> 32);
        result = 31 * result + (int)(this.config1OrBpAddr ^ this.config1OrBpAddr >>> 32);
        result = 31 * result + (int)(this.config2OrBpLen ^ this.config2OrBpLen >>> 32);
        result = 31 * result + (int)(this.flagBits ^ this.flagBits >>> 32);
        result = 31 * result + (int)(this.readFormat ^ this.readFormat >>> 32);
        result = 31 * result + (int)(this.sampleFreqOrPeriod ^ this.sampleFreqOrPeriod >>> 32);
        result = 31 * result + (int)(this.sampleRegsIntr ^ this.sampleRegsIntr >>> 32);
        result = 31 * result + (int)(this.sampleRegsUser ^ this.sampleRegsUser >>> 32);
        result = 31 * result + this.sampleStackUser;
        result = 31 * result + (int)(this.sampleType ^ this.sampleType >>> 32);
        result = 31 * result + this.size;
        result = 31 * result + this.type;
        result = 31 * result + this.wakeupEventsOrWatermark;
        return result;
    }

    public boolean isFlagSet(Flags flag) {
        return (this.flagBits & 1L << flag.bit) != 0L;
    }

    public String toString() {
        return String.format("EventAttribute [%s, size=%s, sampleType=%s, readFormat=%s, flagBits=0x%s, config1OrBpAddr=0x%s, config2OrBpLen=0x%s]", EventAndPmuNames.getEventName(this.getTypeAndConfig()), this.size, EventAndPmuNames.sampleTypeToString(this.sampleType), EventAndPmuNames.readFormatToString(this.readFormat), Long.toHexString(this.flagBits), Long.toHexString(this.config1OrBpAddr), Long.toHexString(this.config2OrBpLen));
    }

    public void write(@NonNull DataOutput output) throws IOException {
        this.write(new DataOutputAdapter(output));
    }

    public void write(@NonNull IDataOutput output) throws IOException {
        output.writeInt(this.type);
        output.writeInt(112);
        output.writeLong(this.config);
        output.writeLong(this.sampleFreqOrPeriod);
        output.writeLong(this.sampleType);
        output.writeLong(this.readFormat);
        output.writeLong(this.flagBits);
        output.writeInt(this.wakeupEventsOrWatermark);
        output.writeInt(this.bpType);
        output.writeLong(this.config1OrBpAddr);
        output.writeLong(this.config2OrBpLen);
        output.writeLong(this.branchSampleType);
        output.writeLong(this.sampleRegsUser);
        output.writeInt(this.sampleStackUser);
        output.writeInt(this.clockId);
        output.writeLong(this.sampleRegsIntr);
        output.writeInt(this.auxWatermark);
        output.writeInt(0);
    }

    public void write(@NonNull XMLGenerator xml) throws IOException {
        xml.addAttribute("auxWatermark", this.auxWatermark);
        xml.addAttribute("bpType", this.bpType);
        xml.addAttribute("branchSampleType", this.branchSampleType);
        xml.addAttribute("clockId", this.clockId);
        xml.addAttribute("config", this.config);
        xml.addAttribute("config1OrBpAddr", this.config1OrBpAddr);
        xml.addAttribute("config2OrBpLen", this.config2OrBpLen);
        xml.addAttribute("flagBits", this.flagBits);
        xml.addAttribute("readFormat", this.readFormat);
        xml.addAttribute("sampleFreqOrPeriod", this.sampleFreqOrPeriod);
        xml.addAttribute("sampleRegsIntr", this.sampleRegsIntr);
        xml.addAttribute("sampleRegsUser", this.sampleRegsUser);
        xml.addAttribute("sampleStackUser", this.sampleStackUser);
        xml.addAttribute("sampleType", this.sampleType);
        xml.addAttribute("size", this.size);
        xml.addAttribute("type", this.type);
        xml.addAttribute("wakeupEventsOrWatermark", this.wakeupEventsOrWatermark);
    }

    private static final class APCByteReaderInputAdapter
    implements IDataInput {
        private final @NonNull IAPCByteReader input;

        public APCByteReaderInputAdapter(@NonNull IAPCByteReader input) {
            this.input = input;
        }

        @Override
        public int readInt() throws IOException {
            return this.input.getLEInt();
        }

        @Override
        public long readLong() throws IOException {
            return this.input.getLELong();
        }

        @Override
        public void skipBytes(int i) throws IOException {
            this.input.skipBytes(i);
        }
    }

    private static final class ByteBufferDataInputAdapter
    implements IDataInput {
        private final @NonNull ByteBuffer buffer;

        public ByteBufferDataInputAdapter(@NonNull ByteBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public int readInt() throws IOException {
            try {
                return this.buffer.getInt();
            }
            catch (BufferUnderflowException | ReadOnlyBufferException e) {
                throw new IOException(e);
            }
        }

        @Override
        public long readLong() throws IOException {
            try {
                return this.buffer.getLong();
            }
            catch (BufferUnderflowException | ReadOnlyBufferException e) {
                throw new IOException(e);
            }
        }

        @Override
        public void skipBytes(int i) throws IOException {
            try {
                if (i < 0) {
                    throw new IllegalArgumentException();
                }
                this.buffer.position(this.buffer.position() + i);
            }
            catch (IllegalArgumentException e) {
                throw new IOException(e);
            }
        }
    }

    private static final class DataInputAdapter
    implements IDataInput {
        private final @NonNull DataInput input;

        public DataInputAdapter(@NonNull DataInput input) {
            this.input = input;
        }

        @Override
        public int readInt() throws IOException {
            return this.input.readInt();
        }

        @Override
        public long readLong() throws IOException {
            return this.input.readLong();
        }

        @Override
        public void skipBytes(int i) throws IOException {
            this.input.skipBytes(i);
        }
    }

    private static final class DataOutputAdapter
    implements IDataOutput {
        private final @NonNull DataOutput output;

        public DataOutputAdapter(@NonNull DataOutput output) {
            this.output = output;
        }

        @Override
        public void writeInt(int v) throws IOException {
            this.output.writeInt(v);
        }

        @Override
        public void writeLong(long v) throws IOException {
            this.output.writeLong(v);
        }
    }

    public static enum Flags {
        DISABLED(0),
        INHERIT(1),
        PINNED(2),
        EXCLUSIVE(3),
        EXCLUDE_USER(4),
        EXCLUDE_KERNEL(5),
        EXCLUDE_HV(6),
        EXCLUDE_IDLE(7),
        MMAP(8),
        COMM(9),
        FREQ(10),
        INHERIT_STAT(11),
        ENABLE_ON_EXEC(12),
        TASK(13),
        WATERMARK(14),
        PRECISE_IP_BIT0(15),
        PRECISE_IP_BIT1(16),
        MMAP_DATA(17),
        SAMPLE_ID_ALL(18),
        EXCLUDE_HOST(19),
        EXCLUDE_GUEST(20),
        EXCLUDE_CALLCHAIN_KERNEL(21),
        EXCLUDE_CALLCHAIN_USER(22),
        MMAP2(23),
        COMM_EXEC(24),
        USE_CLOCKID(25),
        CONTEXT_SWITCH(26);

        public final int bit;
        public final long value;

        private Flags(int bit) {
            this.bit = bit;
            this.value = 1L << bit;
        }
    }

    public static interface IDataInput {
        public int readInt() throws IOException;

        public long readLong() throws IOException;

        public void skipBytes(int var1) throws IOException;
    }

    public static interface IDataOutput {
        public void writeInt(int var1) throws IOException;

        public void writeLong(long var1) throws IOException;
    }
}

