/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.perf.records;

import com.arm.utils.StreamUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class EventAndPmuNames {
    private static final @NonNull Map<@NonNull TypeAndConfig, @NonNull String> ARM_EVENTS = new HashMap<TypeAndConfig, String>();
    private static final @NonNull Map<@NonNull TypeAndConfig, @NonNull String> PORTABLE_EVENTS = new HashMap<TypeAndConfig, String>();

    static {
        PORTABLE_EVENTS.put(new TypeAndConfig(0, 0L), "cpu-cycles");
        PORTABLE_EVENTS.put(new TypeAndConfig(0, 1L), "instructions");
        PORTABLE_EVENTS.put(new TypeAndConfig(0, 2L), "cache-references");
        PORTABLE_EVENTS.put(new TypeAndConfig(0, 3L), "cache-misses");
        PORTABLE_EVENTS.put(new TypeAndConfig(0, 4L), "branch-instructions");
        PORTABLE_EVENTS.put(new TypeAndConfig(0, 5L), "branch-misses");
        PORTABLE_EVENTS.put(new TypeAndConfig(0, 6L), "bus-cycles");
        PORTABLE_EVENTS.put(new TypeAndConfig(0, 7L), "stalled-cycles-frontend");
        PORTABLE_EVENTS.put(new TypeAndConfig(0, 8L), "stalled-cycles-backend");
        PORTABLE_EVENTS.put(new TypeAndConfig(1, 0L), "cpu-clock");
        PORTABLE_EVENTS.put(new TypeAndConfig(1, 1L), "task-clock");
        PORTABLE_EVENTS.put(new TypeAndConfig(1, 2L), "page-faults");
        PORTABLE_EVENTS.put(new TypeAndConfig(1, 3L), "context-switches");
        PORTABLE_EVENTS.put(new TypeAndConfig(1, 4L), "cpu-migrations");
        PORTABLE_EVENTS.put(new TypeAndConfig(1, 5L), "minor-faults");
        PORTABLE_EVENTS.put(new TypeAndConfig(1, 6L), "major-faults");
        PORTABLE_EVENTS.put(new TypeAndConfig(1, 7L), "alignment-faults");
        PORTABLE_EVENTS.put(new TypeAndConfig(1, 8L), "emulation-faults");
        PORTABLE_EVENTS.put(new TypeAndConfig(3, 0L), "L1-dcache-loads");
        PORTABLE_EVENTS.put(new TypeAndConfig(3, 65536L), "L1-dcache-load-misses");
        PORTABLE_EVENTS.put(new TypeAndConfig(3, 256L), "L1-dcache-stores");
        PORTABLE_EVENTS.put(new TypeAndConfig(3, 65792L), "L1-dcache-store-misses");
        PORTABLE_EVENTS.put(new TypeAndConfig(3, 512L), "L1-dcache-prefetches");
        PORTABLE_EVENTS.put(new TypeAndConfig(3, 66048L), "L1-dcache-prefetch-misses");
        PORTABLE_EVENTS.put(new TypeAndConfig(3, 1L), "L1-icache-loads");
        PORTABLE_EVENTS.put(new TypeAndConfig(3, 65537L), "L1-icache-load-misses");
        PORTABLE_EVENTS.put(new TypeAndConfig(3, 257L), "L1-icache-stores");
        PORTABLE_EVENTS.put(new TypeAndConfig(3, 65793L), "L1-icache-store-misses");
        PORTABLE_EVENTS.put(new TypeAndConfig(3, 513L), "L1-icache-prefetches");
        PORTABLE_EVENTS.put(new TypeAndConfig(3, 66049L), "L1-icache-prefetch-misses");
        PORTABLE_EVENTS.put(new TypeAndConfig(3, 2L), "LLC-loads");
        PORTABLE_EVENTS.put(new TypeAndConfig(3, 65538L), "LLC-load-misses");
        PORTABLE_EVENTS.put(new TypeAndConfig(3, 258L), "LLC-stores");
        PORTABLE_EVENTS.put(new TypeAndConfig(3, 65794L), "LLC-store-misses");
        PORTABLE_EVENTS.put(new TypeAndConfig(3, 514L), "LLC-prefetches");
        PORTABLE_EVENTS.put(new TypeAndConfig(3, 66050L), "LLC-prefetch-misses");
        PORTABLE_EVENTS.put(new TypeAndConfig(3, 3L), "dTLB-loads");
        PORTABLE_EVENTS.put(new TypeAndConfig(3, 65539L), "dTLB-load-misses");
        PORTABLE_EVENTS.put(new TypeAndConfig(3, 259L), "dTLB-stores");
        PORTABLE_EVENTS.put(new TypeAndConfig(3, 65795L), "dTLB-store-misses");
        PORTABLE_EVENTS.put(new TypeAndConfig(3, 515L), "dTLB-prefetches");
        PORTABLE_EVENTS.put(new TypeAndConfig(3, 66051L), "dTLB-prefetch-misses");
        PORTABLE_EVENTS.put(new TypeAndConfig(3, 4L), "iTLB-loads");
        PORTABLE_EVENTS.put(new TypeAndConfig(3, 65540L), "iTLB-load-misses");
        PORTABLE_EVENTS.put(new TypeAndConfig(3, 260L), "iTLB-stores");
        PORTABLE_EVENTS.put(new TypeAndConfig(3, 65796L), "iTLB-store-misses");
        PORTABLE_EVENTS.put(new TypeAndConfig(3, 516L), "iTLB-prefetches");
        PORTABLE_EVENTS.put(new TypeAndConfig(3, 66052L), "iTLB-prefetch-misses");
        PORTABLE_EVENTS.put(new TypeAndConfig(3, 5L), "branch-loads");
        PORTABLE_EVENTS.put(new TypeAndConfig(3, 65541L), "branch-load-misses");
        PORTABLE_EVENTS.put(new TypeAndConfig(3, 261L), "branch-stores");
        PORTABLE_EVENTS.put(new TypeAndConfig(3, 65797L), "branch-store-misses");
        PORTABLE_EVENTS.put(new TypeAndConfig(3, 517L), "branch-prefetches");
        PORTABLE_EVENTS.put(new TypeAndConfig(3, 66053L), "branch-prefetch-misses");
        PORTABLE_EVENTS.put(new TypeAndConfig(3, 6L), "node-loads");
        PORTABLE_EVENTS.put(new TypeAndConfig(3, 65542L), "node-load-misses");
        PORTABLE_EVENTS.put(new TypeAndConfig(3, 262L), "node-stores");
        PORTABLE_EVENTS.put(new TypeAndConfig(3, 65798L), "node-store-misses");
        PORTABLE_EVENTS.put(new TypeAndConfig(3, 518L), "node-prefetches");
        PORTABLE_EVENTS.put(new TypeAndConfig(3, 66054L), "node-prefetch-misses");
        PORTABLE_EVENTS.put(new TypeAndConfig(32768, 0L), "inplace-sampler");
        ARM_EVENTS.put(new TypeAndConfig(4, 0L), "raw-sw-incr");
        ARM_EVENTS.put(new TypeAndConfig(4, 1L), "raw-l1-icache-refill");
        ARM_EVENTS.put(new TypeAndConfig(4, 2L), "raw-l1-itlb-refill");
        ARM_EVENTS.put(new TypeAndConfig(4, 3L), "raw-l1-dcache-refill");
        ARM_EVENTS.put(new TypeAndConfig(4, 4L), "raw-l1-dcache");
        ARM_EVENTS.put(new TypeAndConfig(4, 5L), "raw-l1-dtlb-refill");
        ARM_EVENTS.put(new TypeAndConfig(4, 6L), "raw-load-retired");
        ARM_EVENTS.put(new TypeAndConfig(4, 7L), "raw-store-retired");
        ARM_EVENTS.put(new TypeAndConfig(4, 8L), "raw-instruction-retired");
        ARM_EVENTS.put(new TypeAndConfig(4, 9L), "raw-exception-taken");
        ARM_EVENTS.put(new TypeAndConfig(4, 10L), "raw-exception-return");
        ARM_EVENTS.put(new TypeAndConfig(4, 11L), "raw-cid-write-retired");
        ARM_EVENTS.put(new TypeAndConfig(4, 12L), "raw-pc-write-retired");
        ARM_EVENTS.put(new TypeAndConfig(4, 13L), "raw-br-immed-retired");
        ARM_EVENTS.put(new TypeAndConfig(4, 14L), "raw-br-return-retired");
        ARM_EVENTS.put(new TypeAndConfig(4, 15L), "raw-unaligned-ldst-retired");
        ARM_EVENTS.put(new TypeAndConfig(4, 16L), "raw-br-mis-pred");
        ARM_EVENTS.put(new TypeAndConfig(4, 17L), "raw-cpu-cycles");
        ARM_EVENTS.put(new TypeAndConfig(4, 18L), "raw-br-pred");
        ARM_EVENTS.put(new TypeAndConfig(4, 19L), "raw-mem-access");
        ARM_EVENTS.put(new TypeAndConfig(4, 20L), "raw-l1-icache");
        ARM_EVENTS.put(new TypeAndConfig(4, 21L), "raw-l1-dcache-wb");
        ARM_EVENTS.put(new TypeAndConfig(4, 22L), "raw-l2-dcache");
        ARM_EVENTS.put(new TypeAndConfig(4, 23L), "raw-l2-dcache-refill");
        ARM_EVENTS.put(new TypeAndConfig(4, 24L), "raw-l2-dcache-wb");
        ARM_EVENTS.put(new TypeAndConfig(4, 25L), "raw-bus-access");
        ARM_EVENTS.put(new TypeAndConfig(4, 26L), "raw-memory-error");
        ARM_EVENTS.put(new TypeAndConfig(4, 27L), "raw-inst-spec");
        ARM_EVENTS.put(new TypeAndConfig(4, 28L), "raw-ttbr-write-retired");
        ARM_EVENTS.put(new TypeAndConfig(4, 29L), "raw-bus-cycles");
        ARM_EVENTS.put(new TypeAndConfig(4, 31L), "raw-l1-dcache-allocate");
        ARM_EVENTS.put(new TypeAndConfig(4, 32L), "raw-l2-dcache-allocate");
        ARM_EVENTS.put(new TypeAndConfig(4, 33L), "raw-br-retired");
        ARM_EVENTS.put(new TypeAndConfig(4, 34L), "raw-br-mis-pred-retired");
        ARM_EVENTS.put(new TypeAndConfig(4, 35L), "raw-stall-frontend");
        ARM_EVENTS.put(new TypeAndConfig(4, 36L), "raw-stall-backend");
        ARM_EVENTS.put(new TypeAndConfig(4, 37L), "raw-l1-dtlb");
        ARM_EVENTS.put(new TypeAndConfig(4, 38L), "raw-l1-itlb");
        ARM_EVENTS.put(new TypeAndConfig(4, 39L), "raw-l2-icache");
        ARM_EVENTS.put(new TypeAndConfig(4, 40L), "raw-l2-icache-refill");
        ARM_EVENTS.put(new TypeAndConfig(4, 41L), "raw-l3-dcache-allocate");
        ARM_EVENTS.put(new TypeAndConfig(4, 42L), "raw-l3-dcache-refill");
        ARM_EVENTS.put(new TypeAndConfig(4, 43L), "raw-l3-dcache");
        ARM_EVENTS.put(new TypeAndConfig(4, 44L), "raw-l3-dcache-wb");
        ARM_EVENTS.put(new TypeAndConfig(4, 45L), "raw-l2-dtlb-refill");
        ARM_EVENTS.put(new TypeAndConfig(4, 46L), "raw-l2-itlb-refill");
        ARM_EVENTS.put(new TypeAndConfig(4, 47L), "raw-l2-dtlb");
        ARM_EVENTS.put(new TypeAndConfig(4, 48L), "raw-l2-itlb");
    }

    public static @NonNull String getEventName(int type, long config) {
        return EventAndPmuNames.getEventName(new TypeAndConfig(type, config));
    }

    public static @NonNull String getEventName(@NonNull TypeAndConfig typeAndConfig) {
        return EventAndPmuNames.getEventName(typeAndConfig, null, EventAndPmuNames::getPmuName);
    }

    public static @Nullable String getPerfEventName(@NonNull TypeAndConfig typeAndConfig) {
        String name = PORTABLE_EVENTS.get(typeAndConfig);
        if (name != null) {
            return name;
        }
        return null;
    }

    public static @NonNull String getEventName(@NonNull TypeAndConfig typeAndConfig, @Nullable String arch, @NonNull IntFunction<@NonNull String> pmuNames) {
        String name = PORTABLE_EVENTS.get(typeAndConfig);
        if (name != null) {
            return name;
        }
        if (arch != null && (arch.startsWith("aarch64") || arch.startsWith("arm")) && (name = ARM_EVENTS.get(typeAndConfig)) != null) {
            return name;
        }
        return pmuNames.apply(typeAndConfig.type) + ",config=" + typeAndConfig.config;
    }

    public static @NonNull String getPmuName(int type) {
        switch (type) {
            case 0: {
                return "hardware";
            }
            case 1: {
                return "software";
            }
            case 3: {
                return "hardware-cache";
            }
            case 4: {
                return "cpu";
            }
            case 5: {
                return "breakpoint";
            }
            case 2: {
                return "tracepoint";
            }
            case 32768: {
                return "user-space-sampler";
            }
        }
        return "type=" + type;
    }

    public static @NonNull String readFormatBitToString(int readFormatBit) {
        int mask = 1 << readFormatBit;
        switch (mask) {
            case 1: {
                return "TOTAL_TIME_ENABLED";
            }
            case 2: {
                return "TOTAL_TIME_RUNNING";
            }
            case 4: {
                return "ID";
            }
            case 8: {
                return "GROUP";
            }
        }
        return Integer.toString(readFormatBit);
    }

    public static @NonNull String readFormatToString(long readFormat) {
        return StreamUtils.longSetBitIndexes((long[])new long[]{readFormat}).mapToObj(EventAndPmuNames::readFormatBitToString).collect(Collectors.joining("|"));
    }

    public static @NonNull String sampleTypeBitToString(int sampleTypeBit) {
        int mask = 1 << sampleTypeBit;
        switch (mask) {
            case 8: {
                return "ADDR";
            }
            case 2048: {
                return "BRANCH_STACK";
            }
            case 32: {
                return "CALLCHAIN";
            }
            case 128: {
                return "CPU";
            }
            case 32768: {
                return "DATA_SRC";
            }
            case 64: {
                return "ID";
            }
            case 65536: {
                return "IDENTIFIER";
            }
            case 1: {
                return "IP";
            }
            case 256: {
                return "PERIOD";
            }
            case 1024: {
                return "RAW";
            }
            case 16: {
                return "READ";
            }
            case 262144: {
                return "REGS_INTR";
            }
            case 4096: {
                return "REGS_USER";
            }
            case 8192: {
                return "STACK_USER";
            }
            case 512: {
                return "STREAM_ID";
            }
            case 2: {
                return "TID";
            }
            case 4: {
                return "TIME";
            }
            case 131072: {
                return "TRANSACTION";
            }
            case 16384: {
                return "WEIGHT";
            }
        }
        return Integer.toString(sampleTypeBit);
    }

    public static @NonNull String sampleTypeToString(long sampleType) {
        return StreamUtils.longSetBitIndexes((long[])new long[]{sampleType}).mapToObj(EventAndPmuNames::sampleTypeBitToString).collect(Collectors.joining("|"));
    }

    public static class TypeAndConfig {
        public final long config;
        public final int type;

        public TypeAndConfig(int type, long config) {
            this.type = type;
            this.config = config;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypeAndConfig other = (TypeAndConfig)obj;
            if (this.config != other.config) {
                return false;
            }
            return this.type == other.type;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.config ^ this.config >>> 32);
            result = 31 * result + this.type;
            return result;
        }
    }
}

