/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.perf.io;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.jdt.annotation.NonNull;

public final class StringIO {
    public static @NonNull String readCString(@NonNull DataInput input) throws IOException {
        StringBuilder result = new StringBuilder();
        try {
            byte chr;
            while ((chr = input.readByte()) != 0) {
                result.append((char)chr);
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return result.toString();
    }

    public static @NonNull String readFixedString(@NonNull ByteBuffer buffer, int length) {
        byte[] data = new byte[length];
        buffer.get(data);
        return new String(data, StandardCharsets.US_ASCII);
    }

    public static char[] readFixedString(@NonNull DataInput input, int length) throws IOException {
        char[] chars = new char[length];
        int i = 0;
        while (i < length) {
            chars[i] = (char)(input.readByte() & 0xFF);
            ++i;
        }
        return chars;
    }

    public static @NonNull String readFixedStringNullTerminated(@NonNull ByteBuffer buffer, int length) {
        byte[] bytes = new byte[length];
        buffer.get(bytes);
        return StringIO.extractNullTerminatedString(bytes, StandardCharsets.US_ASCII);
    }

    public static @NonNull String readFixedStringNullTerminated(@NonNull DataInput input, int length) throws IOException {
        byte[] bytes = new byte[length];
        input.readFully(bytes);
        return StringIO.extractNullTerminatedString(bytes, StandardCharsets.US_ASCII);
    }

    public static @NonNull String extractNullTerminatedString(byte @NonNull [] bytes, @NonNull Charset charset) {
        int pos = 0;
        while (pos < bytes.length) {
            if (bytes[pos] == 0) {
                return new String(bytes, 0, pos, charset);
            }
            ++pos;
        }
        return new String(bytes, charset);
    }

    public static @NonNull String stripNullTerminator(@NonNull String text) {
        return text.replaceAll("\\u0000.*$", "");
    }
}

