/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.log;

import com.arm.streamline.log.IAPCGatorLogCapturer;
import com.arm.streamline.log.IAPCGatorLogWriter;
import java.io.IOException;
import java.util.function.BooleanSupplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class APCGatorLogCapturer
implements IAPCGatorLogCapturer {
    private volatile boolean eosFlag = false;
    private final @NonNull IAPCGatorLogWriter logWriter;
    private final @NonNull BooleanSupplier isCaptureDiscarded;

    public APCGatorLogCapturer(@NonNull IAPCGatorLogWriter logWriter, @NonNull BooleanSupplier isCaptureDiscarded) throws IOException {
        this.logWriter = logWriter;
        this.isCaptureDiscarded = isCaptureDiscarded;
    }

    @Override
    public void close() throws IOException {
        this.eosFlag = true;
        try {
            this.logWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void consumeGatorLogMessage(byte @Nullable [] data) throws IOException {
        if (!this.eosFlag) {
            if (this.isCaptureDiscarded.getAsBoolean()) {
                this.close();
                return;
            }
            try {
                if (data != null && data.length > 0) {
                    this.logWriter.writeLog(data);
                    return;
                }
                this.close();
                return;
            }
            catch (Throwable t) {
                this.close();
                throw t;
            }
        }
    }

    @Override
    public void closeOnDisconnect() {
        this.eosFlag = true;
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

