/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.ftrace;

import com.arm.streamline.common.utility.io.BufferUtils;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.ftrace.TracepointField;
import com.arm.utils.NullChecking;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TracepointFormat {
    public static final int FORMAT_HEADER_EVENT = -2147483646;
    public static final int FORMAT_HEADER_PAGE = -2147483647;
    public static final int FORMAT_TRACEPOINT = -1;
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String FIELD = "\tfield:";
    private static final String ID = "ID: ";
    private static final String NAME = "name: ";
    private static final String TAG_FIELD = "field";
    private final Map<@NonNull String, @NonNull TracepointField> mFields;
    private final long mId;
    private final String mName;

    private static @NonNull ParseResults parse(@NonNull String format, @NonNull Map<@NonNull String, @NonNull TracepointField> fields) {
        int endPos;
        int pos = 0;
        String name = null;
        long id = Long.MIN_VALUE;
        while ((endPos = format.indexOf(10, pos)) != -1) {
            if (pos == endPos) {
                ++pos;
                continue;
            }
            if (format.regionMatches(pos, FIELD, 0, FIELD.length())) {
                TracepointField field = new TracepointField(format.substring(pos + FIELD.length(), endPos));
                fields.put(field.getName(), field);
            } else if (format.regionMatches(pos, NAME, 0, NAME.length())) {
                name = format.substring(pos + NAME.length(), endPos);
            } else if (format.regionMatches(pos, ID, 0, ID.length())) {
                id = Long.parseLong(format.substring(pos + ID.length(), endPos));
            }
            pos = endPos + 1;
        }
        return new ParseResults(name, id);
    }

    public TracepointFormat(int formatType, @NonNull String format) {
        this.mFields = new HashMap<String, TracepointField>();
        ParseResults parseResults = TracepointFormat.parse(format, this.mFields);
        this.mName = parseResults.getName();
        switch (formatType) {
            case -2147483647: 
            case -2147483646: {
                this.mId = formatType;
                break;
            }
            default: {
                this.mId = parseResults.getId();
            }
        }
    }

    public TracepointFormat(int id, @NonNull String name, @NonNull Map<@NonNull String, @NonNull TracepointField> fields) {
        this.mId = id;
        this.mName = name;
        this.mFields = fields;
    }

    public TracepointFormat(@NonNull String format) {
        this.mFields = new HashMap<String, TracepointField>();
        ParseResults parseResults = TracepointFormat.parse(format, this.mFields);
        this.mName = parseResults.getName();
        this.mId = parseResults.getId();
    }

    public TracepointFormat(XMLParser xml) throws IOException {
        String tag;
        this.mFields = new HashMap<String, TracepointField>();
        this.mName = xml.getAttribute(ATTR_NAME);
        this.mId = xml.getLongAttribute(ATTR_ID);
        String marker = xml.getMarker();
        while ((tag = xml.nextTag(marker)) != null) {
            if (TAG_FIELD.equals(tag)) {
                TracepointField field = new TracepointField(xml);
                this.mFields.put(field.getName(), field);
                continue;
            }
            xml.skip();
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TracepointFormat) {
            TracepointFormat that = (TracepointFormat)obj;
            return this.mId == that.mId && NullChecking.equalsNullable((Object)this.mName, (Object)that.mName) && this.mFields.equals(that.mFields);
        }
        return false;
    }

    public TracepointField getField(String string) {
        return this.mFields.get(string);
    }

    public long getId() {
        return this.mId;
    }

    public long getInt(String string, byte[] raw) throws IOException {
        return this.getInt(string, raw, 0);
    }

    public long getInt(String string, byte[] raw, int offset) throws IOException {
        return ((TracepointField)NullChecking.neverNull((Object)this.mFields.get(string))).getInt(raw, offset);
    }

    public @NonNull String getName() {
        @Nullable String name = this.mName;
        if (name != null) {
            return name;
        }
        if (this.mId == -2147483647L) {
            return "header_page";
        }
        if (this.mId == -2147483646L) {
            return "header_event";
        }
        throw new AssertionError();
    }

    public @NonNull String getString(String string, byte[] raw) {
        return this.getString(string, raw, 0);
    }

    public @NonNull String getString(String string, byte[] raw, int offset) {
        return ((TracepointField)NullChecking.neverNull((Object)this.mFields.get(string))).getString(raw, offset);
    }

    public @NonNull String getDynamicString(@NonNull String field, byte[] raw) {
        TracepointField tracepointField = this.mFields.get(field);
        if (tracepointField == null) {
            throw new AssertionError((Object)String.format("The tracepoint format is not present for %s", field));
        }
        if (tracepointField.getSize() != 4) {
            throw new AssertionError((Object)"The string descriptor should be exactly four bytes");
        }
        if (!tracepointField.isDynamicString()) {
            throw new AssertionError((Object)"The given tracepoint field is not of type dynamic string");
        }
        int offset = tracepointField.getOffset();
        try {
            short stringOffset = BufferUtils.readLEShort((byte[])raw, (int)offset);
            short stringLength = BufferUtils.readLEShort((byte[])raw, (int)(offset + 2));
            if (raw.length < stringOffset + stringLength) {
                throw new AssertionError((Object)"Invalid tracepoint raw data: incomplete or no string data found");
            }
            return new String(raw, (int)stringOffset, stringLength - 1, StandardCharsets.US_ASCII);
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)"The raw data for the given tracepoint does not contain a string descriptor or any string data");
        }
    }

    public boolean getBool(@NonNull String field, byte[] raw) throws IOException {
        TracepointField tracepointField = this.mFields.get(field);
        if (tracepointField == null) {
            throw new AssertionError((Object)String.format("The tracepoint format is not present for %s", field));
        }
        return tracepointField.getInt(raw, 0) != 0L;
    }

    public int hashCode() {
        return Long.hashCode(this.mId);
    }

    public void print(byte[] raw) {
        System.out.println(this.mName);
        for (TracepointField field : this.mFields.values()) {
            field.print(raw);
        }
        System.out.println();
    }

    public String toString() {
        return String.format("TracepointFormat [mId=%s, mName=%s, mFields=%s]", this.mId, this.mName, this.mFields);
    }

    public void write(XMLGenerator xml) throws IOException {
        xml.addAttribute(ATTR_NAME, this.mName);
        xml.addAttribute(ATTR_ID, this.mId);
        for (TracepointField field : this.mFields.values()) {
            xml.startEmptyTag(TAG_FIELD);
            field.write(xml);
        }
    }

    private static class ParseResults {
        private final long mId;
        private final @Nullable String mName;

        public ParseResults(@Nullable String name, long id) {
            this.mName = name;
            this.mId = id;
        }

        public long getId() {
            return this.mId;
        }

        public @Nullable String getName() {
            return this.mName;
        }
    }
}

