/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.jdibridge;

import com.arm.mgd.utils.NullUtils;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.MethodEntryRequest;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdi.Bootstrap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class JDILibraryInjector {
    private static final @NonNull String NO_EMPTY_ARGUMENTS_CONSTRUCTOR_FOUND_ERROR = "Unable to find a constructor without parameters while injecting the interceptor library.";
    private static final @NonNull String NO_SYSTEM_CLASS_FOUND_ERROR = "Unable to find the System class on the target VM while injecting the interceptor library.";
    private static final @NonNull String NO_LOAD_METHOD_FOUND_ERROR = "Unable to find the \"load\" method for the System class while injecting the interceptor library.";
    private static final @NonNull String MISSING_DEFAULT_ARGUMENT_ERROR = "Connector did not return all required default arguments while injecting the interceptor library.";
    private static final @NonNull String NO_ANDROID_APPLICATION_ERROR = "Unable to find android.app.Application while injecting the interceptor library.";
    private static final @NonNull String HOSTNAME_KEY = "hostname";
    private static final @NonNull String HOSTNAME_VAL = "localhost";
    private static final @NonNull String PORT_KEY = "port";
    private static final @NonNull String TIMEOUT_KEY = "timeout";
    private static final @NonNull ExecutorService EXECUTOR = (ExecutorService)NullUtils.neverNull((Object)Executors.newSingleThreadExecutor());
    private static final @NonNull String SOCKET_ATTACH_NAME = "com.sun.jdi.SocketAttach";

    public static void injectLibrary(int hostPort, @NonNull String libraryLocationOnTarget, long timeout, @NonNull TimeUnit timeoutUnit) throws Throwable {
        AttachingConnector socketAttachConnector = JDILibraryInjector.getSocketAttachConnectorFromVMM((VirtualMachineManager)NullUtils.neverNull((Object)Bootstrap.virtualMachineManager()));
        Map<String, Connector.Argument> dargs = socketAttachConnector.defaultArguments();
        Connector.Argument hostnameArg = dargs.get(HOSTNAME_KEY);
        Connector.Argument portArg = dargs.get(PORT_KEY);
        Connector.Argument timeoutArg = dargs.get(TIMEOUT_KEY);
        if (hostnameArg == null || portArg == null || timeoutArg == null) {
            throw new IllegalStateException(MISSING_DEFAULT_ARGUMENT_ERROR);
        }
        hostnameArg.setValue(HOSTNAME_VAL);
        portArg.setValue(Integer.toString(hostPort));
        timeoutArg.setValue("0");
        VirtualMachine vm = socketAttachConnector.attach(dargs);
        vm.suspend();
        EventRequestManager emgr = vm.eventRequestManager();
        EventQueue eventQueue = vm.eventQueue();
        ClassType androidAppApplicationClass = (ClassType)vm.classesByName("android.app.Application").stream().findFirst().orElseThrow(() -> new IllegalStateException(NO_ANDROID_APPLICATION_ERROR));
        List<Method> allConstructors = androidAppApplicationClass.methodsByName("<init>");
        Method noArgumentConstructor = allConstructors.stream().filter(JDILibraryInjector::areMethodArgumentsEmpty).findAny().orElseThrow(() -> new IllegalStateException(NO_EMPTY_ARGUMENTS_CONSTRUCTOR_FOUND_ERROR));
        MethodEntryRequest applicationMethodSuspendAllRequest = emgr.createMethodEntryRequest();
        applicationMethodSuspendAllRequest.addClassFilter(androidAppApplicationClass);
        applicationMethodSuspendAllRequest.setSuspendPolicy(2);
        applicationMethodSuspendAllRequest.enable();
        vm.resume();
        try {
            while (true) {
                Future<EventSet> futureEvents = EXECUTOR.submit(() -> eventQueue.remove());
                EventSet eventsFromEventQueue = futureEvents.get(timeout, timeoutUnit);
                for (Event queuedEvent : eventsFromEventQueue) {
                    if (!(queuedEvent instanceof MethodEntryEvent)) continue;
                    MethodEntryEvent event = (MethodEntryEvent)queuedEvent;
                    Method method = event.method();
                    if (!JDILibraryInjector.sameMethod((Method)NullUtils.neverNull((Object)noArgumentConstructor), (Method)NullUtils.neverNull((Object)method))) continue;
                    ThreadReference thread = event.thread();
                    emgr.methodEntryRequests().forEach(EventRequest::disable);
                    ClassType javaSystemClass = (ClassType)vm.classesByName("java.lang.System").stream().findAny().orElseThrow(() -> new IllegalStateException(NO_SYSTEM_CLASS_FOUND_ERROR));
                    Method loadMethod = (Method)javaSystemClass.methodsByName("load", "(Ljava/lang/String;)V").stream().findAny().orElseThrow(() -> new IllegalStateException(NO_LOAD_METHOD_FOUND_ERROR));
                    StringReference targetLibraryReference = vm.mirrorOf(libraryLocationOnTarget);
                    javaSystemClass.invokeMethod(thread, loadMethod, List.of(targetLibraryReference), 0);
                    return;
                }
                vm.resume();
            }
        }
        finally {
            vm.dispose();
        }
    }

    private static @NonNull AttachingConnector getSocketAttachConnectorFromVMM(@NonNull VirtualMachineManager vmm) {
        return vmm.attachingConnectors().stream().filter(atc -> atc.name().equals(SOCKET_ATTACH_NAME)).findAny().orElseThrow(() -> new RuntimeException("Unable to find SocketAttachConnector"));
    }

    private static boolean areMethodArgumentsEmpty(@Nullable Method method) {
        try {
            return method != null && method.arguments().isEmpty();
        }
        catch (AbsentInformationException e) {
            return false;
        }
    }

    private static boolean sameMethod(@NonNull Method a, @NonNull Method b) {
        return a.name().contentEquals(b.name()) && a.signature().contentEquals(b.signature());
    }
}

