/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util.tree;

import com.arm.util.tree.Filter;
import com.arm.util.tree.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SimpleNode<E>
implements Node<E> {
    private final E innerObject;
    private final List<Node<E>> children;
    private Node<E> parent;

    public SimpleNode(E object) {
        this.innerObject = object;
        this.children = new ArrayList<Node<E>>();
    }

    @Override
    public final void setParent(Node<E> parent) {
        this.parent = parent;
    }

    @Override
    public final E getObject() {
        return this.innerObject;
    }

    @Override
    public final Node<E> getParent() {
        return this.parent;
    }

    @Override
    public final List<Node<E>> getChildren() {
        return this.getChildren(false);
    }

    @Override
    public final List<Node<E>> getChildren(boolean flatten) {
        return this.getChildren(flatten, null);
    }

    @Override
    public final List<Node<E>> getChildren(boolean flatten, Filter<E> filter) {
        List<Object> result;
        if (flatten) {
            result = new ArrayList();
            for (Node<E> child : this.children) {
                if (filter == null || filter.accept(child)) {
                    result.add(child);
                }
                result.addAll(child.getChildren(flatten, filter));
            }
        } else if (filter == null) {
            result = this.children;
        } else {
            result = new ArrayList(this.children.size());
            for (Node<E> child : this.children) {
                if (!filter.accept(child)) continue;
                result.add(child);
            }
        }
        return result;
    }

    @Override
    public final void addChild(Node<E> child) {
        child.setParent(this);
        this.children.add(child);
    }

    @Override
    public final void addChildren(Collection<Node<E>> children) {
        for (Node<E> child : children) {
            this.addChild(child);
        }
    }

    @Override
    public Node<E> getChild(int index) {
        return this.children.get(index);
    }

    @Override
    public List<Node<E>> find(E object, boolean recurse) {
        ArrayList<Node<Node<E>>> result = new ArrayList<Node<Node<E>>>();
        for (Node<E> child : this.children) {
            if (child.getObject() == object || child.getObject().equals(object)) {
                result.add(child);
            }
            if (!recurse) continue;
            result.addAll(child.find(object, recurse));
        }
        return result;
    }

    void stringify(Node<E> node, StringBuilder builder, int level) {
        int i = 1;
        while (i < level) {
            builder.append(" .");
            ++i;
        }
        if (level == 0) {
            builder.append(".");
        } else {
            builder.append(" :.");
        }
        builder.append(node.getObject());
        builder.append('\n');
        for (Node<E> child : node.getChildren()) {
            this.stringify(child, builder, level + 1);
        }
    }

    @Override
    public void removeChild(int index) {
        Node node = this.children.remove(index);
        node.setParent(null);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.stringify(this, builder, 0);
        return builder.toString();
    }
}

