/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util.tree;

import java.util.Arrays;

class RedBlackTreeStorage<V> {
    public static final int INVALID_NODE = -1;
    private static final Object DELETED_NODE = new Object();
    private int[][] lrkpArray = new int[0][0];
    private static final int LEFT_OFFSET = 0;
    private static final int RIGHT_OFFSET = 1;
    private static final int KEY_OFFSET = 2;
    private static final int PARENT_OFFSET = 3;
    private Object[][] valueArray = new Object[0][0];
    private int[] freeArray = new int[0];
    private int[][] redArray = new int[0][0];
    private static final int INDEX_SIZE_IN_BITS = 8;
    private static final int INDEX_SIZE = 256;
    private static final int INDEX_MASK = 255;
    private int nextArrayForAllocation;
    private int nextIndexForAllocation = 256;

    RedBlackTreeStorage() {
    }

    private void allocateNewNodeArrays() {
        this.valueArray = (Object[][])Arrays.copyOf(this.valueArray, this.valueArray.length + 1);
        this.lrkpArray = (int[][])Arrays.copyOf(this.lrkpArray, this.lrkpArray.length + 1);
        this.redArray = (int[][])Arrays.copyOf(this.redArray, this.redArray.length + 1);
        this.freeArray = Arrays.copyOf(this.freeArray, this.freeArray.length + 1);
        this.freeArray[this.freeArray.length - 1] = 256;
        this.nextArrayForAllocation = this.lrkpArray.length - 1;
        this.nextIndexForAllocation = 0;
    }

    public int allocateNode(int key, V value) {
        if (this.nextIndexForAllocation >= 256) {
            ++this.nextArrayForAllocation;
            this.nextIndexForAllocation = 0;
        }
        while (this.nextArrayForAllocation < this.freeArray.length && this.freeArray[this.nextArrayForAllocation] == 0) {
            ++this.nextArrayForAllocation;
            this.nextIndexForAllocation = 0;
        }
        if (this.nextArrayForAllocation >= this.freeArray.length) {
            this.allocateNewNodeArrays();
        }
        if (this.valueArray[this.nextArrayForAllocation] == null) {
            Object[] values = new Object[256];
            Arrays.fill(values, DELETED_NODE);
            this.valueArray[this.nextArrayForAllocation] = values;
            this.lrkpArray[this.nextArrayForAllocation] = new int[1024];
            this.redArray[this.nextArrayForAllocation] = new int[8];
        }
        while (this.valueArray[this.nextArrayForAllocation][this.nextIndexForAllocation] != DELETED_NODE) {
            ++this.nextIndexForAllocation;
        }
        int node = this.nextArrayForAllocation << 8 | this.nextIndexForAllocation;
        this.setParent(node, -1);
        this.setLeft(node, -1);
        this.setRight(node, -1);
        this.setKey(node, key);
        this.setValue(node, value);
        int n = this.nextArrayForAllocation;
        this.freeArray[n] = this.freeArray[n] - 1;
        ++this.nextIndexForAllocation;
        return node;
    }

    public void deleteNode(int node) {
        int array = node >> 8;
        int index = node & 0xFF;
        if (this.valueArray[array][index] == DELETED_NODE) {
            return;
        }
        this.valueArray[array][index] = DELETED_NODE;
        int n = array;
        this.freeArray[n] = this.freeArray[n] + 1;
        if (this.freeArray[array] == 256) {
            this.valueArray[array] = null;
            this.lrkpArray[array] = null;
            this.redArray[array] = null;
        }
        if (array < this.nextArrayForAllocation || array == this.nextArrayForAllocation && index < this.nextIndexForAllocation) {
            this.nextArrayForAllocation = array;
            this.nextIndexForAllocation = index;
        }
    }

    public int getKey(int node) {
        int array = node >> 8;
        int index = (node & 0xFF) * 4 + 2;
        return this.lrkpArray[array][index];
    }

    public void setKey(int node, int key) {
        int array = node >> 8;
        int index = (node & 0xFF) * 4 + 2;
        this.lrkpArray[array][index] = key;
    }

    public V getValue(int node) {
        int array = node >> 8;
        int index = node & 0xFF;
        return (V)this.valueArray[array][index];
    }

    public void setValue(int node, V value) {
        int array = node >> 8;
        int index = node & 0xFF;
        this.valueArray[array][index] = value;
    }

    public int getParent(int node) {
        int array = node >> 8;
        int index = (node & 0xFF) * 4 + 3;
        return this.lrkpArray[array][index];
    }

    public void setParent(int node, int parent) {
        int array = node >> 8;
        int index = (node & 0xFF) * 4 + 3;
        this.lrkpArray[array][index] = parent;
    }

    public int getLeft(int node) {
        int array = node >> 8;
        int index = (node & 0xFF) * 4 + 0;
        return this.lrkpArray[array][index];
    }

    public void setLeft(int node, int left) {
        int array = node >> 8;
        int index = (node & 0xFF) * 4 + 0;
        this.lrkpArray[array][index] = left;
    }

    public int getRight(int node) {
        int array = node >> 8;
        int index = (node & 0xFF) * 4 + 1;
        return this.lrkpArray[array][index];
    }

    public void setRight(int node, int right) {
        int array = node >> 8;
        int index = (node & 0xFF) * 4 + 1;
        this.lrkpArray[array][index] = right;
    }

    public boolean getRed(int node) {
        int array = node >> 8;
        int index = (node & 0xFF) / 32;
        int bit = 1 << node % 32;
        return (this.redArray[array][index] & bit) != 0;
    }

    public void setRed(int node, boolean red) {
        int array = node >> 8;
        int index = (node & 0xFF) / 32;
        int bit = 1 << node % 32;
        if (red) {
            int[] nArray = this.redArray[array];
            int n = index;
            nArray[n] = nArray[n] | bit;
        } else {
            int[] nArray = this.redArray[array];
            int n = index;
            nArray[n] = nArray[n] & ~bit;
        }
    }
}

