/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CharTree<T> {
    protected final Node<T> rootNode = new Node(Character.valueOf('\u0000').charValue());
    private static final Map<Character, Character> otherCaseMap = new HashMap<Character, Character>();
    private final boolean caseInsensitive;

    static {
        int diff = -32;
        int i = 97;
        while (i <= 122) {
            Character indexed = Character.valueOf((char)(i + diff));
            Character unIndexed = Character.valueOf((char)i);
            otherCaseMap.put(indexed, unIndexed);
            otherCaseMap.put(unIndexed, indexed);
            ++i;
        }
    }

    public CharTree(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    public void addNode(String s, T t) {
        char[] chars = s.toCharArray();
        Node<T> node = this.rootNode;
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            Node<T> newNode = node.getChildren().get(Character.valueOf(c));
            if (newNode == null) {
                newNode = new Node(c);
                node.addChild(newNode);
            }
            node = newNode;
            ++i;
        }
        node.setContent(t);
    }

    public T lookup(String s) throws AmbiguousException {
        char[] chars = s.toCharArray();
        Node<T> node = this.rootNode;
        int i = 0;
        while (i < chars.length) {
            Character c = Character.valueOf(chars[i]);
            Node<T> newNode = node.getChildren().get(c);
            if (newNode == null && this.caseInsensitive) {
                newNode = node.getChildren().get(otherCaseMap.get(c));
            }
            if (newNode == null) {
                return null;
            }
            node = newNode;
            ++i;
        }
        T content = node.getContent();
        while (node.getChildren().size() == 1) {
            content = node.getContent();
            if (content != null) break;
            node = node.getChildren().entrySet().iterator().next().getValue();
        }
        if (content == null && node.getChildren().size() > 1) {
            throw new AmbiguousException(this.getCompletions(s));
        }
        return node.getContent();
    }

    private List<String> getCompletions(String s) {
        char[] chars = s.toCharArray();
        Node<T> node = this.rootNode;
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            Node<T> newNode = node.getChildren().get(Character.valueOf(c));
            if (newNode == null && this.caseInsensitive) {
                newNode = node.getChildren().get(otherCaseMap.get(Character.valueOf(c)));
            }
            if (newNode == null) {
                return null;
            }
            node = newNode;
            ++i;
        }
        ArrayList<String> completions = new ArrayList<String>();
        this.getCompletions(s, node, completions);
        return completions;
    }

    private void getCompletions(String priorContent, Node<T> node, List<String> resultList) {
        if (node.getContent() != null) {
            resultList.add(priorContent);
        }
        for (Node<T> child : node.getChildren().values()) {
            String thisContent = String.valueOf(priorContent) + child.getChar();
            this.getCompletions(thisContent, child, resultList);
        }
    }

    public static class AmbiguousException
    extends Exception {
        private static final long serialVersionUID = -3076727790379517675L;
        private final List<String> completions;

        public AmbiguousException(List<String> completions) {
            this.completions = completions;
        }

        public List<String> getCompletions() {
            return this.completions;
        }
    }

    protected static class Node<T> {
        private final Map<Character, Node<T>> children;
        private T content;
        private final char c;

        public Node(char c) {
            this.c = c;
            this.children = new HashMap<Character, Node<T>>();
            this.content = null;
        }

        public Map<Character, Node<T>> getChildren() {
            return Collections.unmodifiableMap(this.children);
        }

        public void addChild(Node<T> child) {
            Character c = Character.valueOf(child.getChar());
            this.children.put(c, child);
        }

        public void setContent(T content) {
            this.content = content;
        }

        public T getContent() {
            return this.content;
        }

        public char getChar() {
            return this.c;
        }
    }
}

