/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util.libs;

import com.arm.io.Files;
import com.arm.io.JVMTempFolder;
import com.arm.util.Tuple;
import com.arm.util.libs.AbstractURLResolver;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class JarURLResolver
extends AbstractURLResolver {
    private static final Logger log = Logger.getLogger(JarURLResolver.class.getName());

    @Override
    public String getSupportedProtocol() {
        return "jar";
    }

    private Tuple<String, String> parse(URL url) throws IOException {
        int lastCharIndex;
        String path;
        this.checkSupportedProtocol(url);
        URL fileURL = new URL(url.getPath());
        try {
            path = fileURL.toURI().getSchemeSpecificPart();
        }
        catch (URISyntaxException uRISyntaxException) {
            path = fileURL.getPath();
        }
        int mark = path.indexOf(33);
        String jar = path.substring(0, mark);
        String entry = path.substring(mark + 2);
        if (!entry.isEmpty() && entry.charAt(lastCharIndex = entry.length() - 1) == '/') {
            entry = entry.substring(0, lastCharIndex);
        }
        return new Tuple<String, String>(jar, entry);
    }

    @Override
    public String getPhysicalPath(URL url) throws IOException {
        return (String)this.parse((URL)url).tb;
    }

    @Override
    public File resolve(URL url) throws IOException {
        return this.resolve(url, null);
    }

    @Override
    public File resolve(URL url, File targetDir) throws IOException {
        Tuple<String, String> parsed = this.parse(url);
        return this.extract(new File((String)parsed.ta), (String)parsed.tb, targetDir);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected File extract(File jarFile, String entry, File targetDir) throws IOException {
        boolean trace = log.isLoggable(Level.FINER);
        if (targetDir == null) {
            targetDir = JVMTempFolder.getJVMTempFolder();
        } else {
            Files.mkdirs(targetDir);
        }
        if (trace) {
            log.finer("extracting " + entry + " from jar file " + jarFile + " to " + targetDir);
            log.finer("examining jar file " + jarFile);
        }
        ZipFile zipFile = new ZipFile(jarFile);
        FileInputStream fis = new FileInputStream(jarFile);
        BufferedInputStream bis = new BufferedInputStream(fis);
        ZipInputStream zis = new ZipInputStream(bis);
        ZipEntry ze = zis.getNextEntry();
        while (ze != null) {
            block17: {
                block15: {
                    File extractedFile;
                    block18: {
                        block19: {
                            block16: {
                                String entryName = ze.getName();
                                if (!entryName.startsWith(entry)) break block15;
                                if (trace) {
                                    log.finer("found matching entry " + entryName);
                                }
                                extractedFile = new File(targetDir, entryName);
                                if (!ze.isDirectory()) break block16;
                                if (trace && !extractedFile.exists()) {
                                    log.finer("creating target folder " + extractedFile);
                                }
                                Files.mkdirs(extractedFile);
                                break block17;
                            }
                            if (!extractedFile.exists()) break block18;
                            if (trace) {
                                log.finer("target file " + extractedFile + " already exists");
                            }
                            if (extractedFile.lastModified() != ze.getTime()) break block19;
                            if (trace) {
                                log.finer("identical file timestamp: skipping");
                            }
                            break block17;
                        }
                        if (trace) {
                            log.finer("deleting existing " + extractedFile);
                        }
                        Files.delete(extractedFile);
                    }
                    if (trace && !extractedFile.getParentFile().exists()) {
                        log.finer("creating target folder " + extractedFile.getParentFile());
                    }
                    Files.mkdirs(extractedFile.getParentFile());
                    log.finer("creating target file " + extractedFile);
                    Files.createFile(extractedFile);
                    if (trace) {
                        log.finer("extracting " + ze.getName() + " to " + extractedFile);
                    }
                    InputStream is = zipFile.getInputStream(ze);
                    Files.copy(is, extractedFile);
                    is.close();
                    if (ze.getTime() != -1L) {
                        if (trace) {
                            log.finer("restoring file timestamp on " + extractedFile);
                        }
                        if (!extractedFile.setLastModified(ze.getTime())) {
                            log.finer("could not set timestamp for " + extractedFile);
                        }
                    }
                    break block17;
                }
                if (trace) {
                    log.finer("discarding entry " + ze.getName());
                }
            }
            ze = zis.getNextEntry();
        }
        zis.close();
        zipFile.close();
        return new File(targetDir, entry);
    }
}

