/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util;

import com.arm.util.ParseXMLException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XPathAPIWrapper {
    private static Method __selectSingleNode;
    private static Method __selectNodeList;

    static {
        Class<?> XPathAPI = null;
        try {
            XPathAPI = Class.forName("org.apache.xpath.XPathAPI");
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                XPathAPI = Class.forName("com.sun.org.apache.xpath.internal.XPathAPI");
            }
            catch (ClassNotFoundException e1) {
                throw new Error(e1);
            }
        }
        try {
            __selectSingleNode = XPathAPI.getMethod("selectSingleNode", Node.class, String.class);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        try {
            __selectNodeList = XPathAPI.getMethod("selectNodeList", Node.class, String.class);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
    }

    public static Node selectSingleNode(Node node, String xpath) {
        try {
            return (Node)__selectSingleNode.invoke(null, node, xpath);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        return null;
    }

    public static NodeList selectNodeList(Node contextNode, String xpath) throws TransformerException {
        try {
            return (NodeList)__selectNodeList.invoke(null, contextNode, xpath);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        return null;
    }

    public static Document parseXmlFile(InputStream file, boolean validating) throws ParseXMLException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(validating);
            Document doc = factory.newDocumentBuilder().parse(file);
            return doc;
        }
        catch (IOException ioe) {
            throw new ParseXMLException(ioe.getMessage(), ioe);
        }
        catch (SAXException se) {
            throw new ParseXMLException(se.getMessage(), se);
        }
        catch (ParserConfigurationException pce) {
            throw new ParseXMLException(pce.getMessage(), pce);
        }
    }

    public static Document parseXmlFile(InputStream file, final InputStream dtd) throws ParseXMLException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    if (systemId.contains(".dtd")) {
                        return new InputSource(dtd);
                    }
                    return null;
                }
            });
            Document doc = builder.parse(file);
            return doc;
        }
        catch (IOException ioe) {
            throw new ParseXMLException(ioe.getMessage(), ioe);
        }
        catch (SAXException se) {
            throw new ParseXMLException(se.getMessage(), se);
        }
        catch (ParserConfigurationException pce) {
            throw new ParseXMLException(pce.getMessage(), pce);
        }
    }

    public static String getTextValue(Node parentNode, String key) throws TransformerException {
        Node node = XPathAPIWrapper.selectSingleNode(parentNode, key);
        if (node != null) {
            return node.getNodeValue();
        }
        return "";
    }

    public static Document stringToDom(String xml) throws ParseXMLException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            Document d = xml.trim().length() == 0 ? factory.newDocumentBuilder().newDocument() : factory.newDocumentBuilder().parse(new InputSource(new StringReader(xml)));
            return d;
        }
        catch (IOException ioe) {
            throw new ParseXMLException(ioe.getMessage(), ioe);
        }
        catch (SAXException se) {
            throw new ParseXMLException(se.getMessage(), se);
        }
        catch (ParserConfigurationException pce) {
            throw new ParseXMLException(pce.getMessage(), pce);
        }
    }

    public static String domToString(Document document) throws TransformerException {
        return XPathAPIWrapper.domToString(document.getDocumentElement());
    }

    public static String domToString(Node rootNode) throws TransformerException {
        String result = null;
        if (rootNode != null) {
            StringWriter strWtr = new StringWriter();
            StreamResult strResult = new StreamResult(strWtr);
            TransformerFactory tfac = TransformerFactory.newInstance();
            Transformer t = tfac.newTransformer();
            t.setOutputProperty("encoding", "UTF8");
            t.setOutputProperty("indent", "yes");
            t.setOutputProperty("method", "xml");
            t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            t.transform(new DOMSource(rootNode), strResult);
            result = strResult.getWriter().toString();
        }
        return result;
    }

    public static List<String> getElementTextContents(Node contextNode, String xpath) throws TransformerException {
        NodeList nodes = XPathAPIWrapper.selectNodeList(contextNode, xpath);
        ArrayList<String> result = new ArrayList<String>(nodes.getLength());
        int i = 0;
        while (i < nodes.getLength()) {
            Element currentElement = (Element)nodes.item(i);
            result.add(currentElement.getTextContent());
            ++i;
        }
        return result;
    }

    public static List<String> getAttributeValues(Node contextNode, String xpath, String attributeName) throws TransformerException {
        NodeList nodes = XPathAPIWrapper.selectNodeList(contextNode, xpath);
        ArrayList<String> result = new ArrayList<String>(nodes.getLength());
        int i = 0;
        while (i < nodes.getLength()) {
            Element currentElement = (Element)nodes.item(i);
            result.add(currentElement.getAttribute(attributeName));
            ++i;
        }
        return result;
    }
}

