/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util;

import com.arm.text.FormattedMessage;
import com.arm.text.IFormattedMessage;
import com.arm.text.ILayer;
import com.arm.text.IMessage;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.annotation.Nullable;

public enum Messages implements IMessage
{
    CLASS_LOADERS_CLASS_FOUND_IN("001_ClassLoadersClassFoundIn", 1),
    MES("002_MES", 2),
    NT("003_NT", 3),
    MUNGED_TO("004_mungedTo", 4),
    UNRECOGNISED_EOL("005_unrecognisedEOL", 5),
    WINDOWS("006_windows", 6),
    SOLARIS("006_solaris", 6),
    HPUX("007_hpux", 7),
    LINUX("008_linux", 8),
    INTERVAL_PROGRESS_LISTENER_MUST_HAVE_BEGIN_LESS_THAN_END("009_IntervalProgressListenerMustHaveBeginLessThanEnd", 9),
    MY_RES("010_myRes", 10),
    N_MUST_BE_POSITIVE("011_nMustBePositive", 11),
    UNABLE_TO_LOCATE_APPLICATION("012_unableToLocateApplication", 12),
    DAY("013_DAY", 13),
    DAYS("014_DAYS", 14),
    HOUR("015_HOUR", 15),
    HOURS("016_HOURS", 16),
    MINUTE("017_MINUTE", 17),
    MINUTES("018_MINUTES", 18),
    SECOND("019_SECOND", 19),
    SECONDS("020_SECONDS", 20);

    private static final ResourceBundle RESOURCE_BUNDLE_ENGLISH;
    private static ResourceBundle RESOURCE_BUNDLE_LOCALISED;
    private final String key;
    private final int code;

    static {
        RESOURCE_BUNDLE_ENGLISH = ResourceBundle.getBundle("com/arm/util/messages", Locale.ROOT);
        Messages.refreshLocalized();
    }

    public static void refreshLocalized() {
        RESOURCE_BUNDLE_LOCALISED = ResourceBundle.getBundle("com/arm/util/messages");
    }

    private Messages(String key, int code) {
        this.key = key;
        this.code = code;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getEnglishValue(Object ... args) {
        String englishMessage = RESOURCE_BUNDLE_ENGLISH.getString(this.key);
        englishMessage = Messages.removeParameterNames(englishMessage);
        return (args = Messages.removeNesting(args, false)) != null && args.length > 0 ? MessageFormat.format(englishMessage, args) : englishMessage;
    }

    @Override
    public String getLocalisedValue(Object ... args) {
        String localMessage = RESOURCE_BUNDLE_LOCALISED.getString(this.key);
        localMessage = Messages.removeParameterNames(localMessage);
        return (args = Messages.removeNesting(args, true)) != null && args.length > 0 ? MessageFormat.format(localMessage, args) : localMessage;
    }

    private static Object[] removeNesting(@Nullable Object[] args, boolean localise) {
        if (args != null) {
            boolean isCopy = false;
            int i = 0;
            while (i < args.length) {
                Object a = args[i];
                if (a instanceof IFormattedMessage || a instanceof IMessage) {
                    if (!isCopy) {
                        isCopy = true;
                        args = Arrays.copyOf(args, args.length);
                    }
                    args[i] = a instanceof IFormattedMessage ? (localise ? ((IFormattedMessage)a).getLocalisedValue() : ((IFormattedMessage)a).getEnglishValue()) : (localise ? ((IMessage)a).getLocalisedValue(new Object[0]) : ((IMessage)a).getEnglishValue(new Object[0]));
                }
                ++i;
            }
        }
        return args;
    }

    private static String removeParameterNames(String message) {
        if (message.indexOf(123) < 0) {
            return message;
        }
        StringBuilder builder = new StringBuilder();
        boolean strip = false;
        boolean quoted = false;
        int i = 0;
        while (i < message.length()) {
            char current = message.charAt(i);
            switch (current) {
                case '\'': {
                    builder.append(current);
                    if (quoted) {
                        quoted = false;
                        break;
                    }
                    quoted = true;
                    break;
                }
                case '{': {
                    builder.append(current);
                    if (!quoted) {
                        int end = message.indexOf(125, i);
                        int colon = message.indexOf(58, i);
                        if (colon > 0 && colon < end) {
                            strip = true;
                        }
                    }
                    quoted = false;
                    break;
                }
                case ':': {
                    if (!strip) {
                        builder.append(current);
                    }
                    strip = false;
                    quoted = false;
                    break;
                }
                default: {
                    if (!strip) {
                        builder.append(current);
                    }
                    quoted = false;
                }
            }
            ++i;
        }
        return builder.toString();
    }

    @Override
    public IFormattedMessage format(Object ... args) {
        return new FormattedMessage(this, args);
    }

    @Override
    public ILayer getLayer() {
        return null;
    }
}

