/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public final class Lists {
    public static <T> boolean listEndsWith(List<T> list, List<? extends T> candidateTail) {
        int aIndex = list.size();
        int bIndex = candidateTail.size();
        while (aIndex > 0 && bIndex > 0) {
            T a = list.get(aIndex - 1);
            T b = candidateTail.get(bIndex - 1);
            if (a == null && b == null) {
                --aIndex;
                --bIndex;
                continue;
            }
            if (a != null && b == null || a == null && b != null) {
                return false;
            }
            if (a != null && !a.equals(b)) {
                return false;
            }
            --aIndex;
            --bIndex;
        }
        return true;
    }

    public static <T> Iterable<T> reversed(List<T> list) {
        final ListIterator<T> iterator = list.listIterator(list.size());
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasPrevious();
                    }

                    @Override
                    public T next() {
                        return iterator.previous();
                    }
                };
            }
        };
    }
}

