/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util;

import com.arm.util.JVMHeapWatchdogListener;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Timer;
import java.util.TimerTask;

public class JVMHeapWatchdog {
    private static final long MAX_HEAP = Runtime.getRuntime().maxMemory();
    private static final MemoryMXBean bean = ManagementFactory.getMemoryMXBean();
    public static final float DEFAULT_THRESHOLD_HWM = 0.95f;
    public static final float DEFAULT_THRESHOLD_LWM = 0.75f;
    public static final int DEFAULT_MIN_SAMPLE_COUNT = 10;
    public static final long DEFAULT_PERIOD = 1000L;
    private static Timer timer;
    private final Collection<JVMHeapWatchdogListener> listeners = new ArrayList<JVMHeapWatchdogListener>(3);
    private final float thresholdHwm;
    private final float thresholdLwm;
    private final int minSampleCount;
    private final long period;
    private int samplesAboveThreshold;
    private int samplesBelowThreshold;
    private long lastSample;
    private boolean isAboveThreshold;
    private TimerTask task;

    public JVMHeapWatchdog(float thresholdHwm, float thresholdLwm, int minSampleCount, long period) {
        if (thresholdHwm > 1.0f) {
            throw new IllegalArgumentException("illegal threshold high-water mark value: " + thresholdHwm);
        }
        if (thresholdLwm <= 0.0f) {
            throw new IllegalArgumentException("illegal threshold low-water mark value: " + thresholdLwm);
        }
        if (thresholdLwm >= thresholdHwm) {
            throw new IllegalArgumentException("threshold low-water mark greater or equals to threshold high-water mark: " + thresholdLwm + " >= " + thresholdHwm);
        }
        if (minSampleCount < 1) {
            throw new IllegalArgumentException("illegal minimum sample count value: " + minSampleCount);
        }
        if (period < 1L) {
            throw new IllegalArgumentException("illegal period value: " + period);
        }
        this.thresholdHwm = thresholdHwm;
        this.thresholdLwm = thresholdLwm;
        this.minSampleCount = minSampleCount;
        this.period = period;
    }

    public JVMHeapWatchdog() {
        this(0.95f, 0.75f, 10, 1000L);
    }

    private static synchronized Timer getTimer() {
        if (timer == null) {
            timer = new Timer();
        }
        return timer;
    }

    public synchronized void start() {
        if (this.task == null) {
            this.task = new TimerTask(){

                @Override
                public void run() {
                    JVMHeapWatchdog.this.setUsedHeap(bean.getHeapMemoryUsage().getUsed());
                }
            };
            JVMHeapWatchdog.getTimer().scheduleAtFixedRate(this.task, this.period, this.period);
        }
    }

    public synchronized void stop() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
    }

    synchronized void setUsedHeap(long usedHeap) {
        block12: {
            float usedRatio;
            block11: {
                this.lastSample = usedHeap;
                usedRatio = (float)((double)usedHeap / (double)MAX_HEAP);
                if (!(usedRatio > this.thresholdHwm)) break block11;
                if (this.samplesBelowThreshold > 0) {
                    this.samplesBelowThreshold = 0;
                }
                if (this.isAboveThreshold) break block12;
                if (this.samplesAboveThreshold <= this.minSampleCount) {
                    ++this.samplesAboveThreshold;
                }
                if (this.samplesAboveThreshold >= this.minSampleCount) {
                    this.isAboveThreshold = true;
                    for (JVMHeapWatchdogListener listener : this.listeners) {
                        listener.thresholdExceeded(usedHeap, MAX_HEAP);
                    }
                }
                break block12;
            }
            if (this.samplesAboveThreshold > 0) {
                this.samplesAboveThreshold = 0;
            }
            if (this.isAboveThreshold) {
                if (usedRatio < this.thresholdLwm) {
                    this.isAboveThreshold = false;
                } else if (this.samplesBelowThreshold <= this.minSampleCount && ++this.samplesBelowThreshold >= this.minSampleCount) {
                    this.isAboveThreshold = false;
                }
                if (!this.isAboveThreshold) {
                    for (JVMHeapWatchdogListener listener : this.listeners) {
                        listener.falledBelowThreshold(usedHeap, MAX_HEAP);
                    }
                }
            }
        }
    }

    public synchronized void addListener(JVMHeapWatchdogListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
            if (this.isAboveThreshold) {
                listener.thresholdExceeded(this.lastSample, MAX_HEAP);
            }
        }
    }

    public synchronized void removeListener(JVMHeapWatchdogListener listener) {
        this.listeners.remove(listener);
    }
}

