/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class IntervalTimer
implements Comparable<IntervalTimer> {
    private static Map<String, IntervalTimer> mTimers = new TreeMap<String, IntervalTimer>();
    public static final String TIMER_PROPERTY = "com.arm.toolkit.utility.timer";
    private static Set<String> sValidKeys = null;
    private static Set<String> sForbiddenKeys = null;
    private String mId;
    private String mDescription;
    private long mStart;
    private long mStop;
    private long mStartNanos;
    private long mStopNanos;
    private long mCalls;
    private boolean mIsRunning = false;
    private static final IntervalTimer DUMMY_TIMER = new IntervalTimer("", "No Timer");
    private static SimpleDateFormat mFormat = new SimpleDateFormat("HH:mm:ss.SSS");

    private IntervalTimer(String id, String description) {
        this.mId = id;
        this.mDescription = description;
    }

    public static synchronized void activateForPrefix(String prefix, boolean activate) {
        if (sValidKeys == null) {
            IntervalTimer.readEnvironment();
        }
        String lcPrefix = prefix.toLowerCase();
        if (activate) {
            sValidKeys.add(lcPrefix);
            sForbiddenKeys.remove(lcPrefix);
        } else {
            sForbiddenKeys.add(lcPrefix);
            sValidKeys.remove(lcPrefix);
        }
    }

    private static synchronized void readEnvironment() {
        sValidKeys = new HashSet<String>();
        sForbiddenKeys = new HashSet<String>();
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            String key = entry.getKey().toLowerCase();
            if (!key.startsWith(TIMER_PROPERTY)) continue;
            if (Boolean.parseBoolean(entry.getValue())) {
                sValidKeys.add(key);
                continue;
            }
            sForbiddenKeys.add(key);
        }
    }

    public static synchronized boolean isActive(String prefix) {
        if (sValidKeys == null) {
            IntervalTimer.readEnvironment();
        }
        String lcPrefix = prefix.toLowerCase();
        for (String key : sForbiddenKeys) {
            if (!lcPrefix.startsWith(key)) continue;
            return false;
        }
        for (String key : sValidKeys) {
            if (!lcPrefix.startsWith(key)) continue;
            return true;
        }
        return false;
    }

    public static synchronized IntervalTimer start(String id, String description) {
        if (!IntervalTimer.isActive(id)) {
            return DUMMY_TIMER;
        }
        IntervalTimer timer = new IntervalTimer(id, description);
        timer.mStart = System.currentTimeMillis();
        timer.mStartNanos = System.nanoTime();
        timer.mIsRunning = true;
        ++timer.mCalls;
        mTimers.put(id, timer);
        return timer;
    }

    public static synchronized IntervalTimer restart(String id) {
        if (!IntervalTimer.isActive(id)) {
            return DUMMY_TIMER;
        }
        IntervalTimer timer = mTimers.get(id);
        if (timer != null) {
            if (timer.mIsRunning) {
                return timer;
            }
            long duration = timer.mStop - timer.mStart;
            long nanoDuration = timer.mStopNanos - timer.mStartNanos;
            timer.mStop = System.currentTimeMillis();
            timer.mStopNanos = System.nanoTime();
            timer.mStart = timer.mStop - duration;
            timer.mStartNanos = timer.mStopNanos - nanoDuration;
            timer.mIsRunning = true;
            ++timer.mCalls;
            return timer;
        }
        return IntervalTimer.start(id, id);
    }

    public static synchronized IntervalTimer pause(String id) {
        if (!IntervalTimer.isActive(id)) {
            return DUMMY_TIMER;
        }
        IntervalTimer timer = IntervalTimer.checkpoint(id);
        timer.mIsRunning = false;
        return timer;
    }

    public static synchronized IntervalTimer start(String id) {
        return IntervalTimer.start(id, id);
    }

    public static synchronized String print(String id) {
        IntervalTimer timer = mTimers.get(id);
        if (timer == null) {
            return "";
        }
        return timer.toString();
    }

    public static synchronized void printAll(String prefix, boolean remove) {
        ArrayList<IntervalTimer> timers = new ArrayList<IntervalTimer>(mTimers.values());
        ArrayList<IntervalTimer> matches = new ArrayList<IntervalTimer>();
        String lsPrefix = prefix.toLowerCase();
        for (IntervalTimer timer : timers) {
            if (!timer.mId.toLowerCase().startsWith(lsPrefix)) continue;
            matches.add(timer);
            if (!remove) continue;
            mTimers.remove(timer.mId);
        }
        if (matches.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("Displaying ").append(matches.size()).append(" timers (").append(IntervalTimer.timestamp()).append(")\n");
            for (IntervalTimer timer : matches) {
                sb.append("    ").append(timer).append("\n");
            }
            sb.append("Done.");
            PrintStream stdOut = System.out;
            stdOut.println(sb);
        }
    }

    public static synchronized IntervalTimer checkpoint(String id) {
        if (!IntervalTimer.isActive(id)) {
            return DUMMY_TIMER;
        }
        IntervalTimer timer = mTimers.get(id);
        if (timer != null) {
            timer.mStop = System.currentTimeMillis();
            timer.mStopNanos = System.nanoTime();
        } else {
            timer = new IntervalTimer(id, id);
        }
        return timer;
    }

    public static synchronized IntervalTimer end(String id) {
        if (!IntervalTimer.isActive(id)) {
            return DUMMY_TIMER;
        }
        IntervalTimer timer = mTimers.remove(id);
        if (timer != null) {
            timer.mStop = System.currentTimeMillis();
            timer.mStopNanos = System.nanoTime();
        } else {
            timer = new IntervalTimer(id, id);
        }
        timer.mIsRunning = false;
        return timer;
    }

    public static synchronized void clear() {
        mTimers.clear();
    }

    public String toString() {
        if (this == DUMMY_TIMER) {
            return "";
        }
        if (this.mStart == 0L && this.mStop == 0L) {
            return String.valueOf(this.mId) + ": Not Started";
        }
        if (this.mStop == 0L) {
            return String.valueOf(this.mId) + ": Running";
        }
        long millis = this.mStop - this.mStart;
        long nanos = this.mStopNanos - this.mStartNanos;
        return String.valueOf(this.mDescription) + ": " + millis + " millis (" + nanos + " nanos)" + (this.mIsRunning ? " running" : "") + (this.mCalls <= 1L ? "" : " (" + Long.toString(this.mCalls) + " calls)");
    }

    public long nanos() {
        if (this == DUMMY_TIMER) {
            return 0L;
        }
        if (this.mStart == 0L && this.mStop == 0L) {
            return 0L;
        }
        return this.mStopNanos - this.mStartNanos;
    }

    public long millis() {
        if (this == DUMMY_TIMER) {
            return 0L;
        }
        if (this.mStart == 0L && this.mStop == 0L) {
            return 0L;
        }
        return this.mStop - this.mStart;
    }

    @Override
    public int compareTo(IntervalTimer other) {
        if (other == null) {
            return 1;
        }
        return this.mId.compareTo(other.mId);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof IntervalTimer) {
            return this.mId.equals(((IntervalTimer)obj).mId);
        }
        return false;
    }

    public int hashCode() {
        return this.mId.hashCode();
    }

    public static synchronized String timestamp() {
        return mFormat.format(new Date(System.currentTimeMillis()));
    }
}

