/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClockSpeedParser {
    private static final Pattern parsePattern = Pattern.compile("^(\\d+)(mhz|khz|hz)?$", 2);

    public static int parseClockSpeed(String speedString) {
        int speed;
        block18: {
            Matcher m = parsePattern.matcher(speedString);
            speed = 0;
            if (!m.matches()) break block18;
            String integerPart = m.group(1);
            String unit = m.group(2) != null ? m.group(2) : "";
            try {
                speed = Integer.decode(integerPart);
            }
            catch (NumberFormatException numberFormatException) {}
            if (speed <= 0) break block18;
            switch (unit.toLowerCase()) {
                case "mhz": {
                    speed = speed > 1000 ? 0 : speed * 1000000;
                    break;
                }
                case "khz": {
                    speed = speed > 1000000 ? 0 : speed * 1000;
                    break;
                }
                case "hz": {
                    speed = speed > 1000000000 ? 0 : speed;
                    break;
                }
                case "": {
                    speed = speed > 1000000000 ? 0 : speed;
                    break;
                }
                default: {
                    speed = 0;
                }
            }
        }
        return speed;
    }
}

