/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util;

import java.util.Arrays;

public class ByteManipulator {
    public static void shiftArrayLeft(byte[] rawContents, long shift) {
        if (shift == 0L) {
            return;
        }
        if (shift < 0L) {
            ByteManipulator.shiftArrayRight(rawContents, -shift);
            return;
        }
        int byteShift = (int)shift / 8;
        int bitShift = (int)shift % 8;
        int i = 0;
        while (i < rawContents.length) {
            byte current = rawContents[i];
            byte remaining = (byte)((0xFF & current) << bitShift);
            byte bitShiftLeft = (byte)((0xFF & current) >> 8 - bitShift);
            if (i - byteShift - 1 >= 0) {
                int n = i - byteShift - 1;
                rawContents[n] = (byte)(rawContents[n] | bitShiftLeft);
            }
            if (i - byteShift >= 0) {
                rawContents[i - byteShift] = remaining;
            }
            if (i + byteShift >= rawContents.length) {
                rawContents[i] = 0;
            }
            ++i;
        }
    }

    public static void shiftArrayRight(byte[] rawContents, long shift) {
        if (shift == 0L) {
            return;
        }
        if (shift < 0L) {
            ByteManipulator.shiftArrayLeft(rawContents, -shift);
            return;
        }
        int byteShift = (int)shift / 8;
        int bitShift = (int)shift % 8;
        int i = rawContents.length - 1;
        while (i >= 0) {
            byte current = rawContents[i];
            byte remaining = (byte)((0xFF & current) >> bitShift);
            byte bitsShiftedRight = (byte)((0xFF & current) << 8 - bitShift);
            if (i + byteShift + 1 < rawContents.length) {
                int n = i + byteShift + 1;
                rawContents[n] = (byte)(rawContents[n] | bitsShiftedRight);
            }
            if (i + byteShift < rawContents.length) {
                rawContents[i + byteShift] = remaining;
            }
            if (i - byteShift < 0) {
                rawContents[i] = 0;
            }
            --i;
        }
    }

    public static void setBit(int number, byte[] array) {
        int byteIndex = number / 8;
        int bitIndex = 7 - number % 8;
        int n = byteIndex;
        array[n] = (byte)(array[n] | 0xFF & 1 << bitIndex);
    }

    public static void and(byte[] first, byte[] second) {
        if (first.length != second.length) {
            throw new ArrayIndexOutOfBoundsException("Mask and byte[] are not the correct length");
        }
        int i = 0;
        while (i < first.length && i < second.length) {
            int n = i;
            first[n] = (byte)(first[n] & second[i]);
            ++i;
        }
        while (i < first.length && i < second.length) {
            first[i] = 0;
            ++i;
        }
    }

    public static byte[] extractBitRange(byte[] array, int i1, int i2) {
        if (i1 > i2) {
            int tmp = i2;
            i2 = i1;
            i1 = tmp;
        }
        int firstInterestingByteIndex = i1 / 8;
        int lastInterestingByteIndex = i2 / 8;
        byte[] interestingContent = Arrays.copyOfRange(array, firstInterestingByteIndex, lastInterestingByteIndex += i2 % 8 != 0 ? 1 : 0);
        return interestingContent;
    }

    public static void andNot(byte[] first, byte[] second) {
        byte[] notMask = Arrays.copyOf(second, second.length);
        ByteManipulator.not(notMask);
        ByteManipulator.and(first, notMask);
    }

    public static void or(byte[] first, byte[] second) {
        if (first.length != second.length) {
            throw new ArrayIndexOutOfBoundsException("Mask and byte[] are not the correct length");
        }
        int i = 0;
        while (i < first.length && i < second.length) {
            int n = i;
            first[n] = (byte)(first[n] | second[i]);
            ++i;
        }
        while (i < first.length && i < second.length) {
            first[i] = 0;
            ++i;
        }
    }

    public static void not(byte[] data) {
        int i = 0;
        while (i < data.length) {
            data[i] = ~data[i];
            ++i;
        }
    }

    public static byte[] createBitMask(long offsetInBits, long sizeInBits) {
        int byteSize = ByteManipulator.getByteSizeForBits(sizeInBits);
        byte[] result = new byte[byteSize + (int)(offsetInBits / 8L)];
        int i = byteSize - 1;
        while (sizeInBits > 8L) {
            result[i] = -1;
            --i;
            sizeInBits -= 8L;
        }
        if (sizeInBits != 0L) {
            result[i] = (byte)((1 << (int)sizeInBits) - 1);
        }
        return result;
    }

    public static byte[] createBitMask(int setBitCount, int offset, int length) {
        int lzc;
        byte[] result = ByteManipulator.createBitMask(setBitCount);
        int n = lzc = setBitCount % 8 == 0 ? 0 : 8 - setBitCount % 8;
        if (lzc > offset) {
            ByteManipulator.shiftArrayLeft(result, lzc - offset);
        } else if (lzc < offset) {
            result = ByteManipulator.shiftArrayRightWithZeroPadding(result, offset - lzc);
        }
        int roundLength = (length + 7) / 8;
        if (result.length < roundLength) {
            result = Arrays.copyOf(result, roundLength);
        }
        if (length % 8 != 0) {
            ByteManipulator.shiftArrayRight(result, 8 - length % 8);
        }
        return result;
    }

    public static int getByteSizeForBits(long sizeInBits) {
        int byteSize = (int)(sizeInBits / 8L);
        if (sizeInBits % 8L > 0L) {
            ++byteSize;
        }
        return byteSize;
    }

    public static byte[] createBitMask(long sizeInBits) {
        return ByteManipulator.createBitMask(0L, sizeInBits);
    }

    public static void reverseEndian(int wordSize, byte[] data) {
        int word = 0;
        while (word < data.length / wordSize) {
            int offset = word * wordSize;
            int i = 0;
            while (i < wordSize / 2) {
                int a = offset + i;
                int b = offset + (wordSize - 1 - i);
                int n = a;
                data[n] = (byte)(data[n] ^ data[b]);
                int n2 = b;
                data[n2] = (byte)(data[n2] ^ data[a]);
                int n3 = a;
                data[n3] = (byte)(data[n3] ^ data[b]);
                ++i;
            }
            ++word;
        }
        if (data.length % wordSize != 0) {
            int s = wordSize * (data.length / wordSize);
            int i = 0;
            while (i < data.length % wordSize && i < wordSize / 2) {
                byte bc;
                int a = s + i;
                int b = s + wordSize - 1 - i;
                byte by = bc = b >= data.length ? (byte)0 : data[b];
                if (b < data.length) {
                    data[b] = data[a];
                }
                data[a] = bc;
                ++i;
            }
        }
    }

    public static byte[] createBitMaskInto(long containerSizeInBits, long offset, long size) {
        byte[] result = new byte[ByteManipulator.getByteSizeForBits(containerSizeInBits)];
        long i = offset;
        while (i < offset + size) {
            ByteManipulator.setBit((int)i, result);
            ++i;
        }
        return result;
    }

    public static byte[] bytesFromInt(int value) {
        byte[] result = new byte[4];
        int i = 0;
        while (i < result.length) {
            result[result.length - i - 1] = (byte)value;
            value >>= 8;
            ++i;
        }
        return result;
    }

    public static byte[] bytesFromShort(short value) {
        byte[] result = new byte[2];
        int i = 0;
        while (i < result.length) {
            result[result.length - i - 1] = (byte)value;
            value = (short)(value >> 8);
            ++i;
        }
        return result;
    }

    public static byte[] bytesFromLong(long value) {
        byte[] result = new byte[8];
        int i = 0;
        while (i < result.length) {
            result[result.length - i - 1] = (byte)value;
            value >>= 8;
            ++i;
        }
        return result;
    }

    public static byte[] bytesFromFloat(float value) {
        return ByteManipulator.bytesFromInt(Float.floatToRawIntBits(value));
    }

    public static byte[] bytesFromDouble(double value) {
        return ByteManipulator.bytesFromLong(Double.doubleToRawLongBits(value));
    }

    public static long longFromBytes(byte[] value) {
        long result = 0L;
        int i = 0;
        while (i < Math.min(8, value.length)) {
            long temp = 0xFF & value[value.length - 1 - i];
            result |= (temp <<= i * 8);
            ++i;
        }
        return result;
    }

    public static int intFromBytes(byte[] value) {
        int result = 0;
        int i = 0;
        while (i < Math.min(4, value.length)) {
            int temp = 0xFF & value[value.length - 1 - i];
            result |= (temp <<= i * 8);
            ++i;
        }
        return result;
    }

    public static short shortFromBytes(byte[] value) {
        short result = 0;
        int i = 0;
        while (i < Math.min(2, value.length)) {
            short temp = (short)(0xFF & value[value.length - 1 - i]);
            temp = (short)(temp << i * 8);
            result = (short)(result | temp);
            ++i;
        }
        return result;
    }

    public static byte[] ensureTopBitIsZero(byte[] value) {
        if ((value[0] & 0x80) == 0) {
            return value;
        }
        byte[] v2 = new byte[value.length + 1];
        int i = 0;
        while (i < value.length) {
            v2[i + 1] = value[i];
            ++i;
        }
        return v2;
    }

    public static byte[] shiftArrayLeftWithZeroPadding(byte[] data, int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return data;
        }
        int l = data.length + (n + 7) / 8;
        byte[] result = Arrays.copyOf(data, l);
        if (n % 8 != 0) {
            ByteManipulator.shiftArrayRight(result, 8 - n % 8);
        }
        return result;
    }

    public static byte[] insertLeadingZeroes(byte[] data, int n) {
        if (n == 0) {
            return data;
        }
        byte[] ba = new byte[data.length + n];
        int i = 0;
        while (i < data.length) {
            ba[i + n] = data[i];
            ++i;
        }
        return ba;
    }

    public static byte[] shiftArrayRightWithZeroPadding(byte[] data, int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return data;
        }
        int l = data.length + (n + 7) / 8;
        byte[] result = new byte[l];
        int i = 0;
        while (i < data.length) {
            result[i] = data[i];
            ++i;
        }
        ByteManipulator.shiftArrayRight(result, n);
        return result;
    }
}

