/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util;

public class BitManipulator {
    private static final long ALT_1_L = 0x5555555555555555L;
    private static final long ALT_2_L = 0x3333333333333333L;
    private static final long ALT_4_L = 0xF0F0F0F0F0F0F0FL;
    private static final int ALT_1_I = 0x55555555;
    private static final int ALT_2_I = 0x33333333;
    private static final int ALT_4_I = 0xF0F0F0F;
    private static final short ALT_1_S = 21845;
    private static final short ALT_2_S = 13107;
    private static final short ALT_4_S = 3855;
    private static int[] BYTE_TABLE;
    private static final long[] MASKS;

    static {
        int[] nArray = new int[256];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 2;
        nArray[4] = 1;
        nArray[5] = 2;
        nArray[6] = 2;
        nArray[7] = 3;
        nArray[8] = 1;
        nArray[9] = 2;
        nArray[10] = 2;
        nArray[11] = 3;
        nArray[12] = 2;
        nArray[13] = 3;
        nArray[14] = 3;
        nArray[15] = 4;
        nArray[16] = 1;
        nArray[17] = 2;
        nArray[18] = 2;
        nArray[19] = 3;
        nArray[20] = 2;
        nArray[21] = 3;
        nArray[22] = 3;
        nArray[23] = 4;
        nArray[24] = 2;
        nArray[25] = 3;
        nArray[26] = 3;
        nArray[27] = 4;
        nArray[28] = 3;
        nArray[29] = 4;
        nArray[30] = 4;
        nArray[31] = 5;
        nArray[32] = 1;
        nArray[33] = 2;
        nArray[34] = 2;
        nArray[35] = 3;
        nArray[36] = 2;
        nArray[37] = 3;
        nArray[38] = 3;
        nArray[39] = 4;
        nArray[40] = 2;
        nArray[41] = 3;
        nArray[42] = 3;
        nArray[43] = 4;
        nArray[44] = 3;
        nArray[45] = 4;
        nArray[46] = 4;
        nArray[47] = 5;
        nArray[48] = 2;
        nArray[49] = 3;
        nArray[50] = 3;
        nArray[51] = 4;
        nArray[52] = 3;
        nArray[53] = 4;
        nArray[54] = 4;
        nArray[55] = 5;
        nArray[56] = 3;
        nArray[57] = 4;
        nArray[58] = 4;
        nArray[59] = 5;
        nArray[60] = 4;
        nArray[61] = 5;
        nArray[62] = 5;
        nArray[63] = 6;
        nArray[64] = 1;
        nArray[65] = 2;
        nArray[66] = 2;
        nArray[67] = 3;
        nArray[68] = 2;
        nArray[69] = 3;
        nArray[70] = 3;
        nArray[71] = 4;
        nArray[72] = 2;
        nArray[73] = 3;
        nArray[74] = 3;
        nArray[75] = 4;
        nArray[76] = 3;
        nArray[77] = 4;
        nArray[78] = 4;
        nArray[79] = 5;
        nArray[80] = 2;
        nArray[81] = 3;
        nArray[82] = 3;
        nArray[83] = 4;
        nArray[84] = 3;
        nArray[85] = 4;
        nArray[86] = 4;
        nArray[87] = 5;
        nArray[88] = 3;
        nArray[89] = 4;
        nArray[90] = 4;
        nArray[91] = 5;
        nArray[92] = 4;
        nArray[93] = 5;
        nArray[94] = 5;
        nArray[95] = 6;
        nArray[96] = 2;
        nArray[97] = 3;
        nArray[98] = 3;
        nArray[99] = 4;
        nArray[100] = 3;
        nArray[101] = 4;
        nArray[102] = 4;
        nArray[103] = 5;
        nArray[104] = 3;
        nArray[105] = 4;
        nArray[106] = 4;
        nArray[107] = 5;
        nArray[108] = 4;
        nArray[109] = 5;
        nArray[110] = 5;
        nArray[111] = 6;
        nArray[112] = 3;
        nArray[113] = 4;
        nArray[114] = 4;
        nArray[115] = 5;
        nArray[116] = 4;
        nArray[117] = 5;
        nArray[118] = 5;
        nArray[119] = 6;
        nArray[120] = 4;
        nArray[121] = 5;
        nArray[122] = 5;
        nArray[123] = 6;
        nArray[124] = 5;
        nArray[125] = 6;
        nArray[126] = 6;
        nArray[127] = 7;
        nArray[128] = 1;
        nArray[129] = 2;
        nArray[130] = 2;
        nArray[131] = 3;
        nArray[132] = 2;
        nArray[133] = 3;
        nArray[134] = 3;
        nArray[135] = 4;
        nArray[136] = 2;
        nArray[137] = 3;
        nArray[138] = 3;
        nArray[139] = 4;
        nArray[140] = 3;
        nArray[141] = 4;
        nArray[142] = 4;
        nArray[143] = 5;
        nArray[144] = 2;
        nArray[145] = 3;
        nArray[146] = 3;
        nArray[147] = 4;
        nArray[148] = 3;
        nArray[149] = 4;
        nArray[150] = 4;
        nArray[151] = 5;
        nArray[152] = 3;
        nArray[153] = 4;
        nArray[154] = 4;
        nArray[155] = 5;
        nArray[156] = 4;
        nArray[157] = 5;
        nArray[158] = 5;
        nArray[159] = 6;
        nArray[160] = 2;
        nArray[161] = 3;
        nArray[162] = 3;
        nArray[163] = 4;
        nArray[164] = 3;
        nArray[165] = 4;
        nArray[166] = 4;
        nArray[167] = 5;
        nArray[168] = 3;
        nArray[169] = 4;
        nArray[170] = 4;
        nArray[171] = 5;
        nArray[172] = 4;
        nArray[173] = 5;
        nArray[174] = 5;
        nArray[175] = 6;
        nArray[176] = 3;
        nArray[177] = 4;
        nArray[178] = 4;
        nArray[179] = 5;
        nArray[180] = 4;
        nArray[181] = 5;
        nArray[182] = 5;
        nArray[183] = 6;
        nArray[184] = 4;
        nArray[185] = 5;
        nArray[186] = 5;
        nArray[187] = 6;
        nArray[188] = 5;
        nArray[189] = 6;
        nArray[190] = 6;
        nArray[191] = 7;
        nArray[192] = 2;
        nArray[193] = 3;
        nArray[194] = 3;
        nArray[195] = 4;
        nArray[196] = 3;
        nArray[197] = 4;
        nArray[198] = 4;
        nArray[199] = 5;
        nArray[200] = 3;
        nArray[201] = 4;
        nArray[202] = 4;
        nArray[203] = 5;
        nArray[204] = 4;
        nArray[205] = 5;
        nArray[206] = 5;
        nArray[207] = 6;
        nArray[208] = 3;
        nArray[209] = 4;
        nArray[210] = 4;
        nArray[211] = 5;
        nArray[212] = 4;
        nArray[213] = 5;
        nArray[214] = 5;
        nArray[215] = 6;
        nArray[216] = 4;
        nArray[217] = 5;
        nArray[218] = 5;
        nArray[219] = 6;
        nArray[220] = 5;
        nArray[221] = 6;
        nArray[222] = 6;
        nArray[223] = 7;
        nArray[224] = 3;
        nArray[225] = 4;
        nArray[226] = 4;
        nArray[227] = 5;
        nArray[228] = 4;
        nArray[229] = 5;
        nArray[230] = 5;
        nArray[231] = 6;
        nArray[232] = 4;
        nArray[233] = 5;
        nArray[234] = 5;
        nArray[235] = 6;
        nArray[236] = 5;
        nArray[237] = 6;
        nArray[238] = 6;
        nArray[239] = 7;
        nArray[240] = 4;
        nArray[241] = 5;
        nArray[242] = 5;
        nArray[243] = 6;
        nArray[244] = 5;
        nArray[245] = 6;
        nArray[246] = 6;
        nArray[247] = 7;
        nArray[248] = 5;
        nArray[249] = 6;
        nArray[250] = 6;
        nArray[251] = 7;
        nArray[252] = 6;
        nArray[253] = 7;
        nArray[254] = 7;
        nArray[255] = 8;
        BYTE_TABLE = nArray;
        MASKS = new long[64];
        int i = 0;
        while (i < 63) {
            BitManipulator.MASKS[i] = (1L << (i + 1 & 0x3F)) - 1L;
            ++i;
        }
        BitManipulator.MASKS[63] = -1L;
    }

    public static int populationCount(long x) {
        x -= x >> 1 & 0x5555555555555555L;
        x = (x & 0x3333333333333333L) + (x >> 2 & 0x3333333333333333L);
        x = x + (x >> 4) & 0xF0F0F0F0F0F0F0FL;
        x += x >> 8;
        x += x >> 16;
        x += x >> 32;
        return (int)x & 0x7F;
    }

    public static int populationCount(int x) {
        x -= x >> 1 & 0x55555555;
        x = (x & 0x33333333) + (x >> 2 & 0x33333333);
        x = x + (x >> 4) & 0xF0F0F0F;
        x += x >> 8;
        x += x >> 16;
        return x & 0x3F;
    }

    public static int populationCount(short x) {
        x = (short)(x - (x >> 1 & 0x5555));
        x = (short)((x & 0x3333) + (x >> 2 & 0x3333));
        x = (short)(x + (x >> 4) & 0xF0F);
        x = (short)(x + (x >> 8));
        return x & 0x1F;
    }

    public static int populationCount(byte x) {
        return BYTE_TABLE[0xFF & x];
    }

    public static long getMask(int highInclusive, int lowInclusive) {
        long result = MASKS[highInclusive - lowInclusive];
        return result <<= lowInclusive;
    }

    public static final long extract(long input, int highInclusive, int lowInclusive) {
        long mask = MASKS[highInclusive - lowInclusive];
        return input >> lowInclusive & mask;
    }

    public static long floorPowerOf2(long l) {
        return 1L << (Long.numberOfLeadingZeros(l) ^ 0x3F);
    }

    public static long ceilPowerOf2(long l) {
        return 1L << 64 - Long.numberOfLeadingZeros(l - 1L);
    }
}

