/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util;

import java.math.BigInteger;
import java.util.Comparator;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AlphanumericComparator
implements Comparator<String> {
    private static final Pattern DIGIT_MATCHER_PATTERN = Pattern.compile("(?<digit>(\\d+))|(\\D+)");
    private final boolean caseSensitive;

    public AlphanumericComparator(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    @Override
    public int compare(String str1, String str2) {
        if (!this.caseSensitive) {
            str1 = str1.toLowerCase();
            str2 = str2.toLowerCase();
        }
        Tokenizer tokens1 = new Tokenizer(str1);
        Tokenizer tokens2 = new Tokenizer(str2);
        Token t1 = tokens1.next();
        Token t2 = tokens2.next();
        while (!t1.isEOS() && !t2.isEOS()) {
            int result = t1.compareTo(t2);
            if (result != 0) {
                return result;
            }
            t1 = tokens1.next();
            t2 = tokens2.next();
        }
        return str1.length() - str2.length();
    }

    public class Token
    implements Comparable<Token> {
        public final TokenType type;
        public final String content;

        public Token(TokenType type, String content) {
            this.type = type;
            this.content = content;
        }

        public TokenType getType() {
            return this.type;
        }

        public String getContent() {
            return this.content;
        }

        public boolean isEOS() {
            return this.type == TokenType.EOS;
        }

        public String toString() {
            return String.format("<%s>:<%s>", this.type.name(), this.content);
        }

        @Override
        public int compareTo(Token other) {
            if (this.getType() == TokenType.DIGIT && other.getType() == TokenType.DIGIT) {
                return new BigInteger(this.getContent()).compareTo(new BigInteger(other.getContent()));
            }
            if (this.getType() == TokenType.OTHER && other.getType() == TokenType.OTHER) {
                return this.getContent().compareTo(other.getContent());
            }
            return this.getType() == TokenType.DIGIT ? -1 : 1;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.content});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Token)) {
                return false;
            }
            Token other = (Token)obj;
            return Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.content, other.content);
        }
    }

    public static enum TokenType {
        DIGIT,
        OTHER,
        EOS;

    }

    private class Tokenizer {
        private final Matcher digitMatcher;

        private Tokenizer(String input) {
            this.digitMatcher = DIGIT_MATCHER_PATTERN.matcher(Objects.requireNonNull(input));
        }

        public Token next() {
            if (this.digitMatcher.find()) {
                return new Token(this.digitMatcher.group("digit") != null ? TokenType.DIGIT : TokenType.OTHER, this.digitMatcher.group());
            }
            return new Token(TokenType.EOS, TokenType.EOS.name());
        }
    }
}

