/*
 * Decompiled with CFR 0.152.
 */
package com.arm.timestamp;

import com.arm.timestamp.CheckTimestamp;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;

public class PersistantCheckTimestamp
implements CheckTimestamp {
    private static final String FILENAME = "timestamp";
    private final File file;
    private final long interval;
    private long timestamp;

    public PersistantCheckTimestamp(File base, long interval) {
        this.file = new File(base, FILENAME);
        this.interval = interval;
        this.read();
    }

    @Override
    public long getStamp() {
        return this.timestamp;
    }

    @Override
    public boolean hasExpired(long current) {
        return this.timestamp + this.interval >= current;
    }

    @Override
    public boolean stamp(long current) {
        boolean written = this.write(current);
        if (written) {
            this.timestamp = current;
        }
        return written;
    }

    @Override
    public long remaining(long current) {
        return this.timestamp + this.interval - current;
    }

    @Override
    public long interval() {
        return this.interval;
    }

    private void read() {
        if (!this.file.exists()) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(this.file));){
            String value = reader.readLine();
            if (value != null) {
                this.timestamp = Long.parseLong(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (IOException iOException) {}
    }

    private boolean write(long value) {
        try (PrintWriter writer = new PrintWriter(this.file);){
            writer.print(value);
            writer.flush();
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

