/*
 * Decompiled with CFR 0.152.
 */
package com.arm.text;

import com.arm.text.AbstractFormattedMessage;
import com.arm.text.IFormattedMessage;
import com.arm.text.ILayer;
import com.arm.text.IMessage;
import java.util.Arrays;

public final class FormattedMessage
extends AbstractFormattedMessage {
    private final IMessage message;
    private final Object[] args;
    private String localisedMessage = null;
    private String englishMessage = null;

    public FormattedMessage(IMessage message, Object ... args) {
        this.message = message;
        this.args = args == null ? null : Arrays.copyOf(args, args.length);
    }

    @Override
    public int getCode() {
        return this.message.getCode();
    }

    @Override
    public String getEnglishValue() {
        if (this.englishMessage == null) {
            this.englishMessage = this.message.getEnglishValue(this.args);
        }
        return this.englishMessage;
    }

    @Override
    public String getLocalisedValue() {
        if (this.localisedMessage == null) {
            this.localisedMessage = this.message.getLocalisedValue(this.args);
        }
        return this.localisedMessage;
    }

    @Override
    public IMessage getMessage() {
        return this.message;
    }

    public String toString() {
        return this.getLocalisedValue();
    }

    @Override
    public ILayer getLayer() {
        return this.message.getLayer();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FormattedMessage)) {
            return false;
        }
        FormattedMessage om = (FormattedMessage)o;
        return this.message.equals(om.message) && Arrays.equals(this.args, om.args);
    }

    public int hashCode() {
        return this.message.hashCode() + 37 * Arrays.hashCode(this.args);
    }

    @Override
    public IFormattedMessage setAddLineSeparator(boolean addLineSeparator) {
        FormattedMessage msg = new FormattedMessage(this.message, this.args);
        msg.addLineSeparator = addLineSeparator;
        return msg;
    }
}

