/*
 * Decompiled with CFR 0.152.
 */
package com.arm.shell;

import com.arm.io.Files;
import com.arm.shell.ProcessHandler;
import com.arm.shell.ShellException;
import com.arm.util.HostInfo;
import com.arm.util.Platform;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class Shell
extends ProcessHandler {
    private static File shell = null;
    private File script;
    private String rawCommand;
    private boolean scriptSetup = false;

    public Shell(File cwd, String command) throws ShellException {
        super(cwd);
        this.configureOsShell();
        this.rawCommand = command;
    }

    private void checkScript() throws ShellException {
        ArrayList<String> args = new ArrayList<String>();
        if (!this.scriptSetup) {
            if (this.rawCommand == null) {
                this.initialiseForInteractive(args);
            } else {
                this.initialiseForScript(args, this.rawCommand);
            }
        }
        this.setArgs(args);
    }

    private void configureOsShell() throws ShellException {
        if (shell == null) {
            try {
                shell = new File(HostInfo.getShell()).getCanonicalFile();
            }
            catch (RuntimeException runtimeException) {
                throw new ShellException("A shell could not be found");
            }
            catch (IOException iOException) {
                throw new ShellException("A shell could not be found");
            }
            Shell s = new Shell(null, "exit 0");
            int value = s.executeAndWait(null, null, null);
            if (value != 0) {
                shell = null;
                throw new ShellException("A usable shell could not be found: " + s.getStderr());
            }
        }
    }

    private void initialiseForInteractive(List<String> args) {
        if (HostInfo.isWindows()) {
            args.add(shell.getPath());
        } else if (HostInfo.isLinux()) {
            args.add(shell.getPath());
            args.add("-l");
            args.add("-i");
        }
    }

    private void initialiseForScript(List<String> args, String command) throws ShellException {
        if (HostInfo.isWindows()) {
            args.add(shell.getPath());
            args.add("/E:ON");
            args.add("/V:ON");
            args.add("/c");
            this.script = this.createScript("bat", "@echo off", command);
            args.add(this.script.getAbsolutePath());
        } else if (HostInfo.isLinux()) {
            args.add(shell.getPath());
            args.add("-c");
            args.add(command);
        }
        this.scriptSetup = true;
    }

    private File createScript(String extension, String ... lines) throws ShellException {
        try {
            File temp = Files.getTempFile("shell", extension);
            StringBuilder commands = new StringBuilder();
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                commands.append(line);
                commands.append(Platform.LS);
                ++n2;
            }
            Files.writeContent(temp, commands.toString());
            temp.setExecutable(true);
            return temp;
        }
        catch (IOException e) {
            throw new ShellException("Error creating shell command script", e);
        }
    }

    private boolean cleanupScript() {
        if (this.script != null && this.script.exists()) {
            return this.script.delete();
        }
        return true;
    }

    @Override
    public void execute(OutputStream out, OutputStream err, InputStream in) throws ShellException {
        this.checkScript();
        super.execute(out, err, in);
    }

    @Override
    protected void closeStreams() throws ShellException {
        super.closeStreams();
        this.cleanupScript();
        this.scriptSetup = false;
    }
}

