/*
 * Decompiled with CFR 0.152.
 */
package com.arm.shell;

import com.arm.io.ProcessWrapper;
import com.arm.shell.IProcStreamListener;
import com.arm.shell.ShellException;
import com.arm.shell.StreamPipe;
import com.arm.util.HostInfo;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProcessHandler {
    private final File workingDirectory;
    private List<String> args;
    private final List<IProcStreamListener> errListeners = new ArrayList<IProcStreamListener>();
    private final List<IProcStreamListener> outListeners = new ArrayList<IProcStreamListener>();
    private final Map<String, String> envVars = new HashMap<String, String>();
    private final Map<String, String> pathEnvVars = new HashMap<String, String>();
    private OutputStream stdout;
    private OutputStream stderr;
    private StreamPipe outPipe;
    private StreamPipe errPipe;
    private StreamPipe inPipe;
    private ProcessWrapper process;

    public ProcessHandler(File cwd, List<String> args) throws ShellException {
        this(cwd);
        this.setArgs(args);
    }

    public ProcessHandler(File cwd, String[] args) throws ShellException {
        this(cwd, Arrays.asList(args));
    }

    public ProcessHandler(File cwd) {
        this.workingDirectory = cwd == null ? new File(System.getProperty("user.home")) : cwd;
    }

    protected void setArgs(List<String> args) {
        this.args = args;
    }

    public void addStandardOutputListener(IProcStreamListener listener) {
        this.outListeners.add(listener);
    }

    public void addStandardErrorListener(IProcStreamListener listener) {
        this.errListeners.add(listener);
    }

    public void addEnvVar(String name, String value) {
        this.envVars.put(name, value);
    }

    public void appendPathEnvVar(String name, String value) {
        if (HostInfo.isWindows()) {
            this.pathEnvVars.put(name.toUpperCase(), value);
        } else {
            this.pathEnvVars.put(name, value);
        }
    }

    public void execute(OutputStream out, OutputStream err, InputStream in) throws ShellException {
        ProcessBuilder pb = new ProcessBuilder(this.args);
        pb.directory(this.workingDirectory);
        this.updateEnvironment(pb);
        try {
            Process proc = pb.start();
            this.processCreated(proc);
            this.process = new ProcessWrapper(proc);
        }
        catch (IOException e) {
            throw new ShellException("Unable execute program", e);
        }
        this.stdout = out == null ? new ByteArrayOutputStream() : out;
        this.stderr = err == null ? new ByteArrayOutputStream() : err;
        this.outPipe = this.createStreamPipe("stdout", this.stdout, this.process.getInputStream(), this.outListeners);
        this.errPipe = this.createStreamPipe("stderr", this.stderr, this.process.getErrorStream(), this.errListeners);
        this.inPipe = null;
        if (in != null) {
            this.inPipe = new StreamPipe("stdin", this.process.getOutputStream(), in);
            this.inPipe.start();
        }
    }

    protected void processCreated(Process process) {
    }

    public void execute() throws ShellException {
        this.execute(null, null, null);
    }

    public int waitFor() throws ShellException {
        try {
            this.process.waitFor();
        }
        catch (InterruptedException e) {
            throw new ShellException("Shell process interrupted", e);
        }
        try {
            if (this.inPipe != null) {
                this.inPipe.setDone();
                this.inPipe.join();
                this.inPipe = null;
            }
            if (this.outPipe != null) {
                this.outPipe.waitFor();
                this.outPipe = null;
            }
            if (this.errPipe != null) {
                this.errPipe.waitFor();
                this.errPipe = null;
            }
        }
        catch (InterruptedException e) {
            throw new ShellException("Shell process interrupted", e);
        }
        this.closeStreams();
        try {
            return this.process.waitFor();
        }
        catch (InterruptedException e) {
            throw new ShellException("Shell process interrupted", e);
        }
    }

    public void terminate() {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    public int executeAndWait(OutputStream out, OutputStream err, InputStream in) throws ShellException {
        this.execute(out, err, in);
        return this.waitFor();
    }

    public int executeAndWait() throws ShellException {
        return this.executeAndWait(null, null, null);
    }

    public int terminateAndWait() throws ShellException {
        this.terminate();
        return this.waitFor();
    }

    public boolean isReady() {
        return this.process != null;
    }

    public boolean hasExited() {
        return this.process == null ? false : this.process.hasExited();
    }

    public void write(String value) throws IOException {
        this.process.getOutputStream().write(value.getBytes());
        this.process.getOutputStream().flush();
    }

    public String getStdout() throws IllegalStateException {
        if (this.stdout == null || !(this.stdout instanceof ByteArrayOutputStream)) {
            throw new IllegalStateException("a custom output stream was provided");
        }
        return ((ByteArrayOutputStream)this.stdout).toString();
    }

    public String getStderr() throws IllegalStateException {
        if (this.stderr == null || !(this.stderr instanceof ByteArrayOutputStream)) {
            throw new IllegalStateException("a custom output stream was provided");
        }
        return ((ByteArrayOutputStream)this.stderr).toString();
    }

    public String toString() {
        return "ProcessHandler: " + this.argsToString(this.args);
    }

    protected void closeStreams() throws ShellException {
        try {
            this.process.getErrorStream().close();
            this.process.getInputStream().close();
            this.process.getOutputStream().close();
        }
        catch (IOException e) {
            throw new ShellException("Unable to close shell stream", e);
        }
    }

    protected String argsToString(List<String> args) {
        StringBuilder out = new StringBuilder();
        for (String arg : args) {
            if (out.length() > 0) {
                out.append(" ");
            }
            out.append(arg);
        }
        return out.toString();
    }

    private StreamPipe createStreamPipe(String desc, OutputStream os, InputStream is, List<IProcStreamListener> listeners) {
        StreamPipe pipe = new StreamPipe(desc, os, is);
        if (listeners != null) {
            for (IProcStreamListener listener : listeners) {
                pipe.addStreamListener(listener);
            }
        }
        pipe.start();
        return pipe;
    }

    private void updateEnvironment(ProcessBuilder pb) {
        Map<String, String> env = pb.environment();
        env.putAll(this.envVars);
        for (Map.Entry<String, String> e : this.pathEnvVars.entrySet()) {
            String key = this.getEnvVarKey(env, e.getKey());
            String envPath = this.getEnvVarValue(env, key);
            envPath = envPath == null ? e.getValue() : String.valueOf(envPath) + File.pathSeparatorChar + e.getValue();
            env.put(key, envPath);
        }
    }

    private String getEnvVarKey(Map<String, String> env, String key) {
        if (HostInfo.isWindows()) {
            key = key.toUpperCase();
            for (Map.Entry<String, String> e : env.entrySet()) {
                if (!e.getKey().toUpperCase().equals(key)) continue;
                return e.getKey();
            }
        } else {
            return key;
        }
        return null;
    }

    private String getEnvVarValue(Map<String, String> env, String key) {
        if (HostInfo.isWindows()) {
            key = key.toUpperCase();
            for (Map.Entry<String, String> e : env.entrySet()) {
                if (!e.getKey().toUpperCase().equals(key)) continue;
                return e.getValue();
            }
        } else {
            return env.get(key);
        }
        return null;
    }

    protected String getPathVar(String name) {
        for (Map.Entry<String, String> e : this.pathEnvVars.entrySet()) {
            if (!e.getKey().equalsIgnoreCase(name)) continue;
            return e.getValue();
        }
        return null;
    }
}

