/*
 * Decompiled with CFR 0.152.
 */
package com.arm.prefs;

import com.arm.prefs.IPrefsNode;
import com.arm.prefs.IPrefsStore;
import com.arm.prefs.PrefsException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class PrefsNode
implements IPrefsNode {
    private static final Set<IPrefsNode> NO_CHILDREN = Collections.emptySet();
    private final IPrefsStore store;
    private final String name;
    private final String nodePath;
    private final IPrefsNode parent;
    private Set<IPrefsNode> children;

    public PrefsNode(IPrefsStore store, String name) {
        this.parent = null;
        this.name = name;
        this.store = store;
        this.nodePath = this.getPath();
        this.checkName(name);
    }

    private PrefsNode(PrefsNode parent, String name) {
        this.parent = parent;
        this.name = name;
        this.store = parent.getStore();
        this.nodePath = this.getPath();
        this.checkName(name);
        PrefsNode.checkDuplicate(parent, name);
    }

    private void checkName(String name) {
        if (name == null) {
            throw new NullPointerException("name can't be null");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("name can't be an empty string");
        }
        if (name.indexOf(this.store.getNodePathSeparator()) > -1) {
            throw new IllegalArgumentException("name can't contain the separator character '" + this.store.getNodePathSeparator() + "'");
        }
    }

    private static void checkDuplicate(IPrefsNode parent, String name) {
        for (IPrefsNode child : parent.getChildren()) {
            if (!name.equals(child.getName())) continue;
            throw new IllegalArgumentException("node named '" + name + "' already exists");
        }
    }

    private String getPath(String path, IPrefsNode parent) {
        String result;
        if (parent == null) {
            result = String.valueOf(this.store.getNodePathSeparator()) + path;
        } else {
            path = String.valueOf(parent.getName()) + this.store.getNodePathSeparator() + path;
            result = this.getPath(path, parent.getParent());
        }
        return result;
    }

    private IPrefsStore getStore() {
        return this.store;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.getPath(this.name, this.parent);
    }

    @Override
    public IPrefsNode getParent() {
        return this.parent;
    }

    @Override
    public Set<IPrefsNode> getChildren() {
        return this.children == null ? NO_CHILDREN : Collections.unmodifiableSet(this.children);
    }

    @Override
    public PrefsNode addChildNode(String nodeName) {
        PrefsNode child = new PrefsNode(this, nodeName);
        this.addChild(child);
        return child;
    }

    @Override
    public void removeChildNode(IPrefsNode node) {
        if (node != null) {
            this.removeChildNode(node.getName());
        }
    }

    @Override
    public void removeChildNode(String nodeName) {
        if (this.children != null && nodeName != null) {
            for (IPrefsNode child : this.children) {
                if (!child.getName().equals(nodeName)) continue;
                this.children.remove(child);
                this.store.remove(((PrefsNode)child).getPath());
                break;
            }
        }
    }

    private void addChild(PrefsNode node) {
        if (this.children == null) {
            this.children = new HashSet<IPrefsNode>();
        }
        this.children.add(node);
    }

    @Override
    public Set<String> getKeys() {
        return this.store.getKeys(this.nodePath);
    }

    @Override
    public String get(String key) {
        return this.store.get(this.nodePath, key);
    }

    @Override
    public void put(String key, String value) {
        this.store.put(this.nodePath, key, value);
    }

    @Override
    public void remove(String key) {
        this.store.remove(this.nodePath, key);
    }

    @Override
    public void clear() {
        for (String key : this.store.getKeys(this.nodePath)) {
            this.store.remove(this.nodePath, key);
        }
    }

    @Override
    public IPrefsNode lookup(String ... segments) {
        String segment;
        if (segments != null && segments.length > 0 && (segment = segments[0]) != null && this.children != null) {
            for (IPrefsNode child : this.children) {
                if (!segment.equals(child.getName())) continue;
                if (segments.length > 1) {
                    String[] remaining = new String[segments.length - 1];
                    System.arraycopy(segments, 1, remaining, 0, remaining.length);
                    return ((PrefsNode)child).lookup(remaining);
                }
                return child;
            }
        }
        return null;
    }

    @Override
    public boolean nodeExists(String ... segments) {
        return this.lookup(segments) != null;
    }

    public String toString() {
        return this.nodePath;
    }

    @Override
    public void sync() throws PrefsException {
        this.store.sync(this.nodePath);
        this.updateTree();
    }

    private void updateTree() {
        this.children = null;
        for (String childNodePath : this.store.getChildNodes(this.nodePath)) {
            String childNodeName = childNodePath.substring(childNodePath.lastIndexOf(this.store.getNodePathSeparator()) + 1);
            PrefsNode child = this.addChildNode(childNodeName);
            child.updateTree();
        }
    }

    public int hashCode() {
        return this.nodePath.hashCode();
    }

    public boolean equals(Object obj) {
        boolean equals;
        if (obj == this) {
            equals = true;
        } else if (obj instanceof PrefsNode) {
            IPrefsNode node = (IPrefsNode)obj;
            equals = this.getName().equals(node.getName()) && this.getKeys().equals(node.getKeys()) && this.getChildren().equals(node.getChildren());
        } else {
            equals = false;
        }
        return equals;
    }
}

